/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* DO NOT MODIFY THIS MANUALLY! This file was generated using cbindgen. See RunCbindgen.py */
#ifndef DAPTelemetryBindings_h
#error "Don't include this file directly, instead include DAPTelemetryBindings.h"
#endif


#include <cstdarg>
#include <cstdint>
#include <cstdlib>
#include <ostream>
#include <new>

extern "C" {

extern bool dapHpkeEncryptOneshot(const uint8_t *aKey,
                                  uint32_t aKeyLength,
                                  const uint8_t *aInfo,
                                  uint32_t aInfoLength,
                                  const uint8_t *aAad,
                                  uint32_t aAadLength,
                                  const uint8_t *aPlaintext,
                                  uint32_t aPlaintextLength,
                                  nsTArray<uint8_t> *aOutputEncapsulatedKey,
                                  nsTArray<uint8_t> *aOutputShare);

/// Wraps the function above with minor C interop.
/// Mostly it turns any error result into a return value of false.
bool dapGetReportPrioSum(const nsTArray<uint8_t> *leader_hpke_config_encoded,
                         const nsTArray<uint8_t> *helper_hpke_config_encoded,
                         uint32_t measurement,
                         const nsTArray<uint8_t> *task_id,
                         uint32_t bits,
                         uint64_t time_precision,
                         nsTArray<uint8_t> *out_report);

bool dapGetReportPrioSumVec(const nsTArray<uint8_t> *leader_hpke_config_encoded,
                            const nsTArray<uint8_t> *helper_hpke_config_encoded,
                            const nsTArray<uint32_t> *measurement,
                            const nsTArray<uint8_t> *task_id,
                            uint32_t bits,
                            uint64_t time_precision,
                            nsTArray<uint8_t> *out_report);

bool dapGetReportPrioHistogram(const nsTArray<uint8_t> *leader_hpke_config_encoded,
                               const nsTArray<uint8_t> *helper_hpke_config_encoded,
                               uint32_t measurement,
                               const nsTArray<uint8_t> *task_id,
                               uint32_t length,
                               uint64_t time_precision,
                               nsTArray<uint8_t> *out_report);

}  // extern "C"
