#ifndef DOM_BINDINGNAMES_H_
#define DOM_BINDINGNAMES_H_

#include <stddef.h>
#include <stdint.h>
#include "mozilla/Attributes.h"

namespace mozilla::dom {

enum class BindingNamesOffset : uint16_t {
  ANGLE_instanced_arrays = 0,
  APZHitResultFlags = 23,
  AbortController = 41,
  AbortSignal = 57,
  AbstractRange = 69,
  AccessibleNode = 83,
  Addon = 98,
  AddonEvent = 104,
  AddonInstall = 115,
  AddonManager = 128,
  AddonManagerPermissions = 141,
  AnalyserNode = 165,
  Animation = 178,
  AnimationEffect = 188,
  AnimationEvent = 204,
  AnimationPlaybackEvent = 219,
  AnimationTimeline = 242,
  AnonymousContent = 260,
  Attr = 277,
  Audio = 282,
  AudioBuffer = 288,
  AudioBufferSourceNode = 300,
  AudioContext = 322,
  AudioData = 335,
  AudioDecoder = 345,
  AudioDestinationNode = 358,
  AudioEncoder = 379,
  AudioListener = 392,
  AudioNode = 406,
  AudioParam = 416,
  AudioParamMap = 427,
  AudioProcessingEvent = 441,
  AudioScheduledSourceNode = 462,
  AudioTrack = 487,
  AudioTrackList = 498,
  AudioWorklet = 513,
  AudioWorkletGlobalScope = 526,
  AudioWorkletNode = 550,
  AudioWorkletProcessor = 567,
  AuthenticatorAssertionResponse = 589,
  AuthenticatorAttestationResponse = 620,
  AuthenticatorResponse = 653,
  BarProp = 675,
  BaseAudioContext = 683,
  BatteryManager = 700,
  BeforeUnloadEvent = 715,
  BiquadFilterNode = 733,
  Blob = 750,
  BlobEvent = 755,
  BroadcastChannel = 765,
  BrowsingContext = 782,
  BrowsingContextGroup = 798,
  ByteLengthQueuingStrategy = 819,
  CDATASection = 845,
  CSPViolationReportBody = 858,
  CSS = 881,
  CSS2Properties = 885,
  CSSAnimation = 900,
  CSSConditionRule = 913,
  CSSContainerRule = 930,
  CSSCounterStyleRule = 947,
  CSSCustomPropertyRegisteredEvent = 967,
  CSSFontFaceRule = 1000,
  CSSFontFeatureValuesRule = 1016,
  CSSFontPaletteValuesRule = 1041,
  CSSGroupingRule = 1066,
  CSSImportRule = 1082,
  CSSKeyframeRule = 1096,
  CSSKeyframesRule = 1112,
  CSSLayerBlockRule = 1129,
  CSSLayerStatementRule = 1147,
  CSSMarginRule = 1169,
  CSSMediaRule = 1183,
  CSSMozDocumentRule = 1196,
  CSSNamespaceRule = 1215,
  CSSNestedDeclarations = 1232,
  CSSPageDescriptors = 1254,
  CSSPageRule = 1273,
  CSSPositionTryDescriptors = 1285,
  CSSPositionTryRule = 1311,
  CSSPropertyRule = 1330,
  CSSPseudoElement = 1346,
  CSSRule = 1363,
  CSSRuleList = 1371,
  CSSScopeRule = 1383,
  CSSStartingStyleRule = 1396,
  CSSStyleDeclaration = 1417,
  CSSStyleRule = 1437,
  CSSStyleSheet = 1450,
  CSSSupportsRule = 1464,
  CSSTransition = 1480,
  Cache = 1494,
  CacheStorage = 1500,
  CallbackDebuggerNotification = 1513,
  CanonicalBrowsingContext = 1542,
  CanvasCaptureMediaStream = 1567,
  CanvasGradient = 1592,
  CanvasPattern = 1607,
  CanvasRenderingContext2D = 1621,
  CaretPosition = 1646,
  CaretStateChangedEvent = 1660,
  ChannelMergerNode = 1683,
  ChannelSplitterNode = 1701,
  ChannelWrapper = 1721,
  CharacterData = 1736,
  CheckerboardReportService = 1750,
  ChildProcessMessageManager = 1776,
  ChildSHistory = 1803,
  ChromeMessageBroadcaster = 1817,
  ChromeMessageSender = 1842,
  ChromeNodeList = 1862,
  ChromeUtils = 1877,
  ChromeWorker = 1889,
  Client = 1902,
  Clients = 1909,
  Clipboard = 1917,
  ClipboardEvent = 1927,
  ClipboardItem = 1942,
  ClonedErrorHolder = 1956,
  CloseEvent = 1974,
  CloseWatcher = 1985,
  CommandEvent = 1998,
  Comment = 2011,
  CompositionEvent = 2019,
  CompressionStream = 2036,
  ConsoleInstance = 2054,
  ConstantSourceNode = 2070,
  ContentFrameMessageManager = 2089,
  ContentProcessMessageManager = 2116,
  ContentVisibilityAutoStateChangeEvent = 2145,
  ConvolverNode = 2183,
  CookieChangeEvent = 2197,
  CookieStore = 2215,
  CookieStoreManager = 2227,
  CountQueuingStrategy = 2246,
  CreateOfferRequest = 2267,
  Credential = 2286,
  CredentialsContainer = 2297,
  Crypto = 2318,
  CryptoKey = 2325,
  CustomElementRegistry = 2335,
  CustomEvent = 2357,
  CustomStateSet = 2369,
  DOMException = 2384,
  DOMImplementation = 2397,
  DOMLocalization = 2415,
  DOMMatrix = 2431,
  DOMMatrixReadOnly = 2441,
  DOMParser = 2459,
  DOMPoint = 2469,
  DOMPointReadOnly = 2478,
  DOMQuad = 2495,
  DOMRect = 2503,
  DOMRectList = 2511,
  DOMRectReadOnly = 2523,
  DOMStringList = 2539,
  DOMStringMap = 2553,
  DOMTokenList = 2566,
  DataTransfer = 2579,
  DataTransferItem = 2592,
  DataTransferItemList = 2609,
  DebuggerNotification = 2630,
  DebuggerNotificationObserver = 2651,
  DecompressionStream = 2680,
  DedicatedWorkerGlobalScope = 2700,
  DelayNode = 2727,
  DeprecationReportBody = 2737,
  DeviceAcceleration = 2759,
  DeviceLightEvent = 2778,
  DeviceMotionEvent = 2795,
  DeviceOrientationEvent = 2813,
  DeviceRotationRate = 2836,
  Directory = 2855,
  Document = 2865,
  DocumentFragment = 2874,
  DocumentL10n = 2891,
  DocumentTimeline = 2904,
  DocumentType = 2921,
  DominatorTree = 2934,
  DragEvent = 2948,
  DynamicsCompressorNode = 2958,
  EXT_blend_minmax = 2981,
  EXT_color_buffer_float = 2998,
  EXT_color_buffer_half_float = 3021,
  EXT_depth_clamp = 3049,
  EXT_disjoint_timer_query = 3065,
  EXT_float_blend = 3090,
  EXT_frag_depth = 3106,
  EXT_sRGB = 3121,
  EXT_shader_texture_lod = 3130,
  EXT_texture_compression_bptc = 3153,
  EXT_texture_compression_rgtc = 3182,
  EXT_texture_filter_anisotropic = 3211,
  EXT_texture_norm16 = 3242,
  Element = 3261,
  ElementInternals = 3269,
  EncodedAudioChunk = 3286,
  EncodedVideoChunk = 3304,
  ErrorEvent = 3322,
  Event = 3333,
  EventCallbackDebuggerNotification = 3339,
  EventCounts = 3373,
  EventSource = 3385,
  EventTarget = 3397,
  Exception = 3409,
  ExtendableCookieChangeEvent = 3419,
  ExtendableEvent = 3447,
  ExtendableMessageEvent = 3463,
  ExtensionAlarms = 3486,
  ExtensionBrowser = 3502,
  ExtensionBrowserSettings = 3519,
  ExtensionBrowserSettingsColorManagement = 3544,
  ExtensionDns = 3584,
  ExtensionEventManager = 3597,
  ExtensionMockAPI = 3619,
  ExtensionPort = 3636,
  ExtensionProxy = 3650,
  ExtensionRuntime = 3665,
  ExtensionScripting = 3682,
  ExtensionSetting = 3701,
  ExtensionTest = 3718,
  External = 3732,
  FeaturePolicy = 3741,
  FeaturePolicyViolationReportBody = 3755,
  FetchEvent = 3788,
  FetchObserver = 3799,
  File = 3813,
  FileList = 3818,
  FileReader = 3827,
  FileReaderSync = 3838,
  FileSystem = 3853,
  FileSystemDirectoryEntry = 3864,
  FileSystemDirectoryHandle = 3889,
  FileSystemDirectoryHandle_AsyncIterator = 3915,
  FileSystemDirectoryIterator = 3955,
  FileSystemDirectoryReader = 3983,
  FileSystemEntry = 4009,
  FileSystemFileEntry = 4025,
  FileSystemFileHandle = 4045,
  FileSystemHandle = 4066,
  FileSystemSyncAccessHandle = 4083,
  FileSystemWritableFileStream = 4110,
  Flex = 4139,
  FlexItemValues = 4144,
  FlexLineValues = 4159,
  FluentBundle = 4174,
  FluentBundleAsyncIterator = 4187,
  FluentBundleIterator = 4213,
  FluentPattern = 4234,
  FluentResource = 4248,
  FocusEvent = 4263,
  FontFace = 4274,
  FontFaceSet = 4283,
  FontFaceSetIterator = 4295,
  FontFaceSetLoadEvent = 4315,
  FormData = 4336,
  FormData_Iterator = 4345,
  FormDataEvent = 4363,
  FragmentDirective = 4377,
  FrameCrashedEvent = 4395,
  FrameLoader = 4413,
  GPU = 4425,
  GPUAdapter = 4429,
  GPUAdapterInfo = 4440,
  GPUBindGroup = 4455,
  GPUBindGroupLayout = 4468,
  GPUBuffer = 4487,
  GPUBufferUsage = 4497,
  GPUCanvasContext = 4512,
  GPUColorWrite = 4529,
  GPUCommandBuffer = 4543,
  GPUCommandEncoder = 4560,
  GPUCompilationInfo = 4578,
  GPUCompilationMessage = 4597,
  GPUComputePassEncoder = 4619,
  GPUComputePipeline = 4641,
  GPUDevice = 4660,
  GPUDeviceLostInfo = 4670,
  GPUError = 4688,
  GPUExternalTexture = 4697,
  GPUInternalError = 4716,
  GPUMapMode = 4733,
  GPUOutOfMemoryError = 4744,
  GPUPipelineError = 4764,
  GPUPipelineLayout = 4781,
  GPUQuerySet = 4799,
  GPUQueue = 4811,
  GPURenderBundle = 4820,
  GPURenderBundleEncoder = 4836,
  GPURenderPassEncoder = 4859,
  GPURenderPipeline = 4880,
  GPUSampler = 4898,
  GPUShaderModule = 4909,
  GPUShaderStage = 4925,
  GPUSupportedFeatures = 4940,
  GPUSupportedLimits = 4961,
  GPUTexture = 4980,
  GPUTextureUsage = 4991,
  GPUTextureView = 5007,
  GPUUncapturedErrorEvent = 5022,
  GPUValidationError = 5046,
  GainNode = 5065,
  Gamepad = 5074,
  GamepadAxisMoveEvent = 5082,
  GamepadButton = 5103,
  GamepadButtonEvent = 5117,
  GamepadEvent = 5136,
  GamepadHapticActuator = 5149,
  GamepadLightIndicator = 5171,
  GamepadPose = 5193,
  GamepadServiceTest = 5205,
  GamepadTouch = 5224,
  Geolocation = 5237,
  GeolocationCoordinates = 5249,
  GeolocationPosition = 5272,
  GeolocationPositionError = 5292,
  GetUserMediaRequest = 5317,
  GleanBoolean = 5337,
  GleanCategory = 5350,
  GleanCounter = 5364,
  GleanCustomDistribution = 5377,
  GleanDatetime = 5401,
  GleanDenominator = 5415,
  GleanEvent = 5432,
  GleanImpl = 5443,
  GleanLabeled = 5453,
  GleanMemoryDistribution = 5466,
  GleanMetric = 5490,
  GleanNumerator = 5502,
  GleanObject = 5517,
  GleanPingsImpl = 5529,
  GleanQuantity = 5544,
  GleanRate = 5558,
  GleanString = 5568,
  GleanStringList = 5580,
  GleanText = 5596,
  GleanTimespan = 5606,
  GleanTimingDistribution = 5620,
  GleanUrl = 5644,
  GleanUuid = 5653,
  Grid = 5663,
  GridArea = 5668,
  GridDimension = 5677,
  GridLine = 5691,
  GridLines = 5700,
  GridTrack = 5710,
  GridTracks = 5720,
  HTMLAllCollection = 5731,
  HTMLAnchorElement = 5749,
  HTMLAreaElement = 5767,
  HTMLAudioElement = 5783,
  HTMLBRElement = 5800,
  HTMLBaseElement = 5814,
  HTMLBodyElement = 5830,
  HTMLButtonElement = 5846,
  HTMLCanvasElement = 5864,
  HTMLCollection = 5882,
  HTMLDListElement = 5897,
  HTMLDataElement = 5914,
  HTMLDataListElement = 5930,
  HTMLDetailsElement = 5950,
  HTMLDialogElement = 5969,
  HTMLDirectoryElement = 5987,
  HTMLDivElement = 6008,
  HTMLDocument = 6023,
  HTMLElement = 6036,
  HTMLEmbedElement = 6048,
  HTMLFieldSetElement = 6065,
  HTMLFontElement = 6085,
  HTMLFormControlsCollection = 6101,
  HTMLFormElement = 6128,
  HTMLFrameElement = 6144,
  HTMLFrameSetElement = 6161,
  HTMLHRElement = 6181,
  HTMLHeadElement = 6195,
  HTMLHeadingElement = 6211,
  HTMLHtmlElement = 6230,
  HTMLIFrameElement = 6246,
  HTMLImageElement = 6264,
  HTMLInputElement = 6281,
  HTMLLIElement = 6298,
  HTMLLabelElement = 6312,
  HTMLLegendElement = 6329,
  HTMLLinkElement = 6347,
  HTMLMapElement = 6363,
  HTMLMarqueeElement = 6378,
  HTMLMediaElement = 6397,
  HTMLMenuElement = 6414,
  HTMLMetaElement = 6430,
  HTMLMeterElement = 6446,
  HTMLModElement = 6463,
  HTMLOListElement = 6478,
  HTMLObjectElement = 6495,
  HTMLOptGroupElement = 6513,
  HTMLOptionElement = 6533,
  HTMLOptionsCollection = 6551,
  HTMLOutputElement = 6573,
  HTMLParagraphElement = 6591,
  HTMLParamElement = 6612,
  HTMLPictureElement = 6629,
  HTMLPreElement = 6648,
  HTMLProgressElement = 6663,
  HTMLQuoteElement = 6683,
  HTMLScriptElement = 6700,
  HTMLSelectElement = 6718,
  HTMLSlotElement = 6736,
  HTMLSourceElement = 6752,
  HTMLSpanElement = 6770,
  HTMLStyleElement = 6786,
  HTMLTableCaptionElement = 6803,
  HTMLTableCellElement = 6827,
  HTMLTableColElement = 6848,
  HTMLTableElement = 6868,
  HTMLTableRowElement = 6885,
  HTMLTableSectionElement = 6905,
  HTMLTemplateElement = 6929,
  HTMLTextAreaElement = 6949,
  HTMLTimeElement = 6969,
  HTMLTitleElement = 6985,
  HTMLTrackElement = 7002,
  HTMLUListElement = 7019,
  HTMLUnknownElement = 7036,
  HTMLVideoElement = 7055,
  HashChangeEvent = 7072,
  Headers = 7088,
  Headers_Iterator = 7096,
  HeapSnapshot = 7113,
  Highlight = 7126,
  HighlightRegistry = 7136,
  History = 7154,
  IDBCursor = 7162,
  IDBCursorWithValue = 7172,
  IDBDatabase = 7191,
  IDBFactory = 7203,
  IDBIndex = 7214,
  IDBKeyRange = 7223,
  IDBObjectStore = 7235,
  IDBOpenDBRequest = 7250,
  IDBRequest = 7267,
  IDBTransaction = 7278,
  IDBVersionChangeEvent = 7293,
  IIRFilterNode = 7315,
  IOUtils = 7329,
  IdentityCredential = 7337,
  IdleDeadline = 7356,
  Image = 7369,
  ImageBitmap = 7375,
  ImageBitmapRenderingContext = 7387,
  ImageCapture = 7415,
  ImageCaptureError = 7428,
  ImageCaptureErrorEvent = 7446,
  ImageData = 7469,
  ImageDecoder = 7479,
  ImageDocument = 7492,
  ImageTrack = 7506,
  ImageTrackList = 7517,
  InputEvent = 7532,
  InspectorCSSParser = 7543,
  InspectorFontFace = 7562,
  InspectorUtils = 7580,
  InstallTriggerImpl = 7595,
  IntersectionObserver = 7614,
  IntersectionObserverEntry = 7635,
  IntlUtils = 7661,
  InvokeEvent = 7671,
  JSProcessActorChild = 7683,
  JSProcessActorParent = 7703,
  JSWindowActorChild = 7724,
  JSWindowActorParent = 7743,
  KeyEvent = 7763,
  KeyboardEvent = 7772,
  KeyframeEffect = 7786,
  L10nFileSource = 7801,
  L10nOverlays = 7816,
  L10nRegistry = 7829,
  LargestContentfulPaint = 7842,
  LegacyMozTCPSocket = 7865,
  Localization = 7884,
  Location = 7897,
  Lock = 7906,
  LockManager = 7911,
  MIDIAccess = 7923,
  MIDIConnectionEvent = 7934,
  MIDIInput = 7954,
  MIDIInputMap = 7964,
  MIDIMessageEvent = 7977,
  MIDIOutput = 7994,
  MIDIOutputMap = 8005,
  MIDIPort = 8019,
  MLS = 8028,
  MLSGroupView = 8032,
  MOZ_debug = 8045,
  MatchGlob = 8055,
  MatchPattern = 8065,
  MatchPatternSet = 8078,
  MathMLElement = 8094,
  MediaCapabilities = 8108,
  MediaControlService = 8126,
  MediaController = 8146,
  MediaDeviceInfo = 8162,
  MediaDevices = 8178,
  MediaElementAudioSourceNode = 8191,
  MediaEncryptedEvent = 8219,
  MediaError = 8239,
  MediaKeyError = 8250,
  MediaKeyMessageEvent = 8264,
  MediaKeySession = 8285,
  MediaKeyStatusMap = 8301,
  MediaKeyStatusMap_Iterator = 8319,
  MediaKeySystemAccess = 8346,
  MediaKeys = 8367,
  MediaList = 8377,
  MediaMetadata = 8387,
  MediaQueryList = 8401,
  MediaQueryListEvent = 8416,
  MediaRecorder = 8436,
  MediaRecorderErrorEvent = 8450,
  MediaSession = 8474,
  MediaSource = 8487,
  MediaStream = 8499,
  MediaStreamAudioDestinationNode = 8511,
  MediaStreamAudioSourceNode = 8543,
  MediaStreamError = 8570,
  MediaStreamEvent = 8587,
  MediaStreamTrack = 8604,
  MediaStreamTrackAudioSourceNode = 8621,
  MediaStreamTrackEvent = 8653,
  MerchantValidationEvent = 8675,
  MessageBroadcaster = 8699,
  MessageChannel = 8718,
  MessageEvent = 8733,
  MessageListenerManager = 8746,
  MessagePort = 8769,
  MessageSender = 8781,
  MimeType = 8795,
  MimeTypeArray = 8804,
  MouseEvent = 8818,
  MouseScrollEvent = 8829,
  MozCanvasPrintState = 8846,
  MozDocumentMatcher = 8866,
  MozDocumentObserver = 8885,
  MozQueryInterface = 8905,
  MozSharedMap = 8923,
  MozSharedMap_Iterator = 8936,
  MozSharedMapChangeEvent = 8958,
  MozStorageAsyncStatementParams = 8982,
  MozStorageStatementParams = 9013,
  MozStorageStatementRow = 9039,
  MozWritableSharedMap = 9062,
  MutationEvent = 9083,
  MutationObserver = 9097,
  MutationRecord = 9114,
  NamedNodeMap = 9129,
  NavigateEvent = 9142,
  Navigation = 9156,
  NavigationActivation = 9167,
  NavigationCurrentEntryChangeEvent = 9188,
  NavigationDestination = 9222,
  NavigationHistoryEntry = 9244,
  NavigationPreloadManager = 9267,
  NavigationTransition = 9292,
  Navigator = 9313,
  NavigatorLogin = 9323,
  NetworkInformation = 9338,
  Node = 9357,
  NodeFilter = 9362,
  NodeIterator = 9373,
  NodeList = 9386,
  Notification = 9395,
  NotificationEvent = 9408,
  NotifyPaintEvent = 9426,
  OES_draw_buffers_indexed = 9443,
  OES_element_index_uint = 9468,
  OES_fbo_render_mipmap = 9491,
  OES_standard_derivatives = 9513,
  OES_texture_float = 9538,
  OES_texture_float_linear = 9556,
  OES_texture_half_float = 9581,
  OES_texture_half_float_linear = 9604,
  OES_vertex_array_object = 9634,
  OVR_multiview2 = 9658,
  OfflineAudioCompletionEvent = 9673,
  OfflineAudioContext = 9701,
  OffscreenCanvas = 9721,
  OffscreenCanvasRenderingContext2D = 9737,
  Option = 9771,
  OscillatorNode = 9778,
  PageTransitionEvent = 9793,
  PaintRequest = 9813,
  PaintRequestList = 9826,
  PaintWorkletGlobalScope = 9843,
  PannerNode = 9867,
  ParentProcessMessageManager = 9878,
  Path2D = 9906,
  PathUtils = 9913,
  PaymentAddress = 9923,
  PaymentMethodChangeEvent = 9938,
  PaymentRequest = 9963,
  PaymentRequestUpdateEvent = 9978,
  PaymentResponse = 10004,
  Performance = 10020,
  PerformanceEntry = 10032,
  PerformanceEntryEvent = 10049,
  PerformanceEventTiming = 10071,
  PerformanceMark = 10094,
  PerformanceMeasure = 10110,
  PerformanceNavigation = 10129,
  PerformanceNavigationTiming = 10151,
  PerformanceObserver = 10179,
  PerformanceObserverEntryList = 10199,
  PerformancePaintTiming = 10228,
  PerformanceResourceTiming = 10251,
  PerformanceServerTiming = 10277,
  PerformanceTiming = 10301,
  PeriodicWave = 10319,
  PermissionStatus = 10332,
  Permissions = 10349,
  PlacesBookmark = 10361,
  PlacesBookmarkAddition = 10376,
  PlacesBookmarkChanged = 10399,
  PlacesBookmarkGuid = 10421,
  PlacesBookmarkKeyword = 10440,
  PlacesBookmarkMoved = 10462,
  PlacesBookmarkRemoved = 10482,
  PlacesBookmarkTags = 10504,
  PlacesBookmarkTime = 10523,
  PlacesBookmarkTitle = 10542,
  PlacesBookmarkUrl = 10562,
  PlacesEvent = 10580,
  PlacesEventCounts = 10592,
  PlacesFavicon = 10610,
  PlacesHistoryCleared = 10624,
  PlacesObservers = 10645,
  PlacesPurgeCaches = 10661,
  PlacesRanking = 10679,
  PlacesVisit = 10693,
  PlacesVisitRemoved = 10705,
  PlacesVisitTitle = 10724,
  PlacesWeakCallbackWrapper = 10741,
  Plugin = 10767,
  PluginArray = 10774,
  PluginCrashedEvent = 10786,
  PointerEvent = 10805,
  PopStateEvent = 10818,
  PopupBlockedEvent = 10832,
  PopupPositionedEvent = 10850,
  PositionStateEvent = 10871,
  PrecompiledScript = 10890,
  PrivateAttribution = 10908,
  ProcessMessageManager = 10927,
  ProcessingInstruction = 10949,
  ProgressEvent = 10971,
  PromiseDebugging = 10985,
  PromiseNativeHandler = 11002,
  PromiseRejectionEvent = 11023,
  PublicKeyCredential = 11045,
  PushEvent = 11065,
  PushManager = 11075,
  PushManagerImpl = 11087,
  PushMessageData = 11103,
  PushSubscription = 11119,
  PushSubscriptionChangeEvent = 11136,
  PushSubscriptionOptions = 11164,
  RadioNodeList = 11188,
  Range = 11202,
  ReadableByteStreamController = 11208,
  ReadableStream = 11237,
  ReadableStream_AsyncIterator = 11252,
  ReadableStreamBYOBReader = 11281,
  ReadableStreamBYOBRequest = 11306,
  ReadableStreamDefaultController = 11332,
  ReadableStreamDefaultReader = 11364,
  RedirectBlockedEvent = 11392,
  Report = 11413,
  ReportBody = 11420,
  ReportingObserver = 11431,
  Request = 11449,
  ResizeObserver = 11457,
  ResizeObserverEntry = 11472,
  ResizeObserverSize = 11492,
  Response = 11511,
  SVGAElement = 11520,
  SVGAngle = 11532,
  SVGAnimateElement = 11541,
  SVGAnimateMotionElement = 11559,
  SVGAnimateTransformElement = 11583,
  SVGAnimatedAngle = 11610,
  SVGAnimatedBoolean = 11627,
  SVGAnimatedEnumeration = 11646,
  SVGAnimatedInteger = 11669,
  SVGAnimatedLength = 11688,
  SVGAnimatedLengthList = 11706,
  SVGAnimatedNumber = 11728,
  SVGAnimatedNumberList = 11746,
  SVGAnimatedPreserveAspectRatio = 11768,
  SVGAnimatedRect = 11799,
  SVGAnimatedString = 11815,
  SVGAnimatedTransformList = 11833,
  SVGAnimationElement = 11858,
  SVGCircleElement = 11878,
  SVGClipPathElement = 11895,
  SVGComponentTransferFunctionElement = 11914,
  SVGDefsElement = 11950,
  SVGDescElement = 11965,
  SVGElement = 11980,
  SVGEllipseElement = 11991,
  SVGFEBlendElement = 12009,
  SVGFEColorMatrixElement = 12027,
  SVGFEComponentTransferElement = 12051,
  SVGFECompositeElement = 12081,
  SVGFEConvolveMatrixElement = 12103,
  SVGFEDiffuseLightingElement = 12130,
  SVGFEDisplacementMapElement = 12158,
  SVGFEDistantLightElement = 12186,
  SVGFEDropShadowElement = 12211,
  SVGFEFloodElement = 12234,
  SVGFEFuncAElement = 12252,
  SVGFEFuncBElement = 12270,
  SVGFEFuncGElement = 12288,
  SVGFEFuncRElement = 12306,
  SVGFEGaussianBlurElement = 12324,
  SVGFEImageElement = 12349,
  SVGFEMergeElement = 12367,
  SVGFEMergeNodeElement = 12385,
  SVGFEMorphologyElement = 12407,
  SVGFEOffsetElement = 12430,
  SVGFEPointLightElement = 12449,
  SVGFESpecularLightingElement = 12472,
  SVGFESpotLightElement = 12501,
  SVGFETileElement = 12523,
  SVGFETurbulenceElement = 12540,
  SVGFilterElement = 12563,
  SVGForeignObjectElement = 12580,
  SVGGElement = 12604,
  SVGGeometryElement = 12616,
  SVGGradientElement = 12635,
  SVGGraphicsElement = 12654,
  SVGImageElement = 12673,
  SVGLength = 12689,
  SVGLengthList = 12699,
  SVGLineElement = 12713,
  SVGLinearGradientElement = 12728,
  SVGMPathElement = 12753,
  SVGMarkerElement = 12769,
  SVGMaskElement = 12786,
  SVGMatrix = 12801,
  SVGMetadataElement = 12811,
  SVGNumber = 12830,
  SVGNumberList = 12840,
  SVGPathElement = 12854,
  SVGPathSegment = 12869,
  SVGPatternElement = 12884,
  SVGPoint = 12902,
  SVGPointList = 12911,
  SVGPolygonElement = 12924,
  SVGPolylineElement = 12942,
  SVGPreserveAspectRatio = 12961,
  SVGRadialGradientElement = 12984,
  SVGRect = 13009,
  SVGRectElement = 13017,
  SVGSVGElement = 13032,
  SVGScriptElement = 13046,
  SVGSetElement = 13063,
  SVGStopElement = 13077,
  SVGStringList = 13092,
  SVGStyleElement = 13106,
  SVGSwitchElement = 13122,
  SVGSymbolElement = 13139,
  SVGTSpanElement = 13156,
  SVGTextContentElement = 13172,
  SVGTextElement = 13194,
  SVGTextPathElement = 13209,
  SVGTextPositioningElement = 13228,
  SVGTitleElement = 13254,
  SVGTransform = 13270,
  SVGTransformList = 13283,
  SVGUnitTypes = 13300,
  SVGUseElement = 13313,
  SVGViewElement = 13327,
  Sanitizer = 13342,
  Scheduler = 13352,
  Screen = 13362,
  ScreenLuminance = 13369,
  ScreenOrientation = 13385,
  ScriptProcessorNode = 13403,
  ScrollAreaEvent = 13423,
  SecurityPolicyViolationEvent = 13439,
  Selection = 13468,
  ServiceWorker = 13478,
  ServiceWorkerContainer = 13492,
  ServiceWorkerGlobalScope = 13515,
  ServiceWorkerRegistration = 13540,
  SessionStoreFormData = 13566,
  SessionStoreScrollData = 13587,
  SessionStoreUtils = 13610,
  ShadowRealmGlobalScope = 13628,
  ShadowRoot = 13651,
  SharedWorker = 13662,
  SharedWorkerGlobalScope = 13675,
  SimpleGestureEvent = 13699,
  SourceBuffer = 13718,
  SourceBufferList = 13731,
  SpeechGrammar = 13748,
  SpeechGrammarList = 13762,
  SpeechRecognition = 13780,
  SpeechRecognitionAlternative = 13798,
  SpeechRecognitionError = 13827,
  SpeechRecognitionEvent = 13850,
  SpeechRecognitionResult = 13873,
  SpeechRecognitionResultList = 13897,
  SpeechSynthesis = 13925,
  SpeechSynthesisErrorEvent = 13941,
  SpeechSynthesisEvent = 13967,
  SpeechSynthesisUtterance = 13988,
  SpeechSynthesisVoice = 14013,
  StaticRange = 14034,
  StereoPannerNode = 14046,
  Storage = 14063,
  StorageEvent = 14071,
  StorageManager = 14084,
  StreamFilter = 14099,
  StreamFilterDataEvent = 14112,
  StructuredCloneHolder = 14134,
  StructuredCloneTester = 14156,
  StyleSheet = 14178,
  StyleSheetApplicableStateChangeEvent = 14189,
  StyleSheetList = 14226,
  StyleSheetRemovedEvent = 14241,
  SubmitEvent = 14264,
  SubtleCrypto = 14276,
  SyncMessageSender = 14289,
  SyncReadFile = 14307,
  TCPServerSocket = 14320,
  TCPServerSocketEvent = 14336,
  TCPSocket = 14357,
  TCPSocketErrorEvent = 14367,
  TCPSocketEvent = 14387,
  TaskController = 14402,
  TaskPriorityChangeEvent = 14417,
  TaskSignal = 14441,
  TestUtils = 14452,
  TestingDeprecatedInterface = 14462,
  Text = 14489,
  TextClause = 14494,
  TextDecoder = 14505,
  TextDecoderStream = 14517,
  TextEncoder = 14535,
  TextEncoderStream = 14547,
  TextEvent = 14565,
  TextMetrics = 14575,
  TextTrack = 14587,
  TextTrackCue = 14597,
  TextTrackCueList = 14610,
  TextTrackList = 14627,
  TimeEvent = 14641,
  TimeRanges = 14651,
  ToggleEvent = 14662,
  Touch = 14674,
  TouchEvent = 14680,
  TouchList = 14691,
  TrackEvent = 14701,
  TransformStream = 14712,
  TransformStreamDefaultController = 14728,
  TransitionEvent = 14761,
  TreeColumn = 14777,
  TreeColumns = 14788,
  TreeContentView = 14800,
  TreeWalker = 14816,
  TrustedHTML = 14827,
  TrustedScript = 14839,
  TrustedScriptURL = 14853,
  TrustedTypePolicy = 14870,
  TrustedTypePolicyFactory = 14888,
  UDPMessageEvent = 14913,
  UDPSocket = 14929,
  UIEvent = 14939,
  URL = 14947,
  URLSearchParams = 14951,
  URLSearchParams_Iterator = 14967,
  UniFFIPointer = 14992,
  UniFFIScaffolding = 15006,
  UserActivation = 15024,
  UserInteraction = 15039,
  UserProximityEvent = 15055,
  VRDisplay = 15074,
  VRDisplayCapabilities = 15084,
  VRDisplayEvent = 15106,
  VREyeParameters = 15121,
  VRFieldOfView = 15137,
  VRFrameData = 15151,
  VRMockController = 15163,
  VRMockDisplay = 15180,
  VRPose = 15194,
  VRServiceTest = 15201,
  VRStageParameters = 15215,
  VTTCue = 15233,
  VTTRegion = 15240,
  ValidityState = 15250,
  VideoColorSpace = 15264,
  VideoDecoder = 15280,
  VideoEncoder = 15293,
  VideoFrame = 15306,
  VideoPlaybackQuality = 15317,
  VideoTrack = 15338,
  VideoTrackList = 15349,
  ViewTransition = 15364,
  VisualViewport = 15379,
  WEBGL_color_buffer_float = 15394,
  WEBGL_compressed_texture_astc = 15419,
  WEBGL_compressed_texture_etc = 15449,
  WEBGL_compressed_texture_etc1 = 15478,
  WEBGL_compressed_texture_pvrtc = 15508,
  WEBGL_compressed_texture_s3tc = 15539,
  WEBGL_compressed_texture_s3tc_srgb = 15569,
  WEBGL_debug_renderer_info = 15604,
  WEBGL_debug_shaders = 15630,
  WEBGL_depth_texture = 15650,
  WEBGL_draw_buffers = 15670,
  WEBGL_explicit_present = 15689,
  WEBGL_lose_context = 15712,
  WEBGL_provoking_vertex = 15731,
  WGSLLanguageFeatures = 15754,
  WakeLock = 15775,
  WakeLockSentinel = 15784,
  WaveShaperNode = 15801,
  WebExtensionContentScript = 15816,
  WebExtensionPolicy = 15842,
  WebGL2RenderingContext = 15861,
  WebGLActiveInfo = 15884,
  WebGLBuffer = 15900,
  WebGLContextEvent = 15912,
  WebGLFramebuffer = 15930,
  WebGLProgram = 15947,
  WebGLQuery = 15960,
  WebGLRenderbuffer = 15971,
  WebGLRenderingContext = 15989,
  WebGLSampler = 16011,
  WebGLShader = 16024,
  WebGLShaderPrecisionFormat = 16036,
  WebGLSync = 16063,
  WebGLTexture = 16073,
  WebGLTransformFeedback = 16086,
  WebGLUniformLocation = 16109,
  WebGLVertexArrayObject = 16130,
  WebKitCSSMatrix = 16153,
  WebSocket = 16169,
  WebTransport = 16179,
  WebTransportBidirectionalStream = 16192,
  WebTransportDatagramDuplexStream = 16224,
  WebTransportError = 16257,
  WebTransportReceiveStream = 16275,
  WebTransportSendStream = 16301,
  WheelEvent = 16324,
  Window = 16335,
  WindowClient = 16342,
  WindowContext = 16355,
  WindowGlobalChild = 16369,
  WindowGlobalParent = 16387,
  WindowRoot = 16406,
  Worker = 16417,
  WorkerDebuggerGlobalScope = 16424,
  WorkerGlobalScope = 16450,
  WorkerLocation = 16468,
  WorkerNavigator = 16483,
  WorkerTestUtils = 16499,
  Worklet = 16515,
  WorkletGlobalScope = 16523,
  WritableStream = 16542,
  WritableStreamDefaultController = 16557,
  WritableStreamDefaultWriter = 16589,
  XMLDocument = 16617,
  XMLHttpRequest = 16629,
  XMLHttpRequestEventTarget = 16644,
  XMLHttpRequestUpload = 16670,
  XMLSerializer = 16691,
  XPathEvaluator = 16705,
  XPathExpression = 16720,
  XPathResult = 16736,
  XRBoundedReferenceSpace = 16748,
  XRFrame = 16772,
  XRInputSource = 16780,
  XRInputSourceArray = 16794,
  XRInputSourceEvent = 16813,
  XRInputSourcesChangeEvent = 16832,
  XRPose = 16858,
  XRReferenceSpace = 16865,
  XRReferenceSpaceEvent = 16882,
  XRRenderState = 16904,
  XRRigidTransform = 16918,
  XRSession = 16935,
  XRSessionEvent = 16945,
  XRSpace = 16960,
  XRSystem = 16968,
  XRView = 16977,
  XRViewerPose = 16984,
  XRViewport = 16997,
  XRWebGLLayer = 17008,
  XSLTProcessor = 17021,
  XULCommandEvent = 17035,
  XULElement = 17051,
  XULFrameElement = 17062,
  XULMenuElement = 17078,
  XULPopupElement = 17093,
  XULResizerElement = 17109,
  XULTextElement = 17127,
  XULTreeElement = 17142,
  console = 17157,
  webkitSpeechGrammar = 17165,
  webkitSpeechGrammarList = 17185,
  webkitSpeechRecognition = 17209,
  webkitURL = 17233,
};

namespace binding_detail {
extern const char sBindingNames[];
}  // namespace binding_detail

MOZ_ALWAYS_INLINE const char* BindingName(BindingNamesOffset aOffset) {
  return binding_detail::sBindingNames + static_cast<size_t>(aOffset);
}

} // namespace mozilla::dom


#endif // DOM_BINDINGNAMES_H_
