// For documentation of the format, see README in this directory.
var browserTests = [
["foo[]bar",
    [["fontsize","4"]],
    "foo[]bar",
    [true],
    {"fontsize":[false,false,"3",false,false,"4"]}],
["<p>[foo</p> <p>bar]</p>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<p><span style=\"font-size:large\">[foo</span></p> <p><span style=\"font-size:large\">bar]</span></p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<p>[foo</p> <p>bar]</p>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<p><font size=\"4\">[foo</font></p> <p><font size=\"4\">bar]</font></p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<span>[foo</span> <span>bar]</span>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<span style=\"font-size:large\"><span>[foo</span> <span>bar]</span></span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<span>[foo</span> <span>bar]</span>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<font size=\"4\"><span>[foo</span> <span>bar]</span></font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<p>[foo</p><p> <span>bar</span> </p><p>baz]</p>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<p><span style=\"font-size:large\">[foo</span></p><p> <span style=\"font-size:large\"><span>bar</span></span> </p><p><span style=\"font-size:large\">baz]</span></p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<p>[foo</p><p> <span>bar</span> </p><p>baz]</p>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<p><font size=\"4\">[foo</font></p><p> <font size=\"4\"><span>bar</span></font> </p><p><font size=\"4\">baz]</font></p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<p>[foo<p><br><p>bar]",
    [["stylewithcss","true"],["fontsize","4"]],
    "<p><span style=\"font-size:large\">[foo</span></p><p><br></p><p><span style=\"font-size:large\">bar]</span></p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",true,false,"4"]}],
["<p>[foo<p><br><p>bar]",
    [["stylewithcss","false"],["fontsize","4"]],
    "<p><font size=\"4\">[foo</font></p><p><br></p><p><font size=\"4\">bar]</font></p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",true,false,"4"]}],
["<b>foo[]bar</b>",
    [["fontsize","4"]],
    "<b>foo[]bar</b>",
    [true],
    {"fontsize":[false,false,"3",false,false,"4"]}],
["<i>foo[]bar</i>",
    [["fontsize","4"]],
    "<i>foo[]bar</i>",
    [true],
    {"fontsize":[false,false,"3",false,false,"4"]}],
["<span>foo</span>{}<span>bar</span>",
    [["fontsize","4"]],
    "<span>foo</span>{}<span>bar</span>",
    [true],
    {"fontsize":[false,false,"3",false,false,"4"]}],
["<span>foo[</span><span>]bar</span>",
    [["fontsize","4"]],
    "<span>foo[</span><span>]bar</span>",
    [true],
    {"fontsize":[false,false,"3",false,false,"4"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["fontsize","4"]],
    "foo<span style=\"font-size:large\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["fontsize","4"]],
    "foo<font size=\"4\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["foo[bar<b>baz]qoz</b>quz",
    [["stylewithcss","true"],["fontsize","4"]],
    "foo<span style=\"font-size:large\">[bar</span><b><span style=\"font-size:large\">baz]</span>qoz</b>quz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["foo[bar<b>baz]qoz</b>quz",
    [["stylewithcss","false"],["fontsize","4"]],
    "foo<font size=\"4\">[bar</font><b><font size=\"4\">baz]</font>qoz</b>quz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["foo[bar<i>baz]qoz</i>quz",
    [["stylewithcss","true"],["fontsize","4"]],
    "foo<span style=\"font-size:large\">[bar</span><i><span style=\"font-size:large\">baz]</span>qoz</i>quz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["foo[bar<i>baz]qoz</i>quz",
    [["stylewithcss","false"],["fontsize","4"]],
    "foo<font size=\"4\">[bar</font><i><font size=\"4\">baz]</font>qoz</i>quz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["{<p><p> <p>foo</p>}",
    [["stylewithcss","true"],["fontsize","4"]],
    "{<p></p><p> </p><p><span style=\"font-size:large\">foo</span></p>}",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["{<p><p> <p>foo</p>}",
    [["stylewithcss","false"],["fontsize","4"]],
    "{<p></p><p> </p><p><font size=\"4\">foo</font></p>}",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["fontsize","1"]],
    "foo<span style=\"font-size:x-small\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["fontsize","1"]],
    "foo<font size=\"1\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["fontsize","0"]],
    "foo<span style=\"font-size:x-small\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["fontsize","0"]],
    "foo<font size=\"1\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["fontsize","-5"]],
    "foo<span style=\"font-size:x-small\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["fontsize","-5"]],
    "foo<font size=\"1\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["fontsize","6"]],
    "foo<span style=\"font-size:xx-large\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"6"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["fontsize","6"]],
    "foo<font size=\"6\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"6"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["fontsize","7"]],
    "foo<font size=\"7\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"7"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["fontsize","7"]],
    "foo<font size=\"7\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"7"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["fontsize","8"]],
    "foo<font size=\"7\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"7"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["fontsize","8"]],
    "foo<font size=\"7\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"7"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["fontsize","100"]],
    "foo<font size=\"7\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"7"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["fontsize","100"]],
    "foo<font size=\"7\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"7"]}],
["foo[bar]baz",
    [["fontsize","2em"]],
    "foo[bar]baz",
    [false],
    {"fontsize":[false,false,"3",false,false,"3"]}],
["foo[bar]baz",
    [["fontsize","20pt"]],
    "foo[bar]baz",
    [false],
    {"fontsize":[false,false,"3",false,false,"3"]}],
["foo[bar]baz",
    [["fontsize","xx-large"]],
    "foo[bar]baz",
    [false],
    {"fontsize":[false,false,"3",false,false,"3"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["fontsize"," 1 "]],
    "foo<span style=\"font-size:x-small\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["fontsize"," 1 "]],
    "foo<font size=\"1\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
    [["fontsize","1."]],
    "foo[bar]baz",
    [false],
    {"fontsize":[false,false,"3",false,false,"3"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["fontsize","1.0"]],
    "foo<span style=\"font-size:x-small\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["fontsize","1.0"]],
    "foo<font size=\"1\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["fontsize","1.0e2"]],
    "foo<span style=\"font-size:x-small\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["fontsize","1.0e2"]],
    "foo<font size=\"1\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["fontsize","1.1"]],
    "foo<span style=\"font-size:x-small\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["fontsize","1.1"]],
    "foo<font size=\"1\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["fontsize","1.9"]],
    "foo<span style=\"font-size:x-small\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["fontsize","1.9"]],
    "foo<font size=\"1\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
    [["fontsize","+0"]],
    "foo[bar]baz",
    [true],
    {"fontsize":[false,false,"3",false,false,"3"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["fontsize","+1"]],
    "foo<span style=\"font-size:large\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["fontsize","+1"]],
    "foo<font size=\"4\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["fontsize","+9"]],
    "foo<font size=\"7\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"7"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["fontsize","+9"]],
    "foo<font size=\"7\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"7"]}],
["foo[bar]baz",
    [["fontsize","-0"]],
    "foo[bar]baz",
    [true],
    {"fontsize":[false,false,"3",false,false,"3"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["fontsize","-1"]],
    "foo<span style=\"font-size:small\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"2"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["fontsize","-1"]],
    "foo<font size=\"2\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"2"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["fontsize","-9"]],
    "foo<span style=\"font-size:x-small\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["fontsize","-9"]],
    "foo<font size=\"1\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
    [["fontsize",""]],
    "foo[bar]baz",
    [false],
    {"fontsize":[false,false,"3",false,false,"3"]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<table><tbody><tr><td>foo</td><td>b<span style=\"font-size:large\">[a]</span>r</td><td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<table><tbody><tr><td>foo</td><td>b<font size=\"4\">[a]</font>r</td><td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<table><tbody><tr><td>foo</td>{<td><span style=\"font-size:large\">bar</span></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<table><tbody><tr><td>foo</td>{<td><font size=\"4\">bar</font></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<table><tbody><tr>{<td><span style=\"font-size:large\">foo</span></td><td><span style=\"font-size:large\">bar</span></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<table><tbody><tr>{<td><font size=\"4\">foo</font></td><td><font size=\"4\">bar</font></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<table><tbody>{<tr><td><span style=\"font-size:large\">foo</span></td><td><span style=\"font-size:large\">bar</span></td><td><span style=\"font-size:large\">baz</span></td></tr>}</tbody></table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<table><tbody>{<tr><td><font size=\"4\">foo</font></td><td><font size=\"4\">bar</font></td><td><font size=\"4\">baz</font></td></tr>}</tbody></table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<table>{<tbody><tr><td><span style=\"font-size:large\">foo</span></td><td><span style=\"font-size:large\">bar</span></td><td><span style=\"font-size:large\">baz</span></td></tr></tbody>}</table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<table>{<tbody><tr><td><font size=\"4\">foo</font></td><td><font size=\"4\">bar</font></td><td><font size=\"4\">baz</font></td></tr></tbody>}</table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
    [["stylewithcss","true"],["fontsize","4"]],
    "{<table><tbody><tr><td><span style=\"font-size:large\">foo</span></td><td><span style=\"font-size:large\">bar</span></td><td><span style=\"font-size:large\">baz</span></td></tr></tbody></table>}",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
    [["stylewithcss","false"],["fontsize","4"]],
    "{<table><tbody><tr><td><font size=\"4\">foo</font></td><td><font size=\"4\">bar</font></td><td><font size=\"4\">baz</font></td></tr></tbody></table>}",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["foo<font size=1>[bar]</font>baz",
    [["stylewithcss","true"],["fontsize","4"]],
    "foo<span style=\"font-size:large\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"1",false,false,"4"]}],
["foo<font size=1>[bar]</font>baz",
    [["stylewithcss","false"],["fontsize","4"]],
    "foo<font size=\"4\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"1",false,false,"4"]}],
["<font size=1>foo[bar]baz</font>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<font size=\"1\">foo</font><span style=\"font-size:large\">[bar]</span><font size=\"1\">baz</font>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"1",false,false,"4"]}],
["<font size=1>foo[bar]baz</font>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<font size=\"1\">foo</font><font size=\"4\">[bar]</font><font size=\"1\">baz</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"1",false,false,"4"]}],
["foo<font size=3>[bar]</font>baz",
    [["stylewithcss","true"],["fontsize","4"]],
    "foo<span style=\"font-size:large\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["foo<font size=3>[bar]</font>baz",
    [["stylewithcss","false"],["fontsize","4"]],
    "foo<font size=\"4\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<font size=3>foo[bar]baz</font>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<font size=\"3\">foo</font><span style=\"font-size:large\">[bar]</span><font size=\"3\">baz</font>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<font size=3>foo[bar]baz</font>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<font size=\"3\">foo</font><font size=\"4\">[bar]</font><font size=\"3\">baz</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["foo<font size=4>[bar]</font>baz",
    [["stylewithcss","true"],["fontsize","4"]],
    "foo<span style=\"font-size:large\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"4",false,false,"4"]}],
["foo<font size=4>[bar]</font>baz",
    [["stylewithcss","false"],["fontsize","4"]],
    "foo<font size=\"4\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"4",false,false,"4"]}],
["<font size=4>foo[bar]baz</font>",
    [["fontsize","4"]],
    "<font size=\"4\">foo[bar]baz</font>",
    [true],
    {"fontsize":[false,false,"4",false,false,"4"]}],
["foo<font size=+1>[bar]</font>baz",
    [["stylewithcss","true"],["fontsize","4"]],
    "foo<span style=\"font-size:large\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"4",false,false,"4"]}],
["foo<font size=+1>[bar]</font>baz",
    [["stylewithcss","false"],["fontsize","4"]],
    "foo<font size=\"4\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"4",false,false,"4"]}],
["<font size=+1>foo[bar]baz</font>",
    [["fontsize","4"]],
    "<font size=\"+1\">foo[bar]baz</font>",
    [true],
    {"fontsize":[false,false,"4",false,false,"4"]}],
["<font size=4>foo<font size=1>b[a]r</font>baz</font>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<font size=\"4\">foo<span style=\"font-size:x-small\">b</span>[a]<span style=\"font-size:x-small\">r</span>baz</font>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"1",false,false,"4"]}],
["<font size=4>foo<font size=1>b[a]r</font>baz</font>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<font size=\"4\">foo<font size=\"1\">b</font>[a]<font size=\"1\">r</font>baz</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"1",false,false,"4"]}],
["foo<span style=\"font-size: xx-small\">[bar]</span>baz",
    [["stylewithcss","true"],["fontsize","4"]],
    "foo<span style=\"font-size:large\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"1",false,false,"4"]}],
["foo<span style=\"font-size: xx-small\">[bar]</span>baz",
    [["stylewithcss","false"],["fontsize","4"]],
    "foo<font size=\"4\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"1",false,false,"4"]}],
["<span style=\"font-size: xx-small\">foo[bar]baz</span>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<span style=\"font-size:xx-small\">foo</span><span style=\"font-size:large\">[bar]</span><span style=\"font-size:xx-small\">baz</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"1",false,false,"4"]}],
["<span style=\"font-size: xx-small\">foo[bar]baz</span>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<span style=\"font-size:xx-small\">foo</span><font size=\"4\">[bar]</font><span style=\"font-size:xx-small\">baz</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"1",false,false,"4"]}],
["foo<span style=\"font-size: medium\">[bar]</span>baz",
    [["stylewithcss","true"],["fontsize","4"]],
    "foo<span style=\"font-size:large\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["foo<span style=\"font-size: medium\">[bar]</span>baz",
    [["stylewithcss","false"],["fontsize","4"]],
    "foo<font size=\"4\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<span style=\"font-size: medium\">foo[bar]baz</span>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<span style=\"font-size:medium\">foo</span><span style=\"font-size:large\">[bar]</span><span style=\"font-size:medium\">baz</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<span style=\"font-size: medium\">foo[bar]baz</span>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<span style=\"font-size:medium\">foo</span><font size=\"4\">[bar]</font><span style=\"font-size:medium\">baz</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["foo<span style=\"font-size: large\">[bar]</span>baz",
    [["stylewithcss","true"],["fontsize","4"]],
    "foo<span style=\"font-size:large\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"4",false,false,"4"]}],
["foo<span style=\"font-size: large\">[bar]</span>baz",
    [["stylewithcss","false"],["fontsize","4"]],
    "foo<font size=\"4\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"4",false,false,"4"]}],
["<span style=\"font-size: large\">foo[bar]baz</span>",
    [["fontsize","4"]],
    "<span style=\"font-size:large\">foo[bar]baz</span>",
    [true],
    {"fontsize":[false,false,"4",false,false,"4"]}],
["<span style=\"font-size: large\">foo<span style=\"font-size: xx-small\">b[a]r</span>baz</span>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<span style=\"font-size:large\">foo<span style=\"font-size:xx-small\">b</span>[a]<span style=\"font-size:xx-small\">r</span>baz</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"1",false,false,"4"]}],
["<span style=\"font-size: large\">foo<span style=\"font-size: xx-small\">b[a]r</span>baz</span>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<span style=\"font-size:large\">foo<span style=\"font-size:xx-small\">b</span>[a]<span style=\"font-size:xx-small\">r</span>baz</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"1",false,false,"4"]}],
["foo<span style=\"font-size: 2em\">[bar]</span>baz",
    [["stylewithcss","true"],["fontsize","4"]],
    "foo<span style=\"font-size:large\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"6",false,false,"4"]}],
["foo<span style=\"font-size: 2em\">[bar]</span>baz",
    [["stylewithcss","false"],["fontsize","4"]],
    "foo<font size=\"4\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"6",false,false,"4"]}],
["<span style=\"font-size: 2em\">foo[bar]baz</span>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<span style=\"font-size:2em\">foo</span><span style=\"font-size:large\">[bar]</span><span style=\"font-size:2em\">baz</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"6",false,false,"4"]}],
["<span style=\"font-size: 2em\">foo[bar]baz</span>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<span style=\"font-size:2em\">foo</span><font size=\"4\">[bar]</font><span style=\"font-size:2em\">baz</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"6",false,false,"4"]}],
["<p style=\"font-size: xx-small\">foo[bar]baz</p>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<p style=\"font-size:xx-small\">foo<span style=\"font-size:large\">[bar]</span>baz</p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"1",false,false,"4"]}],
["<p style=\"font-size: xx-small\">foo[bar]baz</p>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<p style=\"font-size:xx-small\">foo<font size=\"4\">[bar]</font>baz</p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"1",false,false,"4"]}],
["<p style=\"font-size: medium\">foo[bar]baz</p>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<p style=\"font-size:medium\">foo<span style=\"font-size:large\">[bar]</span>baz</p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<p style=\"font-size: medium\">foo[bar]baz</p>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<p style=\"font-size:medium\">foo<font size=\"4\">[bar]</font>baz</p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<p style=\"font-size: large\">foo[bar]baz</p>",
    [["fontsize","4"]],
    "<p style=\"font-size:large\">foo[bar]baz</p>",
    [true],
    {"fontsize":[false,false,"4",false,false,"4"]}],
["<p style=\"font-size: 2em\">foo[bar]baz</p>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<p style=\"font-size:2em\">foo<span style=\"font-size:large\">[bar]</span>baz</p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"6",false,false,"4"]}],
["<p style=\"font-size: 2em\">foo[bar]baz</p>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<p style=\"font-size:2em\">foo<font size=\"4\">[bar]</font>baz</p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"6",false,false,"4"]}],
["<p style=\"font-size: xx-small\">foo[bar]baz</p>",
    [["stylewithcss","true"],["fontsize","3"]],
    "<p><span style=\"font-size:xx-small\">foo</span>[bar]<span style=\"font-size:xx-small\">baz</span></p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"1",false,false,"3"]}],
["<p style=\"font-size: xx-small\">foo[bar]baz</p>",
    [["stylewithcss","false"],["fontsize","3"]],
    "<p><span style=\"font-size:xx-small\">foo</span>[bar]<span style=\"font-size:xx-small\">baz</span></p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"1",false,false,"3"]}],
["<p style=\"font-size: medium\">foo[bar]baz</p>",
    [["fontsize","3"]],
    "<p style=\"font-size:medium\">foo[bar]baz</p>",
    [true],
    {"fontsize":[false,false,"3",false,false,"3"]}],
["<p style=\"font-size: large\">foo[bar]baz</p>",
    [["stylewithcss","true"],["fontsize","3"]],
    "<p><span style=\"font-size:large\">foo</span>[bar]<span style=\"font-size:large\">baz</span></p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"4",false,false,"3"]}],
["<p style=\"font-size: large\">foo[bar]baz</p>",
    [["stylewithcss","false"],["fontsize","3"]],
    "<p><font size=\"4\">foo</font>[bar]<font size=\"4\">baz</font></p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"4",false,false,"3"]}],
["<p style=\"font-size: 2em\">foo[bar]baz</p>",
    [["stylewithcss","true"],["fontsize","3"]],
    "<p><span style=\"font-size:2em\">foo</span>[bar]<span style=\"font-size:2em\">baz</span></p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"6",false,false,"3"]}],
["<p style=\"font-size: 2em\">foo[bar]baz</p>",
    [["stylewithcss","false"],["fontsize","3"]],
    "<p><span style=\"font-size:2em\">foo</span>[bar]<span style=\"font-size:2em\">baz</span></p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"6",false,false,"3"]}],
["<font size=6>foo <span style=\"font-size: 2em\">b[a]r</span> baz</font>",
    [["stylewithcss","true"],["fontsize","3"]],
    "<span style=\"font-size:xx-large\">foo </span><span style=\"font-size:2em\">b</span>[a]<span style=\"font-size:2em\">r</span><span style=\"font-size:xx-large\"> baz</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"7",false,false,"3"]}],
["<font size=6>foo <span style=\"font-size: 2em\">b[a]r</span> baz</font>",
    [["stylewithcss","false"],["fontsize","3"]],
    "<font size=\"6\">foo </font><span style=\"font-size:2em\">b</span>[a]<span style=\"font-size:2em\">r</span><font size=\"6\"> baz</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"7",false,false,"3"]}],
["foo<big>[bar]</big>baz",
    [["stylewithcss","true"],["fontsize","3"]],
    "foo<big><span style=\"font-size:medium\">[bar]</span></big>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"4",false,false,"3"]}],
["foo<big>[bar]</big>baz",
    [["stylewithcss","false"],["fontsize","3"]],
    "foo<big><font size=\"3\">[bar]</font></big>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"4",false,false,"3"]}],
["foo<big>b[a]r</big>baz",
    [["stylewithcss","true"],["fontsize","3"]],
    "foo<big>b<span style=\"font-size:medium\">[a]</span>r</big>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"4",false,false,"3"]}],
["foo<big>b[a]r</big>baz",
    [["stylewithcss","false"],["fontsize","3"]],
    "foo<big>b<font size=\"3\">[a]</font>r</big>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"4",false,false,"3"]}],
["foo<small>[bar]</small>baz",
    [["stylewithcss","true"],["fontsize","3"]],
    "foo<small><span style=\"font-size:medium\">[bar]</span></small>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"2",false,false,"3"]}],
["foo<small>[bar]</small>baz",
    [["stylewithcss","false"],["fontsize","3"]],
    "foo<small><font size=\"3\">[bar]</font></small>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"2",false,false,"3"]}],
["foo<small>b[a]r</small>baz",
    [["stylewithcss","true"],["fontsize","3"]],
    "foo<small>b<span style=\"font-size:medium\">[a]</span>r</small>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"2",false,false,"3"]}],
["foo<small>b[a]r</small>baz",
    [["stylewithcss","false"],["fontsize","3"]],
    "foo<small>b<font size=\"3\">[a]</font>r</small>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"2",false,false,"3"]}],
["fo[o<font size=2>b]ar</font>baz",
    [["stylewithcss","true"],["fontsize","4"]],
    "fo<span style=\"font-size:large\">[ob]</span><font size=\"2\">ar</font>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[true,false,"3",false,false,"4"]}],
["fo[o<font size=2>b]ar</font>baz",
    [["stylewithcss","false"],["fontsize","4"]],
    "fo<font size=\"4\">[ob]</font><font size=\"2\">ar</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[true,false,"3",false,false,"4"]}],
["foo<font size=2>ba[r</font>b]az",
    [["stylewithcss","true"],["fontsize","4"]],
    "foo<font size=\"2\">ba</font><span style=\"font-size:large\">[rb]</span>az",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[true,false,"2",false,false,"4"]}],
["foo<font size=2>ba[r</font>b]az",
    [["stylewithcss","false"],["fontsize","4"]],
    "foo<font size=\"2\">ba</font><font size=\"4\">[rb]</font>az",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[true,false,"2",false,false,"4"]}],
["fo[o<font size=2>bar</font>b]az",
    [["stylewithcss","true"],["fontsize","4"]],
    "fo<span style=\"font-size:large\">[obarb]</span>az",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[true,false,"3",false,false,"4"]}],
["fo[o<font size=2>bar</font>b]az",
    [["stylewithcss","false"],["fontsize","4"]],
    "fo<font size=\"4\">[obarb]</font>az",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[true,false,"3",false,false,"4"]}],
["foo[<font size=2>b]ar</font>baz",
    [["stylewithcss","true"],["fontsize","4"]],
    "foo<span style=\"font-size:large\">b</span><font size=\"2\">ar</font>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"2",false,false,"4"]}],
["foo[<font size=2>b]ar</font>baz",
    [["stylewithcss","false"],["fontsize","4"]],
    "foo<font size=\"4\">[b]</font><font size=\"2\">ar</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"2",false,false,"4"]}],
["foo<font size=2>ba[r</font>]baz",
    [["stylewithcss","true"],["fontsize","4"]],
    "foo<font size=\"2\">ba</font><span style=\"font-size:large\">r</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"2",false,false,"4"]}],
["foo<font size=2>ba[r</font>]baz",
    [["stylewithcss","false"],["fontsize","4"]],
    "foo<font size=\"2\">ba</font><font size=\"4\">[r]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"2",false,false,"4"]}],
["foo[<font size=2>bar</font>]baz",
    [["stylewithcss","true"],["fontsize","4"]],
    "foo[<span style=\"font-size:large\">bar</span>]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"2",false,false,"4"]}],
["foo[<font size=2>bar</font>]baz",
    [["stylewithcss","false"],["fontsize","4"]],
    "foo[<font size=\"4\">bar</font>]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"2",false,false,"4"]}],
["foo<font size=2>[bar]</font>baz",
    [["stylewithcss","true"],["fontsize","4"]],
    "foo<span style=\"font-size:large\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"2",false,false,"4"]}],
["foo<font size=2>[bar]</font>baz",
    [["stylewithcss","false"],["fontsize","4"]],
    "foo<font size=\"4\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"2",false,false,"4"]}],
["foo{<font size=2>bar</font>}baz",
    [["stylewithcss","true"],["fontsize","4"]],
    "foo{<span style=\"font-size:large\">bar}</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"2",false,false,"4"]}],
["foo{<font size=2>bar</font>}baz",
    [["stylewithcss","false"],["fontsize","4"]],
    "foo{<font size=\"4\">bar}</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"2",false,false,"4"]}],
["<font size=1>fo[o</font><span style=font-size:xx-small>b]ar</span>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<font size=\"1\">fo</font><span style=\"font-size:large\">[ob]</span><span style=\"font-size:xx-small\">ar</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[true,false,"1",false,false,"4"]}],
["<font size=1>fo[o</font><span style=font-size:xx-small>b]ar</span>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<font size=\"1\">fo</font><font size=\"4\">[ob]</font><span style=\"font-size:xx-small\">ar</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[true,false,"1",false,false,"4"]}],
["<font size=2>fo[o</font><span style=font-size:small>b]ar</span>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<font size=\"2\">fo</font><span style=\"font-size:large\">[ob]</span><span style=\"font-size:small\">ar</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"2",false,false,"4"]}],
["<font size=2>fo[o</font><span style=font-size:small>b]ar</span>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<font size=\"2\">fo</font><font size=\"4\">[ob]</font><span style=\"font-size:small\">ar</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"2",false,false,"4"]}],
["<font size=3>fo[o</font><span style=font-size:medium>b]ar</span>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<font size=\"3\">fo</font><span style=\"font-size:large\">[ob]</span><span style=\"font-size:medium\">ar</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<font size=3>fo[o</font><span style=font-size:medium>b]ar</span>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<font size=\"3\">fo</font><font size=\"4\">ob</font><span style=\"font-size:medium\">ar</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<font size=4>fo[o</font><span style=font-size:large>b]ar</span>",
    [["fontsize","4"]],
    "<font size=\"4\">fo[o</font><span style=\"font-size:large\">b]ar</span>",
    [true],
    {"fontsize":[false,false,"4",false,false,"4"]}],
["<font size=5>fo[o</font><span style=font-size:x-large>b]ar</span>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<font size=\"5\">fo</font><span style=\"font-size:large\">[ob]</span><span style=\"font-size:x-large\">ar</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"5",false,false,"4"]}],
["<font size=5>fo[o</font><span style=font-size:x-large>b]ar</span>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<font size=\"5\">fo</font><font size=\"4\">[ob]</font><span style=\"font-size:x-large\">ar</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"5",false,false,"4"]}],
["<font size=6>fo[o</font><span style=font-size:xx-large>b]ar</span>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<font size=\"6\">fo</font><span style=\"font-size:large\">ob</span><span style=\"font-size:xx-large\">ar</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"6",false,false,"4"]}],
["<font size=6>fo[o</font><span style=font-size:xx-large>b]ar</span>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<font size=\"6\">fo</font><font size=\"4\">ob</font><span style=\"font-size:xx-large\">ar</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"6",false,false,"4"]}],

// If contents of <font> are entirely selected, it should be reused.
["<font color=#ff0000>[abc]</font>",
   [["styleWithCSS","false"],["fontSize","7"]],
   ["<font color=\"#ff0000\" size=\"7\">[abc]</font>",
    "<font size=\"7\" color=\"#ff0000\">[abc]</font>"],
   [true,true],
   {}],
["<font face=monospace>[abc]</font>",
   [["styleWithCSS","false"],["fontSize","7"]],
   ["<font face=\"monospace\" size=\"7\">[abc]</font>",
    "<font size=\"7\" face=\"monospace\">[abc]</font>"],
   [true,true],
   {}],
["<font color=#ff0000 face=monospace>[abc]</font>",
   [["styleWithCSS","false"],["fontSize","7"]],
   ["<font color=\"#ff0000\" face=\"monospace\" size=\"7\">[abc]</font>",
    "<font color=\"#ff0000\" size=\"7\" face=\"monospace\">[abc]</font>",
    "<font face=\"monospace\" color=\"#ff0000\" size=\"7\">[abc]</font>",
    "<font face=\"monospace\" size=\"7\" color=\"#ff0000\">[abc]</font>",
    "<font size=\"7\" color=\"#ff0000\" face=\"monospace\">[abc]</font>",
    "<font size=\"7\" face=\"monospace\" color=\"#ff0000\">[abc]</font>"],
   [true,true],
   {}],
// but don't split existing <font> if partially selected.
["<font color=#ff0000>[a]bc</font>",
   [["styleWithCSS","false"],["fontSize","7"]],
   "<font color=\"#ff0000\"><font size=\"7\">[a]</font>bc</font>",
   [true,true],
   {}],
["<font color=#ff0000>ab[c]</font>",
   [["styleWithCSS","false"],["fontSize","7"]],
   "<font color=\"#ff0000\">ab<font size=\"7\">[c]</font></font>",
   [true,true],
   {}],
["<font face=monospace>[a]bc</font>",
   [["styleWithCSS","false"],["fontSize","7"]],
   "<font face=\"monospace\"><font size=\"7\">[a]</font>bc</font>",
   [true,true],
   {}],
["<font face=monospace>ab[c]</font>",
   [["styleWithCSS","false"],["fontSize","7"]],
   "<font face=\"monospace\">ab<font size=\"7\">[c]</font></font>",
   [true,true],
   {}],

// font-size should be removed when applying fontsize without CSS.
// Blink and WebKit puts <font size="..."> into the <span> element in these
// test cases.  However, this behavior may cause the background color is
// partially applied to the text because the height is computed without the
// <font>.  Therefore, it may be better to put <font> outside any inline
// ancestors.
["<span style=\"font-size:32px; background-color:rgb(0, 128, 128)\">[abc]</span>",
  [["styleWithCSS","false"],["fontSize","5"]],
  ["<span style=\"background-color:rgb(0, 128, 128)\"><font size=\"5\">[abc]</font></span>",
   "<font size=\"5\"><span style=\"background-color:rgb(0, 128, 128)\">[abc]</span></font>"],
  [true,true],
  {}],
["<span style=\"font-size:32px; background-color:rgb(0, 128, 128)\">[a]bc</span>",
  [["styleWithCSS","false"],["fontSize","5"]],
  ["<span style=\"background-color:rgb(0, 128, 128)\"><font size=\"5\">[a]</font></span><span style=\"font-size:32px; background-color:rgb(0, 128, 128)\">bc</span>",
   "<font size=\"5\"><span style=\"background-color:rgb(0, 128, 128)\">[a]</span></font><span style=\"font-size:32px; background-color:rgb(0, 128, 128)\">bc</span>"],
  [true,true],
  {}],
["<span style=\"font-size:32px; background-color:rgb(0, 128, 128)\">a[b]c</span>",
  [["styleWithCSS","false"],["fontSize","5"]],
  ["<span style=\"font-size:32px; background-color:rgb(0, 128, 128)\">a</span><span style=\"background-color:rgb(0, 128, 128)\"><font size=\"5\">[b]</font></span><span style=\"font-size:32px; background-color:rgb(0, 128, 128)\">c</span>",
   "<span style=\"font-size:32px; background-color:rgb(0, 128, 128)\">a</span><font size=\"5\"><span style=\"background-color:rgb(0, 128, 128)\">[b]</span></font><span style=\"font-size:32px; background-color:rgb(0, 128, 128)\">c</span>"],
  [true,true],
  {}],
["<span style=\"font-size:32px; background-color:rgb(0, 128, 128)\">ab[c]</span>",
  [["styleWithCSS","false"],["fontSize","5"]],
  ["<span style=\"font-size:32px; background-color:rgb(0, 128, 128)\">ab</span><span style=\"background-color:rgb(0, 128, 128)\"><font size=\"5\">[c]</font></span>",
   "<span style=\"font-size:32px; background-color:rgb(0, 128, 128)\">ab</span><font size=\"5\"><span style=\"background-color:rgb(0, 128, 128)\">[c]</span></font>"],
  [true,true],
  {}],
["<p><span style=\"font-size:32px; background-color:rgb(0, 128, 128)\">[abc</span></p><p><span style=\"font-size:64px; background-color:rgb(128, 128, 0)\">def]</span></p>",
  [["styleWithCSS","false"],["fontSize","5"]],
  ["<p><span style=\"background-color:rgb(0, 128, 128)\"><font size=\"5\">[abc</font></span></p><p><span style=\"background-color:rgb(128, 128, 0)\"><font size=\"5\">def]</font></span></p>",
   "<p><font size=\"5\"><span style=\"background-color:rgb(0, 128, 128)\">[abc</span></font></p><p><font size=\"5\"><span style=\"background-color:rgb(128, 128, 0)\">def]</span></font></p>"],
  [true,true],
  {}],
]
