/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

const { E10SUtils } = ChromeUtils.importESModule(
  "resource://gre/modules/E10SUtils.sys.mjs"
);

add_task(function () {
  let pre136 = E10SUtils.deserializeCSP(
    "CdntGuXUQAS/4CfOuSPZrAAAAAAAAAAAwAAAAAAAAEYB3pRy0IA0EdOTmQAQS6D9QJIHOlRteE8wkTq4cYEyCMYAAAAC/////wAAAbsBAAAAP2h0dHBzOi8vY2hhdC5tb3ppbGxhLm9yZy8jL3Jvb20vIWVhRmVUa2lTdHZyYnhqQmJ4Uzptb3ppbGxhLm9yZwAAAAAAAAAFAAAACAAAABAAAAAI/////wAAAAj/////AAAACAAAABAAAAAYAAAAJwAAABgAAAABAAAAGAAAAAEAAAAZAAAAAAAAABn/////AAAAAP////8AAAAY/////wAAABoAAAAlAQAAAAAAAAAAAGR7IjEiOnsiMCI6Imh0dHBzOi8vY2hhdC5tb3ppbGxhLm9yZy8jL3Jvb20vIWVhRmVUa2lTdHZyYnhqQmJ4Uzptb3ppbGxhLm9yZyIsIjIiOiJedXNlckNvbnRleHRJZD02In19AAAAAgAAABYAZgByAGEAbQBlAC0AYQBuAGMAZQBzAHQAbwByAHMAIAAnAHMAZQBsAGYAJwAAAAABcgBkAGUAZgBhAHUAbAB0AC0AcwByAGMAIAAnAG4AbwBuAGUAJwA7ACAAcwB0AHkAbABlAC0AcwByAGMAIAAnAHMAZQBsAGYAJwAgACcAdQBuAHMAYQBmAGUALQBpAG4AbABpAG4AZQAnADsAIABzAGMAcgBpAHAAdAAtAHMAcgBjACAAJwBzAGUAbABmACcAIAAnAHcAYQBzAG0ALQB1AG4AcwBhAGYAZQAtAGUAdgBhAGwAJwAgAGgAdAB0AHAAcwA6AC8ALwB3AHcAdwAuAHIAZQBjAGEAcAB0AGMAaABhAC4AbgBlAHQALwByAGUAYwBhAHAAdABjAGgAYQAvACAAaAB0AHQAcABzADoALwAvAHcAdwB3AC4AZwBzAHQAYQB0AGkAYwAuAGMAbwBtAC8AcgBlAGMAYQBwAHQAYwBoAGEALwA7ACAAaQBtAGcALQBzAHIAYwAgACoAIABiAGwAbwBiADoAIABkAGEAdABhADoAOwAgAGMAbwBuAG4AZQBjAHQALQBzAHIAYwAgACoAIABiAGwAbwBiADoAOwAgAGYAbwBuAHQALQBzAHIAYwAgACcAcwBlAGwAZgAnACAAZABhAHQAYQA6ADsAIABtAGUAZABpAGEALQBzAHIAYwAgACoAIABiAGwAbwBiADoAIABkAGEAdABhADoAOwAgAGMAaABpAGwAZAAtAHMAcgBjACAAKgAgAGIAbABvAGIAOgAgAGQAYQB0AGEAOgA7ACAAdwBvAHIAawBlAHIALQBzAHIAYwAgACcAcwBlAGwAZgAnACAAYgBsAG8AYgA6ADsAIABmAHIAYQBtAGUALQBzAHIAYwAgACoAIABiAGwAbwBiADoAIABkAGEAdABhADoAOwAgAGYAbwByAG0ALQBhAGMAdABpAG8AbgAgACcAcwBlAGwAZgAnADsAIABtAGEAbgBpAGYAZQBzAHQALQBzAHIAYwAgACcAcwBlAGwAZgAnAAE="
  );
  let json = JSON.parse(pre136.toJSON());
  Assert.equal(json["csp-policies"].length, 2);
  Assert.equal(json["csp-policies"][0]["report-only"], false);
  Assert.equal(json["csp-policies"][1]["worker-src"][1], "blob:");
  Assert.equal(json["csp-policies"][1]["default-src"][0], "'none'");

  const DATA_v136 =
    "CdntGuXUQAS/4CfOuSPZrAAAAAAAAAAAwAAAAAAAAEYB3pRy0IA0EdOTmQAQS6D9QJIHOlRteE8wkTq4cYEyCMYAAAAC/////wAAAbsBAAAAFGh0dHBzOi8vZXhhbXBsZS5vcmcvAAAAAAAAAAUAAAAIAAAACwAAAAD/////AAAAAP////8AAAAIAAAACwAAABMAAAABAAAAEwAAAAEAAAATAAAAAQAAABQAAAAAAAAAAP////8AAAAA/////wAAAAD/////AAAAAP////8BAAAAAAAAAAAAInsiMSI6eyIwIjoiaHR0cHM6Ly9leGFtcGxlLm9yZy8ifX0AAAACAAAAEgBkAGUAZgBhAHUAbAB0AC0AcwByAGMAIAAnAHMAZQBsAGYAJwABAAAAAA4AaQBtAGcALQBzAHIAYwAgACcAbgBvAG4AZQAnAAEA";
  let v136 = E10SUtils.deserializeCSP(DATA_v136);
  Assert.equal(
    v136.toJSON(),
    `{"csp-policies":[{"default-src":["'self'"],"report-only":false},{"img-src":["'none'"],"report-only":false}]}`
  );

  let v138 = E10SUtils.deserializeCSP(
    "CdntGuXUQAS/4CfOuSPZrAAAAAAAAAAAwAAAAAAAAEYB3pRy0IA0EdOTmQAQS6D9QJIHOlRteE8wkTq4cYEyCMYAAAAC/////wAAAbsBAAAAGGh0dHBzOi8vd3d3LnlvdXR1YmUuY29tLwAAAAAAAAAFAAAACAAAAA8AAAAA/////wAAAAD/////AAAACAAAAA8AAAAXAAAAAQAAABcAAAABAAAAFwAAAAEAAAAYAAAAAAAAAAD/////AAAAAP////8AAAAA/////wAAAAD/////AQAAAAAAAAAAACZ7IjEiOnsiMCI6Imh0dHBzOi8vd3d3LnlvdXR1YmUuY29tLyJ9fQAAAAA="
  );
  Assert.equal(v138.toJSON(), `{"csp-policies":[]}`);

  let v138_2 = E10SUtils.deserializeCSP(
    "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"
  );
  json = JSON.parse(v138_2.toJSON());
  Assert.equal(json["csp-policies"].length, 4);
  Assert.equal(
    Object.keys(json["csp-policies"][0]).join("|"),
    "report-only|report-uri"
  );
  Assert.equal(json["csp-policies"][2]["script-src"][0], "'unsafe-inline'");
  Assert.ok(
    json["csp-policies"][3]["script-src"].includes(
      "https://apis.google.com/js/client.js"
    )
  );

  Assert.equal(
    E10SUtils.serializeCSP(v136),
    DATA_v136,
    "DANGER: serialization format might have changed!"
  );
});
