// DO NOT EDIT! This test has been generated by /html/canvas/tools/gentest.py.
// OffscreenCanvas test in a worker:2d.path.isPointInPath.basic
// Description:Verify the winding rule in isPointInPath works for for rect path.
// Note:

importScripts("/resources/testharness.js");
importScripts("/html/canvas/resources/canvas-tests.js");

var t = async_test("Verify the winding rule in isPointInPath works for for rect path.");
var t_pass = t.done.bind(t);
var t_fail = t.step_func(function(reason) {
    throw reason;
});
t.step(function() {

  var canvas = new OffscreenCanvas(100, 50);
  var ctx = canvas.getContext('2d');

  canvas.width = 200;
  canvas.height = 200;

  // Testing default isPointInPath
  ctx.beginPath();
  ctx.rect(0, 0, 100, 100);
  ctx.rect(25, 25, 50, 50);
  _assertSame(ctx.isPointInPath(50, 50), true, "ctx.isPointInPath(50, 50)", "true");
  _assertSame(ctx.isPointInPath(NaN, 50), false, "ctx.isPointInPath(NaN, 50)", "false");
  _assertSame(ctx.isPointInPath(50, NaN), false, "ctx.isPointInPath(50, NaN)", "false");

  // Testing nonzero isPointInPath
  ctx.beginPath();
  ctx.rect(0, 0, 100, 100);
  ctx.rect(25, 25, 50, 50);
  _assertSame(ctx.isPointInPath(50, 50, 'nonzero'), true, "ctx.isPointInPath(50, 50, 'nonzero')", "true");

  // Testing evenodd isPointInPath
  ctx.beginPath();
  ctx.rect(0, 0, 100, 100);
  ctx.rect(25, 25, 50, 50);
  _assertSame(ctx.isPointInPath(50, 50, 'evenodd'), false, "ctx.isPointInPath(50, 50, 'evenodd')", "false");

  // Testing extremely large scale
  ctx.save();
  ctx.scale(Number.MAX_VALUE, Number.MAX_VALUE);
  ctx.beginPath();
  ctx.rect(-10, -10, 20, 20);
  _assertSame(ctx.isPointInPath(0, 0, 'nonzero'), true, "ctx.isPointInPath(0, 0, 'nonzero')", "true");
  _assertSame(ctx.isPointInPath(0, 0, 'evenodd'), true, "ctx.isPointInPath(0, 0, 'evenodd')", "true");
  ctx.restore();

  // Check with non-invertible ctm.
  ctx.save();
  ctx.scale(0, 0);
  ctx.beginPath();
  ctx.rect(-10, -10, 20, 20);
  _assertSame(ctx.isPointInPath(0, 0, 'nonzero'), false, "ctx.isPointInPath(0, 0, 'nonzero')", "false");
  _assertSame(ctx.isPointInPath(0, 0, 'evenodd'), false, "ctx.isPointInPath(0, 0, 'evenodd')", "false");
  ctx.restore();
  t.done();
});
done();
