template = '''<!DOCTYPE html>
<meta charset="utf-8">
<meta name="timeout" content="long">
<title>Moving script elements between documents</title>
<!-- This is generated by tools/generate.py. Do not manually edit. -->
<link rel="help" href="https://html.spec.whatwg.org/multipage/#execute-the-script-block">
<script src="/resources/testharness.js"></script>
<script src="/resources/testharnessreport.js"></script>
<script src="resources/moving-between-documents-helper.js"></script>

<body>
<script>
runTest("%s", "%s", "%s", "%s", "%s");
</script>
'''

n = 0
for timing in ["before-prepare", "after-prepare", "move-back"]:
  for destType in ["iframe", "createHTMLDocument"]:
    for inlineOrExternal in ["inline", "external", "empty-src"]:
      for result in ["fetch-error", "parse-error", "success"]:
        for type in ["classic", "module"]:
            # The |inlineOrExternal| keyword creates a certain kind of script,
            # and the |result| keyword can influence the generated script in
            # different ways i.e., giving the script a parse-error, or creating
            # a script that fails to load. When we're creating an inline script,
            # it doesn't make sense to test the fetch-error case, so we ignore
            # this combination, as the server will not react to it in any
            # meaningful way.
          if inlineOrExternal == "inline" and result == "fetch-error":
            continue

          if inlineOrExternal == "empty-src":
            # The "empty-src" tests aim to exercise #prepare-a-script step 26
            # substep 2, where the <script> has a src attribute that is empty:
            #   "If src is the empty string, queue a task to fire an event named
            #    error at the element, and return."
            # Therefore, the server will generate a script that does not have a
            # "parse-error" or "fetch-error", so we can ignore these combinations.
            if result != "success":
              continue

            # The "empty-src" tests check that the parser document <=> node document
            # check is implemented correctly in #prepare-a-script. Therefore we're
            # only interested in tests that move the <script> before #prepare-a-script.
            if timing != "before-prepare":
              continue

          # The current test helper uses
          # #has-a-style-sheet-that-is-blocking-scripts to block script
          # evaluation after #prepare-a-script, but in some cases this
          # doesn't work:
          # - inline scripts to createHTMLDocument
          if timing != "before-prepare" and destType == "createHTMLDocument" and inlineOrExternal == "inline":
            continue
          # - module inline scripts https://github.com/whatwg/html/issues/3890
          if timing != "before-prepare" and inlineOrExternal == "inline" and type == "module":
            continue

          with open('%s-%s-%s-%s-%s.html' % (timing, destType, result, inlineOrExternal, type), 'w') as f:
            f.write(template % (timing, destType, result, inlineOrExternal, type))
