// META: title=validation tests for WebNN API reverse operation
// META: global=window
// META: variant=?cpu
// META: variant=?gpu
// META: variant=?npu
// META: script=../resources/utils_validation.js

'use strict';

const tests = [
  {
    name: '[reverse] Test reverse with default options',
    input: {dataType: 'float32', shape: [3, 3]},
    output: {dataType: 'float32', shape: [3, 3]}
  },
  {
    name: '[reverse] Test reverse with axes = [0, 1]',
    input: {dataType: 'int32', shape: [1, 2, 3]},
    axes: [0, 1],
    output: {dataType: 'int32', shape: [1, 2, 3]}
  },
  {
    name: '[reverse] Throw if axes is greater than input rank',
    input: {dataType: 'float32', shape: [3, 3]},
    axes: [3]
  },
  {
    name: '[reverse] Throw if axes is duplicated',
    input: {dataType: 'float32', shape: [1, 2, 3, 4]},
    axes: [2, 2, 3]
  }
];

tests.forEach(test => promise_test(async t => {
                const builder = new MLGraphBuilder(context);
                const input = builder.input('input', test.input);
                const options = {};
                if (test.axes) {
                  options.axes = test.axes;
                }

                if (test.output) {
                  const output = builder.reverse(input, options);
                  assert_equals(output.dataType, test.output.dataType);
                  assert_array_equals(output.shape, test.output.shape);
                } else {
                  const label = 'reverse_1'
                  options.label = label;
                  const regexp = new RegExp('\\[' + label + '\\]');
                  assert_throws_with_label(
                      () => builder.reverse(input, options), regexp);
                }
              }, test.name));

multi_builder_test(async (t, builder, otherBuilder) => {
  const input =
      otherBuilder.input('input', {dataType: 'float32', shape: [3, 3]});
  assert_throws_js(TypeError, () => builder.reverse(input));
}, '[reverse] Throw if input is from another builder');
