#ifndef DOM_BINDINGNAMES_H_
#define DOM_BINDINGNAMES_H_

#include <stddef.h>
#include <stdint.h>
#include "mozilla/Attributes.h"

namespace mozilla::dom {

enum class BindingNamesOffset : uint16_t {
  ANGLE_instanced_arrays = 0,
  APZHitResultFlags = 23,
  AbortController = 41,
  AbortSignal = 57,
  AbstractRange = 69,
  AccessibleNode = 83,
  Addon = 98,
  AddonEvent = 104,
  AddonInstall = 115,
  AddonManager = 128,
  AddonManagerPermissions = 141,
  AnalyserNode = 165,
  Animation = 178,
  AnimationEffect = 188,
  AnimationEvent = 204,
  AnimationPlaybackEvent = 219,
  AnimationTimeline = 242,
  AnonymousContent = 260,
  Attr = 277,
  Audio = 282,
  AudioBuffer = 288,
  AudioBufferSourceNode = 300,
  AudioContext = 322,
  AudioData = 335,
  AudioDecoder = 345,
  AudioDestinationNode = 358,
  AudioEncoder = 379,
  AudioListener = 392,
  AudioNode = 406,
  AudioParam = 416,
  AudioParamMap = 427,
  AudioProcessingEvent = 441,
  AudioScheduledSourceNode = 462,
  AudioTrack = 487,
  AudioTrackList = 498,
  AudioWorklet = 513,
  AudioWorkletGlobalScope = 526,
  AudioWorkletNode = 550,
  AudioWorkletProcessor = 567,
  AuthenticatorAssertionResponse = 589,
  AuthenticatorAttestationResponse = 620,
  AuthenticatorResponse = 653,
  BarProp = 675,
  BaseAudioContext = 683,
  BatteryManager = 700,
  BeforeUnloadEvent = 715,
  BiquadFilterNode = 733,
  Blob = 750,
  BlobEvent = 755,
  BroadcastChannel = 765,
  BrowsingContext = 782,
  BrowsingContextGroup = 798,
  ByteLengthQueuingStrategy = 819,
  CDATASection = 845,
  CSPViolationReportBody = 858,
  CSS = 881,
  CSS2Properties = 885,
  CSSAnimation = 900,
  CSSConditionRule = 913,
  CSSContainerRule = 930,
  CSSCounterStyleRule = 947,
  CSSCustomPropertyRegisteredEvent = 967,
  CSSFontFaceRule = 1000,
  CSSFontFeatureValuesRule = 1016,
  CSSFontPaletteValuesRule = 1041,
  CSSGroupingRule = 1066,
  CSSImportRule = 1082,
  CSSKeyframeRule = 1096,
  CSSKeyframesRule = 1112,
  CSSLayerBlockRule = 1129,
  CSSLayerStatementRule = 1147,
  CSSMarginRule = 1169,
  CSSMediaRule = 1183,
  CSSMozDocumentRule = 1196,
  CSSNamespaceRule = 1215,
  CSSNestedDeclarations = 1232,
  CSSPageDescriptors = 1254,
  CSSPageRule = 1273,
  CSSPositionTryDescriptors = 1285,
  CSSPositionTryRule = 1311,
  CSSPropertyRule = 1330,
  CSSPseudoElement = 1346,
  CSSRule = 1363,
  CSSRuleList = 1371,
  CSSScopeRule = 1383,
  CSSStartingStyleRule = 1396,
  CSSStyleDeclaration = 1417,
  CSSStyleRule = 1437,
  CSSStyleSheet = 1450,
  CSSSupportsRule = 1464,
  CSSTransition = 1480,
  Cache = 1494,
  CacheStorage = 1500,
  CallbackDebuggerNotification = 1513,
  CanonicalBrowsingContext = 1542,
  CanvasCaptureMediaStream = 1567,
  CanvasGradient = 1592,
  CanvasPattern = 1607,
  CanvasRenderingContext2D = 1621,
  CaretPosition = 1646,
  CaretStateChangedEvent = 1660,
  ChannelMergerNode = 1683,
  ChannelSplitterNode = 1701,
  ChannelWrapper = 1721,
  CharacterData = 1736,
  CheckerboardReportService = 1750,
  ChildProcessMessageManager = 1776,
  ChildSHistory = 1803,
  ChromeMessageBroadcaster = 1817,
  ChromeMessageSender = 1842,
  ChromeNodeList = 1862,
  ChromeUtils = 1877,
  ChromeWorker = 1889,
  Client = 1902,
  Clients = 1909,
  Clipboard = 1917,
  ClipboardEvent = 1927,
  ClipboardItem = 1942,
  ClonedErrorHolder = 1956,
  CloseEvent = 1974,
  CloseWatcher = 1985,
  CommandEvent = 1998,
  Comment = 2011,
  CompositionEvent = 2019,
  CompressionStream = 2036,
  ConsoleInstance = 2054,
  ConstantSourceNode = 2070,
  ContentFrameMessageManager = 2089,
  ContentProcessMessageManager = 2116,
  ContentVisibilityAutoStateChangeEvent = 2145,
  ConvolverNode = 2183,
  CookieChangeEvent = 2197,
  CookieStore = 2215,
  CookieStoreManager = 2227,
  CountQueuingStrategy = 2246,
  CreateOfferRequest = 2267,
  Credential = 2286,
  CredentialsContainer = 2297,
  Crypto = 2318,
  CryptoKey = 2325,
  CustomElementRegistry = 2335,
  CustomEvent = 2357,
  CustomStateSet = 2369,
  DOMException = 2384,
  DOMImplementation = 2397,
  DOMLocalization = 2415,
  DOMMatrix = 2431,
  DOMMatrixReadOnly = 2441,
  DOMParser = 2459,
  DOMPoint = 2469,
  DOMPointReadOnly = 2478,
  DOMQuad = 2495,
  DOMRect = 2503,
  DOMRectList = 2511,
  DOMRectReadOnly = 2523,
  DOMStringList = 2539,
  DOMStringMap = 2553,
  DOMTokenList = 2566,
  DataTransfer = 2579,
  DataTransferItem = 2592,
  DataTransferItemList = 2609,
  DebuggerNotification = 2630,
  DebuggerNotificationObserver = 2651,
  DecompressionStream = 2680,
  DedicatedWorkerGlobalScope = 2700,
  DelayNode = 2727,
  DeprecationReportBody = 2737,
  DeviceAcceleration = 2759,
  DeviceLightEvent = 2778,
  DeviceMotionEvent = 2795,
  DeviceOrientationEvent = 2813,
  DeviceRotationRate = 2836,
  Directory = 2855,
  Document = 2865,
  DocumentFragment = 2874,
  DocumentL10n = 2891,
  DocumentTimeline = 2904,
  DocumentType = 2921,
  DominatorTree = 2934,
  DragEvent = 2948,
  DynamicsCompressorNode = 2958,
  EXT_blend_minmax = 2981,
  EXT_color_buffer_float = 2998,
  EXT_color_buffer_half_float = 3021,
  EXT_depth_clamp = 3049,
  EXT_disjoint_timer_query = 3065,
  EXT_float_blend = 3090,
  EXT_frag_depth = 3106,
  EXT_sRGB = 3121,
  EXT_shader_texture_lod = 3130,
  EXT_texture_compression_bptc = 3153,
  EXT_texture_compression_rgtc = 3182,
  EXT_texture_filter_anisotropic = 3211,
  EXT_texture_norm16 = 3242,
  Element = 3261,
  ElementInternals = 3269,
  EncodedAudioChunk = 3286,
  EncodedVideoChunk = 3304,
  ErrorEvent = 3322,
  Event = 3333,
  EventCallbackDebuggerNotification = 3339,
  EventCounts = 3373,
  EventSource = 3385,
  EventTarget = 3397,
  Exception = 3409,
  ExtendableCookieChangeEvent = 3419,
  ExtendableEvent = 3447,
  ExtendableMessageEvent = 3463,
  ExtensionAlarms = 3486,
  ExtensionBrowser = 3502,
  ExtensionBrowserSettings = 3519,
  ExtensionBrowserSettingsColorManagement = 3544,
  ExtensionDns = 3584,
  ExtensionEventManager = 3597,
  ExtensionMockAPI = 3619,
  ExtensionPort = 3636,
  ExtensionProxy = 3650,
  ExtensionRuntime = 3665,
  ExtensionScripting = 3682,
  ExtensionSetting = 3701,
  ExtensionTest = 3718,
  External = 3732,
  FeaturePolicy = 3741,
  FeaturePolicyViolationReportBody = 3755,
  FetchEvent = 3788,
  FetchObserver = 3799,
  File = 3813,
  FileList = 3818,
  FileReader = 3827,
  FileReaderSync = 3838,
  FileSystem = 3853,
  FileSystemDirectoryEntry = 3864,
  FileSystemDirectoryHandle = 3889,
  FileSystemDirectoryHandle_AsyncIterator = 3915,
  FileSystemDirectoryIterator = 3955,
  FileSystemDirectoryReader = 3983,
  FileSystemEntry = 4009,
  FileSystemFileEntry = 4025,
  FileSystemFileHandle = 4045,
  FileSystemHandle = 4066,
  FileSystemSyncAccessHandle = 4083,
  FileSystemWritableFileStream = 4110,
  Flex = 4139,
  FlexItemValues = 4144,
  FlexLineValues = 4159,
  FluentBundle = 4174,
  FluentBundleAsyncIterator = 4187,
  FluentBundleIterator = 4213,
  FluentPattern = 4234,
  FluentResource = 4248,
  FocusEvent = 4263,
  FontFace = 4274,
  FontFaceSet = 4283,
  FontFaceSetIterator = 4295,
  FontFaceSetLoadEvent = 4315,
  FormData = 4336,
  FormData_Iterator = 4345,
  FormDataEvent = 4363,
  FragmentDirective = 4377,
  FrameCrashedEvent = 4395,
  FrameLoader = 4413,
  GPU = 4425,
  GPUAdapter = 4429,
  GPUAdapterInfo = 4440,
  GPUBindGroup = 4455,
  GPUBindGroupLayout = 4468,
  GPUBuffer = 4487,
  GPUBufferUsage = 4497,
  GPUCanvasContext = 4512,
  GPUColorWrite = 4529,
  GPUCommandBuffer = 4543,
  GPUCommandEncoder = 4560,
  GPUCompilationInfo = 4578,
  GPUCompilationMessage = 4597,
  GPUComputePassEncoder = 4619,
  GPUComputePipeline = 4641,
  GPUDevice = 4660,
  GPUDeviceLostInfo = 4670,
  GPUError = 4688,
  GPUExternalTexture = 4697,
  GPUInternalError = 4716,
  GPUMapMode = 4733,
  GPUOutOfMemoryError = 4744,
  GPUPipelineError = 4764,
  GPUPipelineLayout = 4781,
  GPUQuerySet = 4799,
  GPUQueue = 4811,
  GPURenderBundle = 4820,
  GPURenderBundleEncoder = 4836,
  GPURenderPassEncoder = 4859,
  GPURenderPipeline = 4880,
  GPUSampler = 4898,
  GPUShaderModule = 4909,
  GPUShaderStage = 4925,
  GPUSupportedFeatures = 4940,
  GPUSupportedLimits = 4961,
  GPUTexture = 4980,
  GPUTextureUsage = 4991,
  GPUTextureView = 5007,
  GPUUncapturedErrorEvent = 5022,
  GPUValidationError = 5046,
  GainNode = 5065,
  Gamepad = 5074,
  GamepadAxisMoveEvent = 5082,
  GamepadButton = 5103,
  GamepadButtonEvent = 5117,
  GamepadEvent = 5136,
  GamepadHapticActuator = 5149,
  GamepadLightIndicator = 5171,
  GamepadPose = 5193,
  GamepadServiceTest = 5205,
  GamepadTouch = 5224,
  Geolocation = 5237,
  GeolocationCoordinates = 5249,
  GeolocationPosition = 5272,
  GeolocationPositionError = 5292,
  GetUserMediaRequest = 5317,
  GleanBoolean = 5337,
  GleanCategory = 5350,
  GleanCounter = 5364,
  GleanCustomDistribution = 5377,
  GleanDatetime = 5401,
  GleanDenominator = 5415,
  GleanEvent = 5432,
  GleanImpl = 5443,
  GleanLabeled = 5453,
  GleanMemoryDistribution = 5466,
  GleanMetric = 5490,
  GleanNumerator = 5502,
  GleanObject = 5517,
  GleanPingsImpl = 5529,
  GleanQuantity = 5544,
  GleanRate = 5558,
  GleanString = 5568,
  GleanStringList = 5580,
  GleanText = 5596,
  GleanTimespan = 5606,
  GleanTimingDistribution = 5620,
  GleanUrl = 5644,
  GleanUuid = 5653,
  Grid = 5663,
  GridArea = 5668,
  GridDimension = 5677,
  GridLine = 5691,
  GridLines = 5700,
  GridTrack = 5710,
  GridTracks = 5720,
  HTMLAllCollection = 5731,
  HTMLAnchorElement = 5749,
  HTMLAreaElement = 5767,
  HTMLAudioElement = 5783,
  HTMLBRElement = 5800,
  HTMLBaseElement = 5814,
  HTMLBodyElement = 5830,
  HTMLButtonElement = 5846,
  HTMLCanvasElement = 5864,
  HTMLCollection = 5882,
  HTMLDListElement = 5897,
  HTMLDataElement = 5914,
  HTMLDataListElement = 5930,
  HTMLDetailsElement = 5950,
  HTMLDialogElement = 5969,
  HTMLDirectoryElement = 5987,
  HTMLDivElement = 6008,
  HTMLDocument = 6023,
  HTMLElement = 6036,
  HTMLEmbedElement = 6048,
  HTMLFieldSetElement = 6065,
  HTMLFontElement = 6085,
  HTMLFormControlsCollection = 6101,
  HTMLFormElement = 6128,
  HTMLFrameElement = 6144,
  HTMLFrameSetElement = 6161,
  HTMLHRElement = 6181,
  HTMLHeadElement = 6195,
  HTMLHeadingElement = 6211,
  HTMLHtmlElement = 6230,
  HTMLIFrameElement = 6246,
  HTMLImageElement = 6264,
  HTMLInputElement = 6281,
  HTMLLIElement = 6298,
  HTMLLabelElement = 6312,
  HTMLLegendElement = 6329,
  HTMLLinkElement = 6347,
  HTMLMapElement = 6363,
  HTMLMarqueeElement = 6378,
  HTMLMediaElement = 6397,
  HTMLMenuElement = 6414,
  HTMLMetaElement = 6430,
  HTMLMeterElement = 6446,
  HTMLModElement = 6463,
  HTMLOListElement = 6478,
  HTMLObjectElement = 6495,
  HTMLOptGroupElement = 6513,
  HTMLOptionElement = 6533,
  HTMLOptionsCollection = 6551,
  HTMLOutputElement = 6573,
  HTMLParagraphElement = 6591,
  HTMLParamElement = 6612,
  HTMLPictureElement = 6629,
  HTMLPreElement = 6648,
  HTMLProgressElement = 6663,
  HTMLQuoteElement = 6683,
  HTMLScriptElement = 6700,
  HTMLSelectElement = 6718,
  HTMLSlotElement = 6736,
  HTMLSourceElement = 6752,
  HTMLSpanElement = 6770,
  HTMLStyleElement = 6786,
  HTMLTableCaptionElement = 6803,
  HTMLTableCellElement = 6827,
  HTMLTableColElement = 6848,
  HTMLTableElement = 6868,
  HTMLTableRowElement = 6885,
  HTMLTableSectionElement = 6905,
  HTMLTemplateElement = 6929,
  HTMLTextAreaElement = 6949,
  HTMLTimeElement = 6969,
  HTMLTitleElement = 6985,
  HTMLTrackElement = 7002,
  HTMLUListElement = 7019,
  HTMLUnknownElement = 7036,
  HTMLVideoElement = 7055,
  HashChangeEvent = 7072,
  Headers = 7088,
  Headers_Iterator = 7096,
  HeapSnapshot = 7113,
  Highlight = 7126,
  HighlightRegistry = 7136,
  History = 7154,
  IDBCursor = 7162,
  IDBCursorWithValue = 7172,
  IDBDatabase = 7191,
  IDBFactory = 7203,
  IDBIndex = 7214,
  IDBKeyRange = 7223,
  IDBObjectStore = 7235,
  IDBOpenDBRequest = 7250,
  IDBRequest = 7267,
  IDBTransaction = 7278,
  IDBVersionChangeEvent = 7293,
  IIRFilterNode = 7315,
  IOUtils = 7329,
  IdentityCredential = 7337,
  IdleDeadline = 7356,
  Image = 7369,
  ImageBitmap = 7375,
  ImageBitmapRenderingContext = 7387,
  ImageCapture = 7415,
  ImageCaptureError = 7428,
  ImageCaptureErrorEvent = 7446,
  ImageData = 7469,
  ImageDecoder = 7479,
  ImageDocument = 7492,
  ImageTrack = 7506,
  ImageTrackList = 7517,
  InputEvent = 7532,
  InspectorCSSParser = 7543,
  InspectorFontFace = 7562,
  InspectorUtils = 7580,
  InstallTriggerImpl = 7595,
  IntersectionObserver = 7614,
  IntersectionObserverEntry = 7635,
  IntlUtils = 7661,
  InvokeEvent = 7671,
  JSProcessActorChild = 7683,
  JSProcessActorParent = 7703,
  JSWindowActorChild = 7724,
  JSWindowActorParent = 7743,
  KeyEvent = 7763,
  KeyboardEvent = 7772,
  KeyframeEffect = 7786,
  L10nFileSource = 7801,
  L10nOverlays = 7816,
  L10nRegistry = 7829,
  LargestContentfulPaint = 7842,
  LegacyMozTCPSocket = 7865,
  Localization = 7884,
  Location = 7897,
  Lock = 7906,
  LockManager = 7911,
  MIDIAccess = 7923,
  MIDIConnectionEvent = 7934,
  MIDIInput = 7954,
  MIDIInputMap = 7964,
  MIDIMessageEvent = 7977,
  MIDIOutput = 7994,
  MIDIOutputMap = 8005,
  MIDIPort = 8019,
  MLS = 8028,
  MLSGroupView = 8032,
  MOZ_debug = 8045,
  MatchGlob = 8055,
  MatchPattern = 8065,
  MatchPatternSet = 8078,
  MathMLElement = 8094,
  MediaCapabilities = 8108,
  MediaControlService = 8126,
  MediaController = 8146,
  MediaDeviceInfo = 8162,
  MediaDevices = 8178,
  MediaElementAudioSourceNode = 8191,
  MediaEncryptedEvent = 8219,
  MediaError = 8239,
  MediaKeyError = 8250,
  MediaKeyMessageEvent = 8264,
  MediaKeySession = 8285,
  MediaKeyStatusMap = 8301,
  MediaKeyStatusMap_Iterator = 8319,
  MediaKeySystemAccess = 8346,
  MediaKeys = 8367,
  MediaList = 8377,
  MediaMetadata = 8387,
  MediaQueryList = 8401,
  MediaQueryListEvent = 8416,
  MediaRecorder = 8436,
  MediaRecorderErrorEvent = 8450,
  MediaSession = 8474,
  MediaSource = 8487,
  MediaStream = 8499,
  MediaStreamAudioDestinationNode = 8511,
  MediaStreamAudioSourceNode = 8543,
  MediaStreamError = 8570,
  MediaStreamEvent = 8587,
  MediaStreamTrack = 8604,
  MediaStreamTrackAudioSourceNode = 8621,
  MediaStreamTrackEvent = 8653,
  MerchantValidationEvent = 8675,
  MessageBroadcaster = 8699,
  MessageChannel = 8718,
  MessageEvent = 8733,
  MessageListenerManager = 8746,
  MessagePort = 8769,
  MessageSender = 8781,
  MimeType = 8795,
  MimeTypeArray = 8804,
  MouseEvent = 8818,
  MouseScrollEvent = 8829,
  MozCanvasPrintState = 8846,
  MozDocumentMatcher = 8866,
  MozDocumentObserver = 8885,
  MozQueryInterface = 8905,
  MozSharedMap = 8923,
  MozSharedMap_Iterator = 8936,
  MozSharedMapChangeEvent = 8958,
  MozStorageAsyncStatementParams = 8982,
  MozStorageStatementParams = 9013,
  MozStorageStatementRow = 9039,
  MozWritableSharedMap = 9062,
  MutationEvent = 9083,
  MutationObserver = 9097,
  MutationRecord = 9114,
  NamedNodeMap = 9129,
  NavigateEvent = 9142,
  Navigation = 9156,
  NavigationActivation = 9167,
  NavigationCurrentEntryChangeEvent = 9188,
  NavigationDestination = 9222,
  NavigationHistoryEntry = 9244,
  NavigationPreloadManager = 9267,
  NavigationTransition = 9292,
  Navigator = 9313,
  NavigatorLogin = 9323,
  NetworkInformation = 9338,
  Node = 9357,
  NodeFilter = 9362,
  NodeIterator = 9373,
  NodeList = 9386,
  Notification = 9395,
  NotificationEvent = 9408,
  NotifyPaintEvent = 9426,
  OES_draw_buffers_indexed = 9443,
  OES_element_index_uint = 9468,
  OES_fbo_render_mipmap = 9491,
  OES_standard_derivatives = 9513,
  OES_texture_float = 9538,
  OES_texture_float_linear = 9556,
  OES_texture_half_float = 9581,
  OES_texture_half_float_linear = 9604,
  OES_vertex_array_object = 9634,
  OVR_multiview2 = 9658,
  OfflineAudioCompletionEvent = 9673,
  OfflineAudioContext = 9701,
  OffscreenCanvas = 9721,
  OffscreenCanvasRenderingContext2D = 9737,
  OnlyForUseInConstructor = 9771,
  Option = 9795,
  OscillatorNode = 9802,
  PageTransitionEvent = 9817,
  PaintRequest = 9837,
  PaintRequestList = 9850,
  PaintWorkletGlobalScope = 9867,
  PannerNode = 9891,
  ParentProcessMessageManager = 9902,
  Path2D = 9930,
  PathUtils = 9937,
  PaymentAddress = 9947,
  PaymentMethodChangeEvent = 9962,
  PaymentRequest = 9987,
  PaymentRequestUpdateEvent = 10002,
  PaymentResponse = 10028,
  PeerConnectionImpl = 10044,
  PeerConnectionObserver = 10063,
  Performance = 10086,
  PerformanceEntry = 10098,
  PerformanceEntryEvent = 10115,
  PerformanceEventTiming = 10137,
  PerformanceMark = 10160,
  PerformanceMeasure = 10176,
  PerformanceNavigation = 10195,
  PerformanceNavigationTiming = 10217,
  PerformanceObserver = 10245,
  PerformanceObserverEntryList = 10265,
  PerformancePaintTiming = 10294,
  PerformanceResourceTiming = 10317,
  PerformanceServerTiming = 10343,
  PerformanceTiming = 10367,
  PeriodicWave = 10385,
  PermissionStatus = 10398,
  Permissions = 10415,
  PlacesBookmark = 10427,
  PlacesBookmarkAddition = 10442,
  PlacesBookmarkChanged = 10465,
  PlacesBookmarkGuid = 10487,
  PlacesBookmarkKeyword = 10506,
  PlacesBookmarkMoved = 10528,
  PlacesBookmarkRemoved = 10548,
  PlacesBookmarkTags = 10570,
  PlacesBookmarkTime = 10589,
  PlacesBookmarkTitle = 10608,
  PlacesBookmarkUrl = 10628,
  PlacesEvent = 10646,
  PlacesEventCounts = 10658,
  PlacesFavicon = 10676,
  PlacesHistoryCleared = 10690,
  PlacesObservers = 10711,
  PlacesPurgeCaches = 10727,
  PlacesRanking = 10745,
  PlacesVisit = 10759,
  PlacesVisitRemoved = 10771,
  PlacesVisitTitle = 10790,
  PlacesWeakCallbackWrapper = 10807,
  Plugin = 10833,
  PluginArray = 10840,
  PluginCrashedEvent = 10852,
  PointerEvent = 10871,
  PopStateEvent = 10884,
  PopupBlockedEvent = 10898,
  PopupPositionedEvent = 10916,
  PositionStateEvent = 10937,
  PrecompiledScript = 10956,
  PrivateAttribution = 10974,
  ProcessMessageManager = 10993,
  ProcessingInstruction = 11015,
  ProgressEvent = 11037,
  PromiseDebugging = 11051,
  PromiseNativeHandler = 11068,
  PromiseRejectionEvent = 11089,
  PublicKeyCredential = 11111,
  PushEvent = 11131,
  PushManager = 11141,
  PushManagerImpl = 11153,
  PushMessageData = 11169,
  PushSubscription = 11185,
  PushSubscriptionChangeEvent = 11202,
  PushSubscriptionOptions = 11230,
  RTCCertificate = 11254,
  RTCDTMFSender = 11269,
  RTCDTMFToneChangeEvent = 11283,
  RTCDataChannel = 11306,
  RTCDataChannelEvent = 11321,
  RTCDtlsTransport = 11341,
  RTCEncodedAudioFrame = 11358,
  RTCEncodedVideoFrame = 11379,
  RTCIceCandidate = 11400,
  RTCIceTransport = 11416,
  RTCIdentityProviderRegistrar = 11432,
  RTCPeerConnection = 11461,
  RTCPeerConnectionIceEvent = 11479,
  RTCPeerConnectionStatic = 11505,
  RTCRtpReceiver = 11529,
  RTCRtpScriptTransform = 11544,
  RTCRtpScriptTransformer = 11566,
  RTCRtpSender = 11590,
  RTCRtpTransceiver = 11603,
  RTCSctpTransport = 11621,
  RTCSessionDescription = 11638,
  RTCStatsReport = 11660,
  RTCTrackEvent = 11675,
  RTCTransformEvent = 11689,
  RadioNodeList = 11707,
  Range = 11721,
  ReadableByteStreamController = 11727,
  ReadableStream = 11756,
  ReadableStream_AsyncIterator = 11771,
  ReadableStreamBYOBReader = 11800,
  ReadableStreamBYOBRequest = 11825,
  ReadableStreamDefaultController = 11851,
  ReadableStreamDefaultReader = 11883,
  RedirectBlockedEvent = 11911,
  Report = 11932,
  ReportBody = 11939,
  ReportingObserver = 11950,
  Request = 11968,
  ResizeObserver = 11976,
  ResizeObserverEntry = 11991,
  ResizeObserverSize = 12011,
  Response = 12030,
  SVGAElement = 12039,
  SVGAngle = 12051,
  SVGAnimateElement = 12060,
  SVGAnimateMotionElement = 12078,
  SVGAnimateTransformElement = 12102,
  SVGAnimatedAngle = 12129,
  SVGAnimatedBoolean = 12146,
  SVGAnimatedEnumeration = 12165,
  SVGAnimatedInteger = 12188,
  SVGAnimatedLength = 12207,
  SVGAnimatedLengthList = 12225,
  SVGAnimatedNumber = 12247,
  SVGAnimatedNumberList = 12265,
  SVGAnimatedPreserveAspectRatio = 12287,
  SVGAnimatedRect = 12318,
  SVGAnimatedString = 12334,
  SVGAnimatedTransformList = 12352,
  SVGAnimationElement = 12377,
  SVGCircleElement = 12397,
  SVGClipPathElement = 12414,
  SVGComponentTransferFunctionElement = 12433,
  SVGDefsElement = 12469,
  SVGDescElement = 12484,
  SVGElement = 12499,
  SVGEllipseElement = 12510,
  SVGFEBlendElement = 12528,
  SVGFEColorMatrixElement = 12546,
  SVGFEComponentTransferElement = 12570,
  SVGFECompositeElement = 12600,
  SVGFEConvolveMatrixElement = 12622,
  SVGFEDiffuseLightingElement = 12649,
  SVGFEDisplacementMapElement = 12677,
  SVGFEDistantLightElement = 12705,
  SVGFEDropShadowElement = 12730,
  SVGFEFloodElement = 12753,
  SVGFEFuncAElement = 12771,
  SVGFEFuncBElement = 12789,
  SVGFEFuncGElement = 12807,
  SVGFEFuncRElement = 12825,
  SVGFEGaussianBlurElement = 12843,
  SVGFEImageElement = 12868,
  SVGFEMergeElement = 12886,
  SVGFEMergeNodeElement = 12904,
  SVGFEMorphologyElement = 12926,
  SVGFEOffsetElement = 12949,
  SVGFEPointLightElement = 12968,
  SVGFESpecularLightingElement = 12991,
  SVGFESpotLightElement = 13020,
  SVGFETileElement = 13042,
  SVGFETurbulenceElement = 13059,
  SVGFilterElement = 13082,
  SVGForeignObjectElement = 13099,
  SVGGElement = 13123,
  SVGGeometryElement = 13135,
  SVGGradientElement = 13154,
  SVGGraphicsElement = 13173,
  SVGImageElement = 13192,
  SVGLength = 13208,
  SVGLengthList = 13218,
  SVGLineElement = 13232,
  SVGLinearGradientElement = 13247,
  SVGMPathElement = 13272,
  SVGMarkerElement = 13288,
  SVGMaskElement = 13305,
  SVGMatrix = 13320,
  SVGMetadataElement = 13330,
  SVGNumber = 13349,
  SVGNumberList = 13359,
  SVGPathElement = 13373,
  SVGPathSegment = 13388,
  SVGPatternElement = 13403,
  SVGPoint = 13421,
  SVGPointList = 13430,
  SVGPolygonElement = 13443,
  SVGPolylineElement = 13461,
  SVGPreserveAspectRatio = 13480,
  SVGRadialGradientElement = 13503,
  SVGRect = 13528,
  SVGRectElement = 13536,
  SVGSVGElement = 13551,
  SVGScriptElement = 13565,
  SVGSetElement = 13582,
  SVGStopElement = 13596,
  SVGStringList = 13611,
  SVGStyleElement = 13625,
  SVGSwitchElement = 13641,
  SVGSymbolElement = 13658,
  SVGTSpanElement = 13675,
  SVGTextContentElement = 13691,
  SVGTextElement = 13713,
  SVGTextPathElement = 13728,
  SVGTextPositioningElement = 13747,
  SVGTitleElement = 13773,
  SVGTransform = 13789,
  SVGTransformList = 13802,
  SVGUnitTypes = 13819,
  SVGUseElement = 13832,
  SVGViewElement = 13846,
  Sanitizer = 13861,
  Scheduler = 13871,
  Screen = 13881,
  ScreenLuminance = 13888,
  ScreenOrientation = 13904,
  ScriptProcessorNode = 13922,
  ScrollAreaEvent = 13942,
  SecurityPolicyViolationEvent = 13958,
  Selection = 13987,
  ServiceWorker = 13997,
  ServiceWorkerContainer = 14011,
  ServiceWorkerGlobalScope = 14034,
  ServiceWorkerRegistration = 14059,
  SessionStoreFormData = 14085,
  SessionStoreScrollData = 14106,
  SessionStoreUtils = 14129,
  ShadowRealmGlobalScope = 14147,
  ShadowRoot = 14170,
  SharedWorker = 14181,
  SharedWorkerGlobalScope = 14194,
  SimpleGestureEvent = 14218,
  SourceBuffer = 14237,
  SourceBufferList = 14250,
  SpeechGrammar = 14267,
  SpeechGrammarList = 14281,
  SpeechRecognition = 14299,
  SpeechRecognitionAlternative = 14317,
  SpeechRecognitionError = 14346,
  SpeechRecognitionEvent = 14369,
  SpeechRecognitionResult = 14392,
  SpeechRecognitionResultList = 14416,
  SpeechSynthesis = 14444,
  SpeechSynthesisErrorEvent = 14460,
  SpeechSynthesisEvent = 14486,
  SpeechSynthesisUtterance = 14507,
  SpeechSynthesisVoice = 14532,
  StaticRange = 14553,
  StereoPannerNode = 14565,
  Storage = 14582,
  StorageEvent = 14590,
  StorageManager = 14603,
  StreamFilter = 14618,
  StreamFilterDataEvent = 14631,
  StructuredCloneHolder = 14653,
  StructuredCloneTester = 14675,
  StyleSheet = 14697,
  StyleSheetApplicableStateChangeEvent = 14708,
  StyleSheetList = 14745,
  StyleSheetRemovedEvent = 14760,
  SubmitEvent = 14783,
  SubtleCrypto = 14795,
  SyncMessageSender = 14808,
  SyncReadFile = 14826,
  TCPServerSocket = 14839,
  TCPServerSocketEvent = 14855,
  TCPSocket = 14876,
  TCPSocketErrorEvent = 14886,
  TCPSocketEvent = 14906,
  TaskController = 14921,
  TaskPriorityChangeEvent = 14936,
  TaskSignal = 14960,
  TestAttributesOnTypes = 14971,
  TestCEReactionsInterface = 14993,
  TestCImplementedInterface = 15018,
  TestCImplementedInterface2 = 15044,
  TestCallbackDictUnionOverload = 15071,
  TestChildInterface = 15101,
  TestConstructorForFuncInterface = 15120,
  TestConstructorForPrefInterface = 15152,
  TestConstructorForSCInterface = 15184,
  TestCppKeywordNamedMethodsInterface = 15214,
  TestDeprecatedInterface = 15250,
  TestExampleInterface = 15274,
  TestExampleProxyInterface = 15295,
  TestExampleThrowingConstructorInterface = 15321,
  TestExampleWorkerInterface = 15361,
  TestFuncConstructorForDifferentFuncInterface = 15388,
  TestFuncConstructorForInterface = 15433,
  TestHTMLConstructorInterface = 15465,
  TestIndexedAndNamedGetterAndSetterInterface = 15494,
  TestIndexedAndNamedGetterInterface = 15538,
  TestIndexedAndNamedSetterInterface = 15573,
  TestIndexedGetterAndSetterAndNamedGetterInterface = 15608,
  TestIndexedGetterInterface = 15658,
  TestIndexedSetterInterface = 15685,
  TestInterface = 15712,
  TestInterfaceWithPromiseConstructorArg = 15726,
  TestJSImplInterface = 15765,
  TestJSImplInterface2 = 15785,
  TestJSImplInterface3 = 15806,
  TestJSImplInterface4 = 15827,
  TestJSImplInterface5 = 15848,
  TestJSImplInterface6 = 15869,
  TestJSImplNoInterfaceObject = 15890,
  TestLegacyFactoryFunctionInterface = 15918,
  TestLegacyFactoryFunctionInterface2 = 15953,
  TestNamedDeleterInterface = 15989,
  TestNamedDeleterWithRetvalInterface = 16015,
  TestNamedGetterInterface = 16051,
  TestNamedSetterInterface = 16076,
  TestNamespace = 16101,
  TestNonWrapperCacheInterface = 16115,
  TestParentInterface = 16144,
  TestPrefChromeOnlySCFuncConstructorForInterface = 16164,
  TestPrefConstructorForDifferentPrefInterface = 16212,
  TestPrefConstructorForInterface = 16257,
  TestProtoObjectHackedNamespace = 16289,
  TestRenamedInterface = 16320,
  TestRenamedNamespace = 16341,
  TestSCConstructorForInterface = 16362,
  TestSecureContextInterface = 16392,
  TestThrowingConstructorInterface = 16419,
  TestUtils = 16452,
  TestWorkerExposedInterface = 16462,
  TestingDeprecatedInterface = 16489,
  Text = 16516,
  TextClause = 16521,
  TextDecoder = 16532,
  TextDecoderStream = 16544,
  TextEncoder = 16562,
  TextEncoderStream = 16574,
  TextEvent = 16592,
  TextMetrics = 16602,
  TextTrack = 16614,
  TextTrackCue = 16624,
  TextTrackCueList = 16637,
  TextTrackList = 16654,
  TimeEvent = 16668,
  TimeRanges = 16678,
  ToggleEvent = 16689,
  Touch = 16701,
  TouchEvent = 16707,
  TouchList = 16718,
  TrackEvent = 16728,
  TransformStream = 16739,
  TransformStreamDefaultController = 16755,
  TransitionEvent = 16788,
  TreeColumn = 16804,
  TreeColumns = 16815,
  TreeContentView = 16827,
  TreeWalker = 16843,
  TrustedHTML = 16854,
  TrustedScript = 16866,
  TrustedScriptURL = 16880,
  TrustedTypePolicy = 16897,
  TrustedTypePolicyFactory = 16915,
  UDPMessageEvent = 16940,
  UDPSocket = 16956,
  UIEvent = 16966,
  URL = 16974,
  URLSearchParams = 16978,
  URLSearchParams_Iterator = 16994,
  UniFFIPointer = 17019,
  UniFFIScaffolding = 17033,
  UserActivation = 17051,
  UserInteraction = 17066,
  UserProximityEvent = 17082,
  VRDisplay = 17101,
  VRDisplayCapabilities = 17111,
  VRDisplayEvent = 17133,
  VREyeParameters = 17148,
  VRFieldOfView = 17164,
  VRFrameData = 17178,
  VRMockController = 17190,
  VRMockDisplay = 17207,
  VRPose = 17221,
  VRServiceTest = 17228,
  VRStageParameters = 17242,
  VTTCue = 17260,
  VTTRegion = 17267,
  ValidityState = 17277,
  VideoColorSpace = 17291,
  VideoDecoder = 17307,
  VideoEncoder = 17320,
  VideoFrame = 17333,
  VideoPlaybackQuality = 17344,
  VideoTrack = 17365,
  VideoTrackList = 17376,
  ViewTransition = 17391,
  VisualViewport = 17406,
  WEBGL_color_buffer_float = 17421,
  WEBGL_compressed_texture_astc = 17446,
  WEBGL_compressed_texture_etc = 17476,
  WEBGL_compressed_texture_etc1 = 17505,
  WEBGL_compressed_texture_pvrtc = 17535,
  WEBGL_compressed_texture_s3tc = 17566,
  WEBGL_compressed_texture_s3tc_srgb = 17596,
  WEBGL_debug_renderer_info = 17631,
  WEBGL_debug_shaders = 17657,
  WEBGL_depth_texture = 17677,
  WEBGL_draw_buffers = 17697,
  WEBGL_explicit_present = 17716,
  WEBGL_lose_context = 17739,
  WEBGL_provoking_vertex = 17758,
  WGSLLanguageFeatures = 17781,
  WakeLock = 17802,
  WakeLockSentinel = 17811,
  WaveShaperNode = 17828,
  WebExtensionContentScript = 17843,
  WebExtensionPolicy = 17869,
  WebGL2RenderingContext = 17888,
  WebGLActiveInfo = 17911,
  WebGLBuffer = 17927,
  WebGLContextEvent = 17939,
  WebGLFramebuffer = 17957,
  WebGLProgram = 17974,
  WebGLQuery = 17987,
  WebGLRenderbuffer = 17998,
  WebGLRenderingContext = 18016,
  WebGLSampler = 18038,
  WebGLShader = 18051,
  WebGLShaderPrecisionFormat = 18063,
  WebGLSync = 18090,
  WebGLTexture = 18100,
  WebGLTransformFeedback = 18113,
  WebGLUniformLocation = 18136,
  WebGLVertexArrayObject = 18157,
  WebKitCSSMatrix = 18180,
  WebSocket = 18196,
  WebTransport = 18206,
  WebTransportBidirectionalStream = 18219,
  WebTransportDatagramDuplexStream = 18251,
  WebTransportError = 18284,
  WebTransportReceiveStream = 18302,
  WebTransportSendStream = 18328,
  WebrtcGlobalInformation = 18351,
  WheelEvent = 18375,
  Window = 18386,
  WindowClient = 18393,
  WindowContext = 18406,
  WindowGlobalChild = 18420,
  WindowGlobalParent = 18438,
  WindowRoot = 18457,
  Worker = 18468,
  WorkerDebuggerGlobalScope = 18475,
  WorkerGlobalScope = 18501,
  WorkerLocation = 18519,
  WorkerNavigator = 18534,
  WorkerTestUtils = 18550,
  Worklet = 18566,
  WorkletGlobalScope = 18574,
  WritableStream = 18593,
  WritableStreamDefaultController = 18608,
  WritableStreamDefaultWriter = 18640,
  XMLDocument = 18668,
  XMLHttpRequest = 18680,
  XMLHttpRequestEventTarget = 18695,
  XMLHttpRequestUpload = 18721,
  XMLSerializer = 18742,
  XPathEvaluator = 18756,
  XPathExpression = 18771,
  XPathResult = 18787,
  XRBoundedReferenceSpace = 18799,
  XRFrame = 18823,
  XRInputSource = 18831,
  XRInputSourceArray = 18845,
  XRInputSourceEvent = 18864,
  XRInputSourcesChangeEvent = 18883,
  XRPose = 18909,
  XRReferenceSpace = 18916,
  XRReferenceSpaceEvent = 18933,
  XRRenderState = 18955,
  XRRigidTransform = 18969,
  XRSession = 18986,
  XRSessionEvent = 18996,
  XRSpace = 19011,
  XRSystem = 19019,
  XRView = 19028,
  XRViewerPose = 19035,
  XRViewport = 19048,
  XRWebGLLayer = 19059,
  XSLTProcessor = 19072,
  XULCommandEvent = 19086,
  XULElement = 19102,
  XULFrameElement = 19113,
  XULMenuElement = 19129,
  XULPopupElement = 19144,
  XULResizerElement = 19160,
  XULTextElement = 19178,
  XULTreeElement = 19193,
  console = 19208,
  webkitSpeechGrammar = 19216,
  webkitSpeechGrammarList = 19236,
  webkitSpeechRecognition = 19260,
  webkitURL = 19284,
};

namespace binding_detail {
extern const char sBindingNames[];
}  // namespace binding_detail

MOZ_ALWAYS_INLINE const char* BindingName(BindingNamesOffset aOffset) {
  return binding_detail::sBindingNames + static_cast<size_t>(aOffset);
}

} // namespace mozilla::dom


#endif // DOM_BINDINGNAMES_H_
