// DO NOT EDIT! This test has been generated by /html/canvas/tools/gentest.py.
// OffscreenCanvas test in a worker:2d.text.measure.text-clusters-exceptions.tentative
// Description:Check that TextMetrics::getTextClusters() throws when using invalid indexes.
// Note:

importScripts("/resources/testharness.js");
importScripts("/html/canvas/resources/canvas-tests.js");

var t = async_test("Check that TextMetrics::getTextClusters() throws when using invalid indexes.");
var t_pass = t.done.bind(t);
var t_fail = t.step_func(function(reason) {
    throw reason;
});
t.step(function() {

  var canvas = new OffscreenCanvas(100, 50);
  var ctx = canvas.getContext('2d');

  const kTexts = [
    'UNAVAILABLE',
    '🏁🎶🏁',
    '）（あ）（',
    '-abcd_'
  ]

  for (const text of kTexts) {
    const tm = ctx.measureText(text);
    // Handled by the IDL binding.
    assert_throws_js(TypeError, () => tm.getTextClusters(-1, 0) );
    assert_throws_js(TypeError, () => tm.getTextClusters(0, -1) );
    assert_throws_js(TypeError, () => tm.getTextClusters(-1, -1) );
    // Thrown in TextMetrics.
    assert_throws_dom("IndexSizeError",
            () => tm.getTextClusters(text.length, 0) );
    assert_throws_dom("IndexSizeError",
            () => tm.getTextClusters(0, text.length + 1) );
    assert_throws_dom("IndexSizeError",
            () => tm.getTextClusters(text.length, text.length + 1) );
  }
  t.done();
});
done();
