// DO NOT EDIT! This test has been generated by /html/canvas/tools/gentest.py.
// OffscreenCanvas test in a worker:2d.text.measure.text-clusters-split.tentative
// Description:Test that getTextClusters() splits the input correctly into the minimal clusters, keeping emojis together.
// Note:

importScripts("/resources/testharness.js");
importScripts("/html/canvas/resources/canvas-tests.js");

var t = async_test("Test that getTextClusters() splits the input correctly into the minimal clusters, keeping emojis together.");
var t_pass = t.done.bind(t);
var t_fail = t.step_func(function(reason) {
    throw reason;
});
t.step(function() {

  var canvas = new OffscreenCanvas(400, 200);
  var ctx = canvas.getContext('2d');

  ctx.font = '50px serif';
  const text = 'ABC ☺️❤️';
  ctx.fillText(text, 20, 100);
  const tm = ctx.measureText(text);
  const clusters = tm.getTextClusters();
  // Should return 6 clusters(A|B|C| |☺️|❤️).
  _assertSame(clusters.length, 6, "clusters.length", "6");
  // A from position 0 to 1.
  _assertSame(clusters[0].start, 0, "clusters[\""+(0)+"\"].start", "0");
  _assertSame(clusters[0].end, 1, "clusters[\""+(0)+"\"].end", "1");
  // B from position 1 to 2.
  _assertSame(clusters[1].start, 1, "clusters[\""+(1)+"\"].start", "1");
  _assertSame(clusters[1].end, 2, "clusters[\""+(1)+"\"].end", "2");
  // C from position 2 to 3.
  _assertSame(clusters[2].start, 2, "clusters[\""+(2)+"\"].start", "2");
  _assertSame(clusters[2].end, 3, "clusters[\""+(2)+"\"].end", "3");
  // space from position 3 to 4.
  _assertSame(clusters[3].start, 3, "clusters[\""+(3)+"\"].start", "3");
  _assertSame(clusters[3].end, 4, "clusters[\""+(3)+"\"].end", "4");
  // ☺️ from position 4 to 6.
  _assertSame(clusters[4].start, 4, "clusters[\""+(4)+"\"].start", "4");
  _assertSame(clusters[4].end, 6, "clusters[\""+(4)+"\"].end", "6");
  // ❤️ from position 6 to 8.
  _assertSame(clusters[5].start, 6, "clusters[\""+(5)+"\"].start", "6");
  _assertSame(clusters[5].end, 8, "clusters[\""+(5)+"\"].end", "8");
  t.done();
});
done();
