# Regenerating APNG Test Images

## Test images

Most of the APNG tests are a port to WPT of an [earlier testsuite by Philip Taylor](https://philip.html5.org/tests/apng/tests.html). The test images were autogenerated, and this directory contains what is needed to regenerate them:

- ['source.html'](./source.html) which contains a human-readable description of each test file
- ['generate.pl'](./generate.pl) which uses [Cairo](https://www.cairographics.org/) to create the test images

If this script is used to create additional images, not part of the original test suite, be aware that the generated files are automatically named as sequentially-numbered `nnn.png` so add any new ones _at the end_ to avoid changing the name of existing files.

## Reference images

The reference images were created by decompiling the APNG with [apngasm](https://github.com/apngasm/apngasm) into a series of static PNG representing the displayed state of each frame. The last one therefore represents the end state of the animation. Again this tool produces numbered files like `nn.png` so these were renamed in a more meaningful way (such as `darkblue.png`) to create the reference images.
