#ifndef DOM_BINDINGNAMES_H_
#define DOM_BINDINGNAMES_H_

#include <stddef.h>
#include <stdint.h>
#include "mozilla/Attributes.h"

namespace mozilla::dom {

enum class BindingNamesOffset : uint16_t {
  ANGLE_instanced_arrays = 0,
  APZHitResultFlags = 23,
  AbortController = 41,
  AbortSignal = 57,
  AbstractRange = 69,
  AccessibleNode = 83,
  Addon = 98,
  AddonEvent = 104,
  AddonInstall = 115,
  AddonManager = 128,
  AddonManagerPermissions = 141,
  AnalyserNode = 165,
  Animation = 178,
  AnimationEffect = 188,
  AnimationEvent = 204,
  AnimationPlaybackEvent = 219,
  AnimationTimeline = 242,
  AnonymousContent = 260,
  Attr = 277,
  Audio = 282,
  AudioBuffer = 288,
  AudioBufferSourceNode = 300,
  AudioContext = 322,
  AudioData = 335,
  AudioDecoder = 345,
  AudioDestinationNode = 358,
  AudioEncoder = 379,
  AudioListener = 392,
  AudioNode = 406,
  AudioParam = 416,
  AudioParamMap = 427,
  AudioProcessingEvent = 441,
  AudioScheduledSourceNode = 462,
  AudioTrack = 487,
  AudioTrackList = 498,
  AudioWorklet = 513,
  AudioWorkletGlobalScope = 526,
  AudioWorkletNode = 550,
  AudioWorkletProcessor = 567,
  AuthenticatorAssertionResponse = 589,
  AuthenticatorAttestationResponse = 620,
  AuthenticatorResponse = 653,
  BarProp = 675,
  BaseAudioContext = 683,
  BatteryManager = 700,
  BeforeUnloadEvent = 715,
  BiquadFilterNode = 733,
  Blob = 750,
  BlobEvent = 755,
  BroadcastChannel = 765,
  BrowsingContext = 782,
  BrowsingContextGroup = 798,
  ByteLengthQueuingStrategy = 819,
  CDATASection = 845,
  CSPViolationReportBody = 858,
  CSS = 881,
  CSSAnimation = 885,
  CSSColor = 898,
  CSSColorValue = 907,
  CSSConditionRule = 921,
  CSSContainerRule = 938,
  CSSCounterStyleRule = 955,
  CSSCustomMediaRule = 975,
  CSSCustomPropertyRegisteredEvent = 994,
  CSSFontFaceRule = 1027,
  CSSFontFeatureValuesRule = 1043,
  CSSFontPaletteValuesRule = 1068,
  CSSGroupingRule = 1093,
  CSSHSL = 1109,
  CSSHWB = 1116,
  CSSImageValue = 1123,
  CSSImportRule = 1137,
  CSSKeyframeRule = 1151,
  CSSKeyframesRule = 1167,
  CSSKeywordValue = 1184,
  CSSLCH = 1200,
  CSSLab = 1207,
  CSSLayerBlockRule = 1214,
  CSSLayerStatementRule = 1232,
  CSSMarginRule = 1254,
  CSSMathClamp = 1268,
  CSSMathInvert = 1281,
  CSSMathMax = 1295,
  CSSMathMin = 1306,
  CSSMathNegate = 1317,
  CSSMathProduct = 1331,
  CSSMathSum = 1346,
  CSSMathValue = 1357,
  CSSMatrixComponent = 1370,
  CSSMediaRule = 1389,
  CSSMozDocumentRule = 1402,
  CSSNamespaceRule = 1421,
  CSSNestedDeclarations = 1438,
  CSSNumericArray = 1460,
  CSSNumericValue = 1476,
  CSSOKLCH = 1492,
  CSSOKLab = 1501,
  CSSPageDescriptors = 1510,
  CSSPageRule = 1529,
  CSSPerspective = 1541,
  CSSPositionTryDescriptors = 1556,
  CSSPositionTryRule = 1582,
  CSSPropertyRule = 1601,
  CSSPseudoElement = 1617,
  CSSRGB = 1634,
  CSSRotate = 1641,
  CSSRule = 1651,
  CSSRuleList = 1659,
  CSSScale = 1671,
  CSSScopeRule = 1680,
  CSSSkew = 1693,
  CSSSkewX = 1701,
  CSSSkewY = 1710,
  CSSStartingStyleRule = 1719,
  CSSStyleDeclaration = 1740,
  CSSStyleProperties = 1760,
  CSSStyleRule = 1779,
  CSSStyleSheet = 1792,
  CSSStyleValue = 1806,
  CSSSupportsRule = 1820,
  CSSTransformComponent = 1836,
  CSSTransformValue = 1858,
  CSSTransition = 1876,
  CSSTranslate = 1890,
  CSSUnitValue = 1903,
  CSSUnparsedValue = 1916,
  CSSVariableReferenceValue = 1933,
  Cache = 1959,
  CacheStorage = 1965,
  CallbackDebuggerNotification = 1978,
  CanonicalBrowsingContext = 2007,
  CanvasCaptureMediaStream = 2032,
  CanvasGradient = 2057,
  CanvasPattern = 2072,
  CanvasRenderingContext2D = 2086,
  CaretPosition = 2111,
  CaretStateChangedEvent = 2125,
  ChannelMergerNode = 2148,
  ChannelSplitterNode = 2166,
  ChannelWrapper = 2186,
  CharacterData = 2201,
  CheckerboardReportService = 2215,
  ChildProcessMessageManager = 2241,
  ChildSHistory = 2268,
  ChromeMessageBroadcaster = 2282,
  ChromeMessageSender = 2307,
  ChromeNodeList = 2327,
  ChromeUtils = 2342,
  ChromeWorker = 2354,
  Client = 2367,
  Clients = 2374,
  Clipboard = 2382,
  ClipboardEvent = 2392,
  ClipboardItem = 2407,
  ClonedErrorHolder = 2421,
  CloseEvent = 2439,
  CloseWatcher = 2450,
  CommandEvent = 2463,
  Comment = 2476,
  CompositionEvent = 2484,
  CompressionStream = 2501,
  ConsoleInstance = 2519,
  ConstantSourceNode = 2535,
  ContentFrameMessageManager = 2554,
  ContentProcessMessageManager = 2581,
  ContentVisibilityAutoStateChangeEvent = 2610,
  ConvolverNode = 2648,
  CookieChangeEvent = 2662,
  CookieStore = 2680,
  CookieStoreManager = 2692,
  CountQueuingStrategy = 2711,
  CreateOfferRequest = 2732,
  Credential = 2751,
  CredentialsContainer = 2762,
  Crypto = 2783,
  CryptoKey = 2790,
  CustomElementRegistry = 2800,
  CustomEvent = 2822,
  CustomStateSet = 2834,
  DOMException = 2849,
  DOMImplementation = 2862,
  DOMLocalization = 2880,
  DOMMatrix = 2896,
  DOMMatrixReadOnly = 2906,
  DOMParser = 2924,
  DOMPoint = 2934,
  DOMPointReadOnly = 2943,
  DOMQuad = 2960,
  DOMRect = 2968,
  DOMRectList = 2976,
  DOMRectReadOnly = 2988,
  DOMStringList = 3004,
  DOMStringMap = 3018,
  DOMTokenList = 3031,
  DataTransfer = 3044,
  DataTransferItem = 3057,
  DataTransferItemList = 3074,
  DebuggerNotification = 3095,
  DebuggerNotificationObserver = 3116,
  DecompressionStream = 3145,
  DedicatedWorkerGlobalScope = 3165,
  DelayNode = 3192,
  DeprecationReportBody = 3202,
  DeviceAcceleration = 3224,
  DeviceLightEvent = 3243,
  DeviceMotionEvent = 3260,
  DeviceOrientationEvent = 3278,
  DeviceRotationRate = 3301,
  Directory = 3320,
  Document = 3330,
  DocumentFragment = 3339,
  DocumentL10n = 3356,
  DocumentTimeline = 3369,
  DocumentType = 3386,
  DominatorTree = 3399,
  DragEvent = 3413,
  DynamicsCompressorNode = 3423,
  EXT_blend_minmax = 3446,
  EXT_color_buffer_float = 3463,
  EXT_color_buffer_half_float = 3486,
  EXT_depth_clamp = 3514,
  EXT_disjoint_timer_query = 3530,
  EXT_float_blend = 3555,
  EXT_frag_depth = 3571,
  EXT_sRGB = 3586,
  EXT_shader_texture_lod = 3595,
  EXT_texture_compression_bptc = 3618,
  EXT_texture_compression_rgtc = 3647,
  EXT_texture_filter_anisotropic = 3676,
  EXT_texture_norm16 = 3707,
  Element = 3726,
  ElementInternals = 3734,
  EncodedAudioChunk = 3751,
  EncodedVideoChunk = 3769,
  ErrorEvent = 3787,
  Event = 3798,
  EventCallbackDebuggerNotification = 3804,
  EventCounts = 3838,
  EventSource = 3850,
  EventTarget = 3862,
  Exception = 3874,
  ExtendableCookieChangeEvent = 3884,
  ExtendableEvent = 3912,
  ExtendableMessageEvent = 3928,
  ExtensionAlarms = 3951,
  ExtensionBrowser = 3967,
  ExtensionBrowserSettings = 3984,
  ExtensionBrowserSettingsColorManagement = 4009,
  ExtensionDns = 4049,
  ExtensionEventManager = 4062,
  ExtensionMockAPI = 4084,
  ExtensionPort = 4101,
  ExtensionProxy = 4115,
  ExtensionRuntime = 4130,
  ExtensionScripting = 4147,
  ExtensionSetting = 4166,
  ExtensionTest = 4183,
  External = 4197,
  FeaturePolicy = 4206,
  FeaturePolicyViolationReportBody = 4220,
  FetchEvent = 4253,
  FetchObserver = 4264,
  File = 4278,
  FileList = 4283,
  FileReader = 4292,
  FileReaderSync = 4303,
  FileSystem = 4318,
  FileSystemDirectoryEntry = 4329,
  FileSystemDirectoryHandle = 4354,
  FileSystemDirectoryHandle_AsyncIterator = 4380,
  FileSystemDirectoryIterator = 4420,
  FileSystemDirectoryReader = 4448,
  FileSystemEntry = 4474,
  FileSystemFileEntry = 4490,
  FileSystemFileHandle = 4510,
  FileSystemHandle = 4531,
  FileSystemSyncAccessHandle = 4548,
  FileSystemWritableFileStream = 4575,
  Flex = 4604,
  FlexItemValues = 4609,
  FlexLineValues = 4624,
  FluentBundle = 4639,
  FluentBundleAsyncIterator = 4652,
  FluentBundleIterator = 4678,
  FluentPattern = 4699,
  FluentResource = 4713,
  FocusEvent = 4728,
  FontFace = 4739,
  FontFaceSet = 4748,
  FontFaceSetIterator = 4760,
  FontFaceSetLoadEvent = 4780,
  FormData = 4801,
  FormData_Iterator = 4810,
  FormDataEvent = 4828,
  FragmentDirective = 4842,
  FrameCrashedEvent = 4860,
  FrameLoader = 4878,
  GPU = 4890,
  GPUAdapter = 4894,
  GPUAdapterInfo = 4905,
  GPUBindGroup = 4920,
  GPUBindGroupLayout = 4933,
  GPUBuffer = 4952,
  GPUBufferUsage = 4962,
  GPUCanvasContext = 4977,
  GPUColorWrite = 4994,
  GPUCommandBuffer = 5008,
  GPUCommandEncoder = 5025,
  GPUCompilationInfo = 5043,
  GPUCompilationMessage = 5062,
  GPUComputePassEncoder = 5084,
  GPUComputePipeline = 5106,
  GPUDevice = 5125,
  GPUDeviceLostInfo = 5135,
  GPUError = 5153,
  GPUExternalTexture = 5162,
  GPUInternalError = 5181,
  GPUMapMode = 5198,
  GPUOutOfMemoryError = 5209,
  GPUPipelineError = 5229,
  GPUPipelineLayout = 5246,
  GPUQuerySet = 5264,
  GPUQueue = 5276,
  GPURenderBundle = 5285,
  GPURenderBundleEncoder = 5301,
  GPURenderPassEncoder = 5324,
  GPURenderPipeline = 5345,
  GPUSampler = 5363,
  GPUShaderModule = 5374,
  GPUShaderStage = 5390,
  GPUSupportedFeatures = 5405,
  GPUSupportedLimits = 5426,
  GPUTexture = 5445,
  GPUTextureUsage = 5456,
  GPUTextureView = 5472,
  GPUUncapturedErrorEvent = 5487,
  GPUValidationError = 5511,
  GainNode = 5530,
  Gamepad = 5539,
  GamepadAxisMoveEvent = 5547,
  GamepadButton = 5568,
  GamepadButtonEvent = 5582,
  GamepadEvent = 5601,
  GamepadHapticActuator = 5614,
  GamepadLightIndicator = 5636,
  GamepadPose = 5658,
  GamepadServiceTest = 5670,
  GamepadTouch = 5689,
  Geolocation = 5702,
  GeolocationCoordinates = 5714,
  GeolocationPosition = 5737,
  GeolocationPositionError = 5757,
  GetUserMediaRequest = 5782,
  GleanBoolean = 5802,
  GleanCategory = 5815,
  GleanCounter = 5829,
  GleanCustomDistribution = 5842,
  GleanDatetime = 5866,
  GleanDenominator = 5880,
  GleanDualLabeledCounter = 5897,
  GleanEvent = 5921,
  GleanImpl = 5932,
  GleanLabeled = 5942,
  GleanMemoryDistribution = 5955,
  GleanMetric = 5979,
  GleanNumerator = 5991,
  GleanObject = 6006,
  GleanPingsImpl = 6018,
  GleanQuantity = 6033,
  GleanRate = 6047,
  GleanString = 6057,
  GleanStringList = 6069,
  GleanText = 6085,
  GleanTimespan = 6095,
  GleanTimingDistribution = 6109,
  GleanUrl = 6133,
  GleanUuid = 6142,
  Grid = 6152,
  GridArea = 6157,
  GridDimension = 6166,
  GridLine = 6180,
  GridLines = 6189,
  GridTrack = 6199,
  GridTracks = 6209,
  HTMLAllCollection = 6220,
  HTMLAnchorElement = 6238,
  HTMLAreaElement = 6256,
  HTMLAudioElement = 6272,
  HTMLBRElement = 6289,
  HTMLBaseElement = 6303,
  HTMLBodyElement = 6319,
  HTMLButtonElement = 6335,
  HTMLCanvasElement = 6353,
  HTMLCollection = 6371,
  HTMLDListElement = 6386,
  HTMLDataElement = 6403,
  HTMLDataListElement = 6419,
  HTMLDetailsElement = 6439,
  HTMLDialogElement = 6458,
  HTMLDirectoryElement = 6476,
  HTMLDivElement = 6497,
  HTMLDocument = 6512,
  HTMLElement = 6525,
  HTMLEmbedElement = 6537,
  HTMLFieldSetElement = 6554,
  HTMLFontElement = 6574,
  HTMLFormControlsCollection = 6590,
  HTMLFormElement = 6617,
  HTMLFrameElement = 6633,
  HTMLFrameSetElement = 6650,
  HTMLHRElement = 6670,
  HTMLHeadElement = 6684,
  HTMLHeadingElement = 6700,
  HTMLHtmlElement = 6719,
  HTMLIFrameElement = 6735,
  HTMLImageElement = 6753,
  HTMLInputElement = 6770,
  HTMLLIElement = 6787,
  HTMLLabelElement = 6801,
  HTMLLegendElement = 6818,
  HTMLLinkElement = 6836,
  HTMLMapElement = 6852,
  HTMLMarqueeElement = 6867,
  HTMLMediaElement = 6886,
  HTMLMenuElement = 6903,
  HTMLMetaElement = 6919,
  HTMLMeterElement = 6935,
  HTMLModElement = 6952,
  HTMLOListElement = 6967,
  HTMLObjectElement = 6984,
  HTMLOptGroupElement = 7002,
  HTMLOptionElement = 7022,
  HTMLOptionsCollection = 7040,
  HTMLOutputElement = 7062,
  HTMLParagraphElement = 7080,
  HTMLParamElement = 7101,
  HTMLPictureElement = 7118,
  HTMLPreElement = 7137,
  HTMLProgressElement = 7152,
  HTMLQuoteElement = 7172,
  HTMLScriptElement = 7189,
  HTMLSelectElement = 7207,
  HTMLSlotElement = 7225,
  HTMLSourceElement = 7241,
  HTMLSpanElement = 7259,
  HTMLStyleElement = 7275,
  HTMLTableCaptionElement = 7292,
  HTMLTableCellElement = 7316,
  HTMLTableColElement = 7337,
  HTMLTableElement = 7357,
  HTMLTableRowElement = 7374,
  HTMLTableSectionElement = 7394,
  HTMLTemplateElement = 7418,
  HTMLTextAreaElement = 7438,
  HTMLTimeElement = 7458,
  HTMLTitleElement = 7474,
  HTMLTrackElement = 7491,
  HTMLUListElement = 7508,
  HTMLUnknownElement = 7525,
  HTMLVideoElement = 7544,
  HashChangeEvent = 7561,
  Headers = 7577,
  Headers_Iterator = 7585,
  HeapSnapshot = 7602,
  Highlight = 7615,
  HighlightRegistry = 7625,
  History = 7643,
  IDBCursor = 7651,
  IDBCursorWithValue = 7661,
  IDBDatabase = 7680,
  IDBFactory = 7692,
  IDBIndex = 7703,
  IDBKeyRange = 7712,
  IDBObjectStore = 7724,
  IDBOpenDBRequest = 7739,
  IDBRequest = 7756,
  IDBTransaction = 7767,
  IDBVersionChangeEvent = 7782,
  IIRFilterNode = 7804,
  IOUtils = 7818,
  IdentityCredential = 7826,
  IdentityProvider = 7845,
  IdleDeadline = 7862,
  Image = 7875,
  ImageBitmap = 7881,
  ImageBitmapRenderingContext = 7893,
  ImageCapture = 7921,
  ImageCaptureError = 7934,
  ImageCaptureErrorEvent = 7952,
  ImageData = 7975,
  ImageDecoder = 7985,
  ImageDocument = 7998,
  ImageTrack = 8012,
  ImageTrackList = 8023,
  InferenceSession = 8038,
  InputEvent = 8055,
  InspectorCSSParser = 8066,
  InspectorFontFace = 8085,
  InspectorUtils = 8103,
  IntersectionObserver = 8118,
  IntersectionObserverEntry = 8139,
  IntlUtils = 8165,
  JSProcessActorChild = 8175,
  JSProcessActorParent = 8195,
  JSWindowActorChild = 8216,
  JSWindowActorParent = 8235,
  KeyEvent = 8255,
  KeyboardEvent = 8264,
  KeyframeEffect = 8278,
  L10nFileSource = 8293,
  L10nOverlays = 8308,
  L10nRegistry = 8321,
  LargestContentfulPaint = 8334,
  LegacyMozTCPSocket = 8357,
  Localization = 8376,
  Location = 8389,
  Lock = 8398,
  LockManager = 8403,
  MIDIAccess = 8415,
  MIDIConnectionEvent = 8426,
  MIDIInput = 8446,
  MIDIInputMap = 8456,
  MIDIMessageEvent = 8469,
  MIDIOutput = 8486,
  MIDIOutputMap = 8497,
  MIDIPort = 8511,
  MLS = 8520,
  MLSGroupView = 8524,
  MOZ_debug = 8537,
  MatchGlob = 8547,
  MatchPattern = 8557,
  MatchPatternSet = 8570,
  MathMLElement = 8586,
  MediaCapabilities = 8600,
  MediaControlService = 8618,
  MediaController = 8638,
  MediaDeviceInfo = 8654,
  MediaDevices = 8670,
  MediaElementAudioSourceNode = 8683,
  MediaEncryptedEvent = 8711,
  MediaError = 8731,
  MediaKeyError = 8742,
  MediaKeyMessageEvent = 8756,
  MediaKeySession = 8777,
  MediaKeyStatusMap = 8793,
  MediaKeyStatusMap_Iterator = 8811,
  MediaKeySystemAccess = 8838,
  MediaKeys = 8859,
  MediaList = 8869,
  MediaMetadata = 8879,
  MediaQueryList = 8893,
  MediaQueryListEvent = 8908,
  MediaRecorder = 8928,
  MediaRecorderErrorEvent = 8942,
  MediaSession = 8966,
  MediaSource = 8979,
  MediaStream = 8991,
  MediaStreamAudioDestinationNode = 9003,
  MediaStreamAudioSourceNode = 9035,
  MediaStreamError = 9062,
  MediaStreamEvent = 9079,
  MediaStreamTrack = 9096,
  MediaStreamTrackAudioSourceNode = 9113,
  MediaStreamTrackEvent = 9145,
  MerchantValidationEvent = 9167,
  MessageBroadcaster = 9191,
  MessageChannel = 9210,
  MessageEvent = 9225,
  MessageListenerManager = 9238,
  MessagePort = 9261,
  MessageSender = 9273,
  MimeType = 9287,
  MimeTypeArray = 9296,
  MouseEvent = 9310,
  MouseScrollEvent = 9321,
  MozCanvasPrintState = 9338,
  MozDocumentMatcher = 9358,
  MozDocumentObserver = 9377,
  MozQueryInterface = 9397,
  MozSharedMap = 9415,
  MozSharedMap_Iterator = 9428,
  MozSharedMapChangeEvent = 9450,
  MozStorageAsyncStatementParams = 9474,
  MozStorageStatementParams = 9505,
  MozStorageStatementRow = 9531,
  MozWritableSharedMap = 9554,
  MutationObserver = 9575,
  MutationRecord = 9592,
  NamedNodeMap = 9607,
  NavigateEvent = 9620,
  Navigation = 9634,
  NavigationActivation = 9645,
  NavigationCurrentEntryChangeEvent = 9666,
  NavigationDestination = 9700,
  NavigationHistoryEntry = 9722,
  NavigationPrecommitController = 9745,
  NavigationPreloadManager = 9775,
  NavigationTransition = 9800,
  Navigator = 9821,
  NavigatorLogin = 9831,
  NetworkInformation = 9846,
  Node = 9865,
  NodeFilter = 9870,
  NodeIterator = 9881,
  NodeList = 9894,
  Notification = 9903,
  NotificationEvent = 9916,
  NotifyPaintEvent = 9934,
  OES_draw_buffers_indexed = 9951,
  OES_element_index_uint = 9976,
  OES_fbo_render_mipmap = 9999,
  OES_standard_derivatives = 10021,
  OES_texture_float = 10046,
  OES_texture_float_linear = 10064,
  OES_texture_half_float = 10089,
  OES_texture_half_float_linear = 10112,
  OES_vertex_array_object = 10142,
  OVR_multiview2 = 10166,
  OfflineAudioCompletionEvent = 10181,
  OfflineAudioContext = 10209,
  OffscreenCanvas = 10229,
  OffscreenCanvasRenderingContext2D = 10245,
  OnlyForUseInConstructor = 10279,
  Option = 10303,
  OscillatorNode = 10310,
  PageTransitionEvent = 10325,
  PaintRequest = 10345,
  PaintRequestList = 10358,
  PaintWorkletGlobalScope = 10375,
  PannerNode = 10399,
  ParentProcessMessageManager = 10410,
  Path2D = 10438,
  PathUtils = 10445,
  PaymentAddress = 10455,
  PaymentMethodChangeEvent = 10470,
  PaymentRequest = 10495,
  PaymentRequestUpdateEvent = 10510,
  PaymentResponse = 10536,
  PeerConnectionImpl = 10552,
  PeerConnectionObserver = 10571,
  Performance = 10594,
  PerformanceEntry = 10606,
  PerformanceEntryEvent = 10623,
  PerformanceEventTiming = 10645,
  PerformanceMark = 10668,
  PerformanceMeasure = 10684,
  PerformanceNavigation = 10703,
  PerformanceNavigationTiming = 10725,
  PerformanceObserver = 10753,
  PerformanceObserverEntryList = 10773,
  PerformancePaintTiming = 10802,
  PerformanceResourceTiming = 10825,
  PerformanceServerTiming = 10851,
  PerformanceTiming = 10875,
  PeriodicWave = 10893,
  PermissionStatus = 10906,
  Permissions = 10923,
  PlacesBookmark = 10935,
  PlacesBookmarkAddition = 10950,
  PlacesBookmarkChanged = 10973,
  PlacesBookmarkGuid = 10995,
  PlacesBookmarkKeyword = 11014,
  PlacesBookmarkMoved = 11036,
  PlacesBookmarkRemoved = 11056,
  PlacesBookmarkTags = 11078,
  PlacesBookmarkTime = 11097,
  PlacesBookmarkTitle = 11116,
  PlacesBookmarkUrl = 11136,
  PlacesEvent = 11154,
  PlacesEventCounts = 11166,
  PlacesFavicon = 11184,
  PlacesHistoryCleared = 11198,
  PlacesObservers = 11219,
  PlacesPurgeCaches = 11235,
  PlacesRanking = 11253,
  PlacesVisit = 11267,
  PlacesVisitRemoved = 11279,
  PlacesVisitTitle = 11298,
  PlacesWeakCallbackWrapper = 11315,
  Plugin = 11341,
  PluginArray = 11348,
  PluginCrashedEvent = 11360,
  PointerEvent = 11379,
  PopStateEvent = 11392,
  PopupBlockedEvent = 11406,
  PopupPositionedEvent = 11424,
  PositionStateEvent = 11445,
  PrecompiledScript = 11464,
  PrivateAttribution = 11482,
  ProcessMessageManager = 11501,
  ProcessingInstruction = 11523,
  ProgressEvent = 11545,
  PromiseDebugging = 11559,
  PromiseNativeHandler = 11576,
  PromiseRejectionEvent = 11597,
  PublicKeyCredential = 11619,
  PushEvent = 11639,
  PushManager = 11649,
  PushManagerImpl = 11661,
  PushMessageData = 11677,
  PushSubscription = 11693,
  PushSubscriptionChangeEvent = 11710,
  PushSubscriptionOptions = 11738,
  RTCCertificate = 11762,
  RTCDTMFSender = 11777,
  RTCDTMFToneChangeEvent = 11791,
  RTCDataChannel = 11814,
  RTCDataChannelEvent = 11829,
  RTCDtlsTransport = 11849,
  RTCEncodedAudioFrame = 11866,
  RTCEncodedVideoFrame = 11887,
  RTCIceCandidate = 11908,
  RTCIceTransport = 11924,
  RTCIdentityProviderRegistrar = 11940,
  RTCPeerConnection = 11969,
  RTCPeerConnectionIceEvent = 11987,
  RTCPeerConnectionStatic = 12013,
  RTCRtpReceiver = 12037,
  RTCRtpScriptTransform = 12052,
  RTCRtpScriptTransformer = 12074,
  RTCRtpSender = 12098,
  RTCRtpTransceiver = 12111,
  RTCSctpTransport = 12129,
  RTCSessionDescription = 12146,
  RTCStatsReport = 12168,
  RTCTrackEvent = 12183,
  RTCTransformEvent = 12197,
  RadioNodeList = 12215,
  Range = 12229,
  ReadableByteStreamController = 12235,
  ReadableStream = 12264,
  ReadableStream_AsyncIterator = 12279,
  ReadableStreamBYOBReader = 12308,
  ReadableStreamBYOBRequest = 12333,
  ReadableStreamDefaultController = 12359,
  ReadableStreamDefaultReader = 12391,
  RedirectBlockedEvent = 12419,
  Report = 12440,
  ReportBody = 12447,
  ReportingObserver = 12458,
  Request = 12476,
  ResizeObserver = 12484,
  ResizeObserverEntry = 12499,
  ResizeObserverSize = 12519,
  Response = 12538,
  SVGAElement = 12547,
  SVGAngle = 12559,
  SVGAnimateElement = 12568,
  SVGAnimateMotionElement = 12586,
  SVGAnimateTransformElement = 12610,
  SVGAnimatedAngle = 12637,
  SVGAnimatedBoolean = 12654,
  SVGAnimatedEnumeration = 12673,
  SVGAnimatedInteger = 12696,
  SVGAnimatedLength = 12715,
  SVGAnimatedLengthList = 12733,
  SVGAnimatedNumber = 12755,
  SVGAnimatedNumberList = 12773,
  SVGAnimatedPreserveAspectRatio = 12795,
  SVGAnimatedRect = 12826,
  SVGAnimatedString = 12842,
  SVGAnimatedTransformList = 12860,
  SVGAnimationElement = 12885,
  SVGCircleElement = 12905,
  SVGClipPathElement = 12922,
  SVGComponentTransferFunctionElement = 12941,
  SVGDefsElement = 12977,
  SVGDescElement = 12992,
  SVGElement = 13007,
  SVGEllipseElement = 13018,
  SVGFEBlendElement = 13036,
  SVGFEColorMatrixElement = 13054,
  SVGFEComponentTransferElement = 13078,
  SVGFECompositeElement = 13108,
  SVGFEConvolveMatrixElement = 13130,
  SVGFEDiffuseLightingElement = 13157,
  SVGFEDisplacementMapElement = 13185,
  SVGFEDistantLightElement = 13213,
  SVGFEDropShadowElement = 13238,
  SVGFEFloodElement = 13261,
  SVGFEFuncAElement = 13279,
  SVGFEFuncBElement = 13297,
  SVGFEFuncGElement = 13315,
  SVGFEFuncRElement = 13333,
  SVGFEGaussianBlurElement = 13351,
  SVGFEImageElement = 13376,
  SVGFEMergeElement = 13394,
  SVGFEMergeNodeElement = 13412,
  SVGFEMorphologyElement = 13434,
  SVGFEOffsetElement = 13457,
  SVGFEPointLightElement = 13476,
  SVGFESpecularLightingElement = 13499,
  SVGFESpotLightElement = 13528,
  SVGFETileElement = 13550,
  SVGFETurbulenceElement = 13567,
  SVGFilterElement = 13590,
  SVGForeignObjectElement = 13607,
  SVGGElement = 13631,
  SVGGeometryElement = 13643,
  SVGGradientElement = 13662,
  SVGGraphicsElement = 13681,
  SVGImageElement = 13700,
  SVGLength = 13716,
  SVGLengthList = 13726,
  SVGLineElement = 13740,
  SVGLinearGradientElement = 13755,
  SVGMPathElement = 13780,
  SVGMarkerElement = 13796,
  SVGMaskElement = 13813,
  SVGMatrix = 13828,
  SVGMetadataElement = 13838,
  SVGNumber = 13857,
  SVGNumberList = 13867,
  SVGPathElement = 13881,
  SVGPathSegment = 13896,
  SVGPatternElement = 13911,
  SVGPoint = 13929,
  SVGPointList = 13938,
  SVGPolygonElement = 13951,
  SVGPolylineElement = 13969,
  SVGPreserveAspectRatio = 13988,
  SVGRadialGradientElement = 14011,
  SVGRect = 14036,
  SVGRectElement = 14044,
  SVGSVGElement = 14059,
  SVGScriptElement = 14073,
  SVGSetElement = 14090,
  SVGStopElement = 14104,
  SVGStringList = 14119,
  SVGStyleElement = 14133,
  SVGSwitchElement = 14149,
  SVGSymbolElement = 14166,
  SVGTSpanElement = 14183,
  SVGTextContentElement = 14199,
  SVGTextElement = 14221,
  SVGTextPathElement = 14236,
  SVGTextPositioningElement = 14255,
  SVGTitleElement = 14281,
  SVGTransform = 14297,
  SVGTransformList = 14310,
  SVGUnitTypes = 14327,
  SVGUseElement = 14340,
  SVGViewElement = 14354,
  Sanitizer = 14369,
  Scheduler = 14379,
  Screen = 14389,
  ScreenLuminance = 14396,
  ScreenOrientation = 14412,
  ScriptProcessorNode = 14430,
  ScrollAreaEvent = 14450,
  SecurityPolicyViolationEvent = 14466,
  Selection = 14495,
  ServiceWorker = 14505,
  ServiceWorkerContainer = 14519,
  ServiceWorkerGlobalScope = 14542,
  ServiceWorkerRegistration = 14567,
  SessionStoreFormData = 14593,
  SessionStoreScrollData = 14614,
  SessionStoreUtils = 14637,
  ShadowRealmGlobalScope = 14655,
  ShadowRoot = 14678,
  SharedWorker = 14689,
  SharedWorkerGlobalScope = 14702,
  SimpleGestureEvent = 14726,
  SourceBuffer = 14745,
  SourceBufferList = 14758,
  SpeechGrammar = 14775,
  SpeechGrammarList = 14789,
  SpeechRecognition = 14807,
  SpeechRecognitionAlternative = 14825,
  SpeechRecognitionError = 14854,
  SpeechRecognitionEvent = 14877,
  SpeechRecognitionResult = 14900,
  SpeechRecognitionResultList = 14924,
  SpeechSynthesis = 14952,
  SpeechSynthesisErrorEvent = 14968,
  SpeechSynthesisEvent = 14994,
  SpeechSynthesisUtterance = 15015,
  SpeechSynthesisVoice = 15040,
  StaticRange = 15061,
  StereoPannerNode = 15073,
  Storage = 15090,
  StorageEvent = 15098,
  StorageManager = 15111,
  StreamFilter = 15126,
  StreamFilterDataEvent = 15139,
  StructuredCloneHolder = 15161,
  StructuredCloneTester = 15183,
  StylePropertyMap = 15205,
  StylePropertyMapReadOnly = 15222,
  StylePropertyMapReadOnly_Iterator = 15247,
  StyleSheet = 15281,
  StyleSheetApplicableStateChangeEvent = 15292,
  StyleSheetList = 15329,
  StyleSheetRemovedEvent = 15344,
  SubmitEvent = 15367,
  SubtleCrypto = 15379,
  SyncMessageSender = 15392,
  SyncReadFile = 15410,
  TCPServerSocket = 15423,
  TCPServerSocketEvent = 15439,
  TCPSocket = 15460,
  TCPSocketErrorEvent = 15470,
  TCPSocketEvent = 15490,
  TaskController = 15505,
  TaskPriorityChangeEvent = 15520,
  TaskSignal = 15544,
  Tensor = 15555,
  TestAttributesOnTypes = 15562,
  TestCEReactionsInterface = 15584,
  TestCImplementedInterface = 15609,
  TestCImplementedInterface2 = 15635,
  TestCallbackDictUnionOverload = 15662,
  TestChildInterface = 15692,
  TestConstructorForFuncInterface = 15711,
  TestConstructorForPrefInterface = 15743,
  TestConstructorForSCInterface = 15775,
  TestCppKeywordNamedMethodsInterface = 15805,
  TestDeprecatedInterface = 15841,
  TestExampleInterface = 15865,
  TestExampleProxyInterface = 15886,
  TestExampleThrowingConstructorInterface = 15912,
  TestExampleWorkerInterface = 15952,
  TestFuncConstructorForDifferentFuncInterface = 15979,
  TestFuncConstructorForInterface = 16024,
  TestHTMLConstructorInterface = 16056,
  TestIndexedAndNamedGetterAndSetterInterface = 16085,
  TestIndexedAndNamedGetterInterface = 16129,
  TestIndexedAndNamedSetterInterface = 16164,
  TestIndexedGetterAndSetterAndNamedGetterInterface = 16199,
  TestIndexedGetterInterface = 16249,
  TestIndexedSetterInterface = 16276,
  TestInterface = 16303,
  TestInterfaceWithPromiseConstructorArg = 16317,
  TestJSImplInterface = 16356,
  TestJSImplInterface2 = 16376,
  TestJSImplInterface3 = 16397,
  TestJSImplInterface4 = 16418,
  TestJSImplInterface5 = 16439,
  TestJSImplInterface6 = 16460,
  TestJSImplNoInterfaceObject = 16481,
  TestLegacyFactoryFunctionInterface = 16509,
  TestLegacyFactoryFunctionInterface2 = 16544,
  TestNamedDeleterInterface = 16580,
  TestNamedDeleterWithRetvalInterface = 16606,
  TestNamedGetterInterface = 16642,
  TestNamedSetterInterface = 16667,
  TestNamespace = 16692,
  TestNonWrapperCacheInterface = 16706,
  TestParentInterface = 16735,
  TestPrefChromeOnlySCFuncConstructorForInterface = 16755,
  TestPrefConstructorForDifferentPrefInterface = 16803,
  TestPrefConstructorForInterface = 16848,
  TestProtoObjectHackedNamespace = 16880,
  TestRenamedInterface = 16911,
  TestRenamedNamespace = 16932,
  TestSCConstructorForInterface = 16953,
  TestSecureContextInterface = 16983,
  TestThrowingConstructorInterface = 17010,
  TestUtils = 17043,
  TestWorkerExposedInterface = 17053,
  TestingDeprecatedInterface = 17080,
  Text = 17107,
  TextClause = 17112,
  TextDecoder = 17123,
  TextDecoderStream = 17135,
  TextEncoder = 17153,
  TextEncoderStream = 17165,
  TextEvent = 17183,
  TextMetrics = 17193,
  TextTrack = 17205,
  TextTrackCue = 17215,
  TextTrackCueList = 17228,
  TextTrackList = 17245,
  TimeEvent = 17259,
  TimeRanges = 17269,
  ToggleEvent = 17280,
  Touch = 17292,
  TouchEvent = 17298,
  TouchList = 17309,
  TrackEvent = 17319,
  TransformStream = 17330,
  TransformStreamDefaultController = 17346,
  TransitionEvent = 17379,
  TreeColumn = 17395,
  TreeColumns = 17406,
  TreeContentView = 17418,
  TreeWalker = 17434,
  TrustedHTML = 17445,
  TrustedScript = 17457,
  TrustedScriptURL = 17471,
  TrustedTypePolicy = 17488,
  TrustedTypePolicyFactory = 17506,
  UDPMessageEvent = 17531,
  UDPSocket = 17547,
  UIEvent = 17557,
  URL = 17565,
  URLPattern = 17569,
  URLSearchParams = 17580,
  URLSearchParams_Iterator = 17596,
  UniFFIPointer = 17621,
  UniFFIScaffolding = 17635,
  UserActivation = 17653,
  UserInteraction = 17668,
  UserProximityEvent = 17684,
  VRDisplay = 17703,
  VRDisplayCapabilities = 17713,
  VRDisplayEvent = 17735,
  VREyeParameters = 17750,
  VRFieldOfView = 17766,
  VRFrameData = 17780,
  VRMockController = 17792,
  VRMockDisplay = 17809,
  VRPose = 17823,
  VRServiceTest = 17830,
  VRStageParameters = 17844,
  VTTCue = 17862,
  VTTRegion = 17869,
  ValidityState = 17879,
  VideoColorSpace = 17893,
  VideoDecoder = 17909,
  VideoEncoder = 17922,
  VideoFrame = 17935,
  VideoPlaybackQuality = 17946,
  VideoTrack = 17967,
  VideoTrackList = 17978,
  ViewTransition = 17993,
  VisualViewport = 18008,
  WEBGL_color_buffer_float = 18023,
  WEBGL_compressed_texture_astc = 18048,
  WEBGL_compressed_texture_etc = 18078,
  WEBGL_compressed_texture_etc1 = 18107,
  WEBGL_compressed_texture_pvrtc = 18137,
  WEBGL_compressed_texture_s3tc = 18168,
  WEBGL_compressed_texture_s3tc_srgb = 18198,
  WEBGL_debug_renderer_info = 18233,
  WEBGL_debug_shaders = 18259,
  WEBGL_depth_texture = 18279,
  WEBGL_draw_buffers = 18299,
  WEBGL_explicit_present = 18318,
  WEBGL_lose_context = 18341,
  WEBGL_provoking_vertex = 18360,
  WGSLLanguageFeatures = 18383,
  WakeLock = 18404,
  WakeLockSentinel = 18413,
  WaveShaperNode = 18430,
  WebExtensionContentScript = 18445,
  WebExtensionPolicy = 18471,
  WebGL2RenderingContext = 18490,
  WebGLActiveInfo = 18513,
  WebGLBuffer = 18529,
  WebGLContextEvent = 18541,
  WebGLFramebuffer = 18559,
  WebGLProgram = 18576,
  WebGLQuery = 18589,
  WebGLRenderbuffer = 18600,
  WebGLRenderingContext = 18618,
  WebGLSampler = 18640,
  WebGLShader = 18653,
  WebGLShaderPrecisionFormat = 18665,
  WebGLSync = 18692,
  WebGLTexture = 18702,
  WebGLTransformFeedback = 18715,
  WebGLUniformLocation = 18738,
  WebGLVertexArrayObject = 18759,
  WebKitCSSMatrix = 18782,
  WebSocket = 18798,
  WebTransport = 18808,
  WebTransportBidirectionalStream = 18821,
  WebTransportDatagramDuplexStream = 18853,
  WebTransportError = 18886,
  WebTransportReceiveStream = 18904,
  WebTransportSendStream = 18930,
  WebrtcGlobalInformation = 18953,
  WheelEvent = 18977,
  Window = 18988,
  WindowClient = 18995,
  WindowContext = 19008,
  WindowGlobalChild = 19022,
  WindowGlobalParent = 19040,
  WindowRoot = 19059,
  Worker = 19070,
  WorkerDebuggerGlobalScope = 19077,
  WorkerGlobalScope = 19103,
  WorkerLocation = 19121,
  WorkerNavigator = 19136,
  WorkerTestUtils = 19152,
  Worklet = 19168,
  WorkletGlobalScope = 19176,
  WritableStream = 19195,
  WritableStreamDefaultController = 19210,
  WritableStreamDefaultWriter = 19242,
  XMLDocument = 19270,
  XMLHttpRequest = 19282,
  XMLHttpRequestEventTarget = 19297,
  XMLHttpRequestUpload = 19323,
  XMLSerializer = 19344,
  XPathEvaluator = 19358,
  XPathExpression = 19373,
  XPathResult = 19389,
  XRBoundedReferenceSpace = 19401,
  XRFrame = 19425,
  XRInputSource = 19433,
  XRInputSourceArray = 19447,
  XRInputSourceEvent = 19466,
  XRInputSourcesChangeEvent = 19485,
  XRPose = 19511,
  XRReferenceSpace = 19518,
  XRReferenceSpaceEvent = 19535,
  XRRenderState = 19557,
  XRRigidTransform = 19571,
  XRSession = 19588,
  XRSessionEvent = 19598,
  XRSpace = 19613,
  XRSystem = 19621,
  XRView = 19630,
  XRViewerPose = 19637,
  XRViewport = 19650,
  XRWebGLLayer = 19661,
  XSLTProcessor = 19674,
  XULCommandEvent = 19688,
  XULElement = 19704,
  XULFrameElement = 19715,
  XULMenuElement = 19731,
  XULPopupElement = 19746,
  XULResizerElement = 19762,
  XULTextElement = 19780,
  XULTreeElement = 19795,
  console = 19810,
  webkitSpeechGrammar = 19818,
  webkitSpeechGrammarList = 19838,
  webkitSpeechRecognition = 19862,
  webkitURL = 19886,
};

namespace binding_detail {
extern const char sBindingNames[];
}  // namespace binding_detail

MOZ_ALWAYS_INLINE const char* BindingName(BindingNamesOffset aOffset) {
  return binding_detail::sBindingNames + static_cast<size_t>(aOffset);
}

} // namespace mozilla::dom


#endif // DOM_BINDINGNAMES_H_
