/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim: set ts=8 sts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_dom_FileSystemRequestParent_h
#define mozilla_dom_FileSystemRequestParent_h

#include "mozilla/dom/FileSystemBase.h"
#include "mozilla/dom/PFileSystemRequestParent.h"

namespace mozilla::dom {

class FileSystemParams;
class FileSystemTaskParentBase;

class FileSystemRequestParent final : public PFileSystemRequestParent {
  NS_INLINE_DECL_THREADSAFE_REFCOUNTING(FileSystemRequestParent, final)

 public:
  FileSystemRequestParent();

  bool Initialize(const FileSystemParams& aParams);

  void Start();

  bool Destroyed() const { return mDestroyed; }

  virtual void ActorDestroy(ActorDestroyReason why) override;

 private:
  ~FileSystemRequestParent();

  RefPtr<FileSystemBase> mFileSystem;
  RefPtr<FileSystemTaskParentBase> mTask;

  bool mDestroyed;
};

}  // namespace mozilla::dom

#endif  // mozilla_dom_FileSystemRequestParent_h
