#ifndef DOM_UNIONTYPES_H_
#define DOM_UNIONTYPES_H_

#include "DOMParserBinding.h"
#include "js/RootingAPI.h"
#include "js/Value.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/Record.h"
#include "mozilla/dom/RootedRecord.h"
#include "mozilla/dom/TypedArray.h"
#include "mozilla/dom/UnionMember.h"

class nsGenericHTMLElement;
class nsINode;

namespace mozilla {
namespace dom {

class Blob;
class CanvasGradient;
class CanvasPattern;
class Directory;
class File;
class FormData;
class HTMLCanvasElement;
class HTMLOptGroupElement;
class HTMLOptionElement;
class OffscreenCanvas;
class OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String;
class OwningCanvasPatternOrCanvasGradient;
class OwningCanvasPatternOrNullOrCanvasGradient;
class OwningFileOrDirectory;
class OwningFileOrUSVStringOrFormData;
class OwningHTMLCanvasElementOrOffscreenCanvas;
class OwningHTMLElementOrLong;
class OwningHTMLOptionElementOrHTMLOptGroupElement;
class OwningNodeOrString;
class OwningTrustedHTMLOrNullIsEmptyString;
class OwningTrustedHTMLOrString;
class OwningTrustedScriptURLOrString;
class OwningTrustedScriptURLOrUSVString;
class OwningUndefinedOrCanvasPattern;
class OwningUndefinedOrCanvasPatternOrNull;
class OwningUndefinedOrNullOrCanvasPattern;
class TrustedHTML;
class TrustedScriptURL;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {
void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String& aUnion, const char* aName, uint32_t aFlags = 0);

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningCanvasPatternOrCanvasGradient& aUnion, const char* aName, uint32_t aFlags = 0);

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningCanvasPatternOrNullOrCanvasGradient& aUnion, const char* aName, uint32_t aFlags = 0);

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningFileOrDirectory& aUnion, const char* aName, uint32_t aFlags = 0);

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningFileOrUSVStringOrFormData& aUnion, const char* aName, uint32_t aFlags = 0);

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningHTMLCanvasElementOrOffscreenCanvas& aUnion, const char* aName, uint32_t aFlags = 0);

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningHTMLElementOrLong& aUnion, const char* aName, uint32_t aFlags = 0);

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningHTMLOptionElementOrHTMLOptGroupElement& aUnion, const char* aName, uint32_t aFlags = 0);

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningNodeOrString& aUnion, const char* aName, uint32_t aFlags = 0);

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningTrustedHTMLOrNullIsEmptyString& aUnion, const char* aName, uint32_t aFlags = 0);

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningTrustedHTMLOrString& aUnion, const char* aName, uint32_t aFlags = 0);

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningTrustedScriptURLOrString& aUnion, const char* aName, uint32_t aFlags = 0);

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningTrustedScriptURLOrUSVString& aUnion, const char* aName, uint32_t aFlags = 0);

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningUndefinedOrCanvasPattern& aUnion, const char* aName, uint32_t aFlags = 0);

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningUndefinedOrCanvasPatternOrNull& aUnion, const char* aName, uint32_t aFlags = 0);

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningUndefinedOrNullOrCanvasPattern& aUnion, const char* aName, uint32_t aFlags = 0);

void
ImplCycleCollectionUnlink(OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String& aUnion);

void
ImplCycleCollectionUnlink(OwningCanvasPatternOrCanvasGradient& aUnion);

void
ImplCycleCollectionUnlink(OwningCanvasPatternOrNullOrCanvasGradient& aUnion);

void
ImplCycleCollectionUnlink(OwningFileOrDirectory& aUnion);

void
ImplCycleCollectionUnlink(OwningFileOrUSVStringOrFormData& aUnion);

void
ImplCycleCollectionUnlink(OwningHTMLCanvasElementOrOffscreenCanvas& aUnion);

void
ImplCycleCollectionUnlink(OwningHTMLElementOrLong& aUnion);

void
ImplCycleCollectionUnlink(OwningHTMLOptionElementOrHTMLOptGroupElement& aUnion);

void
ImplCycleCollectionUnlink(OwningNodeOrString& aUnion);

void
ImplCycleCollectionUnlink(OwningTrustedHTMLOrNullIsEmptyString& aUnion);

void
ImplCycleCollectionUnlink(OwningTrustedHTMLOrString& aUnion);

void
ImplCycleCollectionUnlink(OwningTrustedScriptURLOrString& aUnion);

void
ImplCycleCollectionUnlink(OwningTrustedScriptURLOrUSVString& aUnion);

void
ImplCycleCollectionUnlink(OwningUndefinedOrCanvasPattern& aUnion);

void
ImplCycleCollectionUnlink(OwningUndefinedOrCanvasPatternOrNull& aUnion);

void
ImplCycleCollectionUnlink(OwningUndefinedOrNullOrCanvasPattern& aUnion);

class ArrayBufferViewOrArrayBuffer : public AllUnionBase,
                                     public UnionWithTypedArraysBase
{
public:
  using ApplyToTypedArrays = binding_detail::ApplyToTypedArraysHelper<ArrayBufferViewOrArrayBuffer, false, ArrayBufferView, ArrayBuffer>;

private:
  enum TypeOrUninit
  {
    eUninitialized,
    eArrayBufferView,
    eArrayBuffer
  };
public:
  enum class Type
  {
    eArrayBufferView = TypeOrUninit::eArrayBufferView,
    eArrayBuffer = TypeOrUninit::eArrayBuffer
  };

private:
  union Value
  {
    UnionMember<RootedSpiderMonkeyInterface<ArrayBufferView> > mArrayBufferView;
    UnionMember<RootedSpiderMonkeyInterface<ArrayBuffer> > mArrayBuffer;

  };

  TypeOrUninit mType;
  Value mValue;

  ArrayBufferViewOrArrayBuffer(const ArrayBufferViewOrArrayBuffer&) = delete;
  ArrayBufferViewOrArrayBuffer& operator=(const ArrayBufferViewOrArrayBuffer&) = delete;
public:
  explicit inline ArrayBufferViewOrArrayBuffer()
    : mType(eUninitialized)
  {
  }

  inline ~ArrayBufferViewOrArrayBuffer()
  {
    Uninit();
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBufferView>&
  RawSetAsArrayBufferView(JSContext* cx)
  {
    if (mType == eArrayBufferView) {
      return mValue.mArrayBufferView.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eArrayBufferView;
    return mValue.mArrayBufferView.SetValue(cx);
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBufferView>&
  SetAsArrayBufferView(JSContext* cx)
  {
    if (mType == eArrayBufferView) {
      return mValue.mArrayBufferView.Value();
    }
    Uninit();
    mType = eArrayBufferView;
    return mValue.mArrayBufferView.SetValue(cx);
  }

  inline bool
  IsArrayBufferView() const
  {
    return mType == eArrayBufferView;
  }

  inline RootedSpiderMonkeyInterface<ArrayBufferView>&
  GetAsArrayBufferView()
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  inline ArrayBufferView const &
  GetAsArrayBufferView() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  RawSetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  SetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    Uninit();
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  GetAsArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eArrayBufferView: {
        DestroyArrayBufferView();
        break;
      }
      case eArrayBuffer: {
        DestroyArrayBuffer();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToArrayBufferView(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBufferView(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyArrayBufferView()
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    mValue.mArrayBufferView.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToArrayBuffer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBuffer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    mValue.mArrayBuffer.Destroy();
    mType = eUninitialized;
  }
};

class ArrayBufferViewOrArrayBufferOrBlobOrUTF8String : public AllUnionBase,
                                                       public UnionWithTypedArraysBase
{
public:
  using ApplyToTypedArrays = binding_detail::ApplyToTypedArraysHelper<ArrayBufferViewOrArrayBufferOrBlobOrUTF8String, true, ArrayBufferView, ArrayBuffer>;

private:
  enum TypeOrUninit
  {
    eUninitialized,
    eArrayBufferView,
    eArrayBuffer,
    eBlob,
    eUTF8String
  };
public:
  enum class Type
  {
    eArrayBufferView = TypeOrUninit::eArrayBufferView,
    eArrayBuffer = TypeOrUninit::eArrayBuffer,
    eBlob = TypeOrUninit::eBlob,
    eUTF8String = TypeOrUninit::eUTF8String
  };

private:
  union Value
  {
    UnionMember<RootedSpiderMonkeyInterface<ArrayBufferView> > mArrayBufferView;
    UnionMember<RootedSpiderMonkeyInterface<ArrayBuffer> > mArrayBuffer;
    UnionMember<NonNull<mozilla::dom::Blob> > mBlob;
    UnionMember<binding_detail::FakeString<char> > mUTF8String;

  };

  TypeOrUninit mType;
  Value mValue;

  ArrayBufferViewOrArrayBufferOrBlobOrUTF8String(const ArrayBufferViewOrArrayBufferOrBlobOrUTF8String&) = delete;
  ArrayBufferViewOrArrayBufferOrBlobOrUTF8String& operator=(const ArrayBufferViewOrArrayBufferOrBlobOrUTF8String&) = delete;
public:
  explicit inline ArrayBufferViewOrArrayBufferOrBlobOrUTF8String()
    : mType(eUninitialized)
  {
  }

  inline ~ArrayBufferViewOrArrayBufferOrBlobOrUTF8String()
  {
    Uninit();
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBufferView>&
  RawSetAsArrayBufferView(JSContext* cx)
  {
    if (mType == eArrayBufferView) {
      return mValue.mArrayBufferView.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eArrayBufferView;
    return mValue.mArrayBufferView.SetValue(cx);
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBufferView>&
  SetAsArrayBufferView(JSContext* cx)
  {
    if (mType == eArrayBufferView) {
      return mValue.mArrayBufferView.Value();
    }
    Uninit();
    mType = eArrayBufferView;
    return mValue.mArrayBufferView.SetValue(cx);
  }

  inline bool
  IsArrayBufferView() const
  {
    return mType == eArrayBufferView;
  }

  inline RootedSpiderMonkeyInterface<ArrayBufferView>&
  GetAsArrayBufferView()
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  inline ArrayBufferView const &
  GetAsArrayBufferView() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  RawSetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  SetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    Uninit();
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  GetAsArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::Blob>&
  RawSetAsBlob()
  {
    if (mType == eBlob) {
      return mValue.mBlob.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eBlob;
    return mValue.mBlob.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::Blob>&
  SetAsBlob()
  {
    if (mType == eBlob) {
      return mValue.mBlob.Value();
    }
    Uninit();
    mType = eBlob;
    return mValue.mBlob.SetValue();
  }

  inline bool
  IsBlob() const
  {
    return mType == eBlob;
  }

  inline NonNull<mozilla::dom::Blob>&
  GetAsBlob()
  {
    MOZ_RELEASE_ASSERT(IsBlob(), "Wrong type!");
    return mValue.mBlob.Value();
  }

  inline mozilla::dom::Blob&
  GetAsBlob() const
  {
    MOZ_RELEASE_ASSERT(IsBlob(), "Wrong type!");
    return mValue.mBlob.Value();
  }

  [[nodiscard]] inline binding_detail::FakeString<char>&
  RawSetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char>&
  SetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    Uninit();
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline binding_detail::FakeString<char>&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline const nsACString&
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eArrayBufferView: {
        DestroyArrayBufferView();
        break;
      }
      case eArrayBuffer: {
        DestroyArrayBuffer();
        break;
      }
      case eBlob: {
        DestroyBlob();
        break;
      }
      case eUTF8String: {
        DestroyUTF8String();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToArrayBufferView(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBufferView(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyArrayBufferView()
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    mValue.mArrayBufferView.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToArrayBuffer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBuffer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    mValue.mArrayBuffer.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToBlob(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToBlob(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyBlob()
  {
    MOZ_RELEASE_ASSERT(IsBlob(), "Wrong type!");
    mValue.mBlob.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    mValue.mUTF8String.Destroy();
    mType = eUninitialized;
  }
};

class ArrayBufferViewOrArrayBufferOrNull : public AllUnionBase,
                                           public UnionWithTypedArraysBase
{
public:
  using ApplyToTypedArrays = binding_detail::ApplyToTypedArraysHelper<ArrayBufferViewOrArrayBufferOrNull, true, ArrayBufferView, ArrayBuffer>;

private:
  enum TypeOrUninit
  {
    eUninitialized,
    eNull,
    eArrayBufferView,
    eArrayBuffer
  };
public:
  enum class Type
  {
    eNull = TypeOrUninit::eNull,
    eArrayBufferView = TypeOrUninit::eArrayBufferView,
    eArrayBuffer = TypeOrUninit::eArrayBuffer
  };

private:
  union Value
  {
    UnionMember<RootedSpiderMonkeyInterface<ArrayBufferView> > mArrayBufferView;
    UnionMember<RootedSpiderMonkeyInterface<ArrayBuffer> > mArrayBuffer;

  };

  TypeOrUninit mType;
  Value mValue;

  ArrayBufferViewOrArrayBufferOrNull(const ArrayBufferViewOrArrayBufferOrNull&) = delete;
  ArrayBufferViewOrArrayBufferOrNull& operator=(const ArrayBufferViewOrArrayBufferOrNull&) = delete;
public:
  explicit inline ArrayBufferViewOrArrayBufferOrNull()
    : mType(eUninitialized)
  {
  }

  inline ~ArrayBufferViewOrArrayBufferOrNull()
  {
    Uninit();
  }

  inline bool
  IsNull() const
  {
    return mType == eNull;
  }

  inline void
  SetNull()
  {
    Uninit();
    mType = eNull;
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBufferView>&
  RawSetAsArrayBufferView(JSContext* cx)
  {
    if (mType == eArrayBufferView) {
      return mValue.mArrayBufferView.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eArrayBufferView;
    return mValue.mArrayBufferView.SetValue(cx);
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBufferView>&
  SetAsArrayBufferView(JSContext* cx)
  {
    if (mType == eArrayBufferView) {
      return mValue.mArrayBufferView.Value();
    }
    Uninit();
    mType = eArrayBufferView;
    return mValue.mArrayBufferView.SetValue(cx);
  }

  inline bool
  IsArrayBufferView() const
  {
    return mType == eArrayBufferView;
  }

  inline RootedSpiderMonkeyInterface<ArrayBufferView>&
  GetAsArrayBufferView()
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  inline ArrayBufferView const &
  GetAsArrayBufferView() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  RawSetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  SetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    Uninit();
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  GetAsArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eNull: {
        break;
      }
      case eArrayBufferView: {
        DestroyArrayBufferView();
        break;
      }
      case eArrayBuffer: {
        DestroyArrayBuffer();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToArrayBufferView(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBufferView(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyArrayBufferView()
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    mValue.mArrayBufferView.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToArrayBuffer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBuffer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    mValue.mArrayBuffer.Destroy();
    mType = eUninitialized;
  }
};

class ByteStringOrLong : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eByteString,
    eLong
  };
public:
  enum class Type
  {
    eByteString = TypeOrUninit::eByteString,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<nsCString > mByteString;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

  ByteStringOrLong(const ByteStringOrLong&) = delete;
  ByteStringOrLong& operator=(const ByteStringOrLong&) = delete;
public:
  explicit inline ByteStringOrLong()
    : mType(eUninitialized)
  {
  }

  inline ~ByteStringOrLong()
  {
    Uninit();
  }

  [[nodiscard]] inline nsCString&
  RawSetAsByteString()
  {
    if (mType == eByteString) {
      return mValue.mByteString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eByteString;
    return mValue.mByteString.SetValue();
  }

  [[nodiscard]] inline nsCString&
  SetAsByteString()
  {
    if (mType == eByteString) {
      return mValue.mByteString.Value();
    }
    Uninit();
    mType = eByteString;
    return mValue.mByteString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsByteString().AssignLiteral(aData);
  }

  inline bool
  IsByteString() const
  {
    return mType == eByteString;
  }

  inline nsCString&
  GetAsByteString()
  {
    MOZ_RELEASE_ASSERT(IsByteString(), "Wrong type!");
    return mValue.mByteString.Value();
  }

  inline const nsCString&
  GetAsByteString() const
  {
    MOZ_RELEASE_ASSERT(IsByteString(), "Wrong type!");
    return mValue.mByteString.Value();
  }

  [[nodiscard]] inline int32_t&
  RawSetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  [[nodiscard]] inline int32_t&
  SetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    Uninit();
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eByteString: {
        DestroyByteString();
        break;
      }
      case eLong: {
        DestroyLong();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToByteString(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToByteString(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyByteString()
  {
    MOZ_RELEASE_ASSERT(IsByteString(), "Wrong type!");
    mValue.mByteString.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    mValue.mLong.Destroy();
    mType = eUninitialized;
  }
};

class CanvasPatternOrCanvasGradient : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eCanvasPattern,
    eCanvasGradient
  };
public:
  enum class Type
  {
    eCanvasPattern = TypeOrUninit::eCanvasPattern,
    eCanvasGradient = TypeOrUninit::eCanvasGradient
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::CanvasPattern> > mCanvasPattern;
    UnionMember<NonNull<mozilla::dom::CanvasGradient> > mCanvasGradient;

  };

  TypeOrUninit mType;
  Value mValue;

  CanvasPatternOrCanvasGradient(const CanvasPatternOrCanvasGradient&) = delete;
  CanvasPatternOrCanvasGradient& operator=(const CanvasPatternOrCanvasGradient&) = delete;
public:
  explicit inline CanvasPatternOrCanvasGradient()
    : mType(eUninitialized)
  {
  }

  inline ~CanvasPatternOrCanvasGradient()
  {
    Uninit();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::CanvasPattern>&
  RawSetAsCanvasPattern()
  {
    if (mType == eCanvasPattern) {
      return mValue.mCanvasPattern.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eCanvasPattern;
    return mValue.mCanvasPattern.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::CanvasPattern>&
  SetAsCanvasPattern()
  {
    if (mType == eCanvasPattern) {
      return mValue.mCanvasPattern.Value();
    }
    Uninit();
    mType = eCanvasPattern;
    return mValue.mCanvasPattern.SetValue();
  }

  inline bool
  IsCanvasPattern() const
  {
    return mType == eCanvasPattern;
  }

  inline NonNull<mozilla::dom::CanvasPattern>&
  GetAsCanvasPattern()
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    return mValue.mCanvasPattern.Value();
  }

  inline mozilla::dom::CanvasPattern&
  GetAsCanvasPattern() const
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    return mValue.mCanvasPattern.Value();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::CanvasGradient>&
  RawSetAsCanvasGradient()
  {
    if (mType == eCanvasGradient) {
      return mValue.mCanvasGradient.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eCanvasGradient;
    return mValue.mCanvasGradient.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::CanvasGradient>&
  SetAsCanvasGradient()
  {
    if (mType == eCanvasGradient) {
      return mValue.mCanvasGradient.Value();
    }
    Uninit();
    mType = eCanvasGradient;
    return mValue.mCanvasGradient.SetValue();
  }

  inline bool
  IsCanvasGradient() const
  {
    return mType == eCanvasGradient;
  }

  inline NonNull<mozilla::dom::CanvasGradient>&
  GetAsCanvasGradient()
  {
    MOZ_RELEASE_ASSERT(IsCanvasGradient(), "Wrong type!");
    return mValue.mCanvasGradient.Value();
  }

  inline mozilla::dom::CanvasGradient&
  GetAsCanvasGradient() const
  {
    MOZ_RELEASE_ASSERT(IsCanvasGradient(), "Wrong type!");
    return mValue.mCanvasGradient.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eCanvasPattern: {
        DestroyCanvasPattern();
        break;
      }
      case eCanvasGradient: {
        DestroyCanvasGradient();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToCanvasPattern(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCanvasPattern(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyCanvasPattern()
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    mValue.mCanvasPattern.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToCanvasGradient(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCanvasGradient(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyCanvasGradient()
  {
    MOZ_RELEASE_ASSERT(IsCanvasGradient(), "Wrong type!");
    mValue.mCanvasGradient.Destroy();
    mType = eUninitialized;
  }
};

class CanvasPatternOrNullOrCanvasGradient : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eNull,
    eCanvasPattern,
    eCanvasGradient
  };
public:
  enum class Type
  {
    eNull = TypeOrUninit::eNull,
    eCanvasPattern = TypeOrUninit::eCanvasPattern,
    eCanvasGradient = TypeOrUninit::eCanvasGradient
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::CanvasPattern> > mCanvasPattern;
    UnionMember<NonNull<mozilla::dom::CanvasGradient> > mCanvasGradient;

  };

  TypeOrUninit mType;
  Value mValue;

  CanvasPatternOrNullOrCanvasGradient(const CanvasPatternOrNullOrCanvasGradient&) = delete;
  CanvasPatternOrNullOrCanvasGradient& operator=(const CanvasPatternOrNullOrCanvasGradient&) = delete;
public:
  explicit inline CanvasPatternOrNullOrCanvasGradient()
    : mType(eUninitialized)
  {
  }

  inline ~CanvasPatternOrNullOrCanvasGradient()
  {
    Uninit();
  }

  inline bool
  IsNull() const
  {
    return mType == eNull;
  }

  inline void
  SetNull()
  {
    Uninit();
    mType = eNull;
  }

  [[nodiscard]] inline NonNull<mozilla::dom::CanvasPattern>&
  RawSetAsCanvasPattern()
  {
    if (mType == eCanvasPattern) {
      return mValue.mCanvasPattern.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eCanvasPattern;
    return mValue.mCanvasPattern.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::CanvasPattern>&
  SetAsCanvasPattern()
  {
    if (mType == eCanvasPattern) {
      return mValue.mCanvasPattern.Value();
    }
    Uninit();
    mType = eCanvasPattern;
    return mValue.mCanvasPattern.SetValue();
  }

  inline bool
  IsCanvasPattern() const
  {
    return mType == eCanvasPattern;
  }

  inline NonNull<mozilla::dom::CanvasPattern>&
  GetAsCanvasPattern()
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    return mValue.mCanvasPattern.Value();
  }

  inline mozilla::dom::CanvasPattern&
  GetAsCanvasPattern() const
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    return mValue.mCanvasPattern.Value();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::CanvasGradient>&
  RawSetAsCanvasGradient()
  {
    if (mType == eCanvasGradient) {
      return mValue.mCanvasGradient.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eCanvasGradient;
    return mValue.mCanvasGradient.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::CanvasGradient>&
  SetAsCanvasGradient()
  {
    if (mType == eCanvasGradient) {
      return mValue.mCanvasGradient.Value();
    }
    Uninit();
    mType = eCanvasGradient;
    return mValue.mCanvasGradient.SetValue();
  }

  inline bool
  IsCanvasGradient() const
  {
    return mType == eCanvasGradient;
  }

  inline NonNull<mozilla::dom::CanvasGradient>&
  GetAsCanvasGradient()
  {
    MOZ_RELEASE_ASSERT(IsCanvasGradient(), "Wrong type!");
    return mValue.mCanvasGradient.Value();
  }

  inline mozilla::dom::CanvasGradient&
  GetAsCanvasGradient() const
  {
    MOZ_RELEASE_ASSERT(IsCanvasGradient(), "Wrong type!");
    return mValue.mCanvasGradient.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eNull: {
        break;
      }
      case eCanvasPattern: {
        DestroyCanvasPattern();
        break;
      }
      case eCanvasGradient: {
        DestroyCanvasGradient();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToCanvasPattern(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCanvasPattern(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyCanvasPattern()
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    mValue.mCanvasPattern.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToCanvasGradient(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCanvasGradient(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyCanvasGradient()
  {
    MOZ_RELEASE_ASSERT(IsCanvasGradient(), "Wrong type!");
    mValue.mCanvasGradient.Destroy();
    mType = eUninitialized;
  }
};

class DoubleOrByteString : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eDouble,
    eByteString
  };
public:
  enum class Type
  {
    eDouble = TypeOrUninit::eDouble,
    eByteString = TypeOrUninit::eByteString
  };

private:
  union Value
  {
    UnionMember<double > mDouble;
    UnionMember<nsCString > mByteString;

  };

  TypeOrUninit mType;
  Value mValue;

  DoubleOrByteString(const DoubleOrByteString&) = delete;
  DoubleOrByteString& operator=(const DoubleOrByteString&) = delete;
public:
  explicit inline DoubleOrByteString()
    : mType(eUninitialized)
  {
  }

  inline ~DoubleOrByteString()
  {
    Uninit();
  }

  [[nodiscard]] inline double&
  RawSetAsDouble()
  {
    if (mType == eDouble) {
      return mValue.mDouble.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eDouble;
    return mValue.mDouble.SetValue();
  }

  [[nodiscard]] inline double&
  SetAsDouble()
  {
    if (mType == eDouble) {
      return mValue.mDouble.Value();
    }
    Uninit();
    mType = eDouble;
    return mValue.mDouble.SetValue();
  }

  inline bool
  IsDouble() const
  {
    return mType == eDouble;
  }

  inline double&
  GetAsDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  inline double
  GetAsDouble() const
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  [[nodiscard]] inline nsCString&
  RawSetAsByteString()
  {
    if (mType == eByteString) {
      return mValue.mByteString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eByteString;
    return mValue.mByteString.SetValue();
  }

  [[nodiscard]] inline nsCString&
  SetAsByteString()
  {
    if (mType == eByteString) {
      return mValue.mByteString.Value();
    }
    Uninit();
    mType = eByteString;
    return mValue.mByteString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsByteString().AssignLiteral(aData);
  }

  inline bool
  IsByteString() const
  {
    return mType == eByteString;
  }

  inline nsCString&
  GetAsByteString()
  {
    MOZ_RELEASE_ASSERT(IsByteString(), "Wrong type!");
    return mValue.mByteString.Value();
  }

  inline const nsCString&
  GetAsByteString() const
  {
    MOZ_RELEASE_ASSERT(IsByteString(), "Wrong type!");
    return mValue.mByteString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eDouble: {
        DestroyDouble();
        break;
      }
      case eByteString: {
        DestroyByteString();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToDouble(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDouble(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    mValue.mDouble.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToByteString(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToByteString(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyByteString()
  {
    MOZ_RELEASE_ASSERT(IsByteString(), "Wrong type!");
    mValue.mByteString.Destroy();
    mType = eUninitialized;
  }
};

class DoubleOrString : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eDouble,
    eString
  };
public:
  enum class Type
  {
    eDouble = TypeOrUninit::eDouble,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<double > mDouble;
    UnionMember<binding_detail::FakeString<char16_t> > mString;

  };

  TypeOrUninit mType;
  Value mValue;

  DoubleOrString(const DoubleOrString&) = delete;
  DoubleOrString& operator=(const DoubleOrString&) = delete;
public:
  explicit inline DoubleOrString()
    : mType(eUninitialized)
  {
  }

  inline ~DoubleOrString()
  {
    Uninit();
  }

  [[nodiscard]] inline double&
  RawSetAsDouble()
  {
    if (mType == eDouble) {
      return mValue.mDouble.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eDouble;
    return mValue.mDouble.SetValue();
  }

  [[nodiscard]] inline double&
  SetAsDouble()
  {
    if (mType == eDouble) {
      return mValue.mDouble.Value();
    }
    Uninit();
    mType = eDouble;
    return mValue.mDouble.SetValue();
  }

  inline bool
  IsDouble() const
  {
    return mType == eDouble;
  }

  inline double&
  GetAsDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  inline double
  GetAsDouble() const
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eDouble: {
        DestroyDouble();
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToDouble(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDouble(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    mValue.mDouble.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }
};

class DoubleOrSupportedType : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eDouble,
    eSupportedType
  };
public:
  enum class Type
  {
    eDouble = TypeOrUninit::eDouble,
    eSupportedType = TypeOrUninit::eSupportedType
  };

private:
  union Value
  {
    UnionMember<double > mDouble;
    UnionMember<SupportedType > mSupportedType;

  };

  TypeOrUninit mType;
  Value mValue;

  DoubleOrSupportedType(const DoubleOrSupportedType&) = delete;
  DoubleOrSupportedType& operator=(const DoubleOrSupportedType&) = delete;
public:
  explicit inline DoubleOrSupportedType()
    : mType(eUninitialized)
  {
  }

  inline ~DoubleOrSupportedType()
  {
    Uninit();
  }

  [[nodiscard]] inline double&
  RawSetAsDouble()
  {
    if (mType == eDouble) {
      return mValue.mDouble.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eDouble;
    return mValue.mDouble.SetValue();
  }

  [[nodiscard]] inline double&
  SetAsDouble()
  {
    if (mType == eDouble) {
      return mValue.mDouble.Value();
    }
    Uninit();
    mType = eDouble;
    return mValue.mDouble.SetValue();
  }

  inline bool
  IsDouble() const
  {
    return mType == eDouble;
  }

  inline double&
  GetAsDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  inline double
  GetAsDouble() const
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  [[nodiscard]] inline SupportedType&
  RawSetAsSupportedType()
  {
    if (mType == eSupportedType) {
      return mValue.mSupportedType.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eSupportedType;
    return mValue.mSupportedType.SetValue();
  }

  [[nodiscard]] inline SupportedType&
  SetAsSupportedType()
  {
    if (mType == eSupportedType) {
      return mValue.mSupportedType.Value();
    }
    Uninit();
    mType = eSupportedType;
    return mValue.mSupportedType.SetValue();
  }

  inline bool
  IsSupportedType() const
  {
    return mType == eSupportedType;
  }

  inline SupportedType&
  GetAsSupportedType()
  {
    MOZ_RELEASE_ASSERT(IsSupportedType(), "Wrong type!");
    return mValue.mSupportedType.Value();
  }

  inline SupportedType
  GetAsSupportedType() const
  {
    MOZ_RELEASE_ASSERT(IsSupportedType(), "Wrong type!");
    return mValue.mSupportedType.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eDouble: {
        DestroyDouble();
        break;
      }
      case eSupportedType: {
        DestroySupportedType();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToDouble(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDouble(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    mValue.mDouble.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToSupportedType(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToSupportedType(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroySupportedType()
  {
    MOZ_RELEASE_ASSERT(IsSupportedType(), "Wrong type!");
    mValue.mSupportedType.Destroy();
    mType = eUninitialized;
  }
};

class DoubleOrUSVString : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eDouble,
    eUSVString
  };
public:
  enum class Type
  {
    eDouble = TypeOrUninit::eDouble,
    eUSVString = TypeOrUninit::eUSVString
  };

private:
  union Value
  {
    UnionMember<double > mDouble;
    UnionMember<binding_detail::FakeString<char16_t> > mUSVString;

  };

  TypeOrUninit mType;
  Value mValue;

  DoubleOrUSVString(const DoubleOrUSVString&) = delete;
  DoubleOrUSVString& operator=(const DoubleOrUSVString&) = delete;
public:
  explicit inline DoubleOrUSVString()
    : mType(eUninitialized)
  {
  }

  inline ~DoubleOrUSVString()
  {
    Uninit();
  }

  [[nodiscard]] inline double&
  RawSetAsDouble()
  {
    if (mType == eDouble) {
      return mValue.mDouble.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eDouble;
    return mValue.mDouble.SetValue();
  }

  [[nodiscard]] inline double&
  SetAsDouble()
  {
    if (mType == eDouble) {
      return mValue.mDouble.Value();
    }
    Uninit();
    mType = eDouble;
    return mValue.mDouble.SetValue();
  }

  inline bool
  IsDouble() const
  {
    return mType == eDouble;
  }

  inline double&
  GetAsDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  inline double
  GetAsDouble() const
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  RawSetAsUSVString()
  {
    if (mType == eUSVString) {
      return mValue.mUSVString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUSVString;
    return mValue.mUSVString.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  SetAsUSVString()
  {
    if (mType == eUSVString) {
      return mValue.mUSVString.Value();
    }
    Uninit();
    mType = eUSVString;
    return mValue.mUSVString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsUSVString().AssignLiteral(aData);
  }

  inline bool
  IsUSVString() const
  {
    return mType == eUSVString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsUSVString()
  {
    MOZ_RELEASE_ASSERT(IsUSVString(), "Wrong type!");
    return mValue.mUSVString.Value();
  }

  inline const nsAString&
  GetAsUSVString() const
  {
    MOZ_RELEASE_ASSERT(IsUSVString(), "Wrong type!");
    return mValue.mUSVString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eDouble: {
        DestroyDouble();
        break;
      }
      case eUSVString: {
        DestroyUSVString();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToDouble(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDouble(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    mValue.mDouble.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToUSVString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUSVString()
  {
    MOZ_RELEASE_ASSERT(IsUSVString(), "Wrong type!");
    mValue.mUSVString.Destroy();
    mType = eUninitialized;
  }
};

class DoubleOrUTF8String : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eDouble,
    eUTF8String
  };
public:
  enum class Type
  {
    eDouble = TypeOrUninit::eDouble,
    eUTF8String = TypeOrUninit::eUTF8String
  };

private:
  union Value
  {
    UnionMember<double > mDouble;
    UnionMember<binding_detail::FakeString<char> > mUTF8String;

  };

  TypeOrUninit mType;
  Value mValue;

  DoubleOrUTF8String(const DoubleOrUTF8String&) = delete;
  DoubleOrUTF8String& operator=(const DoubleOrUTF8String&) = delete;
public:
  explicit inline DoubleOrUTF8String()
    : mType(eUninitialized)
  {
  }

  inline ~DoubleOrUTF8String()
  {
    Uninit();
  }

  [[nodiscard]] inline double&
  RawSetAsDouble()
  {
    if (mType == eDouble) {
      return mValue.mDouble.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eDouble;
    return mValue.mDouble.SetValue();
  }

  [[nodiscard]] inline double&
  SetAsDouble()
  {
    if (mType == eDouble) {
      return mValue.mDouble.Value();
    }
    Uninit();
    mType = eDouble;
    return mValue.mDouble.SetValue();
  }

  inline bool
  IsDouble() const
  {
    return mType == eDouble;
  }

  inline double&
  GetAsDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  inline double
  GetAsDouble() const
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  [[nodiscard]] inline binding_detail::FakeString<char>&
  RawSetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char>&
  SetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    Uninit();
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline binding_detail::FakeString<char>&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline const nsACString&
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eDouble: {
        DestroyDouble();
        break;
      }
      case eUTF8String: {
        DestroyUTF8String();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToDouble(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDouble(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    mValue.mDouble.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    mValue.mUTF8String.Destroy();
    mType = eUninitialized;
  }
};

class FileOrDirectory : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eFile,
    eDirectory
  };
public:
  enum class Type
  {
    eFile = TypeOrUninit::eFile,
    eDirectory = TypeOrUninit::eDirectory
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::File> > mFile;
    UnionMember<NonNull<mozilla::dom::Directory> > mDirectory;

  };

  TypeOrUninit mType;
  Value mValue;

  FileOrDirectory(const FileOrDirectory&) = delete;
  FileOrDirectory& operator=(const FileOrDirectory&) = delete;
public:
  explicit inline FileOrDirectory()
    : mType(eUninitialized)
  {
  }

  inline ~FileOrDirectory()
  {
    Uninit();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::File>&
  RawSetAsFile()
  {
    if (mType == eFile) {
      return mValue.mFile.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eFile;
    return mValue.mFile.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::File>&
  SetAsFile()
  {
    if (mType == eFile) {
      return mValue.mFile.Value();
    }
    Uninit();
    mType = eFile;
    return mValue.mFile.SetValue();
  }

  inline bool
  IsFile() const
  {
    return mType == eFile;
  }

  inline NonNull<mozilla::dom::File>&
  GetAsFile()
  {
    MOZ_RELEASE_ASSERT(IsFile(), "Wrong type!");
    return mValue.mFile.Value();
  }

  inline mozilla::dom::File&
  GetAsFile() const
  {
    MOZ_RELEASE_ASSERT(IsFile(), "Wrong type!");
    return mValue.mFile.Value();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::Directory>&
  RawSetAsDirectory()
  {
    if (mType == eDirectory) {
      return mValue.mDirectory.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eDirectory;
    return mValue.mDirectory.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::Directory>&
  SetAsDirectory()
  {
    if (mType == eDirectory) {
      return mValue.mDirectory.Value();
    }
    Uninit();
    mType = eDirectory;
    return mValue.mDirectory.SetValue();
  }

  inline bool
  IsDirectory() const
  {
    return mType == eDirectory;
  }

  inline NonNull<mozilla::dom::Directory>&
  GetAsDirectory()
  {
    MOZ_RELEASE_ASSERT(IsDirectory(), "Wrong type!");
    return mValue.mDirectory.Value();
  }

  inline mozilla::dom::Directory&
  GetAsDirectory() const
  {
    MOZ_RELEASE_ASSERT(IsDirectory(), "Wrong type!");
    return mValue.mDirectory.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eFile: {
        DestroyFile();
        break;
      }
      case eDirectory: {
        DestroyDirectory();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToFile(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToFile(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyFile()
  {
    MOZ_RELEASE_ASSERT(IsFile(), "Wrong type!");
    mValue.mFile.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToDirectory(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDirectory(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyDirectory()
  {
    MOZ_RELEASE_ASSERT(IsDirectory(), "Wrong type!");
    mValue.mDirectory.Destroy();
    mType = eUninitialized;
  }
};

class FileOrUSVStringOrFormData : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eFile,
    eUSVString,
    eFormData
  };
public:
  enum class Type
  {
    eFile = TypeOrUninit::eFile,
    eUSVString = TypeOrUninit::eUSVString,
    eFormData = TypeOrUninit::eFormData
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::File> > mFile;
    UnionMember<binding_detail::FakeString<char16_t> > mUSVString;
    UnionMember<NonNull<mozilla::dom::FormData> > mFormData;

  };

  TypeOrUninit mType;
  Value mValue;

  FileOrUSVStringOrFormData(const FileOrUSVStringOrFormData&) = delete;
  FileOrUSVStringOrFormData& operator=(const FileOrUSVStringOrFormData&) = delete;
public:
  explicit inline FileOrUSVStringOrFormData()
    : mType(eUninitialized)
  {
  }

  inline ~FileOrUSVStringOrFormData()
  {
    Uninit();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::File>&
  RawSetAsFile()
  {
    if (mType == eFile) {
      return mValue.mFile.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eFile;
    return mValue.mFile.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::File>&
  SetAsFile()
  {
    if (mType == eFile) {
      return mValue.mFile.Value();
    }
    Uninit();
    mType = eFile;
    return mValue.mFile.SetValue();
  }

  inline bool
  IsFile() const
  {
    return mType == eFile;
  }

  inline NonNull<mozilla::dom::File>&
  GetAsFile()
  {
    MOZ_RELEASE_ASSERT(IsFile(), "Wrong type!");
    return mValue.mFile.Value();
  }

  inline mozilla::dom::File&
  GetAsFile() const
  {
    MOZ_RELEASE_ASSERT(IsFile(), "Wrong type!");
    return mValue.mFile.Value();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  RawSetAsUSVString()
  {
    if (mType == eUSVString) {
      return mValue.mUSVString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUSVString;
    return mValue.mUSVString.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  SetAsUSVString()
  {
    if (mType == eUSVString) {
      return mValue.mUSVString.Value();
    }
    Uninit();
    mType = eUSVString;
    return mValue.mUSVString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsUSVString().AssignLiteral(aData);
  }

  inline bool
  IsUSVString() const
  {
    return mType == eUSVString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsUSVString()
  {
    MOZ_RELEASE_ASSERT(IsUSVString(), "Wrong type!");
    return mValue.mUSVString.Value();
  }

  inline const nsAString&
  GetAsUSVString() const
  {
    MOZ_RELEASE_ASSERT(IsUSVString(), "Wrong type!");
    return mValue.mUSVString.Value();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::FormData>&
  RawSetAsFormData()
  {
    if (mType == eFormData) {
      return mValue.mFormData.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eFormData;
    return mValue.mFormData.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::FormData>&
  SetAsFormData()
  {
    if (mType == eFormData) {
      return mValue.mFormData.Value();
    }
    Uninit();
    mType = eFormData;
    return mValue.mFormData.SetValue();
  }

  inline bool
  IsFormData() const
  {
    return mType == eFormData;
  }

  inline NonNull<mozilla::dom::FormData>&
  GetAsFormData()
  {
    MOZ_RELEASE_ASSERT(IsFormData(), "Wrong type!");
    return mValue.mFormData.Value();
  }

  inline mozilla::dom::FormData&
  GetAsFormData() const
  {
    MOZ_RELEASE_ASSERT(IsFormData(), "Wrong type!");
    return mValue.mFormData.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eFile: {
        DestroyFile();
        break;
      }
      case eUSVString: {
        DestroyUSVString();
        break;
      }
      case eFormData: {
        DestroyFormData();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToFile(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToFile(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyFile()
  {
    MOZ_RELEASE_ASSERT(IsFile(), "Wrong type!");
    mValue.mFile.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToUSVString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUSVString()
  {
    MOZ_RELEASE_ASSERT(IsUSVString(), "Wrong type!");
    mValue.mUSVString.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToFormData(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToFormData(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyFormData()
  {
    MOZ_RELEASE_ASSERT(IsFormData(), "Wrong type!");
    mValue.mFormData.Destroy();
    mType = eUninitialized;
  }
};

class FloatOrString : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eFloat,
    eString
  };
public:
  enum class Type
  {
    eFloat = TypeOrUninit::eFloat,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<float > mFloat;
    UnionMember<binding_detail::FakeString<char16_t> > mString;

  };

  TypeOrUninit mType;
  Value mValue;

  FloatOrString(const FloatOrString&) = delete;
  FloatOrString& operator=(const FloatOrString&) = delete;
public:
  explicit inline FloatOrString()
    : mType(eUninitialized)
  {
  }

  inline ~FloatOrString()
  {
    Uninit();
  }

  [[nodiscard]] inline float&
  RawSetAsFloat()
  {
    if (mType == eFloat) {
      return mValue.mFloat.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eFloat;
    return mValue.mFloat.SetValue();
  }

  [[nodiscard]] inline float&
  SetAsFloat()
  {
    if (mType == eFloat) {
      return mValue.mFloat.Value();
    }
    Uninit();
    mType = eFloat;
    return mValue.mFloat.SetValue();
  }

  inline bool
  IsFloat() const
  {
    return mType == eFloat;
  }

  inline float&
  GetAsFloat()
  {
    MOZ_RELEASE_ASSERT(IsFloat(), "Wrong type!");
    return mValue.mFloat.Value();
  }

  inline float
  GetAsFloat() const
  {
    MOZ_RELEASE_ASSERT(IsFloat(), "Wrong type!");
    return mValue.mFloat.Value();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eFloat: {
        DestroyFloat();
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToFloat(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToFloat(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyFloat()
  {
    MOZ_RELEASE_ASSERT(IsFloat(), "Wrong type!");
    mValue.mFloat.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }
};

class HTMLCanvasElementOrOffscreenCanvas : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eHTMLCanvasElement,
    eOffscreenCanvas
  };
public:
  enum class Type
  {
    eHTMLCanvasElement = TypeOrUninit::eHTMLCanvasElement,
    eOffscreenCanvas = TypeOrUninit::eOffscreenCanvas
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::HTMLCanvasElement> > mHTMLCanvasElement;
    UnionMember<NonNull<mozilla::dom::OffscreenCanvas> > mOffscreenCanvas;

  };

  TypeOrUninit mType;
  Value mValue;

  HTMLCanvasElementOrOffscreenCanvas(const HTMLCanvasElementOrOffscreenCanvas&) = delete;
  HTMLCanvasElementOrOffscreenCanvas& operator=(const HTMLCanvasElementOrOffscreenCanvas&) = delete;
public:
  explicit inline HTMLCanvasElementOrOffscreenCanvas()
    : mType(eUninitialized)
  {
  }

  inline ~HTMLCanvasElementOrOffscreenCanvas()
  {
    Uninit();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::HTMLCanvasElement>&
  RawSetAsHTMLCanvasElement()
  {
    if (mType == eHTMLCanvasElement) {
      return mValue.mHTMLCanvasElement.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eHTMLCanvasElement;
    return mValue.mHTMLCanvasElement.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::HTMLCanvasElement>&
  SetAsHTMLCanvasElement()
  {
    if (mType == eHTMLCanvasElement) {
      return mValue.mHTMLCanvasElement.Value();
    }
    Uninit();
    mType = eHTMLCanvasElement;
    return mValue.mHTMLCanvasElement.SetValue();
  }

  inline bool
  IsHTMLCanvasElement() const
  {
    return mType == eHTMLCanvasElement;
  }

  inline NonNull<mozilla::dom::HTMLCanvasElement>&
  GetAsHTMLCanvasElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    return mValue.mHTMLCanvasElement.Value();
  }

  inline mozilla::dom::HTMLCanvasElement&
  GetAsHTMLCanvasElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    return mValue.mHTMLCanvasElement.Value();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::OffscreenCanvas>&
  RawSetAsOffscreenCanvas()
  {
    if (mType == eOffscreenCanvas) {
      return mValue.mOffscreenCanvas.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eOffscreenCanvas;
    return mValue.mOffscreenCanvas.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::OffscreenCanvas>&
  SetAsOffscreenCanvas()
  {
    if (mType == eOffscreenCanvas) {
      return mValue.mOffscreenCanvas.Value();
    }
    Uninit();
    mType = eOffscreenCanvas;
    return mValue.mOffscreenCanvas.SetValue();
  }

  inline bool
  IsOffscreenCanvas() const
  {
    return mType == eOffscreenCanvas;
  }

  inline NonNull<mozilla::dom::OffscreenCanvas>&
  GetAsOffscreenCanvas()
  {
    MOZ_RELEASE_ASSERT(IsOffscreenCanvas(), "Wrong type!");
    return mValue.mOffscreenCanvas.Value();
  }

  inline mozilla::dom::OffscreenCanvas&
  GetAsOffscreenCanvas() const
  {
    MOZ_RELEASE_ASSERT(IsOffscreenCanvas(), "Wrong type!");
    return mValue.mOffscreenCanvas.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eHTMLCanvasElement: {
        DestroyHTMLCanvasElement();
        break;
      }
      case eOffscreenCanvas: {
        DestroyOffscreenCanvas();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToHTMLCanvasElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLCanvasElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyHTMLCanvasElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    mValue.mHTMLCanvasElement.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToOffscreenCanvas(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToOffscreenCanvas(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyOffscreenCanvas()
  {
    MOZ_RELEASE_ASSERT(IsOffscreenCanvas(), "Wrong type!");
    mValue.mOffscreenCanvas.Destroy();
    mType = eUninitialized;
  }
};

class HTMLElementOrLong : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eHTMLElement,
    eLong
  };
public:
  enum class Type
  {
    eHTMLElement = TypeOrUninit::eHTMLElement,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<NonNull<nsGenericHTMLElement> > mHTMLElement;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

  HTMLElementOrLong(const HTMLElementOrLong&) = delete;
  HTMLElementOrLong& operator=(const HTMLElementOrLong&) = delete;
public:
  explicit inline HTMLElementOrLong()
    : mType(eUninitialized)
  {
  }

  inline ~HTMLElementOrLong()
  {
    Uninit();
  }

  [[nodiscard]] inline NonNull<nsGenericHTMLElement>&
  RawSetAsHTMLElement()
  {
    if (mType == eHTMLElement) {
      return mValue.mHTMLElement.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eHTMLElement;
    return mValue.mHTMLElement.SetValue();
  }

  [[nodiscard]] inline NonNull<nsGenericHTMLElement>&
  SetAsHTMLElement()
  {
    if (mType == eHTMLElement) {
      return mValue.mHTMLElement.Value();
    }
    Uninit();
    mType = eHTMLElement;
    return mValue.mHTMLElement.SetValue();
  }

  inline bool
  IsHTMLElement() const
  {
    return mType == eHTMLElement;
  }

  inline NonNull<nsGenericHTMLElement>&
  GetAsHTMLElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLElement(), "Wrong type!");
    return mValue.mHTMLElement.Value();
  }

  inline nsGenericHTMLElement&
  GetAsHTMLElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLElement(), "Wrong type!");
    return mValue.mHTMLElement.Value();
  }

  [[nodiscard]] inline int32_t&
  RawSetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  [[nodiscard]] inline int32_t&
  SetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    Uninit();
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eHTMLElement: {
        DestroyHTMLElement();
        break;
      }
      case eLong: {
        DestroyLong();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToHTMLElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyHTMLElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLElement(), "Wrong type!");
    mValue.mHTMLElement.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    mValue.mLong.Destroy();
    mType = eUninitialized;
  }
};

class HTMLOptionElementOrHTMLOptGroupElement : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eHTMLOptionElement,
    eHTMLOptGroupElement
  };
public:
  enum class Type
  {
    eHTMLOptionElement = TypeOrUninit::eHTMLOptionElement,
    eHTMLOptGroupElement = TypeOrUninit::eHTMLOptGroupElement
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::HTMLOptionElement> > mHTMLOptionElement;
    UnionMember<NonNull<mozilla::dom::HTMLOptGroupElement> > mHTMLOptGroupElement;

  };

  TypeOrUninit mType;
  Value mValue;

  HTMLOptionElementOrHTMLOptGroupElement(const HTMLOptionElementOrHTMLOptGroupElement&) = delete;
  HTMLOptionElementOrHTMLOptGroupElement& operator=(const HTMLOptionElementOrHTMLOptGroupElement&) = delete;
public:
  explicit inline HTMLOptionElementOrHTMLOptGroupElement()
    : mType(eUninitialized)
  {
  }

  inline ~HTMLOptionElementOrHTMLOptGroupElement()
  {
    Uninit();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::HTMLOptionElement>&
  RawSetAsHTMLOptionElement()
  {
    if (mType == eHTMLOptionElement) {
      return mValue.mHTMLOptionElement.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eHTMLOptionElement;
    return mValue.mHTMLOptionElement.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::HTMLOptionElement>&
  SetAsHTMLOptionElement()
  {
    if (mType == eHTMLOptionElement) {
      return mValue.mHTMLOptionElement.Value();
    }
    Uninit();
    mType = eHTMLOptionElement;
    return mValue.mHTMLOptionElement.SetValue();
  }

  inline bool
  IsHTMLOptionElement() const
  {
    return mType == eHTMLOptionElement;
  }

  inline NonNull<mozilla::dom::HTMLOptionElement>&
  GetAsHTMLOptionElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLOptionElement(), "Wrong type!");
    return mValue.mHTMLOptionElement.Value();
  }

  inline mozilla::dom::HTMLOptionElement&
  GetAsHTMLOptionElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLOptionElement(), "Wrong type!");
    return mValue.mHTMLOptionElement.Value();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::HTMLOptGroupElement>&
  RawSetAsHTMLOptGroupElement()
  {
    if (mType == eHTMLOptGroupElement) {
      return mValue.mHTMLOptGroupElement.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eHTMLOptGroupElement;
    return mValue.mHTMLOptGroupElement.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::HTMLOptGroupElement>&
  SetAsHTMLOptGroupElement()
  {
    if (mType == eHTMLOptGroupElement) {
      return mValue.mHTMLOptGroupElement.Value();
    }
    Uninit();
    mType = eHTMLOptGroupElement;
    return mValue.mHTMLOptGroupElement.SetValue();
  }

  inline bool
  IsHTMLOptGroupElement() const
  {
    return mType == eHTMLOptGroupElement;
  }

  inline NonNull<mozilla::dom::HTMLOptGroupElement>&
  GetAsHTMLOptGroupElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLOptGroupElement(), "Wrong type!");
    return mValue.mHTMLOptGroupElement.Value();
  }

  inline mozilla::dom::HTMLOptGroupElement&
  GetAsHTMLOptGroupElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLOptGroupElement(), "Wrong type!");
    return mValue.mHTMLOptGroupElement.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eHTMLOptionElement: {
        DestroyHTMLOptionElement();
        break;
      }
      case eHTMLOptGroupElement: {
        DestroyHTMLOptGroupElement();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToHTMLOptionElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLOptionElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyHTMLOptionElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLOptionElement(), "Wrong type!");
    mValue.mHTMLOptionElement.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToHTMLOptGroupElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLOptGroupElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyHTMLOptGroupElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLOptGroupElement(), "Wrong type!");
    mValue.mHTMLOptGroupElement.Destroy();
    mType = eUninitialized;
  }
};

class LongOrStringAnyRecord : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eLong,
    eStringAnyRecord
  };
public:
  enum class Type
  {
    eLong = TypeOrUninit::eLong,
    eStringAnyRecord = TypeOrUninit::eStringAnyRecord
  };

private:
  union Value
  {
    UnionMember<int32_t > mLong;
    UnionMember<RootedRecord<nsString, JS::Value> > mStringAnyRecord;

  };

  TypeOrUninit mType;
  Value mValue;

  LongOrStringAnyRecord(const LongOrStringAnyRecord&) = delete;
  LongOrStringAnyRecord& operator=(const LongOrStringAnyRecord&) = delete;
public:
  explicit inline LongOrStringAnyRecord()
    : mType(eUninitialized)
  {
  }

  inline ~LongOrStringAnyRecord()
  {
    Uninit();
  }

  [[nodiscard]] inline int32_t&
  RawSetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  [[nodiscard]] inline int32_t&
  SetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    Uninit();
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  [[nodiscard]] inline RootedRecord<nsString, JS::Value>&
  RawSetAsStringAnyRecord(JSContext* cx)
  {
    if (mType == eStringAnyRecord) {
      return mValue.mStringAnyRecord.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eStringAnyRecord;
    return mValue.mStringAnyRecord.SetValue(cx);
  }

  [[nodiscard]] inline RootedRecord<nsString, JS::Value>&
  SetAsStringAnyRecord(JSContext* cx)
  {
    if (mType == eStringAnyRecord) {
      return mValue.mStringAnyRecord.Value();
    }
    Uninit();
    mType = eStringAnyRecord;
    return mValue.mStringAnyRecord.SetValue(cx);
  }

  inline bool
  IsStringAnyRecord() const
  {
    return mType == eStringAnyRecord;
  }

  inline RootedRecord<nsString, JS::Value>&
  GetAsStringAnyRecord()
  {
    MOZ_RELEASE_ASSERT(IsStringAnyRecord(), "Wrong type!");
    return mValue.mStringAnyRecord.Value();
  }

  inline const Record<nsString, JS::Value>&
  GetAsStringAnyRecord() const
  {
    MOZ_RELEASE_ASSERT(IsStringAnyRecord(), "Wrong type!");
    return mValue.mStringAnyRecord.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eLong: {
        DestroyLong();
        break;
      }
      case eStringAnyRecord: {
        DestroyStringAnyRecord();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    mValue.mLong.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToStringAnyRecord(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToStringAnyRecord(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyStringAnyRecord()
  {
    MOZ_RELEASE_ASSERT(IsStringAnyRecord(), "Wrong type!");
    mValue.mStringAnyRecord.Destroy();
    mType = eUninitialized;
  }
};

class MaybeSharedInt8ArrayOrMaybeSharedInt16Array : public AllUnionBase,
                                                    public UnionWithTypedArraysBase
{
public:
  using ApplyToTypedArrays = binding_detail::ApplyToTypedArraysHelper<MaybeSharedInt8ArrayOrMaybeSharedInt16Array, false, Int8Array, Int16Array>;

private:
  enum TypeOrUninit
  {
    eUninitialized,
    eInt8Array,
    eInt16Array
  };
public:
  enum class Type
  {
    eInt8Array = TypeOrUninit::eInt8Array,
    eInt16Array = TypeOrUninit::eInt16Array
  };

private:
  union Value
  {
    UnionMember<RootedSpiderMonkeyInterface<Int8Array> > mInt8Array;
    UnionMember<RootedSpiderMonkeyInterface<Int16Array> > mInt16Array;

  };

  TypeOrUninit mType;
  Value mValue;

  MaybeSharedInt8ArrayOrMaybeSharedInt16Array(const MaybeSharedInt8ArrayOrMaybeSharedInt16Array&) = delete;
  MaybeSharedInt8ArrayOrMaybeSharedInt16Array& operator=(const MaybeSharedInt8ArrayOrMaybeSharedInt16Array&) = delete;
public:
  explicit inline MaybeSharedInt8ArrayOrMaybeSharedInt16Array()
    : mType(eUninitialized)
  {
  }

  inline ~MaybeSharedInt8ArrayOrMaybeSharedInt16Array()
  {
    Uninit();
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<Int8Array>&
  RawSetAsInt8Array(JSContext* cx)
  {
    if (mType == eInt8Array) {
      return mValue.mInt8Array.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eInt8Array;
    return mValue.mInt8Array.SetValue(cx);
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<Int8Array>&
  SetAsInt8Array(JSContext* cx)
  {
    if (mType == eInt8Array) {
      return mValue.mInt8Array.Value();
    }
    Uninit();
    mType = eInt8Array;
    return mValue.mInt8Array.SetValue(cx);
  }

  inline bool
  IsInt8Array() const
  {
    return mType == eInt8Array;
  }

  inline RootedSpiderMonkeyInterface<Int8Array>&
  GetAsInt8Array()
  {
    MOZ_RELEASE_ASSERT(IsInt8Array(), "Wrong type!");
    return mValue.mInt8Array.Value();
  }

  inline Int8Array const &
  GetAsInt8Array() const
  {
    MOZ_RELEASE_ASSERT(IsInt8Array(), "Wrong type!");
    return mValue.mInt8Array.Value();
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<Int16Array>&
  RawSetAsInt16Array(JSContext* cx)
  {
    if (mType == eInt16Array) {
      return mValue.mInt16Array.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eInt16Array;
    return mValue.mInt16Array.SetValue(cx);
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<Int16Array>&
  SetAsInt16Array(JSContext* cx)
  {
    if (mType == eInt16Array) {
      return mValue.mInt16Array.Value();
    }
    Uninit();
    mType = eInt16Array;
    return mValue.mInt16Array.SetValue(cx);
  }

  inline bool
  IsInt16Array() const
  {
    return mType == eInt16Array;
  }

  inline RootedSpiderMonkeyInterface<Int16Array>&
  GetAsInt16Array()
  {
    MOZ_RELEASE_ASSERT(IsInt16Array(), "Wrong type!");
    return mValue.mInt16Array.Value();
  }

  inline Int16Array const &
  GetAsInt16Array() const
  {
    MOZ_RELEASE_ASSERT(IsInt16Array(), "Wrong type!");
    return mValue.mInt16Array.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eInt8Array: {
        DestroyInt8Array();
        break;
      }
      case eInt16Array: {
        DestroyInt16Array();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToInt8Array(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToInt8Array(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyInt8Array()
  {
    MOZ_RELEASE_ASSERT(IsInt8Array(), "Wrong type!");
    mValue.mInt8Array.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToInt16Array(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToInt16Array(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyInt16Array()
  {
    MOZ_RELEASE_ASSERT(IsInt16Array(), "Wrong type!");
    mValue.mInt16Array.Destroy();
    mType = eUninitialized;
  }
};

class NodeOrString : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eNode,
    eString
  };
public:
  enum class Type
  {
    eNode = TypeOrUninit::eNode,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<NonNull<nsINode> > mNode;
    UnionMember<binding_detail::FakeString<char16_t> > mString;

  };

  TypeOrUninit mType;
  Value mValue;

  NodeOrString(const NodeOrString&) = delete;
  NodeOrString& operator=(const NodeOrString&) = delete;
public:
  explicit inline NodeOrString()
    : mType(eUninitialized)
  {
  }

  inline ~NodeOrString()
  {
    Uninit();
  }

  [[nodiscard]] inline NonNull<nsINode>&
  RawSetAsNode()
  {
    if (mType == eNode) {
      return mValue.mNode.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eNode;
    return mValue.mNode.SetValue();
  }

  [[nodiscard]] inline NonNull<nsINode>&
  SetAsNode()
  {
    if (mType == eNode) {
      return mValue.mNode.Value();
    }
    Uninit();
    mType = eNode;
    return mValue.mNode.SetValue();
  }

  inline bool
  IsNode() const
  {
    return mType == eNode;
  }

  inline NonNull<nsINode>&
  GetAsNode()
  {
    MOZ_RELEASE_ASSERT(IsNode(), "Wrong type!");
    return mValue.mNode.Value();
  }

  inline nsINode&
  GetAsNode() const
  {
    MOZ_RELEASE_ASSERT(IsNode(), "Wrong type!");
    return mValue.mNode.Value();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eNode: {
        DestroyNode();
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToNode(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToNode(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyNode()
  {
    MOZ_RELEASE_ASSERT(IsNode(), "Wrong type!");
    mValue.mNode.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }
};

class ObjectOrLong : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eObject,
    eLong
  };
public:
  enum class Type
  {
    eObject = TypeOrUninit::eObject,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<JS::Rooted<JSObject*> > mObject;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

  ObjectOrLong(const ObjectOrLong&) = delete;
  ObjectOrLong& operator=(const ObjectOrLong&) = delete;
public:
  explicit inline ObjectOrLong()
    : mType(eUninitialized)
  {
  }

  inline ~ObjectOrLong()
  {
    Uninit();
  }

  inline bool
  SetToObject(BindingCallContext& cx, JSObject* obj, bool passedToJSImpl = false)
  {
    MOZ_ASSERT(mType == eUninitialized);
    mValue.mObject.SetValue(cx, obj);
    mType = eObject;
    if (passedToJSImpl && !CallerSubsumes(obj)) {
      cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("object branch of (object or long)");
      return false;
    }
    return true;
  }

  inline bool
  IsObject() const
  {
    return mType == eObject;
  }

  inline JS::Rooted<JSObject*>&
  GetAsObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline JSObject*
  GetAsObject() const
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  [[nodiscard]] inline int32_t&
  RawSetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  [[nodiscard]] inline int32_t&
  SetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType != eObject, "This will not play well with Rooted");
    Uninit();
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eObject: {
        DestroyObject();
        break;
      }
      case eLong: {
        DestroyLong();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    mValue.mObject.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    mValue.mLong.Destroy();
    mType = eUninitialized;
  }
};

class ObjectOrNullOrLong : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eNull,
    eObject,
    eLong
  };
public:
  enum class Type
  {
    eNull = TypeOrUninit::eNull,
    eObject = TypeOrUninit::eObject,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<JS::Rooted<JSObject*> > mObject;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

  ObjectOrNullOrLong(const ObjectOrNullOrLong&) = delete;
  ObjectOrNullOrLong& operator=(const ObjectOrNullOrLong&) = delete;
public:
  explicit inline ObjectOrNullOrLong()
    : mType(eUninitialized)
  {
  }

  inline ~ObjectOrNullOrLong()
  {
    Uninit();
  }

  inline bool
  IsNull() const
  {
    return mType == eNull;
  }

  inline void
  SetNull()
  {
    Uninit();
    mType = eNull;
  }

  inline bool
  SetToObject(BindingCallContext& cx, JSObject* obj, bool passedToJSImpl = false)
  {
    MOZ_ASSERT(mType == eUninitialized);
    mValue.mObject.SetValue(cx, obj);
    mType = eObject;
    if (passedToJSImpl && !CallerSubsumes(obj)) {
      cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("object branch of (object? or long)");
      return false;
    }
    return true;
  }

  inline bool
  IsObject() const
  {
    return mType == eObject;
  }

  inline JS::Rooted<JSObject*>&
  GetAsObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline JSObject*
  GetAsObject() const
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  [[nodiscard]] inline int32_t&
  RawSetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  [[nodiscard]] inline int32_t&
  SetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType != eObject, "This will not play well with Rooted");
    Uninit();
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eNull: {
        break;
      }
      case eObject: {
        DestroyObject();
        break;
      }
      case eLong: {
        DestroyLong();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    mValue.mObject.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    mValue.mLong.Destroy();
    mType = eUninitialized;
  }
};

class StringOrArrayBuffer : public AllUnionBase,
                            public UnionWithTypedArraysBase
{
public:
  using ApplyToTypedArrays = binding_detail::ApplyToTypedArraysHelper<StringOrArrayBuffer, true, ArrayBuffer>;

private:
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eArrayBuffer
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eArrayBuffer = TypeOrUninit::eArrayBuffer
  };

private:
  union Value
  {
    UnionMember<binding_detail::FakeString<char16_t> > mString;
    UnionMember<RootedSpiderMonkeyInterface<ArrayBuffer> > mArrayBuffer;

  };

  TypeOrUninit mType;
  Value mValue;

  StringOrArrayBuffer(const StringOrArrayBuffer&) = delete;
  StringOrArrayBuffer& operator=(const StringOrArrayBuffer&) = delete;
public:
  explicit inline StringOrArrayBuffer()
    : mType(eUninitialized)
  {
  }

  inline ~StringOrArrayBuffer()
  {
    Uninit();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  RawSetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  SetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    Uninit();
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  GetAsArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
      case eArrayBuffer: {
        DestroyArrayBuffer();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToArrayBuffer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBuffer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    mValue.mArrayBuffer.Destroy();
    mType = eUninitialized;
  }
};

class StringOrBooleanOrObject : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eBoolean,
    eObject
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eBoolean = TypeOrUninit::eBoolean,
    eObject = TypeOrUninit::eObject
  };

private:
  union Value
  {
    UnionMember<binding_detail::FakeString<char16_t> > mString;
    UnionMember<bool > mBoolean;
    UnionMember<JS::Rooted<JSObject*> > mObject;

  };

  TypeOrUninit mType;
  Value mValue;

  StringOrBooleanOrObject(const StringOrBooleanOrObject&) = delete;
  StringOrBooleanOrObject& operator=(const StringOrBooleanOrObject&) = delete;
public:
  explicit inline StringOrBooleanOrObject()
    : mType(eUninitialized)
  {
  }

  inline ~StringOrBooleanOrObject()
  {
    Uninit();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType != eObject, "This will not play well with Rooted");
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  [[nodiscard]] inline bool&
  RawSetAsBoolean()
  {
    if (mType == eBoolean) {
      return mValue.mBoolean.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eBoolean;
    return mValue.mBoolean.SetValue();
  }

  [[nodiscard]] inline bool&
  SetAsBoolean()
  {
    if (mType == eBoolean) {
      return mValue.mBoolean.Value();
    }
    MOZ_ASSERT(mType != eObject, "This will not play well with Rooted");
    Uninit();
    mType = eBoolean;
    return mValue.mBoolean.SetValue();
  }

  inline bool
  IsBoolean() const
  {
    return mType == eBoolean;
  }

  inline bool&
  GetAsBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline bool
  GetAsBoolean() const
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline bool
  SetToObject(BindingCallContext& cx, JSObject* obj, bool passedToJSImpl = false)
  {
    MOZ_ASSERT(mType == eUninitialized);
    mValue.mObject.SetValue(cx, obj);
    mType = eObject;
    if (passedToJSImpl && !CallerSubsumes(obj)) {
      cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("object branch of (DOMString or boolean or object)");
      return false;
    }
    return true;
  }

  inline bool
  IsObject() const
  {
    return mType == eObject;
  }

  inline JS::Rooted<JSObject*>&
  GetAsObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline JSObject*
  GetAsObject() const
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
      case eBoolean: {
        DestroyBoolean();
        break;
      }
      case eObject: {
        DestroyObject();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToBoolean(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    mValue.mBoolean.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    mValue.mObject.Destroy();
    mType = eUninitialized;
  }
};

class StringOrMaybeSharedArrayBuffer : public AllUnionBase,
                                       public UnionWithTypedArraysBase
{
public:
  using ApplyToTypedArrays = binding_detail::ApplyToTypedArraysHelper<StringOrMaybeSharedArrayBuffer, true, ArrayBuffer>;

private:
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eArrayBuffer
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eArrayBuffer = TypeOrUninit::eArrayBuffer
  };

private:
  union Value
  {
    UnionMember<binding_detail::FakeString<char16_t> > mString;
    UnionMember<RootedSpiderMonkeyInterface<ArrayBuffer> > mArrayBuffer;

  };

  TypeOrUninit mType;
  Value mValue;

  StringOrMaybeSharedArrayBuffer(const StringOrMaybeSharedArrayBuffer&) = delete;
  StringOrMaybeSharedArrayBuffer& operator=(const StringOrMaybeSharedArrayBuffer&) = delete;
public:
  explicit inline StringOrMaybeSharedArrayBuffer()
    : mType(eUninitialized)
  {
  }

  inline ~StringOrMaybeSharedArrayBuffer()
  {
    Uninit();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  RawSetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  SetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    Uninit();
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  GetAsArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
      case eArrayBuffer: {
        DestroyArrayBuffer();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToArrayBuffer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBuffer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    mValue.mArrayBuffer.Destroy();
    mType = eUninitialized;
  }
};

class StringOrObject : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eObject
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eObject = TypeOrUninit::eObject
  };

private:
  union Value
  {
    UnionMember<binding_detail::FakeString<char16_t> > mString;
    UnionMember<JS::Rooted<JSObject*> > mObject;

  };

  TypeOrUninit mType;
  Value mValue;

  StringOrObject(const StringOrObject&) = delete;
  StringOrObject& operator=(const StringOrObject&) = delete;
public:
  explicit inline StringOrObject()
    : mType(eUninitialized)
  {
  }

  inline ~StringOrObject()
  {
    Uninit();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType != eObject, "This will not play well with Rooted");
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline bool
  SetToObject(BindingCallContext& cx, JSObject* obj, bool passedToJSImpl = false)
  {
    MOZ_ASSERT(mType == eUninitialized);
    mValue.mObject.SetValue(cx, obj);
    mType = eObject;
    if (passedToJSImpl && !CallerSubsumes(obj)) {
      cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("object branch of (DOMString or object)");
      return false;
    }
    return true;
  }

  inline bool
  IsObject() const
  {
    return mType == eObject;
  }

  inline JS::Rooted<JSObject*>&
  GetAsObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline JSObject*
  GetAsObject() const
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
      case eObject: {
        DestroyObject();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    mValue.mObject.Destroy();
    mType = eUninitialized;
  }
};

class StringOrStringSequence : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eStringSequence
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eStringSequence = TypeOrUninit::eStringSequence
  };

private:
  union Value
  {
    UnionMember<binding_detail::FakeString<char16_t> > mString;
    UnionMember<binding_detail::AutoSequence<nsString> > mStringSequence;

  };

  TypeOrUninit mType;
  Value mValue;

  StringOrStringSequence(const StringOrStringSequence&) = delete;
  StringOrStringSequence& operator=(const StringOrStringSequence&) = delete;
public:
  explicit inline StringOrStringSequence()
    : mType(eUninitialized)
  {
  }

  inline ~StringOrStringSequence()
  {
    Uninit();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  [[nodiscard]] inline binding_detail::AutoSequence<nsString>&
  RawSetAsStringSequence()
  {
    if (mType == eStringSequence) {
      return mValue.mStringSequence.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eStringSequence;
    return mValue.mStringSequence.SetValue();
  }

  [[nodiscard]] inline binding_detail::AutoSequence<nsString>&
  SetAsStringSequence()
  {
    if (mType == eStringSequence) {
      return mValue.mStringSequence.Value();
    }
    Uninit();
    mType = eStringSequence;
    return mValue.mStringSequence.SetValue();
  }

  inline bool
  IsStringSequence() const
  {
    return mType == eStringSequence;
  }

  inline binding_detail::AutoSequence<nsString>&
  GetAsStringSequence()
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    return mValue.mStringSequence.Value();
  }

  inline const Sequence<nsString>&
  GetAsStringSequence() const
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    return mValue.mStringSequence.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
      case eStringSequence: {
        DestroyStringSequence();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToStringSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToStringSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyStringSequence()
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    mValue.mStringSequence.Destroy();
    mType = eUninitialized;
  }
};

class SupportedTypeOrObject : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eSupportedType,
    eObject
  };
public:
  enum class Type
  {
    eSupportedType = TypeOrUninit::eSupportedType,
    eObject = TypeOrUninit::eObject
  };

private:
  union Value
  {
    UnionMember<SupportedType > mSupportedType;
    UnionMember<JS::Rooted<JSObject*> > mObject;

  };

  TypeOrUninit mType;
  Value mValue;

  SupportedTypeOrObject(const SupportedTypeOrObject&) = delete;
  SupportedTypeOrObject& operator=(const SupportedTypeOrObject&) = delete;
public:
  explicit inline SupportedTypeOrObject()
    : mType(eUninitialized)
  {
  }

  inline ~SupportedTypeOrObject()
  {
    Uninit();
  }

  [[nodiscard]] inline SupportedType&
  RawSetAsSupportedType()
  {
    if (mType == eSupportedType) {
      return mValue.mSupportedType.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eSupportedType;
    return mValue.mSupportedType.SetValue();
  }

  [[nodiscard]] inline SupportedType&
  SetAsSupportedType()
  {
    if (mType == eSupportedType) {
      return mValue.mSupportedType.Value();
    }
    MOZ_ASSERT(mType != eObject, "This will not play well with Rooted");
    Uninit();
    mType = eSupportedType;
    return mValue.mSupportedType.SetValue();
  }

  inline bool
  IsSupportedType() const
  {
    return mType == eSupportedType;
  }

  inline SupportedType&
  GetAsSupportedType()
  {
    MOZ_RELEASE_ASSERT(IsSupportedType(), "Wrong type!");
    return mValue.mSupportedType.Value();
  }

  inline SupportedType
  GetAsSupportedType() const
  {
    MOZ_RELEASE_ASSERT(IsSupportedType(), "Wrong type!");
    return mValue.mSupportedType.Value();
  }

  inline bool
  SetToObject(BindingCallContext& cx, JSObject* obj, bool passedToJSImpl = false)
  {
    MOZ_ASSERT(mType == eUninitialized);
    mValue.mObject.SetValue(cx, obj);
    mType = eObject;
    if (passedToJSImpl && !CallerSubsumes(obj)) {
      cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("object branch of (SupportedType or object)");
      return false;
    }
    return true;
  }

  inline bool
  IsObject() const
  {
    return mType == eObject;
  }

  inline JS::Rooted<JSObject*>&
  GetAsObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline JSObject*
  GetAsObject() const
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eSupportedType: {
        DestroySupportedType();
        break;
      }
      case eObject: {
        DestroyObject();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToSupportedType(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToSupportedType(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroySupportedType()
  {
    MOZ_RELEASE_ASSERT(IsSupportedType(), "Wrong type!");
    mValue.mSupportedType.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    mValue.mObject.Destroy();
    mType = eUninitialized;
  }
};

class TrustedHTMLOrNullIsEmptyString : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eTrustedHTML,
    eNullIsEmptyString
  };
public:
  enum class Type
  {
    eTrustedHTML = TypeOrUninit::eTrustedHTML,
    eNullIsEmptyString = TypeOrUninit::eNullIsEmptyString
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::TrustedHTML> > mTrustedHTML;
    UnionMember<binding_detail::FakeString<char16_t> > mNullIsEmptyString;

  };

  TypeOrUninit mType;
  Value mValue;

  TrustedHTMLOrNullIsEmptyString(const TrustedHTMLOrNullIsEmptyString&) = delete;
  TrustedHTMLOrNullIsEmptyString& operator=(const TrustedHTMLOrNullIsEmptyString&) = delete;
public:
  explicit inline TrustedHTMLOrNullIsEmptyString()
    : mType(eUninitialized)
  {
  }

  inline ~TrustedHTMLOrNullIsEmptyString()
  {
    Uninit();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::TrustedHTML>&
  RawSetAsTrustedHTML()
  {
    if (mType == eTrustedHTML) {
      return mValue.mTrustedHTML.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eTrustedHTML;
    return mValue.mTrustedHTML.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::TrustedHTML>&
  SetAsTrustedHTML()
  {
    if (mType == eTrustedHTML) {
      return mValue.mTrustedHTML.Value();
    }
    Uninit();
    mType = eTrustedHTML;
    return mValue.mTrustedHTML.SetValue();
  }

  inline bool
  IsTrustedHTML() const
  {
    return mType == eTrustedHTML;
  }

  inline NonNull<mozilla::dom::TrustedHTML>&
  GetAsTrustedHTML()
  {
    MOZ_RELEASE_ASSERT(IsTrustedHTML(), "Wrong type!");
    return mValue.mTrustedHTML.Value();
  }

  inline mozilla::dom::TrustedHTML&
  GetAsTrustedHTML() const
  {
    MOZ_RELEASE_ASSERT(IsTrustedHTML(), "Wrong type!");
    return mValue.mTrustedHTML.Value();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  RawSetAsNullIsEmptyString()
  {
    if (mType == eNullIsEmptyString) {
      return mValue.mNullIsEmptyString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eNullIsEmptyString;
    return mValue.mNullIsEmptyString.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  SetAsNullIsEmptyString()
  {
    if (mType == eNullIsEmptyString) {
      return mValue.mNullIsEmptyString.Value();
    }
    Uninit();
    mType = eNullIsEmptyString;
    return mValue.mNullIsEmptyString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsNullIsEmptyString().AssignLiteral(aData);
  }

  inline bool
  IsNullIsEmptyString() const
  {
    return mType == eNullIsEmptyString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsNullIsEmptyString()
  {
    MOZ_RELEASE_ASSERT(IsNullIsEmptyString(), "Wrong type!");
    return mValue.mNullIsEmptyString.Value();
  }

  inline const nsAString&
  GetAsNullIsEmptyString() const
  {
    MOZ_RELEASE_ASSERT(IsNullIsEmptyString(), "Wrong type!");
    return mValue.mNullIsEmptyString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eTrustedHTML: {
        DestroyTrustedHTML();
        break;
      }
      case eNullIsEmptyString: {
        DestroyNullIsEmptyString();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToTrustedHTML(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToTrustedHTML(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyTrustedHTML()
  {
    MOZ_RELEASE_ASSERT(IsTrustedHTML(), "Wrong type!");
    mValue.mTrustedHTML.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToNullIsEmptyString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyNullIsEmptyString()
  {
    MOZ_RELEASE_ASSERT(IsNullIsEmptyString(), "Wrong type!");
    mValue.mNullIsEmptyString.Destroy();
    mType = eUninitialized;
  }
};

class TrustedHTMLOrString : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eTrustedHTML,
    eString
  };
public:
  enum class Type
  {
    eTrustedHTML = TypeOrUninit::eTrustedHTML,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::TrustedHTML> > mTrustedHTML;
    UnionMember<binding_detail::FakeString<char16_t> > mString;

  };

  TypeOrUninit mType;
  Value mValue;

  TrustedHTMLOrString(const TrustedHTMLOrString&) = delete;
  TrustedHTMLOrString& operator=(const TrustedHTMLOrString&) = delete;
public:
  explicit inline TrustedHTMLOrString()
    : mType(eUninitialized)
  {
  }

  inline ~TrustedHTMLOrString()
  {
    Uninit();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::TrustedHTML>&
  RawSetAsTrustedHTML()
  {
    if (mType == eTrustedHTML) {
      return mValue.mTrustedHTML.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eTrustedHTML;
    return mValue.mTrustedHTML.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::TrustedHTML>&
  SetAsTrustedHTML()
  {
    if (mType == eTrustedHTML) {
      return mValue.mTrustedHTML.Value();
    }
    Uninit();
    mType = eTrustedHTML;
    return mValue.mTrustedHTML.SetValue();
  }

  inline bool
  IsTrustedHTML() const
  {
    return mType == eTrustedHTML;
  }

  inline NonNull<mozilla::dom::TrustedHTML>&
  GetAsTrustedHTML()
  {
    MOZ_RELEASE_ASSERT(IsTrustedHTML(), "Wrong type!");
    return mValue.mTrustedHTML.Value();
  }

  inline mozilla::dom::TrustedHTML&
  GetAsTrustedHTML() const
  {
    MOZ_RELEASE_ASSERT(IsTrustedHTML(), "Wrong type!");
    return mValue.mTrustedHTML.Value();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eTrustedHTML: {
        DestroyTrustedHTML();
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToTrustedHTML(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToTrustedHTML(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyTrustedHTML()
  {
    MOZ_RELEASE_ASSERT(IsTrustedHTML(), "Wrong type!");
    mValue.mTrustedHTML.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }
};

class TrustedScriptURLOrString : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eTrustedScriptURL,
    eString
  };
public:
  enum class Type
  {
    eTrustedScriptURL = TypeOrUninit::eTrustedScriptURL,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::TrustedScriptURL> > mTrustedScriptURL;
    UnionMember<binding_detail::FakeString<char16_t> > mString;

  };

  TypeOrUninit mType;
  Value mValue;

  TrustedScriptURLOrString(const TrustedScriptURLOrString&) = delete;
  TrustedScriptURLOrString& operator=(const TrustedScriptURLOrString&) = delete;
public:
  explicit inline TrustedScriptURLOrString()
    : mType(eUninitialized)
  {
  }

  inline ~TrustedScriptURLOrString()
  {
    Uninit();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::TrustedScriptURL>&
  RawSetAsTrustedScriptURL()
  {
    if (mType == eTrustedScriptURL) {
      return mValue.mTrustedScriptURL.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eTrustedScriptURL;
    return mValue.mTrustedScriptURL.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::TrustedScriptURL>&
  SetAsTrustedScriptURL()
  {
    if (mType == eTrustedScriptURL) {
      return mValue.mTrustedScriptURL.Value();
    }
    Uninit();
    mType = eTrustedScriptURL;
    return mValue.mTrustedScriptURL.SetValue();
  }

  inline bool
  IsTrustedScriptURL() const
  {
    return mType == eTrustedScriptURL;
  }

  inline NonNull<mozilla::dom::TrustedScriptURL>&
  GetAsTrustedScriptURL()
  {
    MOZ_RELEASE_ASSERT(IsTrustedScriptURL(), "Wrong type!");
    return mValue.mTrustedScriptURL.Value();
  }

  inline mozilla::dom::TrustedScriptURL&
  GetAsTrustedScriptURL() const
  {
    MOZ_RELEASE_ASSERT(IsTrustedScriptURL(), "Wrong type!");
    return mValue.mTrustedScriptURL.Value();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eTrustedScriptURL: {
        DestroyTrustedScriptURL();
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToTrustedScriptURL(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToTrustedScriptURL(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyTrustedScriptURL()
  {
    MOZ_RELEASE_ASSERT(IsTrustedScriptURL(), "Wrong type!");
    mValue.mTrustedScriptURL.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }
};

class TrustedScriptURLOrUSVString : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eTrustedScriptURL,
    eUSVString
  };
public:
  enum class Type
  {
    eTrustedScriptURL = TypeOrUninit::eTrustedScriptURL,
    eUSVString = TypeOrUninit::eUSVString
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::TrustedScriptURL> > mTrustedScriptURL;
    UnionMember<binding_detail::FakeString<char16_t> > mUSVString;

  };

  TypeOrUninit mType;
  Value mValue;

  TrustedScriptURLOrUSVString(const TrustedScriptURLOrUSVString&) = delete;
  TrustedScriptURLOrUSVString& operator=(const TrustedScriptURLOrUSVString&) = delete;
public:
  explicit inline TrustedScriptURLOrUSVString()
    : mType(eUninitialized)
  {
  }

  inline ~TrustedScriptURLOrUSVString()
  {
    Uninit();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::TrustedScriptURL>&
  RawSetAsTrustedScriptURL()
  {
    if (mType == eTrustedScriptURL) {
      return mValue.mTrustedScriptURL.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eTrustedScriptURL;
    return mValue.mTrustedScriptURL.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::TrustedScriptURL>&
  SetAsTrustedScriptURL()
  {
    if (mType == eTrustedScriptURL) {
      return mValue.mTrustedScriptURL.Value();
    }
    Uninit();
    mType = eTrustedScriptURL;
    return mValue.mTrustedScriptURL.SetValue();
  }

  inline bool
  IsTrustedScriptURL() const
  {
    return mType == eTrustedScriptURL;
  }

  inline NonNull<mozilla::dom::TrustedScriptURL>&
  GetAsTrustedScriptURL()
  {
    MOZ_RELEASE_ASSERT(IsTrustedScriptURL(), "Wrong type!");
    return mValue.mTrustedScriptURL.Value();
  }

  inline mozilla::dom::TrustedScriptURL&
  GetAsTrustedScriptURL() const
  {
    MOZ_RELEASE_ASSERT(IsTrustedScriptURL(), "Wrong type!");
    return mValue.mTrustedScriptURL.Value();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  RawSetAsUSVString()
  {
    if (mType == eUSVString) {
      return mValue.mUSVString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUSVString;
    return mValue.mUSVString.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  SetAsUSVString()
  {
    if (mType == eUSVString) {
      return mValue.mUSVString.Value();
    }
    Uninit();
    mType = eUSVString;
    return mValue.mUSVString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsUSVString().AssignLiteral(aData);
  }

  inline bool
  IsUSVString() const
  {
    return mType == eUSVString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsUSVString()
  {
    MOZ_RELEASE_ASSERT(IsUSVString(), "Wrong type!");
    return mValue.mUSVString.Value();
  }

  inline const nsAString&
  GetAsUSVString() const
  {
    MOZ_RELEASE_ASSERT(IsUSVString(), "Wrong type!");
    return mValue.mUSVString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eTrustedScriptURL: {
        DestroyTrustedScriptURL();
        break;
      }
      case eUSVString: {
        DestroyUSVString();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToTrustedScriptURL(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToTrustedScriptURL(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyTrustedScriptURL()
  {
    MOZ_RELEASE_ASSERT(IsTrustedScriptURL(), "Wrong type!");
    mValue.mTrustedScriptURL.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToUSVString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUSVString()
  {
    MOZ_RELEASE_ASSERT(IsUSVString(), "Wrong type!");
    mValue.mUSVString.Destroy();
    mType = eUninitialized;
  }
};

class UTF8StringOrArrayBuffer : public AllUnionBase,
                                public UnionWithTypedArraysBase
{
public:
  using ApplyToTypedArrays = binding_detail::ApplyToTypedArraysHelper<UTF8StringOrArrayBuffer, true, ArrayBuffer>;

private:
  enum TypeOrUninit
  {
    eUninitialized,
    eUTF8String,
    eArrayBuffer
  };
public:
  enum class Type
  {
    eUTF8String = TypeOrUninit::eUTF8String,
    eArrayBuffer = TypeOrUninit::eArrayBuffer
  };

private:
  union Value
  {
    UnionMember<binding_detail::FakeString<char> > mUTF8String;
    UnionMember<RootedSpiderMonkeyInterface<ArrayBuffer> > mArrayBuffer;

  };

  TypeOrUninit mType;
  Value mValue;

  UTF8StringOrArrayBuffer(const UTF8StringOrArrayBuffer&) = delete;
  UTF8StringOrArrayBuffer& operator=(const UTF8StringOrArrayBuffer&) = delete;
public:
  explicit inline UTF8StringOrArrayBuffer()
    : mType(eUninitialized)
  {
  }

  inline ~UTF8StringOrArrayBuffer()
  {
    Uninit();
  }

  [[nodiscard]] inline binding_detail::FakeString<char>&
  RawSetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char>&
  SetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    Uninit();
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline binding_detail::FakeString<char>&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline const nsACString&
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  RawSetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  SetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    Uninit();
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  GetAsArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eUTF8String: {
        DestroyUTF8String();
        break;
      }
      case eArrayBuffer: {
        DestroyArrayBuffer();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    mValue.mUTF8String.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToArrayBuffer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBuffer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    mValue.mArrayBuffer.Destroy();
    mType = eUninitialized;
  }
};

class UTF8StringOrArrayBufferOrNull : public AllUnionBase,
                                      public UnionWithTypedArraysBase
{
public:
  using ApplyToTypedArrays = binding_detail::ApplyToTypedArraysHelper<UTF8StringOrArrayBufferOrNull, true, ArrayBuffer>;

private:
  enum TypeOrUninit
  {
    eUninitialized,
    eNull,
    eUTF8String,
    eArrayBuffer
  };
public:
  enum class Type
  {
    eNull = TypeOrUninit::eNull,
    eUTF8String = TypeOrUninit::eUTF8String,
    eArrayBuffer = TypeOrUninit::eArrayBuffer
  };

private:
  union Value
  {
    UnionMember<binding_detail::FakeString<char> > mUTF8String;
    UnionMember<RootedSpiderMonkeyInterface<ArrayBuffer> > mArrayBuffer;

  };

  TypeOrUninit mType;
  Value mValue;

  UTF8StringOrArrayBufferOrNull(const UTF8StringOrArrayBufferOrNull&) = delete;
  UTF8StringOrArrayBufferOrNull& operator=(const UTF8StringOrArrayBufferOrNull&) = delete;
public:
  explicit inline UTF8StringOrArrayBufferOrNull()
    : mType(eUninitialized)
  {
  }

  inline ~UTF8StringOrArrayBufferOrNull()
  {
    Uninit();
  }

  inline bool
  IsNull() const
  {
    return mType == eNull;
  }

  inline void
  SetNull()
  {
    Uninit();
    mType = eNull;
  }

  [[nodiscard]] inline binding_detail::FakeString<char>&
  RawSetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char>&
  SetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    Uninit();
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline binding_detail::FakeString<char>&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline const nsACString&
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  RawSetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  SetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    Uninit();
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  GetAsArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eNull: {
        break;
      }
      case eUTF8String: {
        DestroyUTF8String();
        break;
      }
      case eArrayBuffer: {
        DestroyArrayBuffer();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    mValue.mUTF8String.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToArrayBuffer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBuffer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    mValue.mArrayBuffer.Destroy();
    mType = eUninitialized;
  }
};

class UTF8StringOrLong : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eUTF8String,
    eLong
  };
public:
  enum class Type
  {
    eUTF8String = TypeOrUninit::eUTF8String,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<binding_detail::FakeString<char> > mUTF8String;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

  UTF8StringOrLong(const UTF8StringOrLong&) = delete;
  UTF8StringOrLong& operator=(const UTF8StringOrLong&) = delete;
public:
  explicit inline UTF8StringOrLong()
    : mType(eUninitialized)
  {
  }

  inline ~UTF8StringOrLong()
  {
    Uninit();
  }

  [[nodiscard]] inline binding_detail::FakeString<char>&
  RawSetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char>&
  SetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    Uninit();
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline binding_detail::FakeString<char>&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline const nsACString&
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  [[nodiscard]] inline int32_t&
  RawSetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  [[nodiscard]] inline int32_t&
  SetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    Uninit();
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eUTF8String: {
        DestroyUTF8String();
        break;
      }
      case eLong: {
        DestroyLong();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    mValue.mUTF8String.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    mValue.mLong.Destroy();
    mType = eUninitialized;
  }
};

class UTF8StringOrUTF8StringSequence : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eUTF8String,
    eUTF8StringSequence
  };
public:
  enum class Type
  {
    eUTF8String = TypeOrUninit::eUTF8String,
    eUTF8StringSequence = TypeOrUninit::eUTF8StringSequence
  };

private:
  union Value
  {
    UnionMember<binding_detail::FakeString<char> > mUTF8String;
    UnionMember<binding_detail::AutoSequence<nsCString> > mUTF8StringSequence;

  };

  TypeOrUninit mType;
  Value mValue;

  UTF8StringOrUTF8StringSequence(const UTF8StringOrUTF8StringSequence&) = delete;
  UTF8StringOrUTF8StringSequence& operator=(const UTF8StringOrUTF8StringSequence&) = delete;
public:
  explicit inline UTF8StringOrUTF8StringSequence()
    : mType(eUninitialized)
  {
  }

  inline ~UTF8StringOrUTF8StringSequence()
  {
    Uninit();
  }

  [[nodiscard]] inline binding_detail::FakeString<char>&
  RawSetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char>&
  SetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    Uninit();
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline binding_detail::FakeString<char>&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline const nsACString&
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  [[nodiscard]] inline binding_detail::AutoSequence<nsCString>&
  RawSetAsUTF8StringSequence()
  {
    if (mType == eUTF8StringSequence) {
      return mValue.mUTF8StringSequence.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUTF8StringSequence;
    return mValue.mUTF8StringSequence.SetValue();
  }

  [[nodiscard]] inline binding_detail::AutoSequence<nsCString>&
  SetAsUTF8StringSequence()
  {
    if (mType == eUTF8StringSequence) {
      return mValue.mUTF8StringSequence.Value();
    }
    Uninit();
    mType = eUTF8StringSequence;
    return mValue.mUTF8StringSequence.SetValue();
  }

  inline bool
  IsUTF8StringSequence() const
  {
    return mType == eUTF8StringSequence;
  }

  inline binding_detail::AutoSequence<nsCString>&
  GetAsUTF8StringSequence()
  {
    MOZ_RELEASE_ASSERT(IsUTF8StringSequence(), "Wrong type!");
    return mValue.mUTF8StringSequence.Value();
  }

  inline const Sequence<nsCString>&
  GetAsUTF8StringSequence() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8StringSequence(), "Wrong type!");
    return mValue.mUTF8StringSequence.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eUTF8String: {
        DestroyUTF8String();
        break;
      }
      case eUTF8StringSequence: {
        DestroyUTF8StringSequence();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    mValue.mUTF8String.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToUTF8StringSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToUTF8StringSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUTF8StringSequence()
  {
    MOZ_RELEASE_ASSERT(IsUTF8StringSequence(), "Wrong type!");
    mValue.mUTF8StringSequence.Destroy();
    mType = eUninitialized;
  }
};

class UndefinedOrCanvasPattern : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eUndefined,
    eCanvasPattern
  };
public:
  enum class Type
  {
    eUndefined = TypeOrUninit::eUndefined,
    eCanvasPattern = TypeOrUninit::eCanvasPattern
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::CanvasPattern> > mCanvasPattern;

  };

  TypeOrUninit mType;
  Value mValue;

  UndefinedOrCanvasPattern(const UndefinedOrCanvasPattern&) = delete;
  UndefinedOrCanvasPattern& operator=(const UndefinedOrCanvasPattern&) = delete;
public:
  explicit inline UndefinedOrCanvasPattern()
    : mType(eUninitialized)
  {
  }

  inline ~UndefinedOrCanvasPattern()
  {
    Uninit();
  }

  inline bool
  IsUndefined() const
  {
    return mType == eUndefined;
  }

  inline void
  SetUndefined()
  {
    Uninit();
    mType = eUndefined;
  }

  [[nodiscard]] inline NonNull<mozilla::dom::CanvasPattern>&
  RawSetAsCanvasPattern()
  {
    if (mType == eCanvasPattern) {
      return mValue.mCanvasPattern.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eCanvasPattern;
    return mValue.mCanvasPattern.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::CanvasPattern>&
  SetAsCanvasPattern()
  {
    if (mType == eCanvasPattern) {
      return mValue.mCanvasPattern.Value();
    }
    Uninit();
    mType = eCanvasPattern;
    return mValue.mCanvasPattern.SetValue();
  }

  inline bool
  IsCanvasPattern() const
  {
    return mType == eCanvasPattern;
  }

  inline NonNull<mozilla::dom::CanvasPattern>&
  GetAsCanvasPattern()
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    return mValue.mCanvasPattern.Value();
  }

  inline mozilla::dom::CanvasPattern&
  GetAsCanvasPattern() const
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    return mValue.mCanvasPattern.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eUndefined: {
        break;
      }
      case eCanvasPattern: {
        DestroyCanvasPattern();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToCanvasPattern(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCanvasPattern(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyCanvasPattern()
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    mValue.mCanvasPattern.Destroy();
    mType = eUninitialized;
  }
};

class UndefinedOrCanvasPatternOrNull : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eNull,
    eUndefined,
    eCanvasPattern
  };
public:
  enum class Type
  {
    eNull = TypeOrUninit::eNull,
    eUndefined = TypeOrUninit::eUndefined,
    eCanvasPattern = TypeOrUninit::eCanvasPattern
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::CanvasPattern> > mCanvasPattern;

  };

  TypeOrUninit mType;
  Value mValue;

  UndefinedOrCanvasPatternOrNull(const UndefinedOrCanvasPatternOrNull&) = delete;
  UndefinedOrCanvasPatternOrNull& operator=(const UndefinedOrCanvasPatternOrNull&) = delete;
public:
  explicit inline UndefinedOrCanvasPatternOrNull()
    : mType(eUninitialized)
  {
  }

  inline ~UndefinedOrCanvasPatternOrNull()
  {
    Uninit();
  }

  inline bool
  IsNull() const
  {
    return mType == eNull;
  }

  inline void
  SetNull()
  {
    Uninit();
    mType = eNull;
  }

  inline bool
  IsUndefined() const
  {
    return mType == eUndefined;
  }

  inline void
  SetUndefined()
  {
    Uninit();
    mType = eUndefined;
  }

  [[nodiscard]] inline NonNull<mozilla::dom::CanvasPattern>&
  RawSetAsCanvasPattern()
  {
    if (mType == eCanvasPattern) {
      return mValue.mCanvasPattern.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eCanvasPattern;
    return mValue.mCanvasPattern.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::CanvasPattern>&
  SetAsCanvasPattern()
  {
    if (mType == eCanvasPattern) {
      return mValue.mCanvasPattern.Value();
    }
    Uninit();
    mType = eCanvasPattern;
    return mValue.mCanvasPattern.SetValue();
  }

  inline bool
  IsCanvasPattern() const
  {
    return mType == eCanvasPattern;
  }

  inline NonNull<mozilla::dom::CanvasPattern>&
  GetAsCanvasPattern()
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    return mValue.mCanvasPattern.Value();
  }

  inline mozilla::dom::CanvasPattern&
  GetAsCanvasPattern() const
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    return mValue.mCanvasPattern.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eNull: {
        break;
      }
      case eUndefined: {
        break;
      }
      case eCanvasPattern: {
        DestroyCanvasPattern();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToCanvasPattern(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCanvasPattern(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyCanvasPattern()
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    mValue.mCanvasPattern.Destroy();
    mType = eUninitialized;
  }
};

class UndefinedOrNullOrCanvasPattern : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eNull,
    eUndefined,
    eCanvasPattern
  };
public:
  enum class Type
  {
    eNull = TypeOrUninit::eNull,
    eUndefined = TypeOrUninit::eUndefined,
    eCanvasPattern = TypeOrUninit::eCanvasPattern
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::CanvasPattern> > mCanvasPattern;

  };

  TypeOrUninit mType;
  Value mValue;

  UndefinedOrNullOrCanvasPattern(const UndefinedOrNullOrCanvasPattern&) = delete;
  UndefinedOrNullOrCanvasPattern& operator=(const UndefinedOrNullOrCanvasPattern&) = delete;
public:
  explicit inline UndefinedOrNullOrCanvasPattern()
    : mType(eUninitialized)
  {
  }

  inline ~UndefinedOrNullOrCanvasPattern()
  {
    Uninit();
  }

  inline bool
  IsNull() const
  {
    return mType == eNull;
  }

  inline void
  SetNull()
  {
    Uninit();
    mType = eNull;
  }

  inline bool
  IsUndefined() const
  {
    return mType == eUndefined;
  }

  inline void
  SetUndefined()
  {
    Uninit();
    mType = eUndefined;
  }

  [[nodiscard]] inline NonNull<mozilla::dom::CanvasPattern>&
  RawSetAsCanvasPattern()
  {
    if (mType == eCanvasPattern) {
      return mValue.mCanvasPattern.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eCanvasPattern;
    return mValue.mCanvasPattern.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::CanvasPattern>&
  SetAsCanvasPattern()
  {
    if (mType == eCanvasPattern) {
      return mValue.mCanvasPattern.Value();
    }
    Uninit();
    mType = eCanvasPattern;
    return mValue.mCanvasPattern.SetValue();
  }

  inline bool
  IsCanvasPattern() const
  {
    return mType == eCanvasPattern;
  }

  inline NonNull<mozilla::dom::CanvasPattern>&
  GetAsCanvasPattern()
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    return mValue.mCanvasPattern.Value();
  }

  inline mozilla::dom::CanvasPattern&
  GetAsCanvasPattern() const
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    return mValue.mCanvasPattern.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eNull: {
        break;
      }
      case eUndefined: {
        break;
      }
      case eCanvasPattern: {
        DestroyCanvasPattern();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToCanvasPattern(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCanvasPattern(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyCanvasPattern()
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    mValue.mCanvasPattern.Destroy();
    mType = eUninitialized;
  }
};

class UnrestrictedDoubleOrString : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eUnrestrictedDouble,
    eString
  };
public:
  enum class Type
  {
    eUnrestrictedDouble = TypeOrUninit::eUnrestrictedDouble,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<double > mUnrestrictedDouble;
    UnionMember<binding_detail::FakeString<char16_t> > mString;

  };

  TypeOrUninit mType;
  Value mValue;

  UnrestrictedDoubleOrString(const UnrestrictedDoubleOrString&) = delete;
  UnrestrictedDoubleOrString& operator=(const UnrestrictedDoubleOrString&) = delete;
public:
  explicit inline UnrestrictedDoubleOrString()
    : mType(eUninitialized)
  {
  }

  inline ~UnrestrictedDoubleOrString()
  {
    Uninit();
  }

  [[nodiscard]] inline double&
  RawSetAsUnrestrictedDouble()
  {
    if (mType == eUnrestrictedDouble) {
      return mValue.mUnrestrictedDouble.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUnrestrictedDouble;
    return mValue.mUnrestrictedDouble.SetValue();
  }

  [[nodiscard]] inline double&
  SetAsUnrestrictedDouble()
  {
    if (mType == eUnrestrictedDouble) {
      return mValue.mUnrestrictedDouble.Value();
    }
    Uninit();
    mType = eUnrestrictedDouble;
    return mValue.mUnrestrictedDouble.SetValue();
  }

  inline bool
  IsUnrestrictedDouble() const
  {
    return mType == eUnrestrictedDouble;
  }

  inline double&
  GetAsUnrestrictedDouble()
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    return mValue.mUnrestrictedDouble.Value();
  }

  inline double
  GetAsUnrestrictedDouble() const
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    return mValue.mUnrestrictedDouble.Value();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eUnrestrictedDouble: {
        DestroyUnrestrictedDouble();
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToUnrestrictedDouble(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUnrestrictedDouble()
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    mValue.mUnrestrictedDouble.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }
};

class UnrestrictedFloatOrString : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eUnrestrictedFloat,
    eString
  };
public:
  enum class Type
  {
    eUnrestrictedFloat = TypeOrUninit::eUnrestrictedFloat,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<float > mUnrestrictedFloat;
    UnionMember<binding_detail::FakeString<char16_t> > mString;

  };

  TypeOrUninit mType;
  Value mValue;

  UnrestrictedFloatOrString(const UnrestrictedFloatOrString&) = delete;
  UnrestrictedFloatOrString& operator=(const UnrestrictedFloatOrString&) = delete;
public:
  explicit inline UnrestrictedFloatOrString()
    : mType(eUninitialized)
  {
  }

  inline ~UnrestrictedFloatOrString()
  {
    Uninit();
  }

  [[nodiscard]] inline float&
  RawSetAsUnrestrictedFloat()
  {
    if (mType == eUnrestrictedFloat) {
      return mValue.mUnrestrictedFloat.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUnrestrictedFloat;
    return mValue.mUnrestrictedFloat.SetValue();
  }

  [[nodiscard]] inline float&
  SetAsUnrestrictedFloat()
  {
    if (mType == eUnrestrictedFloat) {
      return mValue.mUnrestrictedFloat.Value();
    }
    Uninit();
    mType = eUnrestrictedFloat;
    return mValue.mUnrestrictedFloat.SetValue();
  }

  inline bool
  IsUnrestrictedFloat() const
  {
    return mType == eUnrestrictedFloat;
  }

  inline float&
  GetAsUnrestrictedFloat()
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedFloat(), "Wrong type!");
    return mValue.mUnrestrictedFloat.Value();
  }

  inline float
  GetAsUnrestrictedFloat() const
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedFloat(), "Wrong type!");
    return mValue.mUnrestrictedFloat.Value();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eUnrestrictedFloat: {
        DestroyUnrestrictedFloat();
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToUnrestrictedFloat(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUnrestrictedFloat()
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedFloat(), "Wrong type!");
    mValue.mUnrestrictedFloat.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }
};

class OwningArrayBufferViewOrArrayBuffer : public AllOwningUnionBase,
                                           public UnionWithTypedArraysBase
{
public:
  using ApplyToTypedArrays = binding_detail::ApplyToTypedArraysHelper<OwningArrayBufferViewOrArrayBuffer, false, ArrayBufferView, ArrayBuffer>;

private:
  enum TypeOrUninit
  {
    eUninitialized,
    eArrayBufferView,
    eArrayBuffer
  };
public:
  enum class Type
  {
    eArrayBufferView = TypeOrUninit::eArrayBufferView,
    eArrayBuffer = TypeOrUninit::eArrayBuffer
  };

private:
  union Value
  {
    UnionMember<ArrayBufferView > mArrayBufferView;
    UnionMember<ArrayBuffer > mArrayBuffer;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningArrayBufferViewOrArrayBuffer(const OwningArrayBufferViewOrArrayBuffer&) = delete;
  OwningArrayBufferViewOrArrayBuffer& operator=(const OwningArrayBufferViewOrArrayBuffer&) = delete;
public:
  explicit inline OwningArrayBufferViewOrArrayBuffer()
    : mType(eUninitialized)
  {
  }

  OwningArrayBufferViewOrArrayBuffer(OwningArrayBufferViewOrArrayBuffer&& aOther);

  inline ~OwningArrayBufferViewOrArrayBuffer()
  {
    Uninit();
  }

  [[nodiscard]] ArrayBufferView&
  RawSetAsArrayBufferView();

  [[nodiscard]] ArrayBufferView&
  SetAsArrayBufferView();

  inline bool
  IsArrayBufferView() const
  {
    return mType == eArrayBufferView;
  }

  inline ArrayBufferView&
  GetAsArrayBufferView()
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  inline ArrayBufferView const &
  GetAsArrayBufferView() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  [[nodiscard]] ArrayBuffer&
  RawSetAsArrayBuffer();

  [[nodiscard]] ArrayBuffer&
  SetAsArrayBuffer();

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline ArrayBuffer&
  GetAsArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningArrayBufferViewOrArrayBuffer&
  operator=(OwningArrayBufferViewOrArrayBuffer&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToArrayBufferView(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBufferView(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyArrayBufferView();

  bool
  TrySetToArrayBuffer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBuffer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyArrayBuffer();
};

class OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String : public AllOwningUnionBase,
                                                             public UnionWithTypedArraysBase
{
  friend void ImplCycleCollectionUnlink(OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String& aUnion);
public:
  using ApplyToTypedArrays = binding_detail::ApplyToTypedArraysHelper<OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String, true, ArrayBufferView, ArrayBuffer>;

private:
  enum TypeOrUninit
  {
    eUninitialized,
    eArrayBufferView,
    eArrayBuffer,
    eBlob,
    eUTF8String
  };
public:
  enum class Type
  {
    eArrayBufferView = TypeOrUninit::eArrayBufferView,
    eArrayBuffer = TypeOrUninit::eArrayBuffer,
    eBlob = TypeOrUninit::eBlob,
    eUTF8String = TypeOrUninit::eUTF8String
  };

private:
  union Value
  {
    UnionMember<ArrayBufferView > mArrayBufferView;
    UnionMember<ArrayBuffer > mArrayBuffer;
    UnionMember<OwningNonNull<mozilla::dom::Blob> > mBlob;
    UnionMember<nsCString > mUTF8String;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String(const OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String&) = delete;
  OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String& operator=(const OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String&) = delete;
public:
  explicit inline OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String()
    : mType(eUninitialized)
  {
  }

  OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String(OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String&& aOther);

  inline ~OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String()
  {
    Uninit();
  }

  [[nodiscard]] ArrayBufferView&
  RawSetAsArrayBufferView();

  [[nodiscard]] ArrayBufferView&
  SetAsArrayBufferView();

  inline bool
  IsArrayBufferView() const
  {
    return mType == eArrayBufferView;
  }

  inline ArrayBufferView&
  GetAsArrayBufferView()
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  inline ArrayBufferView const &
  GetAsArrayBufferView() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  [[nodiscard]] ArrayBuffer&
  RawSetAsArrayBuffer();

  [[nodiscard]] ArrayBuffer&
  SetAsArrayBuffer();

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline ArrayBuffer&
  GetAsArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::Blob>&
  RawSetAsBlob();

  [[nodiscard]] OwningNonNull<mozilla::dom::Blob>&
  SetAsBlob();

  inline bool
  IsBlob() const
  {
    return mType == eBlob;
  }

  inline OwningNonNull<mozilla::dom::Blob>&
  GetAsBlob()
  {
    MOZ_RELEASE_ASSERT(IsBlob(), "Wrong type!");
    return mValue.mBlob.Value();
  }

  inline OwningNonNull<mozilla::dom::Blob> const &
  GetAsBlob() const
  {
    MOZ_RELEASE_ASSERT(IsBlob(), "Wrong type!");
    return mValue.mBlob.Value();
  }

  [[nodiscard]] nsCString&
  RawSetAsUTF8String();

  [[nodiscard]] nsCString&
  SetAsUTF8String();

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline nsCString&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline nsCString const &
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String&
  operator=(OwningArrayBufferViewOrArrayBufferOrBlobOrUTF8String&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToArrayBufferView(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBufferView(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyArrayBufferView();

  bool
  TrySetToArrayBuffer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBuffer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyArrayBuffer();

  bool
  TrySetToBlob(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToBlob(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyBlob();

  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUTF8String();
};

class OwningArrayBufferViewOrArrayBufferOrNull : public AllOwningUnionBase,
                                                 public UnionWithTypedArraysBase
{
public:
  using ApplyToTypedArrays = binding_detail::ApplyToTypedArraysHelper<OwningArrayBufferViewOrArrayBufferOrNull, true, ArrayBufferView, ArrayBuffer>;

private:
  enum TypeOrUninit
  {
    eUninitialized,
    eNull,
    eArrayBufferView,
    eArrayBuffer
  };
public:
  enum class Type
  {
    eNull = TypeOrUninit::eNull,
    eArrayBufferView = TypeOrUninit::eArrayBufferView,
    eArrayBuffer = TypeOrUninit::eArrayBuffer
  };

private:
  union Value
  {
    UnionMember<ArrayBufferView > mArrayBufferView;
    UnionMember<ArrayBuffer > mArrayBuffer;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningArrayBufferViewOrArrayBufferOrNull(const OwningArrayBufferViewOrArrayBufferOrNull&) = delete;
  OwningArrayBufferViewOrArrayBufferOrNull& operator=(const OwningArrayBufferViewOrArrayBufferOrNull&) = delete;
public:
  explicit inline OwningArrayBufferViewOrArrayBufferOrNull()
    : mType(eUninitialized)
  {
  }

  OwningArrayBufferViewOrArrayBufferOrNull(OwningArrayBufferViewOrArrayBufferOrNull&& aOther);

  inline ~OwningArrayBufferViewOrArrayBufferOrNull()
  {
    Uninit();
  }

  inline bool
  IsNull() const
  {
    return mType == eNull;
  }

  inline void
  SetNull()
  {
    Uninit();
    mType = eNull;
  }

  [[nodiscard]] ArrayBufferView&
  RawSetAsArrayBufferView();

  [[nodiscard]] ArrayBufferView&
  SetAsArrayBufferView();

  inline bool
  IsArrayBufferView() const
  {
    return mType == eArrayBufferView;
  }

  inline ArrayBufferView&
  GetAsArrayBufferView()
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  inline ArrayBufferView const &
  GetAsArrayBufferView() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  [[nodiscard]] ArrayBuffer&
  RawSetAsArrayBuffer();

  [[nodiscard]] ArrayBuffer&
  SetAsArrayBuffer();

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline ArrayBuffer&
  GetAsArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningArrayBufferViewOrArrayBufferOrNull&
  operator=(OwningArrayBufferViewOrArrayBufferOrNull&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToArrayBufferView(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBufferView(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyArrayBufferView();

  bool
  TrySetToArrayBuffer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBuffer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyArrayBuffer();
};

class OwningByteStringOrLong : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eByteString,
    eLong
  };
public:
  enum class Type
  {
    eByteString = TypeOrUninit::eByteString,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<nsCString > mByteString;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningByteStringOrLong()
    : mType(eUninitialized)
  {
  }

  OwningByteStringOrLong(OwningByteStringOrLong&& aOther);

  explicit inline OwningByteStringOrLong(const OwningByteStringOrLong& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningByteStringOrLong()
  {
    Uninit();
  }

  [[nodiscard]] nsCString&
  RawSetAsByteString();

  [[nodiscard]] nsCString&
  SetAsByteString();

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsByteString().AssignLiteral(aData);
  }

  inline bool
  IsByteString() const
  {
    return mType == eByteString;
  }

  inline nsCString&
  GetAsByteString()
  {
    MOZ_RELEASE_ASSERT(IsByteString(), "Wrong type!");
    return mValue.mByteString.Value();
  }

  inline nsCString const &
  GetAsByteString() const
  {
    MOZ_RELEASE_ASSERT(IsByteString(), "Wrong type!");
    return mValue.mByteString.Value();
  }

  [[nodiscard]] int32_t&
  RawSetAsLong();

  [[nodiscard]] int32_t&
  SetAsLong();

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t const &
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningByteStringOrLong&
  operator=(OwningByteStringOrLong&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningByteStringOrLong&
  operator=(const OwningByteStringOrLong& aOther);

private:
  bool
  TrySetToByteString(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToByteString(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyByteString();

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyLong();
};

class OwningCanvasPatternOrCanvasGradient : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningCanvasPatternOrCanvasGradient& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eCanvasPattern,
    eCanvasGradient
  };
public:
  enum class Type
  {
    eCanvasPattern = TypeOrUninit::eCanvasPattern,
    eCanvasGradient = TypeOrUninit::eCanvasGradient
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::CanvasPattern> > mCanvasPattern;
    UnionMember<OwningNonNull<mozilla::dom::CanvasGradient> > mCanvasGradient;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningCanvasPatternOrCanvasGradient()
    : mType(eUninitialized)
  {
  }

  OwningCanvasPatternOrCanvasGradient(OwningCanvasPatternOrCanvasGradient&& aOther);

  explicit inline OwningCanvasPatternOrCanvasGradient(const OwningCanvasPatternOrCanvasGradient& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningCanvasPatternOrCanvasGradient()
  {
    Uninit();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::CanvasPattern>&
  RawSetAsCanvasPattern();

  [[nodiscard]] OwningNonNull<mozilla::dom::CanvasPattern>&
  SetAsCanvasPattern();

  inline bool
  IsCanvasPattern() const
  {
    return mType == eCanvasPattern;
  }

  inline OwningNonNull<mozilla::dom::CanvasPattern>&
  GetAsCanvasPattern()
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    return mValue.mCanvasPattern.Value();
  }

  inline OwningNonNull<mozilla::dom::CanvasPattern> const &
  GetAsCanvasPattern() const
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    return mValue.mCanvasPattern.Value();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::CanvasGradient>&
  RawSetAsCanvasGradient();

  [[nodiscard]] OwningNonNull<mozilla::dom::CanvasGradient>&
  SetAsCanvasGradient();

  inline bool
  IsCanvasGradient() const
  {
    return mType == eCanvasGradient;
  }

  inline OwningNonNull<mozilla::dom::CanvasGradient>&
  GetAsCanvasGradient()
  {
    MOZ_RELEASE_ASSERT(IsCanvasGradient(), "Wrong type!");
    return mValue.mCanvasGradient.Value();
  }

  inline OwningNonNull<mozilla::dom::CanvasGradient> const &
  GetAsCanvasGradient() const
  {
    MOZ_RELEASE_ASSERT(IsCanvasGradient(), "Wrong type!");
    return mValue.mCanvasGradient.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningCanvasPatternOrCanvasGradient&
  operator=(OwningCanvasPatternOrCanvasGradient&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningCanvasPatternOrCanvasGradient&
  operator=(const OwningCanvasPatternOrCanvasGradient& aOther);

private:
  bool
  TrySetToCanvasPattern(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCanvasPattern(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyCanvasPattern();

  bool
  TrySetToCanvasGradient(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCanvasGradient(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyCanvasGradient();
};

class OwningCanvasPatternOrNullOrCanvasGradient : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningCanvasPatternOrNullOrCanvasGradient& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eNull,
    eCanvasPattern,
    eCanvasGradient
  };
public:
  enum class Type
  {
    eNull = TypeOrUninit::eNull,
    eCanvasPattern = TypeOrUninit::eCanvasPattern,
    eCanvasGradient = TypeOrUninit::eCanvasGradient
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::CanvasPattern> > mCanvasPattern;
    UnionMember<OwningNonNull<mozilla::dom::CanvasGradient> > mCanvasGradient;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningCanvasPatternOrNullOrCanvasGradient()
    : mType(eUninitialized)
  {
  }

  OwningCanvasPatternOrNullOrCanvasGradient(OwningCanvasPatternOrNullOrCanvasGradient&& aOther);

  explicit inline OwningCanvasPatternOrNullOrCanvasGradient(const OwningCanvasPatternOrNullOrCanvasGradient& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningCanvasPatternOrNullOrCanvasGradient()
  {
    Uninit();
  }

  inline bool
  IsNull() const
  {
    return mType == eNull;
  }

  inline void
  SetNull()
  {
    Uninit();
    mType = eNull;
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::CanvasPattern>&
  RawSetAsCanvasPattern();

  [[nodiscard]] OwningNonNull<mozilla::dom::CanvasPattern>&
  SetAsCanvasPattern();

  inline bool
  IsCanvasPattern() const
  {
    return mType == eCanvasPattern;
  }

  inline OwningNonNull<mozilla::dom::CanvasPattern>&
  GetAsCanvasPattern()
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    return mValue.mCanvasPattern.Value();
  }

  inline OwningNonNull<mozilla::dom::CanvasPattern> const &
  GetAsCanvasPattern() const
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    return mValue.mCanvasPattern.Value();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::CanvasGradient>&
  RawSetAsCanvasGradient();

  [[nodiscard]] OwningNonNull<mozilla::dom::CanvasGradient>&
  SetAsCanvasGradient();

  inline bool
  IsCanvasGradient() const
  {
    return mType == eCanvasGradient;
  }

  inline OwningNonNull<mozilla::dom::CanvasGradient>&
  GetAsCanvasGradient()
  {
    MOZ_RELEASE_ASSERT(IsCanvasGradient(), "Wrong type!");
    return mValue.mCanvasGradient.Value();
  }

  inline OwningNonNull<mozilla::dom::CanvasGradient> const &
  GetAsCanvasGradient() const
  {
    MOZ_RELEASE_ASSERT(IsCanvasGradient(), "Wrong type!");
    return mValue.mCanvasGradient.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningCanvasPatternOrNullOrCanvasGradient&
  operator=(OwningCanvasPatternOrNullOrCanvasGradient&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningCanvasPatternOrNullOrCanvasGradient&
  operator=(const OwningCanvasPatternOrNullOrCanvasGradient& aOther);

private:
  bool
  TrySetToCanvasPattern(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCanvasPattern(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyCanvasPattern();

  bool
  TrySetToCanvasGradient(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCanvasGradient(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyCanvasGradient();
};

class OwningDoubleOrByteString : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eDouble,
    eByteString
  };
public:
  enum class Type
  {
    eDouble = TypeOrUninit::eDouble,
    eByteString = TypeOrUninit::eByteString
  };

private:
  union Value
  {
    UnionMember<double > mDouble;
    UnionMember<nsCString > mByteString;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningDoubleOrByteString()
    : mType(eUninitialized)
  {
  }

  OwningDoubleOrByteString(OwningDoubleOrByteString&& aOther);

  explicit inline OwningDoubleOrByteString(const OwningDoubleOrByteString& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningDoubleOrByteString()
  {
    Uninit();
  }

  [[nodiscard]] double&
  RawSetAsDouble();

  [[nodiscard]] double&
  SetAsDouble();

  inline bool
  IsDouble() const
  {
    return mType == eDouble;
  }

  inline double&
  GetAsDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  inline double const &
  GetAsDouble() const
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  [[nodiscard]] nsCString&
  RawSetAsByteString();

  [[nodiscard]] nsCString&
  SetAsByteString();

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsByteString().AssignLiteral(aData);
  }

  inline bool
  IsByteString() const
  {
    return mType == eByteString;
  }

  inline nsCString&
  GetAsByteString()
  {
    MOZ_RELEASE_ASSERT(IsByteString(), "Wrong type!");
    return mValue.mByteString.Value();
  }

  inline nsCString const &
  GetAsByteString() const
  {
    MOZ_RELEASE_ASSERT(IsByteString(), "Wrong type!");
    return mValue.mByteString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningDoubleOrByteString&
  operator=(OwningDoubleOrByteString&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningDoubleOrByteString&
  operator=(const OwningDoubleOrByteString& aOther);

private:
  bool
  TrySetToDouble(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDouble(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyDouble();

  bool
  TrySetToByteString(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToByteString(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyByteString();
};

class OwningDoubleOrString : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eDouble,
    eString
  };
public:
  enum class Type
  {
    eDouble = TypeOrUninit::eDouble,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<double > mDouble;
    UnionMember<nsString > mString;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningDoubleOrString()
    : mType(eUninitialized)
  {
  }

  OwningDoubleOrString(OwningDoubleOrString&& aOther);

  explicit inline OwningDoubleOrString(const OwningDoubleOrString& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningDoubleOrString()
  {
    Uninit();
  }

  [[nodiscard]] double&
  RawSetAsDouble();

  [[nodiscard]] double&
  SetAsDouble();

  inline bool
  IsDouble() const
  {
    return mType == eDouble;
  }

  inline double&
  GetAsDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  inline double const &
  GetAsDouble() const
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  [[nodiscard]] nsString&
  RawSetAsString();

  [[nodiscard]] nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningDoubleOrString&
  operator=(OwningDoubleOrString&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningDoubleOrString&
  operator=(const OwningDoubleOrString& aOther);

private:
  bool
  TrySetToDouble(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDouble(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyDouble();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();
};

class OwningDoubleOrSupportedType : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eDouble,
    eSupportedType
  };
public:
  enum class Type
  {
    eDouble = TypeOrUninit::eDouble,
    eSupportedType = TypeOrUninit::eSupportedType
  };

private:
  union Value
  {
    UnionMember<double > mDouble;
    UnionMember<SupportedType > mSupportedType;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningDoubleOrSupportedType()
    : mType(eUninitialized)
  {
  }

  OwningDoubleOrSupportedType(OwningDoubleOrSupportedType&& aOther);

  explicit inline OwningDoubleOrSupportedType(const OwningDoubleOrSupportedType& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningDoubleOrSupportedType()
  {
    Uninit();
  }

  [[nodiscard]] double&
  RawSetAsDouble();

  [[nodiscard]] double&
  SetAsDouble();

  inline bool
  IsDouble() const
  {
    return mType == eDouble;
  }

  inline double&
  GetAsDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  inline double const &
  GetAsDouble() const
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  [[nodiscard]] SupportedType&
  RawSetAsSupportedType();

  [[nodiscard]] SupportedType&
  SetAsSupportedType();

  inline bool
  IsSupportedType() const
  {
    return mType == eSupportedType;
  }

  inline SupportedType&
  GetAsSupportedType()
  {
    MOZ_RELEASE_ASSERT(IsSupportedType(), "Wrong type!");
    return mValue.mSupportedType.Value();
  }

  inline SupportedType const &
  GetAsSupportedType() const
  {
    MOZ_RELEASE_ASSERT(IsSupportedType(), "Wrong type!");
    return mValue.mSupportedType.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningDoubleOrSupportedType&
  operator=(OwningDoubleOrSupportedType&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningDoubleOrSupportedType&
  operator=(const OwningDoubleOrSupportedType& aOther);

private:
  bool
  TrySetToDouble(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDouble(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyDouble();

  bool
  TrySetToSupportedType(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToSupportedType(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroySupportedType();
};

class OwningDoubleOrUSVString : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eDouble,
    eUSVString
  };
public:
  enum class Type
  {
    eDouble = TypeOrUninit::eDouble,
    eUSVString = TypeOrUninit::eUSVString
  };

private:
  union Value
  {
    UnionMember<double > mDouble;
    UnionMember<nsString > mUSVString;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningDoubleOrUSVString()
    : mType(eUninitialized)
  {
  }

  OwningDoubleOrUSVString(OwningDoubleOrUSVString&& aOther);

  explicit inline OwningDoubleOrUSVString(const OwningDoubleOrUSVString& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningDoubleOrUSVString()
  {
    Uninit();
  }

  [[nodiscard]] double&
  RawSetAsDouble();

  [[nodiscard]] double&
  SetAsDouble();

  inline bool
  IsDouble() const
  {
    return mType == eDouble;
  }

  inline double&
  GetAsDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  inline double const &
  GetAsDouble() const
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  [[nodiscard]] nsString&
  RawSetAsUSVString();

  [[nodiscard]] nsString&
  SetAsUSVString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsUSVString().AssignLiteral(aData);
  }

  inline bool
  IsUSVString() const
  {
    return mType == eUSVString;
  }

  inline nsString&
  GetAsUSVString()
  {
    MOZ_RELEASE_ASSERT(IsUSVString(), "Wrong type!");
    return mValue.mUSVString.Value();
  }

  inline nsString const &
  GetAsUSVString() const
  {
    MOZ_RELEASE_ASSERT(IsUSVString(), "Wrong type!");
    return mValue.mUSVString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningDoubleOrUSVString&
  operator=(OwningDoubleOrUSVString&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningDoubleOrUSVString&
  operator=(const OwningDoubleOrUSVString& aOther);

private:
  bool
  TrySetToDouble(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDouble(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyDouble();

  bool
  TrySetToUSVString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUSVString();
};

class OwningDoubleOrUTF8String : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eDouble,
    eUTF8String
  };
public:
  enum class Type
  {
    eDouble = TypeOrUninit::eDouble,
    eUTF8String = TypeOrUninit::eUTF8String
  };

private:
  union Value
  {
    UnionMember<double > mDouble;
    UnionMember<nsCString > mUTF8String;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningDoubleOrUTF8String()
    : mType(eUninitialized)
  {
  }

  OwningDoubleOrUTF8String(OwningDoubleOrUTF8String&& aOther);

  explicit inline OwningDoubleOrUTF8String(const OwningDoubleOrUTF8String& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningDoubleOrUTF8String()
  {
    Uninit();
  }

  [[nodiscard]] double&
  RawSetAsDouble();

  [[nodiscard]] double&
  SetAsDouble();

  inline bool
  IsDouble() const
  {
    return mType == eDouble;
  }

  inline double&
  GetAsDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  inline double const &
  GetAsDouble() const
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  [[nodiscard]] nsCString&
  RawSetAsUTF8String();

  [[nodiscard]] nsCString&
  SetAsUTF8String();

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline nsCString&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline nsCString const &
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningDoubleOrUTF8String&
  operator=(OwningDoubleOrUTF8String&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningDoubleOrUTF8String&
  operator=(const OwningDoubleOrUTF8String& aOther);

private:
  bool
  TrySetToDouble(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDouble(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyDouble();

  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUTF8String();
};

class OwningFileOrDirectory : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningFileOrDirectory& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eFile,
    eDirectory
  };
public:
  enum class Type
  {
    eFile = TypeOrUninit::eFile,
    eDirectory = TypeOrUninit::eDirectory
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::File> > mFile;
    UnionMember<OwningNonNull<mozilla::dom::Directory> > mDirectory;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningFileOrDirectory()
    : mType(eUninitialized)
  {
  }

  OwningFileOrDirectory(OwningFileOrDirectory&& aOther);

  explicit inline OwningFileOrDirectory(const OwningFileOrDirectory& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningFileOrDirectory()
  {
    Uninit();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::File>&
  RawSetAsFile();

  [[nodiscard]] OwningNonNull<mozilla::dom::File>&
  SetAsFile();

  inline bool
  IsFile() const
  {
    return mType == eFile;
  }

  inline OwningNonNull<mozilla::dom::File>&
  GetAsFile()
  {
    MOZ_RELEASE_ASSERT(IsFile(), "Wrong type!");
    return mValue.mFile.Value();
  }

  inline OwningNonNull<mozilla::dom::File> const &
  GetAsFile() const
  {
    MOZ_RELEASE_ASSERT(IsFile(), "Wrong type!");
    return mValue.mFile.Value();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::Directory>&
  RawSetAsDirectory();

  [[nodiscard]] OwningNonNull<mozilla::dom::Directory>&
  SetAsDirectory();

  inline bool
  IsDirectory() const
  {
    return mType == eDirectory;
  }

  inline OwningNonNull<mozilla::dom::Directory>&
  GetAsDirectory()
  {
    MOZ_RELEASE_ASSERT(IsDirectory(), "Wrong type!");
    return mValue.mDirectory.Value();
  }

  inline OwningNonNull<mozilla::dom::Directory> const &
  GetAsDirectory() const
  {
    MOZ_RELEASE_ASSERT(IsDirectory(), "Wrong type!");
    return mValue.mDirectory.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningFileOrDirectory&
  operator=(OwningFileOrDirectory&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningFileOrDirectory&
  operator=(const OwningFileOrDirectory& aOther);

private:
  bool
  TrySetToFile(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToFile(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyFile();

  bool
  TrySetToDirectory(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDirectory(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyDirectory();
};

class OwningFileOrUSVStringOrFormData : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningFileOrUSVStringOrFormData& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eFile,
    eUSVString,
    eFormData
  };
public:
  enum class Type
  {
    eFile = TypeOrUninit::eFile,
    eUSVString = TypeOrUninit::eUSVString,
    eFormData = TypeOrUninit::eFormData
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::File> > mFile;
    UnionMember<nsString > mUSVString;
    UnionMember<OwningNonNull<mozilla::dom::FormData> > mFormData;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningFileOrUSVStringOrFormData()
    : mType(eUninitialized)
  {
  }

  OwningFileOrUSVStringOrFormData(OwningFileOrUSVStringOrFormData&& aOther);

  explicit inline OwningFileOrUSVStringOrFormData(const OwningFileOrUSVStringOrFormData& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningFileOrUSVStringOrFormData()
  {
    Uninit();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::File>&
  RawSetAsFile();

  [[nodiscard]] OwningNonNull<mozilla::dom::File>&
  SetAsFile();

  inline bool
  IsFile() const
  {
    return mType == eFile;
  }

  inline OwningNonNull<mozilla::dom::File>&
  GetAsFile()
  {
    MOZ_RELEASE_ASSERT(IsFile(), "Wrong type!");
    return mValue.mFile.Value();
  }

  inline OwningNonNull<mozilla::dom::File> const &
  GetAsFile() const
  {
    MOZ_RELEASE_ASSERT(IsFile(), "Wrong type!");
    return mValue.mFile.Value();
  }

  [[nodiscard]] nsString&
  RawSetAsUSVString();

  [[nodiscard]] nsString&
  SetAsUSVString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsUSVString().AssignLiteral(aData);
  }

  inline bool
  IsUSVString() const
  {
    return mType == eUSVString;
  }

  inline nsString&
  GetAsUSVString()
  {
    MOZ_RELEASE_ASSERT(IsUSVString(), "Wrong type!");
    return mValue.mUSVString.Value();
  }

  inline nsString const &
  GetAsUSVString() const
  {
    MOZ_RELEASE_ASSERT(IsUSVString(), "Wrong type!");
    return mValue.mUSVString.Value();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::FormData>&
  RawSetAsFormData();

  [[nodiscard]] OwningNonNull<mozilla::dom::FormData>&
  SetAsFormData();

  inline bool
  IsFormData() const
  {
    return mType == eFormData;
  }

  inline OwningNonNull<mozilla::dom::FormData>&
  GetAsFormData()
  {
    MOZ_RELEASE_ASSERT(IsFormData(), "Wrong type!");
    return mValue.mFormData.Value();
  }

  inline OwningNonNull<mozilla::dom::FormData> const &
  GetAsFormData() const
  {
    MOZ_RELEASE_ASSERT(IsFormData(), "Wrong type!");
    return mValue.mFormData.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningFileOrUSVStringOrFormData&
  operator=(OwningFileOrUSVStringOrFormData&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningFileOrUSVStringOrFormData&
  operator=(const OwningFileOrUSVStringOrFormData& aOther);

private:
  bool
  TrySetToFile(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToFile(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyFile();

  bool
  TrySetToUSVString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUSVString();

  bool
  TrySetToFormData(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToFormData(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyFormData();
};

class OwningFloatOrString : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eFloat,
    eString
  };
public:
  enum class Type
  {
    eFloat = TypeOrUninit::eFloat,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<float > mFloat;
    UnionMember<nsString > mString;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningFloatOrString()
    : mType(eUninitialized)
  {
  }

  OwningFloatOrString(OwningFloatOrString&& aOther);

  explicit inline OwningFloatOrString(const OwningFloatOrString& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningFloatOrString()
  {
    Uninit();
  }

  [[nodiscard]] float&
  RawSetAsFloat();

  [[nodiscard]] float&
  SetAsFloat();

  inline bool
  IsFloat() const
  {
    return mType == eFloat;
  }

  inline float&
  GetAsFloat()
  {
    MOZ_RELEASE_ASSERT(IsFloat(), "Wrong type!");
    return mValue.mFloat.Value();
  }

  inline float const &
  GetAsFloat() const
  {
    MOZ_RELEASE_ASSERT(IsFloat(), "Wrong type!");
    return mValue.mFloat.Value();
  }

  [[nodiscard]] nsString&
  RawSetAsString();

  [[nodiscard]] nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningFloatOrString&
  operator=(OwningFloatOrString&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningFloatOrString&
  operator=(const OwningFloatOrString& aOther);

private:
  bool
  TrySetToFloat(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToFloat(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyFloat();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();
};

class OwningHTMLCanvasElementOrOffscreenCanvas : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningHTMLCanvasElementOrOffscreenCanvas& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eHTMLCanvasElement,
    eOffscreenCanvas
  };
public:
  enum class Type
  {
    eHTMLCanvasElement = TypeOrUninit::eHTMLCanvasElement,
    eOffscreenCanvas = TypeOrUninit::eOffscreenCanvas
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::HTMLCanvasElement> > mHTMLCanvasElement;
    UnionMember<OwningNonNull<mozilla::dom::OffscreenCanvas> > mOffscreenCanvas;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningHTMLCanvasElementOrOffscreenCanvas()
    : mType(eUninitialized)
  {
  }

  OwningHTMLCanvasElementOrOffscreenCanvas(OwningHTMLCanvasElementOrOffscreenCanvas&& aOther);

  explicit inline OwningHTMLCanvasElementOrOffscreenCanvas(const OwningHTMLCanvasElementOrOffscreenCanvas& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningHTMLCanvasElementOrOffscreenCanvas()
  {
    Uninit();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::HTMLCanvasElement>&
  RawSetAsHTMLCanvasElement();

  [[nodiscard]] OwningNonNull<mozilla::dom::HTMLCanvasElement>&
  SetAsHTMLCanvasElement();

  inline bool
  IsHTMLCanvasElement() const
  {
    return mType == eHTMLCanvasElement;
  }

  inline OwningNonNull<mozilla::dom::HTMLCanvasElement>&
  GetAsHTMLCanvasElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    return mValue.mHTMLCanvasElement.Value();
  }

  inline OwningNonNull<mozilla::dom::HTMLCanvasElement> const &
  GetAsHTMLCanvasElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    return mValue.mHTMLCanvasElement.Value();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::OffscreenCanvas>&
  RawSetAsOffscreenCanvas();

  [[nodiscard]] OwningNonNull<mozilla::dom::OffscreenCanvas>&
  SetAsOffscreenCanvas();

  inline bool
  IsOffscreenCanvas() const
  {
    return mType == eOffscreenCanvas;
  }

  inline OwningNonNull<mozilla::dom::OffscreenCanvas>&
  GetAsOffscreenCanvas()
  {
    MOZ_RELEASE_ASSERT(IsOffscreenCanvas(), "Wrong type!");
    return mValue.mOffscreenCanvas.Value();
  }

  inline OwningNonNull<mozilla::dom::OffscreenCanvas> const &
  GetAsOffscreenCanvas() const
  {
    MOZ_RELEASE_ASSERT(IsOffscreenCanvas(), "Wrong type!");
    return mValue.mOffscreenCanvas.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningHTMLCanvasElementOrOffscreenCanvas&
  operator=(OwningHTMLCanvasElementOrOffscreenCanvas&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningHTMLCanvasElementOrOffscreenCanvas&
  operator=(const OwningHTMLCanvasElementOrOffscreenCanvas& aOther);

private:
  bool
  TrySetToHTMLCanvasElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLCanvasElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyHTMLCanvasElement();

  bool
  TrySetToOffscreenCanvas(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToOffscreenCanvas(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyOffscreenCanvas();
};

class OwningHTMLElementOrLong : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningHTMLElementOrLong& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eHTMLElement,
    eLong
  };
public:
  enum class Type
  {
    eHTMLElement = TypeOrUninit::eHTMLElement,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<nsGenericHTMLElement> > mHTMLElement;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningHTMLElementOrLong()
    : mType(eUninitialized)
  {
  }

  OwningHTMLElementOrLong(OwningHTMLElementOrLong&& aOther);

  explicit inline OwningHTMLElementOrLong(const OwningHTMLElementOrLong& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningHTMLElementOrLong()
  {
    Uninit();
  }

  [[nodiscard]] OwningNonNull<nsGenericHTMLElement>&
  RawSetAsHTMLElement();

  [[nodiscard]] OwningNonNull<nsGenericHTMLElement>&
  SetAsHTMLElement();

  inline bool
  IsHTMLElement() const
  {
    return mType == eHTMLElement;
  }

  inline OwningNonNull<nsGenericHTMLElement>&
  GetAsHTMLElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLElement(), "Wrong type!");
    return mValue.mHTMLElement.Value();
  }

  inline OwningNonNull<nsGenericHTMLElement> const &
  GetAsHTMLElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLElement(), "Wrong type!");
    return mValue.mHTMLElement.Value();
  }

  [[nodiscard]] int32_t&
  RawSetAsLong();

  [[nodiscard]] int32_t&
  SetAsLong();

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t const &
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningHTMLElementOrLong&
  operator=(OwningHTMLElementOrLong&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningHTMLElementOrLong&
  operator=(const OwningHTMLElementOrLong& aOther);

private:
  bool
  TrySetToHTMLElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyHTMLElement();

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyLong();
};

class OwningHTMLOptionElementOrHTMLOptGroupElement : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningHTMLOptionElementOrHTMLOptGroupElement& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eHTMLOptionElement,
    eHTMLOptGroupElement
  };
public:
  enum class Type
  {
    eHTMLOptionElement = TypeOrUninit::eHTMLOptionElement,
    eHTMLOptGroupElement = TypeOrUninit::eHTMLOptGroupElement
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::HTMLOptionElement> > mHTMLOptionElement;
    UnionMember<OwningNonNull<mozilla::dom::HTMLOptGroupElement> > mHTMLOptGroupElement;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningHTMLOptionElementOrHTMLOptGroupElement()
    : mType(eUninitialized)
  {
  }

  OwningHTMLOptionElementOrHTMLOptGroupElement(OwningHTMLOptionElementOrHTMLOptGroupElement&& aOther);

  explicit inline OwningHTMLOptionElementOrHTMLOptGroupElement(const OwningHTMLOptionElementOrHTMLOptGroupElement& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningHTMLOptionElementOrHTMLOptGroupElement()
  {
    Uninit();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::HTMLOptionElement>&
  RawSetAsHTMLOptionElement();

  [[nodiscard]] OwningNonNull<mozilla::dom::HTMLOptionElement>&
  SetAsHTMLOptionElement();

  inline bool
  IsHTMLOptionElement() const
  {
    return mType == eHTMLOptionElement;
  }

  inline OwningNonNull<mozilla::dom::HTMLOptionElement>&
  GetAsHTMLOptionElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLOptionElement(), "Wrong type!");
    return mValue.mHTMLOptionElement.Value();
  }

  inline OwningNonNull<mozilla::dom::HTMLOptionElement> const &
  GetAsHTMLOptionElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLOptionElement(), "Wrong type!");
    return mValue.mHTMLOptionElement.Value();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::HTMLOptGroupElement>&
  RawSetAsHTMLOptGroupElement();

  [[nodiscard]] OwningNonNull<mozilla::dom::HTMLOptGroupElement>&
  SetAsHTMLOptGroupElement();

  inline bool
  IsHTMLOptGroupElement() const
  {
    return mType == eHTMLOptGroupElement;
  }

  inline OwningNonNull<mozilla::dom::HTMLOptGroupElement>&
  GetAsHTMLOptGroupElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLOptGroupElement(), "Wrong type!");
    return mValue.mHTMLOptGroupElement.Value();
  }

  inline OwningNonNull<mozilla::dom::HTMLOptGroupElement> const &
  GetAsHTMLOptGroupElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLOptGroupElement(), "Wrong type!");
    return mValue.mHTMLOptGroupElement.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningHTMLOptionElementOrHTMLOptGroupElement&
  operator=(OwningHTMLOptionElementOrHTMLOptGroupElement&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningHTMLOptionElementOrHTMLOptGroupElement&
  operator=(const OwningHTMLOptionElementOrHTMLOptGroupElement& aOther);

private:
  bool
  TrySetToHTMLOptionElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLOptionElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyHTMLOptionElement();

  bool
  TrySetToHTMLOptGroupElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLOptGroupElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyHTMLOptGroupElement();
};

class OwningLongOrStringAnyRecord : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eLong,
    eStringAnyRecord
  };
public:
  enum class Type
  {
    eLong = TypeOrUninit::eLong,
    eStringAnyRecord = TypeOrUninit::eStringAnyRecord
  };

private:
  union Value
  {
    UnionMember<int32_t > mLong;
    UnionMember<Record<nsString, JS::Value> > mStringAnyRecord;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningLongOrStringAnyRecord(const OwningLongOrStringAnyRecord&) = delete;
  OwningLongOrStringAnyRecord& operator=(const OwningLongOrStringAnyRecord&) = delete;
public:
  explicit inline OwningLongOrStringAnyRecord()
    : mType(eUninitialized)
  {
  }

  OwningLongOrStringAnyRecord(OwningLongOrStringAnyRecord&& aOther);

  inline ~OwningLongOrStringAnyRecord()
  {
    Uninit();
  }

  [[nodiscard]] int32_t&
  RawSetAsLong();

  [[nodiscard]] int32_t&
  SetAsLong();

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t const &
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  [[nodiscard]] Record<nsString, JS::Value>&
  RawSetAsStringAnyRecord();

  [[nodiscard]] Record<nsString, JS::Value>&
  SetAsStringAnyRecord();

  inline bool
  IsStringAnyRecord() const
  {
    return mType == eStringAnyRecord;
  }

  inline Record<nsString, JS::Value>&
  GetAsStringAnyRecord()
  {
    MOZ_RELEASE_ASSERT(IsStringAnyRecord(), "Wrong type!");
    return mValue.mStringAnyRecord.Value();
  }

  inline Record<nsString, JS::Value> const &
  GetAsStringAnyRecord() const
  {
    MOZ_RELEASE_ASSERT(IsStringAnyRecord(), "Wrong type!");
    return mValue.mStringAnyRecord.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningLongOrStringAnyRecord&
  operator=(OwningLongOrStringAnyRecord&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyLong();

  bool
  TrySetToStringAnyRecord(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToStringAnyRecord(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyStringAnyRecord();
};

class OwningMaybeSharedInt8ArrayOrMaybeSharedInt16Array : public AllOwningUnionBase,
                                                          public UnionWithTypedArraysBase
{
public:
  using ApplyToTypedArrays = binding_detail::ApplyToTypedArraysHelper<OwningMaybeSharedInt8ArrayOrMaybeSharedInt16Array, false, Int8Array, Int16Array>;

private:
  enum TypeOrUninit
  {
    eUninitialized,
    eInt8Array,
    eInt16Array
  };
public:
  enum class Type
  {
    eInt8Array = TypeOrUninit::eInt8Array,
    eInt16Array = TypeOrUninit::eInt16Array
  };

private:
  union Value
  {
    UnionMember<Int8Array > mInt8Array;
    UnionMember<Int16Array > mInt16Array;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningMaybeSharedInt8ArrayOrMaybeSharedInt16Array(const OwningMaybeSharedInt8ArrayOrMaybeSharedInt16Array&) = delete;
  OwningMaybeSharedInt8ArrayOrMaybeSharedInt16Array& operator=(const OwningMaybeSharedInt8ArrayOrMaybeSharedInt16Array&) = delete;
public:
  explicit inline OwningMaybeSharedInt8ArrayOrMaybeSharedInt16Array()
    : mType(eUninitialized)
  {
  }

  OwningMaybeSharedInt8ArrayOrMaybeSharedInt16Array(OwningMaybeSharedInt8ArrayOrMaybeSharedInt16Array&& aOther);

  inline ~OwningMaybeSharedInt8ArrayOrMaybeSharedInt16Array()
  {
    Uninit();
  }

  [[nodiscard]] Int8Array&
  RawSetAsInt8Array();

  [[nodiscard]] Int8Array&
  SetAsInt8Array();

  inline bool
  IsInt8Array() const
  {
    return mType == eInt8Array;
  }

  inline Int8Array&
  GetAsInt8Array()
  {
    MOZ_RELEASE_ASSERT(IsInt8Array(), "Wrong type!");
    return mValue.mInt8Array.Value();
  }

  inline Int8Array const &
  GetAsInt8Array() const
  {
    MOZ_RELEASE_ASSERT(IsInt8Array(), "Wrong type!");
    return mValue.mInt8Array.Value();
  }

  [[nodiscard]] Int16Array&
  RawSetAsInt16Array();

  [[nodiscard]] Int16Array&
  SetAsInt16Array();

  inline bool
  IsInt16Array() const
  {
    return mType == eInt16Array;
  }

  inline Int16Array&
  GetAsInt16Array()
  {
    MOZ_RELEASE_ASSERT(IsInt16Array(), "Wrong type!");
    return mValue.mInt16Array.Value();
  }

  inline Int16Array const &
  GetAsInt16Array() const
  {
    MOZ_RELEASE_ASSERT(IsInt16Array(), "Wrong type!");
    return mValue.mInt16Array.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningMaybeSharedInt8ArrayOrMaybeSharedInt16Array&
  operator=(OwningMaybeSharedInt8ArrayOrMaybeSharedInt16Array&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToInt8Array(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToInt8Array(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyInt8Array();

  bool
  TrySetToInt16Array(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToInt16Array(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyInt16Array();
};

class OwningNodeOrString : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningNodeOrString& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eNode,
    eString
  };
public:
  enum class Type
  {
    eNode = TypeOrUninit::eNode,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<nsINode> > mNode;
    UnionMember<nsString > mString;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningNodeOrString()
    : mType(eUninitialized)
  {
  }

  OwningNodeOrString(OwningNodeOrString&& aOther);

  explicit inline OwningNodeOrString(const OwningNodeOrString& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningNodeOrString()
  {
    Uninit();
  }

  [[nodiscard]] OwningNonNull<nsINode>&
  RawSetAsNode();

  [[nodiscard]] OwningNonNull<nsINode>&
  SetAsNode();

  inline bool
  IsNode() const
  {
    return mType == eNode;
  }

  inline OwningNonNull<nsINode>&
  GetAsNode()
  {
    MOZ_RELEASE_ASSERT(IsNode(), "Wrong type!");
    return mValue.mNode.Value();
  }

  inline OwningNonNull<nsINode> const &
  GetAsNode() const
  {
    MOZ_RELEASE_ASSERT(IsNode(), "Wrong type!");
    return mValue.mNode.Value();
  }

  [[nodiscard]] nsString&
  RawSetAsString();

  [[nodiscard]] nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningNodeOrString&
  operator=(OwningNodeOrString&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningNodeOrString&
  operator=(const OwningNodeOrString& aOther);

private:
  bool
  TrySetToNode(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToNode(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyNode();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();
};

class OwningObjectOrLong : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eObject,
    eLong
  };
public:
  enum class Type
  {
    eObject = TypeOrUninit::eObject,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<JSObject* > mObject;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningObjectOrLong(const OwningObjectOrLong&) = delete;
  OwningObjectOrLong& operator=(const OwningObjectOrLong&) = delete;
public:
  explicit inline OwningObjectOrLong()
    : mType(eUninitialized)
  {
  }

  OwningObjectOrLong(OwningObjectOrLong&& aOther);

  inline ~OwningObjectOrLong()
  {
    Uninit();
  }

  inline bool
  SetToObject(BindingCallContext& cx, JSObject* obj, bool passedToJSImpl = false)
  {
    MOZ_ASSERT(mType == eUninitialized);
    mValue.mObject.SetValue(obj);
    mType = eObject;
    if (passedToJSImpl && !CallerSubsumes(obj)) {
      cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("object branch of (object or long)");
      return false;
    }
    return true;
  }

  [[nodiscard]] JSObject*&
  RawSetAsObject();

  [[nodiscard]] JSObject*&
  SetAsObject();

  inline bool
  IsObject() const
  {
    return mType == eObject;
  }

  inline JSObject*&
  GetAsObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline JSObject* const &
  GetAsObject() const
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  [[nodiscard]] int32_t&
  RawSetAsLong();

  [[nodiscard]] int32_t&
  SetAsLong();

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t const &
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningObjectOrLong&
  operator=(OwningObjectOrLong&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  void
  DestroyObject();

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyLong();
};

class OwningObjectOrNullOrLong : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eNull,
    eObject,
    eLong
  };
public:
  enum class Type
  {
    eNull = TypeOrUninit::eNull,
    eObject = TypeOrUninit::eObject,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<JSObject* > mObject;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningObjectOrNullOrLong(const OwningObjectOrNullOrLong&) = delete;
  OwningObjectOrNullOrLong& operator=(const OwningObjectOrNullOrLong&) = delete;
public:
  explicit inline OwningObjectOrNullOrLong()
    : mType(eUninitialized)
  {
  }

  OwningObjectOrNullOrLong(OwningObjectOrNullOrLong&& aOther);

  inline ~OwningObjectOrNullOrLong()
  {
    Uninit();
  }

  inline bool
  IsNull() const
  {
    return mType == eNull;
  }

  inline void
  SetNull()
  {
    Uninit();
    mType = eNull;
  }

  inline bool
  SetToObject(BindingCallContext& cx, JSObject* obj, bool passedToJSImpl = false)
  {
    MOZ_ASSERT(mType == eUninitialized);
    mValue.mObject.SetValue(obj);
    mType = eObject;
    if (passedToJSImpl && !CallerSubsumes(obj)) {
      cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("object branch of (object? or long)");
      return false;
    }
    return true;
  }

  [[nodiscard]] JSObject*&
  RawSetAsObject();

  [[nodiscard]] JSObject*&
  SetAsObject();

  inline bool
  IsObject() const
  {
    return mType == eObject;
  }

  inline JSObject*&
  GetAsObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline JSObject* const &
  GetAsObject() const
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  [[nodiscard]] int32_t&
  RawSetAsLong();

  [[nodiscard]] int32_t&
  SetAsLong();

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t const &
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningObjectOrNullOrLong&
  operator=(OwningObjectOrNullOrLong&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  void
  DestroyObject();

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyLong();
};

class OwningStringOrArrayBuffer : public AllOwningUnionBase,
                                  public UnionWithTypedArraysBase
{
public:
  using ApplyToTypedArrays = binding_detail::ApplyToTypedArraysHelper<OwningStringOrArrayBuffer, true, ArrayBuffer>;

private:
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eArrayBuffer
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eArrayBuffer = TypeOrUninit::eArrayBuffer
  };

private:
  union Value
  {
    UnionMember<nsString > mString;
    UnionMember<ArrayBuffer > mArrayBuffer;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningStringOrArrayBuffer(const OwningStringOrArrayBuffer&) = delete;
  OwningStringOrArrayBuffer& operator=(const OwningStringOrArrayBuffer&) = delete;
public:
  explicit inline OwningStringOrArrayBuffer()
    : mType(eUninitialized)
  {
  }

  OwningStringOrArrayBuffer(OwningStringOrArrayBuffer&& aOther);

  inline ~OwningStringOrArrayBuffer()
  {
    Uninit();
  }

  [[nodiscard]] nsString&
  RawSetAsString();

  [[nodiscard]] nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  [[nodiscard]] ArrayBuffer&
  RawSetAsArrayBuffer();

  [[nodiscard]] ArrayBuffer&
  SetAsArrayBuffer();

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline ArrayBuffer&
  GetAsArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningStringOrArrayBuffer&
  operator=(OwningStringOrArrayBuffer&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();

  bool
  TrySetToArrayBuffer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBuffer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyArrayBuffer();
};

class OwningStringOrBooleanOrObject : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eBoolean,
    eObject
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eBoolean = TypeOrUninit::eBoolean,
    eObject = TypeOrUninit::eObject
  };

private:
  union Value
  {
    UnionMember<nsString > mString;
    UnionMember<bool > mBoolean;
    UnionMember<JSObject* > mObject;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningStringOrBooleanOrObject(const OwningStringOrBooleanOrObject&) = delete;
  OwningStringOrBooleanOrObject& operator=(const OwningStringOrBooleanOrObject&) = delete;
public:
  explicit inline OwningStringOrBooleanOrObject()
    : mType(eUninitialized)
  {
  }

  OwningStringOrBooleanOrObject(OwningStringOrBooleanOrObject&& aOther);

  inline ~OwningStringOrBooleanOrObject()
  {
    Uninit();
  }

  [[nodiscard]] nsString&
  RawSetAsString();

  [[nodiscard]] nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  [[nodiscard]] bool&
  RawSetAsBoolean();

  [[nodiscard]] bool&
  SetAsBoolean();

  inline bool
  IsBoolean() const
  {
    return mType == eBoolean;
  }

  inline bool&
  GetAsBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline bool const &
  GetAsBoolean() const
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline bool
  SetToObject(BindingCallContext& cx, JSObject* obj, bool passedToJSImpl = false)
  {
    MOZ_ASSERT(mType == eUninitialized);
    mValue.mObject.SetValue(obj);
    mType = eObject;
    if (passedToJSImpl && !CallerSubsumes(obj)) {
      cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("object branch of (DOMString or boolean or object)");
      return false;
    }
    return true;
  }

  [[nodiscard]] JSObject*&
  RawSetAsObject();

  [[nodiscard]] JSObject*&
  SetAsObject();

  inline bool
  IsObject() const
  {
    return mType == eObject;
  }

  inline JSObject*&
  GetAsObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline JSObject* const &
  GetAsObject() const
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningStringOrBooleanOrObject&
  operator=(OwningStringOrBooleanOrObject&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();

  bool
  TrySetToBoolean(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyBoolean();

  void
  DestroyObject();
};

class OwningStringOrMaybeSharedArrayBuffer : public AllOwningUnionBase,
                                             public UnionWithTypedArraysBase
{
public:
  using ApplyToTypedArrays = binding_detail::ApplyToTypedArraysHelper<OwningStringOrMaybeSharedArrayBuffer, true, ArrayBuffer>;

private:
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eArrayBuffer
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eArrayBuffer = TypeOrUninit::eArrayBuffer
  };

private:
  union Value
  {
    UnionMember<nsString > mString;
    UnionMember<ArrayBuffer > mArrayBuffer;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningStringOrMaybeSharedArrayBuffer(const OwningStringOrMaybeSharedArrayBuffer&) = delete;
  OwningStringOrMaybeSharedArrayBuffer& operator=(const OwningStringOrMaybeSharedArrayBuffer&) = delete;
public:
  explicit inline OwningStringOrMaybeSharedArrayBuffer()
    : mType(eUninitialized)
  {
  }

  OwningStringOrMaybeSharedArrayBuffer(OwningStringOrMaybeSharedArrayBuffer&& aOther);

  inline ~OwningStringOrMaybeSharedArrayBuffer()
  {
    Uninit();
  }

  [[nodiscard]] nsString&
  RawSetAsString();

  [[nodiscard]] nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  [[nodiscard]] ArrayBuffer&
  RawSetAsArrayBuffer();

  [[nodiscard]] ArrayBuffer&
  SetAsArrayBuffer();

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline ArrayBuffer&
  GetAsArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningStringOrMaybeSharedArrayBuffer&
  operator=(OwningStringOrMaybeSharedArrayBuffer&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();

  bool
  TrySetToArrayBuffer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBuffer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyArrayBuffer();
};

class OwningStringOrObject : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eObject
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eObject = TypeOrUninit::eObject
  };

private:
  union Value
  {
    UnionMember<nsString > mString;
    UnionMember<JSObject* > mObject;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningStringOrObject(const OwningStringOrObject&) = delete;
  OwningStringOrObject& operator=(const OwningStringOrObject&) = delete;
public:
  explicit inline OwningStringOrObject()
    : mType(eUninitialized)
  {
  }

  OwningStringOrObject(OwningStringOrObject&& aOther);

  inline ~OwningStringOrObject()
  {
    Uninit();
  }

  [[nodiscard]] nsString&
  RawSetAsString();

  [[nodiscard]] nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline bool
  SetToObject(BindingCallContext& cx, JSObject* obj, bool passedToJSImpl = false)
  {
    MOZ_ASSERT(mType == eUninitialized);
    mValue.mObject.SetValue(obj);
    mType = eObject;
    if (passedToJSImpl && !CallerSubsumes(obj)) {
      cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("object branch of (DOMString or object)");
      return false;
    }
    return true;
  }

  [[nodiscard]] JSObject*&
  RawSetAsObject();

  [[nodiscard]] JSObject*&
  SetAsObject();

  inline bool
  IsObject() const
  {
    return mType == eObject;
  }

  inline JSObject*&
  GetAsObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline JSObject* const &
  GetAsObject() const
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningStringOrObject&
  operator=(OwningStringOrObject&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();

  void
  DestroyObject();
};

class OwningStringOrStringSequence : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eStringSequence
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eStringSequence = TypeOrUninit::eStringSequence
  };

private:
  union Value
  {
    UnionMember<nsString > mString;
    UnionMember<Sequence<nsString> > mStringSequence;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningStringOrStringSequence()
    : mType(eUninitialized)
  {
  }

  OwningStringOrStringSequence(OwningStringOrStringSequence&& aOther);

  explicit inline OwningStringOrStringSequence(const OwningStringOrStringSequence& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningStringOrStringSequence()
  {
    Uninit();
  }

  [[nodiscard]] nsString&
  RawSetAsString();

  [[nodiscard]] nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  [[nodiscard]] Sequence<nsString>&
  RawSetAsStringSequence();

  [[nodiscard]] Sequence<nsString>&
  SetAsStringSequence();

  inline bool
  IsStringSequence() const
  {
    return mType == eStringSequence;
  }

  inline Sequence<nsString>&
  GetAsStringSequence()
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    return mValue.mStringSequence.Value();
  }

  inline Sequence<nsString> const &
  GetAsStringSequence() const
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    return mValue.mStringSequence.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningStringOrStringSequence&
  operator=(OwningStringOrStringSequence&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningStringOrStringSequence&
  operator=(const OwningStringOrStringSequence& aOther);

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();

  bool
  TrySetToStringSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToStringSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyStringSequence();
};

class OwningSupportedTypeOrObject : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eSupportedType,
    eObject
  };
public:
  enum class Type
  {
    eSupportedType = TypeOrUninit::eSupportedType,
    eObject = TypeOrUninit::eObject
  };

private:
  union Value
  {
    UnionMember<SupportedType > mSupportedType;
    UnionMember<JSObject* > mObject;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningSupportedTypeOrObject(const OwningSupportedTypeOrObject&) = delete;
  OwningSupportedTypeOrObject& operator=(const OwningSupportedTypeOrObject&) = delete;
public:
  explicit inline OwningSupportedTypeOrObject()
    : mType(eUninitialized)
  {
  }

  OwningSupportedTypeOrObject(OwningSupportedTypeOrObject&& aOther);

  inline ~OwningSupportedTypeOrObject()
  {
    Uninit();
  }

  [[nodiscard]] SupportedType&
  RawSetAsSupportedType();

  [[nodiscard]] SupportedType&
  SetAsSupportedType();

  inline bool
  IsSupportedType() const
  {
    return mType == eSupportedType;
  }

  inline SupportedType&
  GetAsSupportedType()
  {
    MOZ_RELEASE_ASSERT(IsSupportedType(), "Wrong type!");
    return mValue.mSupportedType.Value();
  }

  inline SupportedType const &
  GetAsSupportedType() const
  {
    MOZ_RELEASE_ASSERT(IsSupportedType(), "Wrong type!");
    return mValue.mSupportedType.Value();
  }

  inline bool
  SetToObject(BindingCallContext& cx, JSObject* obj, bool passedToJSImpl = false)
  {
    MOZ_ASSERT(mType == eUninitialized);
    mValue.mObject.SetValue(obj);
    mType = eObject;
    if (passedToJSImpl && !CallerSubsumes(obj)) {
      cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("object branch of (SupportedType or object)");
      return false;
    }
    return true;
  }

  [[nodiscard]] JSObject*&
  RawSetAsObject();

  [[nodiscard]] JSObject*&
  SetAsObject();

  inline bool
  IsObject() const
  {
    return mType == eObject;
  }

  inline JSObject*&
  GetAsObject()
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline JSObject* const &
  GetAsObject() const
  {
    MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningSupportedTypeOrObject&
  operator=(OwningSupportedTypeOrObject&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToSupportedType(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToSupportedType(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroySupportedType();

  void
  DestroyObject();
};

class OwningTrustedHTMLOrNullIsEmptyString : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningTrustedHTMLOrNullIsEmptyString& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eTrustedHTML,
    eNullIsEmptyString
  };
public:
  enum class Type
  {
    eTrustedHTML = TypeOrUninit::eTrustedHTML,
    eNullIsEmptyString = TypeOrUninit::eNullIsEmptyString
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::TrustedHTML> > mTrustedHTML;
    UnionMember<nsString > mNullIsEmptyString;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningTrustedHTMLOrNullIsEmptyString()
    : mType(eUninitialized)
  {
  }

  OwningTrustedHTMLOrNullIsEmptyString(OwningTrustedHTMLOrNullIsEmptyString&& aOther);

  explicit inline OwningTrustedHTMLOrNullIsEmptyString(const OwningTrustedHTMLOrNullIsEmptyString& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningTrustedHTMLOrNullIsEmptyString()
  {
    Uninit();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::TrustedHTML>&
  RawSetAsTrustedHTML();

  [[nodiscard]] OwningNonNull<mozilla::dom::TrustedHTML>&
  SetAsTrustedHTML();

  inline bool
  IsTrustedHTML() const
  {
    return mType == eTrustedHTML;
  }

  inline OwningNonNull<mozilla::dom::TrustedHTML>&
  GetAsTrustedHTML()
  {
    MOZ_RELEASE_ASSERT(IsTrustedHTML(), "Wrong type!");
    return mValue.mTrustedHTML.Value();
  }

  inline OwningNonNull<mozilla::dom::TrustedHTML> const &
  GetAsTrustedHTML() const
  {
    MOZ_RELEASE_ASSERT(IsTrustedHTML(), "Wrong type!");
    return mValue.mTrustedHTML.Value();
  }

  [[nodiscard]] nsString&
  RawSetAsNullIsEmptyString();

  [[nodiscard]] nsString&
  SetAsNullIsEmptyString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsNullIsEmptyString().AssignLiteral(aData);
  }

  inline bool
  IsNullIsEmptyString() const
  {
    return mType == eNullIsEmptyString;
  }

  inline nsString&
  GetAsNullIsEmptyString()
  {
    MOZ_RELEASE_ASSERT(IsNullIsEmptyString(), "Wrong type!");
    return mValue.mNullIsEmptyString.Value();
  }

  inline nsString const &
  GetAsNullIsEmptyString() const
  {
    MOZ_RELEASE_ASSERT(IsNullIsEmptyString(), "Wrong type!");
    return mValue.mNullIsEmptyString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningTrustedHTMLOrNullIsEmptyString&
  operator=(OwningTrustedHTMLOrNullIsEmptyString&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningTrustedHTMLOrNullIsEmptyString&
  operator=(const OwningTrustedHTMLOrNullIsEmptyString& aOther);

private:
  bool
  TrySetToTrustedHTML(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToTrustedHTML(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyTrustedHTML();

  bool
  TrySetToNullIsEmptyString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyNullIsEmptyString();
};

class OwningTrustedHTMLOrString : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningTrustedHTMLOrString& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eTrustedHTML,
    eString
  };
public:
  enum class Type
  {
    eTrustedHTML = TypeOrUninit::eTrustedHTML,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::TrustedHTML> > mTrustedHTML;
    UnionMember<nsString > mString;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningTrustedHTMLOrString()
    : mType(eUninitialized)
  {
  }

  OwningTrustedHTMLOrString(OwningTrustedHTMLOrString&& aOther);

  explicit inline OwningTrustedHTMLOrString(const OwningTrustedHTMLOrString& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningTrustedHTMLOrString()
  {
    Uninit();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::TrustedHTML>&
  RawSetAsTrustedHTML();

  [[nodiscard]] OwningNonNull<mozilla::dom::TrustedHTML>&
  SetAsTrustedHTML();

  inline bool
  IsTrustedHTML() const
  {
    return mType == eTrustedHTML;
  }

  inline OwningNonNull<mozilla::dom::TrustedHTML>&
  GetAsTrustedHTML()
  {
    MOZ_RELEASE_ASSERT(IsTrustedHTML(), "Wrong type!");
    return mValue.mTrustedHTML.Value();
  }

  inline OwningNonNull<mozilla::dom::TrustedHTML> const &
  GetAsTrustedHTML() const
  {
    MOZ_RELEASE_ASSERT(IsTrustedHTML(), "Wrong type!");
    return mValue.mTrustedHTML.Value();
  }

  [[nodiscard]] nsString&
  RawSetAsString();

  [[nodiscard]] nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningTrustedHTMLOrString&
  operator=(OwningTrustedHTMLOrString&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningTrustedHTMLOrString&
  operator=(const OwningTrustedHTMLOrString& aOther);

private:
  bool
  TrySetToTrustedHTML(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToTrustedHTML(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyTrustedHTML();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();
};

class OwningTrustedScriptURLOrString : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningTrustedScriptURLOrString& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eTrustedScriptURL,
    eString
  };
public:
  enum class Type
  {
    eTrustedScriptURL = TypeOrUninit::eTrustedScriptURL,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::TrustedScriptURL> > mTrustedScriptURL;
    UnionMember<nsString > mString;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningTrustedScriptURLOrString()
    : mType(eUninitialized)
  {
  }

  OwningTrustedScriptURLOrString(OwningTrustedScriptURLOrString&& aOther);

  explicit inline OwningTrustedScriptURLOrString(const OwningTrustedScriptURLOrString& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningTrustedScriptURLOrString()
  {
    Uninit();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::TrustedScriptURL>&
  RawSetAsTrustedScriptURL();

  [[nodiscard]] OwningNonNull<mozilla::dom::TrustedScriptURL>&
  SetAsTrustedScriptURL();

  inline bool
  IsTrustedScriptURL() const
  {
    return mType == eTrustedScriptURL;
  }

  inline OwningNonNull<mozilla::dom::TrustedScriptURL>&
  GetAsTrustedScriptURL()
  {
    MOZ_RELEASE_ASSERT(IsTrustedScriptURL(), "Wrong type!");
    return mValue.mTrustedScriptURL.Value();
  }

  inline OwningNonNull<mozilla::dom::TrustedScriptURL> const &
  GetAsTrustedScriptURL() const
  {
    MOZ_RELEASE_ASSERT(IsTrustedScriptURL(), "Wrong type!");
    return mValue.mTrustedScriptURL.Value();
  }

  [[nodiscard]] nsString&
  RawSetAsString();

  [[nodiscard]] nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningTrustedScriptURLOrString&
  operator=(OwningTrustedScriptURLOrString&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningTrustedScriptURLOrString&
  operator=(const OwningTrustedScriptURLOrString& aOther);

private:
  bool
  TrySetToTrustedScriptURL(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToTrustedScriptURL(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyTrustedScriptURL();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();
};

class OwningTrustedScriptURLOrUSVString : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningTrustedScriptURLOrUSVString& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eTrustedScriptURL,
    eUSVString
  };
public:
  enum class Type
  {
    eTrustedScriptURL = TypeOrUninit::eTrustedScriptURL,
    eUSVString = TypeOrUninit::eUSVString
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::TrustedScriptURL> > mTrustedScriptURL;
    UnionMember<nsString > mUSVString;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningTrustedScriptURLOrUSVString()
    : mType(eUninitialized)
  {
  }

  OwningTrustedScriptURLOrUSVString(OwningTrustedScriptURLOrUSVString&& aOther);

  explicit inline OwningTrustedScriptURLOrUSVString(const OwningTrustedScriptURLOrUSVString& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningTrustedScriptURLOrUSVString()
  {
    Uninit();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::TrustedScriptURL>&
  RawSetAsTrustedScriptURL();

  [[nodiscard]] OwningNonNull<mozilla::dom::TrustedScriptURL>&
  SetAsTrustedScriptURL();

  inline bool
  IsTrustedScriptURL() const
  {
    return mType == eTrustedScriptURL;
  }

  inline OwningNonNull<mozilla::dom::TrustedScriptURL>&
  GetAsTrustedScriptURL()
  {
    MOZ_RELEASE_ASSERT(IsTrustedScriptURL(), "Wrong type!");
    return mValue.mTrustedScriptURL.Value();
  }

  inline OwningNonNull<mozilla::dom::TrustedScriptURL> const &
  GetAsTrustedScriptURL() const
  {
    MOZ_RELEASE_ASSERT(IsTrustedScriptURL(), "Wrong type!");
    return mValue.mTrustedScriptURL.Value();
  }

  [[nodiscard]] nsString&
  RawSetAsUSVString();

  [[nodiscard]] nsString&
  SetAsUSVString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsUSVString().AssignLiteral(aData);
  }

  inline bool
  IsUSVString() const
  {
    return mType == eUSVString;
  }

  inline nsString&
  GetAsUSVString()
  {
    MOZ_RELEASE_ASSERT(IsUSVString(), "Wrong type!");
    return mValue.mUSVString.Value();
  }

  inline nsString const &
  GetAsUSVString() const
  {
    MOZ_RELEASE_ASSERT(IsUSVString(), "Wrong type!");
    return mValue.mUSVString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningTrustedScriptURLOrUSVString&
  operator=(OwningTrustedScriptURLOrUSVString&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningTrustedScriptURLOrUSVString&
  operator=(const OwningTrustedScriptURLOrUSVString& aOther);

private:
  bool
  TrySetToTrustedScriptURL(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToTrustedScriptURL(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyTrustedScriptURL();

  bool
  TrySetToUSVString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUSVString();
};

class OwningUTF8StringOrArrayBuffer : public AllOwningUnionBase,
                                      public UnionWithTypedArraysBase
{
public:
  using ApplyToTypedArrays = binding_detail::ApplyToTypedArraysHelper<OwningUTF8StringOrArrayBuffer, true, ArrayBuffer>;

private:
  enum TypeOrUninit
  {
    eUninitialized,
    eUTF8String,
    eArrayBuffer
  };
public:
  enum class Type
  {
    eUTF8String = TypeOrUninit::eUTF8String,
    eArrayBuffer = TypeOrUninit::eArrayBuffer
  };

private:
  union Value
  {
    UnionMember<nsCString > mUTF8String;
    UnionMember<ArrayBuffer > mArrayBuffer;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningUTF8StringOrArrayBuffer(const OwningUTF8StringOrArrayBuffer&) = delete;
  OwningUTF8StringOrArrayBuffer& operator=(const OwningUTF8StringOrArrayBuffer&) = delete;
public:
  explicit inline OwningUTF8StringOrArrayBuffer()
    : mType(eUninitialized)
  {
  }

  OwningUTF8StringOrArrayBuffer(OwningUTF8StringOrArrayBuffer&& aOther);

  inline ~OwningUTF8StringOrArrayBuffer()
  {
    Uninit();
  }

  [[nodiscard]] nsCString&
  RawSetAsUTF8String();

  [[nodiscard]] nsCString&
  SetAsUTF8String();

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline nsCString&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline nsCString const &
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  [[nodiscard]] ArrayBuffer&
  RawSetAsArrayBuffer();

  [[nodiscard]] ArrayBuffer&
  SetAsArrayBuffer();

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline ArrayBuffer&
  GetAsArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningUTF8StringOrArrayBuffer&
  operator=(OwningUTF8StringOrArrayBuffer&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUTF8String();

  bool
  TrySetToArrayBuffer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBuffer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyArrayBuffer();
};

class OwningUTF8StringOrArrayBufferOrNull : public AllOwningUnionBase,
                                            public UnionWithTypedArraysBase
{
public:
  using ApplyToTypedArrays = binding_detail::ApplyToTypedArraysHelper<OwningUTF8StringOrArrayBufferOrNull, true, ArrayBuffer>;

private:
  enum TypeOrUninit
  {
    eUninitialized,
    eNull,
    eUTF8String,
    eArrayBuffer
  };
public:
  enum class Type
  {
    eNull = TypeOrUninit::eNull,
    eUTF8String = TypeOrUninit::eUTF8String,
    eArrayBuffer = TypeOrUninit::eArrayBuffer
  };

private:
  union Value
  {
    UnionMember<nsCString > mUTF8String;
    UnionMember<ArrayBuffer > mArrayBuffer;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningUTF8StringOrArrayBufferOrNull(const OwningUTF8StringOrArrayBufferOrNull&) = delete;
  OwningUTF8StringOrArrayBufferOrNull& operator=(const OwningUTF8StringOrArrayBufferOrNull&) = delete;
public:
  explicit inline OwningUTF8StringOrArrayBufferOrNull()
    : mType(eUninitialized)
  {
  }

  OwningUTF8StringOrArrayBufferOrNull(OwningUTF8StringOrArrayBufferOrNull&& aOther);

  inline ~OwningUTF8StringOrArrayBufferOrNull()
  {
    Uninit();
  }

  inline bool
  IsNull() const
  {
    return mType == eNull;
  }

  inline void
  SetNull()
  {
    Uninit();
    mType = eNull;
  }

  [[nodiscard]] nsCString&
  RawSetAsUTF8String();

  [[nodiscard]] nsCString&
  SetAsUTF8String();

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline nsCString&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline nsCString const &
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  [[nodiscard]] ArrayBuffer&
  RawSetAsArrayBuffer();

  [[nodiscard]] ArrayBuffer&
  SetAsArrayBuffer();

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline ArrayBuffer&
  GetAsArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningUTF8StringOrArrayBufferOrNull&
  operator=(OwningUTF8StringOrArrayBufferOrNull&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUTF8String();

  bool
  TrySetToArrayBuffer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBuffer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyArrayBuffer();
};

class OwningUTF8StringOrLong : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eUTF8String,
    eLong
  };
public:
  enum class Type
  {
    eUTF8String = TypeOrUninit::eUTF8String,
    eLong = TypeOrUninit::eLong
  };

private:
  union Value
  {
    UnionMember<nsCString > mUTF8String;
    UnionMember<int32_t > mLong;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningUTF8StringOrLong()
    : mType(eUninitialized)
  {
  }

  OwningUTF8StringOrLong(OwningUTF8StringOrLong&& aOther);

  explicit inline OwningUTF8StringOrLong(const OwningUTF8StringOrLong& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningUTF8StringOrLong()
  {
    Uninit();
  }

  [[nodiscard]] nsCString&
  RawSetAsUTF8String();

  [[nodiscard]] nsCString&
  SetAsUTF8String();

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline nsCString&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline nsCString const &
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  [[nodiscard]] int32_t&
  RawSetAsLong();

  [[nodiscard]] int32_t&
  SetAsLong();

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t const &
  GetAsLong() const
  {
    MOZ_RELEASE_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningUTF8StringOrLong&
  operator=(OwningUTF8StringOrLong&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningUTF8StringOrLong&
  operator=(const OwningUTF8StringOrLong& aOther);

private:
  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUTF8String();

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyLong();
};

class OwningUTF8StringOrUTF8StringSequence : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eUTF8String,
    eUTF8StringSequence
  };
public:
  enum class Type
  {
    eUTF8String = TypeOrUninit::eUTF8String,
    eUTF8StringSequence = TypeOrUninit::eUTF8StringSequence
  };

private:
  union Value
  {
    UnionMember<nsCString > mUTF8String;
    UnionMember<Sequence<nsCString> > mUTF8StringSequence;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningUTF8StringOrUTF8StringSequence()
    : mType(eUninitialized)
  {
  }

  OwningUTF8StringOrUTF8StringSequence(OwningUTF8StringOrUTF8StringSequence&& aOther);

  explicit inline OwningUTF8StringOrUTF8StringSequence(const OwningUTF8StringOrUTF8StringSequence& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningUTF8StringOrUTF8StringSequence()
  {
    Uninit();
  }

  [[nodiscard]] nsCString&
  RawSetAsUTF8String();

  [[nodiscard]] nsCString&
  SetAsUTF8String();

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline nsCString&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline nsCString const &
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  [[nodiscard]] Sequence<nsCString>&
  RawSetAsUTF8StringSequence();

  [[nodiscard]] Sequence<nsCString>&
  SetAsUTF8StringSequence();

  inline bool
  IsUTF8StringSequence() const
  {
    return mType == eUTF8StringSequence;
  }

  inline Sequence<nsCString>&
  GetAsUTF8StringSequence()
  {
    MOZ_RELEASE_ASSERT(IsUTF8StringSequence(), "Wrong type!");
    return mValue.mUTF8StringSequence.Value();
  }

  inline Sequence<nsCString> const &
  GetAsUTF8StringSequence() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8StringSequence(), "Wrong type!");
    return mValue.mUTF8StringSequence.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningUTF8StringOrUTF8StringSequence&
  operator=(OwningUTF8StringOrUTF8StringSequence&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningUTF8StringOrUTF8StringSequence&
  operator=(const OwningUTF8StringOrUTF8StringSequence& aOther);

private:
  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUTF8String();

  bool
  TrySetToUTF8StringSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToUTF8StringSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUTF8StringSequence();
};

class OwningUndefinedOrCanvasPattern : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningUndefinedOrCanvasPattern& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eUndefined,
    eCanvasPattern
  };
public:
  enum class Type
  {
    eUndefined = TypeOrUninit::eUndefined,
    eCanvasPattern = TypeOrUninit::eCanvasPattern
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::CanvasPattern> > mCanvasPattern;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningUndefinedOrCanvasPattern()
    : mType(eUninitialized)
  {
  }

  OwningUndefinedOrCanvasPattern(OwningUndefinedOrCanvasPattern&& aOther);

  explicit inline OwningUndefinedOrCanvasPattern(const OwningUndefinedOrCanvasPattern& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningUndefinedOrCanvasPattern()
  {
    Uninit();
  }

  inline bool
  IsUndefined() const
  {
    return mType == eUndefined;
  }

  inline void
  SetUndefined()
  {
    Uninit();
    mType = eUndefined;
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::CanvasPattern>&
  RawSetAsCanvasPattern();

  [[nodiscard]] OwningNonNull<mozilla::dom::CanvasPattern>&
  SetAsCanvasPattern();

  inline bool
  IsCanvasPattern() const
  {
    return mType == eCanvasPattern;
  }

  inline OwningNonNull<mozilla::dom::CanvasPattern>&
  GetAsCanvasPattern()
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    return mValue.mCanvasPattern.Value();
  }

  inline OwningNonNull<mozilla::dom::CanvasPattern> const &
  GetAsCanvasPattern() const
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    return mValue.mCanvasPattern.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningUndefinedOrCanvasPattern&
  operator=(OwningUndefinedOrCanvasPattern&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningUndefinedOrCanvasPattern&
  operator=(const OwningUndefinedOrCanvasPattern& aOther);

private:
  bool
  TrySetToCanvasPattern(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCanvasPattern(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyCanvasPattern();
};

class OwningUndefinedOrCanvasPatternOrNull : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningUndefinedOrCanvasPatternOrNull& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eNull,
    eUndefined,
    eCanvasPattern
  };
public:
  enum class Type
  {
    eNull = TypeOrUninit::eNull,
    eUndefined = TypeOrUninit::eUndefined,
    eCanvasPattern = TypeOrUninit::eCanvasPattern
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::CanvasPattern> > mCanvasPattern;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningUndefinedOrCanvasPatternOrNull()
    : mType(eUninitialized)
  {
  }

  OwningUndefinedOrCanvasPatternOrNull(OwningUndefinedOrCanvasPatternOrNull&& aOther);

  explicit inline OwningUndefinedOrCanvasPatternOrNull(const OwningUndefinedOrCanvasPatternOrNull& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningUndefinedOrCanvasPatternOrNull()
  {
    Uninit();
  }

  inline bool
  IsNull() const
  {
    return mType == eNull;
  }

  inline void
  SetNull()
  {
    Uninit();
    mType = eNull;
  }

  inline bool
  IsUndefined() const
  {
    return mType == eUndefined;
  }

  inline void
  SetUndefined()
  {
    Uninit();
    mType = eUndefined;
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::CanvasPattern>&
  RawSetAsCanvasPattern();

  [[nodiscard]] OwningNonNull<mozilla::dom::CanvasPattern>&
  SetAsCanvasPattern();

  inline bool
  IsCanvasPattern() const
  {
    return mType == eCanvasPattern;
  }

  inline OwningNonNull<mozilla::dom::CanvasPattern>&
  GetAsCanvasPattern()
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    return mValue.mCanvasPattern.Value();
  }

  inline OwningNonNull<mozilla::dom::CanvasPattern> const &
  GetAsCanvasPattern() const
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    return mValue.mCanvasPattern.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningUndefinedOrCanvasPatternOrNull&
  operator=(OwningUndefinedOrCanvasPatternOrNull&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningUndefinedOrCanvasPatternOrNull&
  operator=(const OwningUndefinedOrCanvasPatternOrNull& aOther);

private:
  bool
  TrySetToCanvasPattern(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCanvasPattern(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyCanvasPattern();
};

class OwningUndefinedOrNullOrCanvasPattern : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningUndefinedOrNullOrCanvasPattern& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eNull,
    eUndefined,
    eCanvasPattern
  };
public:
  enum class Type
  {
    eNull = TypeOrUninit::eNull,
    eUndefined = TypeOrUninit::eUndefined,
    eCanvasPattern = TypeOrUninit::eCanvasPattern
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::CanvasPattern> > mCanvasPattern;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningUndefinedOrNullOrCanvasPattern()
    : mType(eUninitialized)
  {
  }

  OwningUndefinedOrNullOrCanvasPattern(OwningUndefinedOrNullOrCanvasPattern&& aOther);

  explicit inline OwningUndefinedOrNullOrCanvasPattern(const OwningUndefinedOrNullOrCanvasPattern& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningUndefinedOrNullOrCanvasPattern()
  {
    Uninit();
  }

  inline bool
  IsNull() const
  {
    return mType == eNull;
  }

  inline void
  SetNull()
  {
    Uninit();
    mType = eNull;
  }

  inline bool
  IsUndefined() const
  {
    return mType == eUndefined;
  }

  inline void
  SetUndefined()
  {
    Uninit();
    mType = eUndefined;
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::CanvasPattern>&
  RawSetAsCanvasPattern();

  [[nodiscard]] OwningNonNull<mozilla::dom::CanvasPattern>&
  SetAsCanvasPattern();

  inline bool
  IsCanvasPattern() const
  {
    return mType == eCanvasPattern;
  }

  inline OwningNonNull<mozilla::dom::CanvasPattern>&
  GetAsCanvasPattern()
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    return mValue.mCanvasPattern.Value();
  }

  inline OwningNonNull<mozilla::dom::CanvasPattern> const &
  GetAsCanvasPattern() const
  {
    MOZ_RELEASE_ASSERT(IsCanvasPattern(), "Wrong type!");
    return mValue.mCanvasPattern.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningUndefinedOrNullOrCanvasPattern&
  operator=(OwningUndefinedOrNullOrCanvasPattern&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningUndefinedOrNullOrCanvasPattern&
  operator=(const OwningUndefinedOrNullOrCanvasPattern& aOther);

private:
  bool
  TrySetToCanvasPattern(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCanvasPattern(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyCanvasPattern();
};

class OwningUnrestrictedDoubleOrString : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eUnrestrictedDouble,
    eString
  };
public:
  enum class Type
  {
    eUnrestrictedDouble = TypeOrUninit::eUnrestrictedDouble,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<double > mUnrestrictedDouble;
    UnionMember<nsString > mString;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningUnrestrictedDoubleOrString()
    : mType(eUninitialized)
  {
  }

  OwningUnrestrictedDoubleOrString(OwningUnrestrictedDoubleOrString&& aOther);

  explicit inline OwningUnrestrictedDoubleOrString(const OwningUnrestrictedDoubleOrString& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningUnrestrictedDoubleOrString()
  {
    Uninit();
  }

  [[nodiscard]] double&
  RawSetAsUnrestrictedDouble();

  [[nodiscard]] double&
  SetAsUnrestrictedDouble();

  inline bool
  IsUnrestrictedDouble() const
  {
    return mType == eUnrestrictedDouble;
  }

  inline double&
  GetAsUnrestrictedDouble()
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    return mValue.mUnrestrictedDouble.Value();
  }

  inline double const &
  GetAsUnrestrictedDouble() const
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    return mValue.mUnrestrictedDouble.Value();
  }

  [[nodiscard]] nsString&
  RawSetAsString();

  [[nodiscard]] nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningUnrestrictedDoubleOrString&
  operator=(OwningUnrestrictedDoubleOrString&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningUnrestrictedDoubleOrString&
  operator=(const OwningUnrestrictedDoubleOrString& aOther);

private:
  bool
  TrySetToUnrestrictedDouble(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUnrestrictedDouble();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();
};

class OwningUnrestrictedFloatOrString : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eUnrestrictedFloat,
    eString
  };
public:
  enum class Type
  {
    eUnrestrictedFloat = TypeOrUninit::eUnrestrictedFloat,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<float > mUnrestrictedFloat;
    UnionMember<nsString > mString;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningUnrestrictedFloatOrString()
    : mType(eUninitialized)
  {
  }

  OwningUnrestrictedFloatOrString(OwningUnrestrictedFloatOrString&& aOther);

  explicit inline OwningUnrestrictedFloatOrString(const OwningUnrestrictedFloatOrString& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningUnrestrictedFloatOrString()
  {
    Uninit();
  }

  [[nodiscard]] float&
  RawSetAsUnrestrictedFloat();

  [[nodiscard]] float&
  SetAsUnrestrictedFloat();

  inline bool
  IsUnrestrictedFloat() const
  {
    return mType == eUnrestrictedFloat;
  }

  inline float&
  GetAsUnrestrictedFloat()
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedFloat(), "Wrong type!");
    return mValue.mUnrestrictedFloat.Value();
  }

  inline float const &
  GetAsUnrestrictedFloat() const
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedFloat(), "Wrong type!");
    return mValue.mUnrestrictedFloat.Value();
  }

  [[nodiscard]] nsString&
  RawSetAsString();

  [[nodiscard]] nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningUnrestrictedFloatOrString&
  operator=(OwningUnrestrictedFloatOrString&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningUnrestrictedFloatOrString&
  operator=(const OwningUnrestrictedFloatOrString& aOther);

private:
  bool
  TrySetToUnrestrictedFloat(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUnrestrictedFloat();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();
};
} // namespace mozilla::dom


#endif // DOM_UNIONTYPES_H_
