#ifndef DOM_BINDINGNAMES_H_
#define DOM_BINDINGNAMES_H_

#include <stddef.h>
#include <stdint.h>
#include "mozilla/Attributes.h"

namespace mozilla::dom {

enum class BindingNamesOffset : uint16_t {
  ANGLE_instanced_arrays = 0,
  APZHitResultFlags = 23,
  AbortController = 41,
  AbortSignal = 57,
  AbstractRange = 69,
  AccessibleNode = 83,
  Addon = 98,
  AddonEvent = 104,
  AddonInstall = 115,
  AddonManager = 128,
  AddonManagerPermissions = 141,
  AnalyserNode = 165,
  Animation = 178,
  AnimationEffect = 188,
  AnimationEvent = 204,
  AnimationPlaybackEvent = 219,
  AnimationTimeline = 242,
  AnonymousContent = 260,
  Attr = 277,
  Audio = 282,
  AudioBuffer = 288,
  AudioBufferSourceNode = 300,
  AudioContext = 322,
  AudioData = 335,
  AudioDecoder = 345,
  AudioDestinationNode = 358,
  AudioEncoder = 379,
  AudioListener = 392,
  AudioNode = 406,
  AudioParam = 416,
  AudioParamMap = 427,
  AudioProcessingEvent = 441,
  AudioScheduledSourceNode = 462,
  AudioTrack = 487,
  AudioTrackList = 498,
  AudioWorklet = 513,
  AudioWorkletGlobalScope = 526,
  AudioWorkletNode = 550,
  AudioWorkletProcessor = 567,
  AuthenticatorAssertionResponse = 589,
  AuthenticatorAttestationResponse = 620,
  AuthenticatorResponse = 653,
  BarProp = 675,
  BaseAudioContext = 683,
  BatteryManager = 700,
  BeforeUnloadEvent = 715,
  BiquadFilterNode = 733,
  Blob = 750,
  BlobEvent = 755,
  BroadcastChannel = 765,
  BrowsingContext = 782,
  BrowsingContextGroup = 798,
  ByteLengthQueuingStrategy = 819,
  CDATASection = 845,
  CSPViolationReportBody = 858,
  CSS = 881,
  CSSAnimation = 885,
  CSSColor = 898,
  CSSColorValue = 907,
  CSSConditionRule = 921,
  CSSContainerRule = 938,
  CSSCounterStyleRule = 955,
  CSSCustomMediaRule = 975,
  CSSCustomPropertyRegisteredEvent = 994,
  CSSFontFaceRule = 1027,
  CSSFontFeatureValuesRule = 1043,
  CSSFontPaletteValuesRule = 1068,
  CSSGroupingRule = 1093,
  CSSHSL = 1109,
  CSSHWB = 1116,
  CSSImageValue = 1123,
  CSSImportRule = 1137,
  CSSKeyframeRule = 1151,
  CSSKeyframesRule = 1167,
  CSSKeywordValue = 1184,
  CSSLCH = 1200,
  CSSLab = 1207,
  CSSLayerBlockRule = 1214,
  CSSLayerStatementRule = 1232,
  CSSMarginRule = 1254,
  CSSMathClamp = 1268,
  CSSMathInvert = 1281,
  CSSMathMax = 1295,
  CSSMathMin = 1306,
  CSSMathNegate = 1317,
  CSSMathProduct = 1331,
  CSSMathSum = 1346,
  CSSMathValue = 1357,
  CSSMatrixComponent = 1370,
  CSSMediaRule = 1389,
  CSSMozDocumentRule = 1402,
  CSSNamespaceRule = 1421,
  CSSNestedDeclarations = 1438,
  CSSNumericArray = 1460,
  CSSNumericValue = 1476,
  CSSOKLCH = 1492,
  CSSOKLab = 1501,
  CSSPageDescriptors = 1510,
  CSSPageRule = 1529,
  CSSPerspective = 1541,
  CSSPositionTryDescriptors = 1556,
  CSSPositionTryRule = 1582,
  CSSPropertyRule = 1601,
  CSSPseudoElement = 1617,
  CSSRGB = 1634,
  CSSRotate = 1641,
  CSSRule = 1651,
  CSSRuleList = 1659,
  CSSScale = 1671,
  CSSScopeRule = 1680,
  CSSSkew = 1693,
  CSSSkewX = 1701,
  CSSSkewY = 1710,
  CSSStartingStyleRule = 1719,
  CSSStyleDeclaration = 1740,
  CSSStyleProperties = 1760,
  CSSStyleRule = 1779,
  CSSStyleSheet = 1792,
  CSSStyleValue = 1806,
  CSSSupportsRule = 1820,
  CSSTransformComponent = 1836,
  CSSTransformValue = 1858,
  CSSTransition = 1876,
  CSSTranslate = 1890,
  CSSUnitValue = 1903,
  CSSUnparsedValue = 1916,
  CSSVariableReferenceValue = 1933,
  Cache = 1959,
  CacheStorage = 1965,
  CallbackDebuggerNotification = 1978,
  CanonicalBrowsingContext = 2007,
  CanvasCaptureMediaStream = 2032,
  CanvasGradient = 2057,
  CanvasPattern = 2072,
  CanvasRenderingContext2D = 2086,
  CaretPosition = 2111,
  CaretStateChangedEvent = 2125,
  ChannelMergerNode = 2148,
  ChannelSplitterNode = 2166,
  ChannelWrapper = 2186,
  CharacterData = 2201,
  CheckerboardReportService = 2215,
  ChildProcessMessageManager = 2241,
  ChildSHistory = 2268,
  ChromeMessageBroadcaster = 2282,
  ChromeMessageSender = 2307,
  ChromeNodeList = 2327,
  ChromeUtils = 2342,
  ChromeWorker = 2354,
  Client = 2367,
  Clients = 2374,
  Clipboard = 2382,
  ClipboardEvent = 2392,
  ClipboardItem = 2407,
  ClonedErrorHolder = 2421,
  CloseEvent = 2439,
  CloseWatcher = 2450,
  CommandEvent = 2463,
  Comment = 2476,
  CompositionEvent = 2484,
  CompressionStream = 2501,
  ConsoleInstance = 2519,
  ConstantSourceNode = 2535,
  ContentFrameMessageManager = 2554,
  ContentProcessMessageManager = 2581,
  ContentVisibilityAutoStateChangeEvent = 2610,
  ConvolverNode = 2648,
  CookieChangeEvent = 2662,
  CookieStore = 2680,
  CookieStoreManager = 2692,
  CountQueuingStrategy = 2711,
  CreateOfferRequest = 2732,
  Credential = 2751,
  CredentialsContainer = 2762,
  Crypto = 2783,
  CryptoKey = 2790,
  CustomElementRegistry = 2800,
  CustomEvent = 2822,
  CustomStateSet = 2834,
  DOMException = 2849,
  DOMImplementation = 2862,
  DOMLocalization = 2880,
  DOMMatrix = 2896,
  DOMMatrixReadOnly = 2906,
  DOMParser = 2924,
  DOMPoint = 2934,
  DOMPointReadOnly = 2943,
  DOMQuad = 2960,
  DOMRect = 2968,
  DOMRectList = 2976,
  DOMRectReadOnly = 2988,
  DOMStringList = 3004,
  DOMStringMap = 3018,
  DOMTokenList = 3031,
  DataTransfer = 3044,
  DataTransferItem = 3057,
  DataTransferItemList = 3074,
  DebuggerNotification = 3095,
  DebuggerNotificationObserver = 3116,
  DecompressionStream = 3145,
  DedicatedWorkerGlobalScope = 3165,
  DelayNode = 3192,
  DeprecationReportBody = 3202,
  DeviceAcceleration = 3224,
  DeviceLightEvent = 3243,
  DeviceMotionEvent = 3260,
  DeviceOrientationEvent = 3278,
  DeviceRotationRate = 3301,
  Directory = 3320,
  Document = 3330,
  DocumentFragment = 3339,
  DocumentL10n = 3356,
  DocumentTimeline = 3369,
  DocumentType = 3386,
  DominatorTree = 3399,
  DragEvent = 3413,
  DynamicsCompressorNode = 3423,
  EXT_blend_minmax = 3446,
  EXT_color_buffer_float = 3463,
  EXT_color_buffer_half_float = 3486,
  EXT_depth_clamp = 3514,
  EXT_disjoint_timer_query = 3530,
  EXT_float_blend = 3555,
  EXT_frag_depth = 3571,
  EXT_sRGB = 3586,
  EXT_shader_texture_lod = 3595,
  EXT_texture_compression_bptc = 3618,
  EXT_texture_compression_rgtc = 3647,
  EXT_texture_filter_anisotropic = 3676,
  EXT_texture_norm16 = 3707,
  Element = 3726,
  ElementInternals = 3734,
  EncodedAudioChunk = 3751,
  EncodedVideoChunk = 3769,
  ErrorEvent = 3787,
  Event = 3798,
  EventCallbackDebuggerNotification = 3804,
  EventCounts = 3838,
  EventSource = 3850,
  EventTarget = 3862,
  Exception = 3874,
  ExtendableCookieChangeEvent = 3884,
  ExtendableEvent = 3912,
  ExtendableMessageEvent = 3928,
  ExtensionAlarms = 3951,
  ExtensionBrowser = 3967,
  ExtensionBrowserSettings = 3984,
  ExtensionBrowserSettingsColorManagement = 4009,
  ExtensionDns = 4049,
  ExtensionEventManager = 4062,
  ExtensionMockAPI = 4084,
  ExtensionPort = 4101,
  ExtensionProxy = 4115,
  ExtensionRuntime = 4130,
  ExtensionScripting = 4147,
  ExtensionSetting = 4166,
  ExtensionTest = 4183,
  External = 4197,
  FeaturePolicy = 4206,
  FeaturePolicyViolationReportBody = 4220,
  FetchEvent = 4253,
  FetchObserver = 4264,
  File = 4278,
  FileList = 4283,
  FileReader = 4292,
  FileReaderSync = 4303,
  FileSystem = 4318,
  FileSystemDirectoryEntry = 4329,
  FileSystemDirectoryHandle = 4354,
  FileSystemDirectoryHandle_AsyncIterator = 4380,
  FileSystemDirectoryIterator = 4420,
  FileSystemDirectoryReader = 4448,
  FileSystemEntry = 4474,
  FileSystemFileEntry = 4490,
  FileSystemFileHandle = 4510,
  FileSystemHandle = 4531,
  FileSystemSyncAccessHandle = 4548,
  FileSystemWritableFileStream = 4575,
  Flex = 4604,
  FlexItemValues = 4609,
  FlexLineValues = 4624,
  FluentBundle = 4639,
  FluentBundleAsyncIterator = 4652,
  FluentBundleIterator = 4678,
  FluentPattern = 4699,
  FluentResource = 4713,
  FocusEvent = 4728,
  FontFace = 4739,
  FontFaceSet = 4748,
  FontFaceSetIterator = 4760,
  FontFaceSetLoadEvent = 4780,
  FormData = 4801,
  FormData_Iterator = 4810,
  FormDataEvent = 4828,
  FragmentDirective = 4842,
  FrameCrashedEvent = 4860,
  FrameLoader = 4878,
  GPU = 4890,
  GPUAdapter = 4894,
  GPUAdapterInfo = 4905,
  GPUBindGroup = 4920,
  GPUBindGroupLayout = 4933,
  GPUBuffer = 4952,
  GPUBufferUsage = 4962,
  GPUCanvasContext = 4977,
  GPUColorWrite = 4994,
  GPUCommandBuffer = 5008,
  GPUCommandEncoder = 5025,
  GPUCompilationInfo = 5043,
  GPUCompilationMessage = 5062,
  GPUComputePassEncoder = 5084,
  GPUComputePipeline = 5106,
  GPUDevice = 5125,
  GPUDeviceLostInfo = 5135,
  GPUError = 5153,
  GPUExternalTexture = 5162,
  GPUInternalError = 5181,
  GPUMapMode = 5198,
  GPUOutOfMemoryError = 5209,
  GPUPipelineError = 5229,
  GPUPipelineLayout = 5246,
  GPUQuerySet = 5264,
  GPUQueue = 5276,
  GPURenderBundle = 5285,
  GPURenderBundleEncoder = 5301,
  GPURenderPassEncoder = 5324,
  GPURenderPipeline = 5345,
  GPUSampler = 5363,
  GPUShaderModule = 5374,
  GPUShaderStage = 5390,
  GPUSupportedFeatures = 5405,
  GPUSupportedLimits = 5426,
  GPUTexture = 5445,
  GPUTextureUsage = 5456,
  GPUTextureView = 5472,
  GPUUncapturedErrorEvent = 5487,
  GPUValidationError = 5511,
  GainNode = 5530,
  Gamepad = 5539,
  GamepadAxisMoveEvent = 5547,
  GamepadButton = 5568,
  GamepadButtonEvent = 5582,
  GamepadEvent = 5601,
  GamepadHapticActuator = 5614,
  GamepadLightIndicator = 5636,
  GamepadPose = 5658,
  GamepadServiceTest = 5670,
  GamepadTouch = 5689,
  Geolocation = 5702,
  GeolocationCoordinates = 5714,
  GeolocationPosition = 5737,
  GeolocationPositionError = 5757,
  GetUserMediaRequest = 5782,
  GleanBoolean = 5802,
  GleanCategory = 5815,
  GleanCounter = 5829,
  GleanCustomDistribution = 5842,
  GleanDatetime = 5866,
  GleanDenominator = 5880,
  GleanDualLabeledCounter = 5897,
  GleanEvent = 5921,
  GleanImpl = 5932,
  GleanLabeled = 5942,
  GleanMemoryDistribution = 5955,
  GleanMetric = 5979,
  GleanNumerator = 5991,
  GleanObject = 6006,
  GleanPingsImpl = 6018,
  GleanQuantity = 6033,
  GleanRate = 6047,
  GleanString = 6057,
  GleanStringList = 6069,
  GleanText = 6085,
  GleanTimespan = 6095,
  GleanTimingDistribution = 6109,
  GleanUrl = 6133,
  GleanUuid = 6142,
  Grid = 6152,
  GridArea = 6157,
  GridDimension = 6166,
  GridLine = 6180,
  GridLines = 6189,
  GridTrack = 6199,
  GridTracks = 6209,
  HTMLAllCollection = 6220,
  HTMLAnchorElement = 6238,
  HTMLAreaElement = 6256,
  HTMLAudioElement = 6272,
  HTMLBRElement = 6289,
  HTMLBaseElement = 6303,
  HTMLBodyElement = 6319,
  HTMLButtonElement = 6335,
  HTMLCanvasElement = 6353,
  HTMLCollection = 6371,
  HTMLDListElement = 6386,
  HTMLDataElement = 6403,
  HTMLDataListElement = 6419,
  HTMLDetailsElement = 6439,
  HTMLDialogElement = 6458,
  HTMLDirectoryElement = 6476,
  HTMLDivElement = 6497,
  HTMLDocument = 6512,
  HTMLElement = 6525,
  HTMLEmbedElement = 6537,
  HTMLFieldSetElement = 6554,
  HTMLFontElement = 6574,
  HTMLFormControlsCollection = 6590,
  HTMLFormElement = 6617,
  HTMLFrameElement = 6633,
  HTMLFrameSetElement = 6650,
  HTMLHRElement = 6670,
  HTMLHeadElement = 6684,
  HTMLHeadingElement = 6700,
  HTMLHtmlElement = 6719,
  HTMLIFrameElement = 6735,
  HTMLImageElement = 6753,
  HTMLInputElement = 6770,
  HTMLLIElement = 6787,
  HTMLLabelElement = 6801,
  HTMLLegendElement = 6818,
  HTMLLinkElement = 6836,
  HTMLMapElement = 6852,
  HTMLMarqueeElement = 6867,
  HTMLMediaElement = 6886,
  HTMLMenuElement = 6903,
  HTMLMetaElement = 6919,
  HTMLMeterElement = 6935,
  HTMLModElement = 6952,
  HTMLOListElement = 6967,
  HTMLObjectElement = 6984,
  HTMLOptGroupElement = 7002,
  HTMLOptionElement = 7022,
  HTMLOptionsCollection = 7040,
  HTMLOutputElement = 7062,
  HTMLParagraphElement = 7080,
  HTMLParamElement = 7101,
  HTMLPictureElement = 7118,
  HTMLPreElement = 7137,
  HTMLProgressElement = 7152,
  HTMLQuoteElement = 7172,
  HTMLScriptElement = 7189,
  HTMLSelectElement = 7207,
  HTMLSlotElement = 7225,
  HTMLSourceElement = 7241,
  HTMLSpanElement = 7259,
  HTMLStyleElement = 7275,
  HTMLTableCaptionElement = 7292,
  HTMLTableCellElement = 7316,
  HTMLTableColElement = 7337,
  HTMLTableElement = 7357,
  HTMLTableRowElement = 7374,
  HTMLTableSectionElement = 7394,
  HTMLTemplateElement = 7418,
  HTMLTextAreaElement = 7438,
  HTMLTimeElement = 7458,
  HTMLTitleElement = 7474,
  HTMLTrackElement = 7491,
  HTMLUListElement = 7508,
  HTMLUnknownElement = 7525,
  HTMLVideoElement = 7544,
  HashChangeEvent = 7561,
  Headers = 7577,
  Headers_Iterator = 7585,
  HeapSnapshot = 7602,
  Highlight = 7615,
  HighlightRegistry = 7625,
  History = 7643,
  IDBCursor = 7651,
  IDBCursorWithValue = 7661,
  IDBDatabase = 7680,
  IDBFactory = 7692,
  IDBIndex = 7703,
  IDBKeyRange = 7712,
  IDBObjectStore = 7724,
  IDBOpenDBRequest = 7739,
  IDBRequest = 7756,
  IDBTransaction = 7767,
  IDBVersionChangeEvent = 7782,
  IIRFilterNode = 7804,
  IOUtils = 7818,
  IdentityCredential = 7826,
  IdentityProvider = 7845,
  IdleDeadline = 7862,
  Image = 7875,
  ImageBitmap = 7881,
  ImageBitmapRenderingContext = 7893,
  ImageCapture = 7921,
  ImageCaptureError = 7934,
  ImageCaptureErrorEvent = 7952,
  ImageData = 7975,
  ImageDecoder = 7985,
  ImageDocument = 7998,
  ImageTrack = 8012,
  ImageTrackList = 8023,
  InferenceSession = 8038,
  InputEvent = 8055,
  InspectorCSSParser = 8066,
  InspectorFontFace = 8085,
  InspectorUtils = 8103,
  IntersectionObserver = 8118,
  IntersectionObserverEntry = 8139,
  IntlUtils = 8165,
  JSProcessActorChild = 8175,
  JSProcessActorParent = 8195,
  JSWindowActorChild = 8216,
  JSWindowActorParent = 8235,
  KeyEvent = 8255,
  KeyboardEvent = 8264,
  KeyframeEffect = 8278,
  L10nFileSource = 8293,
  L10nOverlays = 8308,
  L10nRegistry = 8321,
  LargestContentfulPaint = 8334,
  LegacyMozTCPSocket = 8357,
  Localization = 8376,
  Location = 8389,
  Lock = 8398,
  LockManager = 8403,
  MIDIAccess = 8415,
  MIDIConnectionEvent = 8426,
  MIDIInput = 8446,
  MIDIInputMap = 8456,
  MIDIMessageEvent = 8469,
  MIDIOutput = 8486,
  MIDIOutputMap = 8497,
  MIDIPort = 8511,
  MLS = 8520,
  MLSGroupView = 8524,
  MOZ_debug = 8537,
  MatchGlob = 8547,
  MatchPattern = 8557,
  MatchPatternSet = 8570,
  MathMLElement = 8586,
  MediaCapabilities = 8600,
  MediaControlService = 8618,
  MediaController = 8638,
  MediaDeviceInfo = 8654,
  MediaDevices = 8670,
  MediaElementAudioSourceNode = 8683,
  MediaEncryptedEvent = 8711,
  MediaError = 8731,
  MediaKeyError = 8742,
  MediaKeyMessageEvent = 8756,
  MediaKeySession = 8777,
  MediaKeyStatusMap = 8793,
  MediaKeyStatusMap_Iterator = 8811,
  MediaKeySystemAccess = 8838,
  MediaKeys = 8859,
  MediaList = 8869,
  MediaMetadata = 8879,
  MediaQueryList = 8893,
  MediaQueryListEvent = 8908,
  MediaRecorder = 8928,
  MediaRecorderErrorEvent = 8942,
  MediaSession = 8966,
  MediaSource = 8979,
  MediaStream = 8991,
  MediaStreamAudioDestinationNode = 9003,
  MediaStreamAudioSourceNode = 9035,
  MediaStreamError = 9062,
  MediaStreamEvent = 9079,
  MediaStreamTrack = 9096,
  MediaStreamTrackAudioSourceNode = 9113,
  MediaStreamTrackEvent = 9145,
  MerchantValidationEvent = 9167,
  MessageBroadcaster = 9191,
  MessageChannel = 9210,
  MessageEvent = 9225,
  MessageListenerManager = 9238,
  MessagePort = 9261,
  MessageSender = 9273,
  MimeType = 9287,
  MimeTypeArray = 9296,
  MouseEvent = 9310,
  MouseScrollEvent = 9321,
  MozCanvasPrintState = 9338,
  MozDocumentMatcher = 9358,
  MozDocumentObserver = 9377,
  MozQueryInterface = 9397,
  MozSharedMap = 9415,
  MozSharedMap_Iterator = 9428,
  MozSharedMapChangeEvent = 9450,
  MozStorageAsyncStatementParams = 9474,
  MozStorageStatementParams = 9505,
  MozStorageStatementRow = 9531,
  MozWritableSharedMap = 9554,
  MutationObserver = 9575,
  MutationRecord = 9592,
  NamedNodeMap = 9607,
  NavigateEvent = 9620,
  Navigation = 9634,
  NavigationActivation = 9645,
  NavigationCurrentEntryChangeEvent = 9666,
  NavigationDestination = 9700,
  NavigationHistoryEntry = 9722,
  NavigationPrecommitController = 9745,
  NavigationPreloadManager = 9775,
  NavigationTransition = 9800,
  Navigator = 9821,
  NavigatorLogin = 9831,
  NetworkInformation = 9846,
  Node = 9865,
  NodeFilter = 9870,
  NodeIterator = 9881,
  NodeList = 9894,
  Notification = 9903,
  NotificationEvent = 9916,
  NotifyPaintEvent = 9934,
  OES_draw_buffers_indexed = 9951,
  OES_element_index_uint = 9976,
  OES_fbo_render_mipmap = 9999,
  OES_standard_derivatives = 10021,
  OES_texture_float = 10046,
  OES_texture_float_linear = 10064,
  OES_texture_half_float = 10089,
  OES_texture_half_float_linear = 10112,
  OES_vertex_array_object = 10142,
  OVR_multiview2 = 10166,
  OfflineAudioCompletionEvent = 10181,
  OfflineAudioContext = 10209,
  OffscreenCanvas = 10229,
  OffscreenCanvasRenderingContext2D = 10245,
  OnlyForUseInConstructor = 10279,
  Option = 10303,
  OscillatorNode = 10310,
  PageTransitionEvent = 10325,
  PaintRequest = 10345,
  PaintRequestList = 10358,
  PaintWorkletGlobalScope = 10375,
  PannerNode = 10399,
  ParentProcessMessageManager = 10410,
  Path2D = 10438,
  PathUtils = 10445,
  PaymentAddress = 10455,
  PaymentMethodChangeEvent = 10470,
  PaymentRequest = 10495,
  PaymentRequestUpdateEvent = 10510,
  PaymentResponse = 10536,
  Performance = 10552,
  PerformanceEntry = 10564,
  PerformanceEntryEvent = 10581,
  PerformanceEventTiming = 10603,
  PerformanceMark = 10626,
  PerformanceMeasure = 10642,
  PerformanceNavigation = 10661,
  PerformanceNavigationTiming = 10683,
  PerformanceObserver = 10711,
  PerformanceObserverEntryList = 10731,
  PerformancePaintTiming = 10760,
  PerformanceResourceTiming = 10783,
  PerformanceServerTiming = 10809,
  PerformanceTiming = 10833,
  PeriodicWave = 10851,
  PermissionStatus = 10864,
  Permissions = 10881,
  PlacesBookmark = 10893,
  PlacesBookmarkAddition = 10908,
  PlacesBookmarkChanged = 10931,
  PlacesBookmarkGuid = 10953,
  PlacesBookmarkKeyword = 10972,
  PlacesBookmarkMoved = 10994,
  PlacesBookmarkRemoved = 11014,
  PlacesBookmarkTags = 11036,
  PlacesBookmarkTime = 11055,
  PlacesBookmarkTitle = 11074,
  PlacesBookmarkUrl = 11094,
  PlacesEvent = 11112,
  PlacesEventCounts = 11124,
  PlacesFavicon = 11142,
  PlacesHistoryCleared = 11156,
  PlacesObservers = 11177,
  PlacesPurgeCaches = 11193,
  PlacesRanking = 11211,
  PlacesVisit = 11225,
  PlacesVisitRemoved = 11237,
  PlacesVisitTitle = 11256,
  PlacesWeakCallbackWrapper = 11273,
  Plugin = 11299,
  PluginArray = 11306,
  PluginCrashedEvent = 11318,
  PointerEvent = 11337,
  PopStateEvent = 11350,
  PopupBlockedEvent = 11364,
  PopupPositionedEvent = 11382,
  PositionStateEvent = 11403,
  PrecompiledScript = 11422,
  PrivateAttribution = 11440,
  ProcessMessageManager = 11459,
  ProcessingInstruction = 11481,
  ProgressEvent = 11503,
  PromiseDebugging = 11517,
  PromiseNativeHandler = 11534,
  PromiseRejectionEvent = 11555,
  PublicKeyCredential = 11577,
  PushEvent = 11597,
  PushManager = 11607,
  PushManagerImpl = 11619,
  PushMessageData = 11635,
  PushSubscription = 11651,
  PushSubscriptionChangeEvent = 11668,
  PushSubscriptionOptions = 11696,
  RadioNodeList = 11720,
  Range = 11734,
  ReadableByteStreamController = 11740,
  ReadableStream = 11769,
  ReadableStream_AsyncIterator = 11784,
  ReadableStreamBYOBReader = 11813,
  ReadableStreamBYOBRequest = 11838,
  ReadableStreamDefaultController = 11864,
  ReadableStreamDefaultReader = 11896,
  RedirectBlockedEvent = 11924,
  Report = 11945,
  ReportBody = 11952,
  ReportingObserver = 11963,
  Request = 11981,
  ResizeObserver = 11989,
  ResizeObserverEntry = 12004,
  ResizeObserverSize = 12024,
  Response = 12043,
  SVGAElement = 12052,
  SVGAngle = 12064,
  SVGAnimateElement = 12073,
  SVGAnimateMotionElement = 12091,
  SVGAnimateTransformElement = 12115,
  SVGAnimatedAngle = 12142,
  SVGAnimatedBoolean = 12159,
  SVGAnimatedEnumeration = 12178,
  SVGAnimatedInteger = 12201,
  SVGAnimatedLength = 12220,
  SVGAnimatedLengthList = 12238,
  SVGAnimatedNumber = 12260,
  SVGAnimatedNumberList = 12278,
  SVGAnimatedPreserveAspectRatio = 12300,
  SVGAnimatedRect = 12331,
  SVGAnimatedString = 12347,
  SVGAnimatedTransformList = 12365,
  SVGAnimationElement = 12390,
  SVGCircleElement = 12410,
  SVGClipPathElement = 12427,
  SVGComponentTransferFunctionElement = 12446,
  SVGDefsElement = 12482,
  SVGDescElement = 12497,
  SVGElement = 12512,
  SVGEllipseElement = 12523,
  SVGFEBlendElement = 12541,
  SVGFEColorMatrixElement = 12559,
  SVGFEComponentTransferElement = 12583,
  SVGFECompositeElement = 12613,
  SVGFEConvolveMatrixElement = 12635,
  SVGFEDiffuseLightingElement = 12662,
  SVGFEDisplacementMapElement = 12690,
  SVGFEDistantLightElement = 12718,
  SVGFEDropShadowElement = 12743,
  SVGFEFloodElement = 12766,
  SVGFEFuncAElement = 12784,
  SVGFEFuncBElement = 12802,
  SVGFEFuncGElement = 12820,
  SVGFEFuncRElement = 12838,
  SVGFEGaussianBlurElement = 12856,
  SVGFEImageElement = 12881,
  SVGFEMergeElement = 12899,
  SVGFEMergeNodeElement = 12917,
  SVGFEMorphologyElement = 12939,
  SVGFEOffsetElement = 12962,
  SVGFEPointLightElement = 12981,
  SVGFESpecularLightingElement = 13004,
  SVGFESpotLightElement = 13033,
  SVGFETileElement = 13055,
  SVGFETurbulenceElement = 13072,
  SVGFilterElement = 13095,
  SVGForeignObjectElement = 13112,
  SVGGElement = 13136,
  SVGGeometryElement = 13148,
  SVGGradientElement = 13167,
  SVGGraphicsElement = 13186,
  SVGImageElement = 13205,
  SVGLength = 13221,
  SVGLengthList = 13231,
  SVGLineElement = 13245,
  SVGLinearGradientElement = 13260,
  SVGMPathElement = 13285,
  SVGMarkerElement = 13301,
  SVGMaskElement = 13318,
  SVGMatrix = 13333,
  SVGMetadataElement = 13343,
  SVGNumber = 13362,
  SVGNumberList = 13372,
  SVGPathElement = 13386,
  SVGPathSegment = 13401,
  SVGPatternElement = 13416,
  SVGPoint = 13434,
  SVGPointList = 13443,
  SVGPolygonElement = 13456,
  SVGPolylineElement = 13474,
  SVGPreserveAspectRatio = 13493,
  SVGRadialGradientElement = 13516,
  SVGRect = 13541,
  SVGRectElement = 13549,
  SVGSVGElement = 13564,
  SVGScriptElement = 13578,
  SVGSetElement = 13595,
  SVGStopElement = 13609,
  SVGStringList = 13624,
  SVGStyleElement = 13638,
  SVGSwitchElement = 13654,
  SVGSymbolElement = 13671,
  SVGTSpanElement = 13688,
  SVGTextContentElement = 13704,
  SVGTextElement = 13726,
  SVGTextPathElement = 13741,
  SVGTextPositioningElement = 13760,
  SVGTitleElement = 13786,
  SVGTransform = 13802,
  SVGTransformList = 13815,
  SVGUnitTypes = 13832,
  SVGUseElement = 13845,
  SVGViewElement = 13859,
  Sanitizer = 13874,
  Scheduler = 13884,
  Screen = 13894,
  ScreenLuminance = 13901,
  ScreenOrientation = 13917,
  ScriptProcessorNode = 13935,
  ScrollAreaEvent = 13955,
  SecurityPolicyViolationEvent = 13971,
  Selection = 14000,
  ServiceWorker = 14010,
  ServiceWorkerContainer = 14024,
  ServiceWorkerGlobalScope = 14047,
  ServiceWorkerRegistration = 14072,
  SessionStoreFormData = 14098,
  SessionStoreScrollData = 14119,
  SessionStoreUtils = 14142,
  ShadowRealmGlobalScope = 14160,
  ShadowRoot = 14183,
  SharedWorker = 14194,
  SharedWorkerGlobalScope = 14207,
  SimpleGestureEvent = 14231,
  SourceBuffer = 14250,
  SourceBufferList = 14263,
  SpeechGrammar = 14280,
  SpeechGrammarList = 14294,
  SpeechRecognition = 14312,
  SpeechRecognitionAlternative = 14330,
  SpeechRecognitionError = 14359,
  SpeechRecognitionEvent = 14382,
  SpeechRecognitionResult = 14405,
  SpeechRecognitionResultList = 14429,
  SpeechSynthesis = 14457,
  SpeechSynthesisErrorEvent = 14473,
  SpeechSynthesisEvent = 14499,
  SpeechSynthesisUtterance = 14520,
  SpeechSynthesisVoice = 14545,
  StaticRange = 14566,
  StereoPannerNode = 14578,
  Storage = 14595,
  StorageEvent = 14603,
  StorageManager = 14616,
  StreamFilter = 14631,
  StreamFilterDataEvent = 14644,
  StructuredCloneHolder = 14666,
  StructuredCloneTester = 14688,
  StylePropertyMap = 14710,
  StylePropertyMapReadOnly = 14727,
  StylePropertyMapReadOnly_Iterator = 14752,
  StyleSheet = 14786,
  StyleSheetApplicableStateChangeEvent = 14797,
  StyleSheetList = 14834,
  StyleSheetRemovedEvent = 14849,
  SubmitEvent = 14872,
  SubtleCrypto = 14884,
  SyncMessageSender = 14897,
  SyncReadFile = 14915,
  TCPServerSocket = 14928,
  TCPServerSocketEvent = 14944,
  TCPSocket = 14965,
  TCPSocketErrorEvent = 14975,
  TCPSocketEvent = 14995,
  TaskController = 15010,
  TaskPriorityChangeEvent = 15025,
  TaskSignal = 15049,
  Tensor = 15060,
  TestAttributesOnTypes = 15067,
  TestCEReactionsInterface = 15089,
  TestCImplementedInterface = 15114,
  TestCImplementedInterface2 = 15140,
  TestCallbackDictUnionOverload = 15167,
  TestChildInterface = 15197,
  TestConstructorForFuncInterface = 15216,
  TestConstructorForPrefInterface = 15248,
  TestConstructorForSCInterface = 15280,
  TestCppKeywordNamedMethodsInterface = 15310,
  TestDeprecatedInterface = 15346,
  TestExampleInterface = 15370,
  TestExampleProxyInterface = 15391,
  TestExampleThrowingConstructorInterface = 15417,
  TestExampleWorkerInterface = 15457,
  TestFuncConstructorForDifferentFuncInterface = 15484,
  TestFuncConstructorForInterface = 15529,
  TestHTMLConstructorInterface = 15561,
  TestIndexedAndNamedGetterAndSetterInterface = 15590,
  TestIndexedAndNamedGetterInterface = 15634,
  TestIndexedAndNamedSetterInterface = 15669,
  TestIndexedGetterAndSetterAndNamedGetterInterface = 15704,
  TestIndexedGetterInterface = 15754,
  TestIndexedSetterInterface = 15781,
  TestInterface = 15808,
  TestInterfaceWithPromiseConstructorArg = 15822,
  TestJSImplInterface = 15861,
  TestJSImplInterface2 = 15881,
  TestJSImplInterface3 = 15902,
  TestJSImplInterface4 = 15923,
  TestJSImplInterface5 = 15944,
  TestJSImplInterface6 = 15965,
  TestJSImplNoInterfaceObject = 15986,
  TestLegacyFactoryFunctionInterface = 16014,
  TestLegacyFactoryFunctionInterface2 = 16049,
  TestNamedDeleterInterface = 16085,
  TestNamedDeleterWithRetvalInterface = 16111,
  TestNamedGetterInterface = 16147,
  TestNamedSetterInterface = 16172,
  TestNamespace = 16197,
  TestNonWrapperCacheInterface = 16211,
  TestParentInterface = 16240,
  TestPrefChromeOnlySCFuncConstructorForInterface = 16260,
  TestPrefConstructorForDifferentPrefInterface = 16308,
  TestPrefConstructorForInterface = 16353,
  TestProtoObjectHackedNamespace = 16385,
  TestRenamedInterface = 16416,
  TestRenamedNamespace = 16437,
  TestSCConstructorForInterface = 16458,
  TestSecureContextInterface = 16488,
  TestThrowingConstructorInterface = 16515,
  TestUtils = 16548,
  TestWorkerExposedInterface = 16558,
  TestingDeprecatedInterface = 16585,
  Text = 16612,
  TextClause = 16617,
  TextDecoder = 16628,
  TextDecoderStream = 16640,
  TextEncoder = 16658,
  TextEncoderStream = 16670,
  TextEvent = 16688,
  TextMetrics = 16698,
  TextTrack = 16710,
  TextTrackCue = 16720,
  TextTrackCueList = 16733,
  TextTrackList = 16750,
  TimeEvent = 16764,
  TimeRanges = 16774,
  ToggleEvent = 16785,
  Touch = 16797,
  TouchEvent = 16803,
  TouchList = 16814,
  TrackEvent = 16824,
  TransformStream = 16835,
  TransformStreamDefaultController = 16851,
  TransitionEvent = 16884,
  TreeColumn = 16900,
  TreeColumns = 16911,
  TreeContentView = 16923,
  TreeWalker = 16939,
  TrustedHTML = 16950,
  TrustedScript = 16962,
  TrustedScriptURL = 16976,
  TrustedTypePolicy = 16993,
  TrustedTypePolicyFactory = 17011,
  UDPMessageEvent = 17036,
  UDPSocket = 17052,
  UIEvent = 17062,
  URL = 17070,
  URLPattern = 17074,
  URLSearchParams = 17085,
  URLSearchParams_Iterator = 17101,
  UniFFIPointer = 17126,
  UniFFIScaffolding = 17140,
  UserActivation = 17158,
  UserInteraction = 17173,
  UserProximityEvent = 17189,
  VRDisplay = 17208,
  VRDisplayCapabilities = 17218,
  VRDisplayEvent = 17240,
  VREyeParameters = 17255,
  VRFieldOfView = 17271,
  VRFrameData = 17285,
  VRMockController = 17297,
  VRMockDisplay = 17314,
  VRPose = 17328,
  VRServiceTest = 17335,
  VRStageParameters = 17349,
  VTTCue = 17367,
  VTTRegion = 17374,
  ValidityState = 17384,
  VideoColorSpace = 17398,
  VideoDecoder = 17414,
  VideoEncoder = 17427,
  VideoFrame = 17440,
  VideoPlaybackQuality = 17451,
  VideoTrack = 17472,
  VideoTrackList = 17483,
  ViewTransition = 17498,
  VisualViewport = 17513,
  WEBGL_color_buffer_float = 17528,
  WEBGL_compressed_texture_astc = 17553,
  WEBGL_compressed_texture_etc = 17583,
  WEBGL_compressed_texture_etc1 = 17612,
  WEBGL_compressed_texture_pvrtc = 17642,
  WEBGL_compressed_texture_s3tc = 17673,
  WEBGL_compressed_texture_s3tc_srgb = 17703,
  WEBGL_debug_renderer_info = 17738,
  WEBGL_debug_shaders = 17764,
  WEBGL_depth_texture = 17784,
  WEBGL_draw_buffers = 17804,
  WEBGL_explicit_present = 17823,
  WEBGL_lose_context = 17846,
  WEBGL_provoking_vertex = 17865,
  WGSLLanguageFeatures = 17888,
  WakeLock = 17909,
  WakeLockSentinel = 17918,
  WaveShaperNode = 17935,
  WebExtensionContentScript = 17950,
  WebExtensionPolicy = 17976,
  WebGL2RenderingContext = 17995,
  WebGLActiveInfo = 18018,
  WebGLBuffer = 18034,
  WebGLContextEvent = 18046,
  WebGLFramebuffer = 18064,
  WebGLProgram = 18081,
  WebGLQuery = 18094,
  WebGLRenderbuffer = 18105,
  WebGLRenderingContext = 18123,
  WebGLSampler = 18145,
  WebGLShader = 18158,
  WebGLShaderPrecisionFormat = 18170,
  WebGLSync = 18197,
  WebGLTexture = 18207,
  WebGLTransformFeedback = 18220,
  WebGLUniformLocation = 18243,
  WebGLVertexArrayObject = 18264,
  WebKitCSSMatrix = 18287,
  WebSocket = 18303,
  WebTransport = 18313,
  WebTransportBidirectionalStream = 18326,
  WebTransportDatagramDuplexStream = 18358,
  WebTransportError = 18391,
  WebTransportReceiveStream = 18409,
  WebTransportSendStream = 18435,
  WheelEvent = 18458,
  Window = 18469,
  WindowClient = 18476,
  WindowContext = 18489,
  WindowGlobalChild = 18503,
  WindowGlobalParent = 18521,
  WindowRoot = 18540,
  Worker = 18551,
  WorkerDebuggerGlobalScope = 18558,
  WorkerGlobalScope = 18584,
  WorkerLocation = 18602,
  WorkerNavigator = 18617,
  WorkerTestUtils = 18633,
  Worklet = 18649,
  WorkletGlobalScope = 18657,
  WritableStream = 18676,
  WritableStreamDefaultController = 18691,
  WritableStreamDefaultWriter = 18723,
  XMLDocument = 18751,
  XMLHttpRequest = 18763,
  XMLHttpRequestEventTarget = 18778,
  XMLHttpRequestUpload = 18804,
  XMLSerializer = 18825,
  XPathEvaluator = 18839,
  XPathExpression = 18854,
  XPathResult = 18870,
  XRBoundedReferenceSpace = 18882,
  XRFrame = 18906,
  XRInputSource = 18914,
  XRInputSourceArray = 18928,
  XRInputSourceEvent = 18947,
  XRInputSourcesChangeEvent = 18966,
  XRPose = 18992,
  XRReferenceSpace = 18999,
  XRReferenceSpaceEvent = 19016,
  XRRenderState = 19038,
  XRRigidTransform = 19052,
  XRSession = 19069,
  XRSessionEvent = 19079,
  XRSpace = 19094,
  XRSystem = 19102,
  XRView = 19111,
  XRViewerPose = 19118,
  XRViewport = 19131,
  XRWebGLLayer = 19142,
  XSLTProcessor = 19155,
  XULCommandEvent = 19169,
  XULElement = 19185,
  XULFrameElement = 19196,
  XULMenuElement = 19212,
  XULPopupElement = 19227,
  XULResizerElement = 19243,
  XULTextElement = 19261,
  XULTreeElement = 19276,
  console = 19291,
  webkitSpeechGrammar = 19299,
  webkitSpeechGrammarList = 19319,
  webkitSpeechRecognition = 19343,
  webkitURL = 19367,
};

namespace binding_detail {
extern const char sBindingNames[];
}  // namespace binding_detail

MOZ_ALWAYS_INLINE const char* BindingName(BindingNamesOffset aOffset) {
  return binding_detail::sBindingNames + static_cast<size_t>(aOffset);
}

} // namespace mozilla::dom


#endif // DOM_BINDINGNAMES_H_
