/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim: set ts=8 sts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_Components_h
#define mozilla_Components_h

#include "nsCOMPtr.h"

struct nsID;

#define NS_IMPL_COMPONENT_FACTORY(iface) \
  template <>                            \
  already_AddRefed<nsISupports> mozCreateComponent<iface>()

template <typename T>
already_AddRefed<nsISupports> mozCreateComponent();

namespace mozilla {
namespace xpcom {

enum class ModuleID : uint16_t {
  Anonymous349,
  Anonymous275,
  Anonymous147,
  Anonymous314,
  Anonymous368,
  NSSComponent,
  Anonymous052,
  Console,
  DNS,
  Anonymous064,
  Anonymous072,
  Anonymous048,
  Anonymous046,
  Anonymous227,
  NetworkErrorLogging,
  Anonymous143,
  Anonymous173,
  Anonymous251,
  Anonymous077,
  Anonymous216,
  Anonymous145,
  Anonymous119,
  CacheStorage,
  Anonymous201,
  Anonymous253,
  Anonymous298,
  Anonymous058,
  DocLoader,
  Anonymous065,
  Anonymous151,
  Anonymous423,
  Anonymous117,
  Observer,
  Anonymous045,
  Anonymous316,
  Anonymous211,
  Anonymous215,
  Anonymous233,
  Anonymous344,
  Anonymous056,
  Anonymous008,
  AsyncShutdown,
  CookieBannerService,
  Anonymous328,
  Anonymous351,
  URLQueryStringStripper,
  Anonymous130,
  Anonymous293,
  Anonymous388,
  Anonymous371,
  Anonymous150,
  Anonymous260,
  Anonymous168,
  Anonymous330,
  Anonymous213,
  Anonymous013,
  Anonymous369,
  Anonymous087,
  Anonymous360,
  Anonymous183,
  Anonymous442,
  Anonymous228,
  Anonymous133,
  Anonymous329,
  Anonymous113,
  Anonymous239,
  Anonymous415,
  Anonymous353,
  Anonymous031,
  Anonymous141,
  Anonymous125,
  Anonymous198,
  Anonymous281,
  Anonymous207,
  Anonymous391,
  Anonymous333,
  Anonymous196,
  Anonymous156,
  Anonymous199,
  Anonymous004,
  Anonymous115,
  ContentSecurityManager,
  Anonymous297,
  Anonymous238,
  Anonymous161,
  CaptivePortal,
  Anonymous393,
  AppStartup,
  Anonymous124,
  Anonymous382,
  Anonymous243,
  Anonymous272,
  ProtocolProxy,
  Anonymous053,
  Anonymous154,
  Anonymous160,
  Anonymous039,
  Directory,
  WifiMonitor,
  Anonymous409,
  Anonymous009,
  Anonymous040,
  Anonymous219,
  Anonymous019,
  Anonymous016,
  Anonymous021,
  Anonymous307,
  StringBundle,
  Anonymous237,
  FileProtocolHandler,
  Anonymous336,
  Anonymous428,
  Anonymous051,
  Anonymous012,
  Anonymous223,
  Anonymous163,
  Anonymous165,
  Anonymous217,
  Anonymous317,
  Anonymous174,
  Anonymous127,
  Anonymous375,
  Anonymous138,
  Anonymous346,
  Anonymous304,
  Anonymous167,
  Anonymous259,
  Anonymous190,
  Anonymous311,
  Anonymous140,
  Anonymous247,
  Anonymous398,
  Anonymous320,
  Anonymous322,
  Anonymous078,
  Anonymous090,
  Anonymous245,
  Anonymous146,
  Anonymous282,
  Anonymous191,
  Anonymous378,
  Anonymous129,
  Anonymous411,
  Anonymous256,
  Anonymous034,
  Anonymous018,
  Anonymous338,
  Prefetch,
  Anonymous234,
  Anonymous390,
  GfxInfo,
  Anonymous443,
  Anonymous300,
  Anonymous318,
  Anonymous315,
  Anonymous197,
  Anonymous454,
  Anonymous325,
  Anonymous354,
  Anonymous182,
  Predictor,
  Anonymous267,
  ExtensionPolicy,
  Anonymous395,
  Anonymous030,
  Anonymous123,
  Anonymous421,
  Anonymous084,
  Anonymous254,
  Anonymous269,
  Anonymous204,
  Anonymous404,
  Anonymous166,
  Anonymous334,
  Anonymous364,
  Anonymous419,
  Anonymous111,
  UrlClassifierTestUtils,
  Anonymous149,
  URIFixup,
  Anonymous049,
  Anonymous188,
  UrlClassifierDB,
  EffectiveTLD,
  XULRuntime,
  Alerts,
  Anonymous263,
  TextToSubURI,
  Anonymous071,
  IdentityCredentialStorageService,
  Anonymous103,
  Anonymous394,
  Anonymous361,
  Anonymous439,
  Anonymous405,
  ApplicationReputation,
  Anonymous352,
  RFPService,
  Anonymous399,
  Anonymous335,
  Anonymous294,
  Anonymous347,
  Anonymous134,
  Anonymous274,
  Anonymous024,
  UrlClassifierUtils,
  Anonymous403,
  Anonymous310,
  RandomGenerator,
  Anonymous373,
  Anonymous192,
  Anonymous060,
  Anonymous339,
  Anonymous062,
  CredentialChooserService,
  Anonymous437,
  IO,
  Anonymous057,
  Anonymous205,
  Anonymous327,
  Anonymous180,
  Anonymous027,
  Anonymous323,
  Anonymous184,
  Anonymous380,
  Anonymous448,
  HttpHandler,
  Anonymous416,
  Anonymous291,
  Anonymous324,
  Anonymous235,
  Anonymous093,
  Anonymous326,
  Anonymous222,
  Anonymous246,
  Anonymous290,
  Anonymous402,
  Anonymous438,
  Anonymous108,
  URILoader,
  Anonymous186,
  PlacesPreviewsHelper,
  Anonymous319,
  Anonymous332,
  Anonymous122,
  Anonymous107,
  Dashboard,
  Anonymous033,
  Anonymous178,
  Anonymous061,
  Anonymous385,
  Anonymous355,
  Anonymous386,
  CategoryManager,
  Anonymous104,
  Anonymous444,
  Anonymous286,
  Anonymous358,
  UrlClassifierPrefixSet,
  Anonymous359,
  Anonymous312,
  Anonymous446,
  Anonymous194,
  Anonymous407,
  Anonymous170,
  Anonymous210,
  Anonymous159,
  Anonymous350,
  Anonymous342,
  Anonymous379,
  Anonymous445,
  Anonymous023,
  Anonymous085,
  Anonymous313,
  TypeAheadFind,
  Anonymous406,
  AuthPromptAdapter,
  Anonymous426,
  Anonymous055,
  Anonymous067,
  Anonymous348,
  History,
  Anonymous080,
  Anonymous091,
  Anonymous451,
  Anonymous370,
  Anonymous155,
  DownloadPlatform,
  Anonymous144,
  Anonymous175,
  Anonymous383,
  Anonymous337,
  Anonymous010,
  Anonymous271,
  Anonymous366,
  Anonymous221,
  Anonymous262,
  Anonymous070,
  Anonymous302,
  Anonymous362,
  MimeHeaderParam,
  SocketTransport,
  Anonymous279,
  Anonymous106,
  WindowWatcher,
  Anonymous277,
  Anonymous028,
  Anonymous449,
  Anonymous212,
  Anonymous088,
  AlertNotification,
  Anonymous179,
  Anonymous005,
  PrivateAttribution,
  Anonymous367,
  Anonymous044,
  Anonymous374,
  Anonymous441,
  Anonymous377,
  Anonymous229,
  Anonymous295,
  Anonymous003,
  Anonymous096,
  Anonymous250,
  Anonymous148,
  Anonymous340,
  Anonymous365,
  Anonymous452,
  Anonymous162,
  Anonymous413,
  Anonymous376,
  Anonymous000,
  Anonymous356,
  Anonymous321,
  Anonymous020,
  Anonymous032,
  Anonymous264,
  Anonymous195,
  Anonymous343,
  Anonymous036,
  Anonymous116,
  Anonymous230,
  Anonymous309,
  PermissionManager,
  Anonymous384,
  Anonymous242,
  Anonymous193,
  Anonymous224,
  Anonymous430,
  NSSCertificateDB,
  Anonymous225,
  Anonymous433,
  Anonymous100,
  Anonymous434,
  Anonymous283,
  Anonymous112,
  Anonymous226,
  Anonymous092,
  Anonymous341,
  Anonymous177,
  SiteSecurity,
  Anonymous014,
  Anonymous075,
  Anonymous038,
  Anonymous389,
  Anonymous187,
  Anonymous139,
  Anonymous086,
  Anonymous288,
  StreamConverter,
  Anonymous345,
  UUIDGenerator,
  Anonymous076,
  Anonymous249,
  Anonymous152,
  Anonymous417,
  Anonymous372,
  Anonymous118,
  Anonymous301,
  Anonymous206,
  Anonymous420,
  Anonymous220,
  Anonymous083,
  Anonymous396,
  nsIWindowsTestDebug,
  IdentityCredentialPromptService,
  Anonymous303,
  Anonymous029,
  Anonymous181,
  Anonymous011,
  Anonymous429,
  Anonymous082,
  Anonymous101,
  FindService,
  Anonymous202,
  Anonymous252,
  Anonymous073,
  Anonymous308,
  BounceTrackingProtection,
  Anonymous244,
  Anonymous200,
  Anonymous126,
  Anonymous164,
  Anonymous169,
  Anonymous401,
  Anonymous068,
  Anonymous268,
  Anonymous172,
  Anonymous431,
  Anonymous041,
  Anonymous241,
  Anonymous208,
  Anonymous095,
  Anonymous098,
  ChromeRegistry,
  IDN,
  Anonymous132,
  CORSPreflightCache,
  Anonymous266,
  Anonymous097,
  Anonymous109,
  Anonymous410,
  Anonymous063,
  PageThumbsStorage,
  Anonymous412,
  Anonymous440,
  Anonymous447,
  Anonymous273,
  ExternalProtocolHandler,
  Anonymous292,
  Anonymous432,
  Anonymous296,
  Anonymous158,
  Anonymous285,
  Anonymous422,
  Anonymous110,
  Anonymous331,
  Anonymous007,
  SystemInfo,
  Anonymous436,
  Anonymous102,
  Anonymous171,
  Anonymous387,
  Anonymous059,
  Anonymous248,
  Anonymous299,
  nsIContentAnalysis,
  Anonymous079,
  Anonymous025,
  Anonymous002,
  Anonymous240,
  Anonymous232,
  Anonymous135,
  Anonymous026,
  Anonymous128,
  Anonymous231,
  Anonymous397,
  Anonymous042,
  Anonymous137,
  Anonymous287,
  Anonymous142,
  Anonymous414,
  Anonymous131,
  Anonymous276,
  Anonymous203,
  Anonymous081,
  ServiceWorkerManager,
  ScriptSecurityManager,
  Anonymous066,
  Anonymous236,
  Anonymous270,
  Anonymous043,
  NSSErrors,
  StreamTransport,
  Anonymous289,
  Anonymous284,
  Anonymous120,
  Anonymous136,
  Anonymous069,
  Anonymous017,
  Anonymous418,
  Anonymous408,
  Anonymous255,
  Preferences,
  Anonymous037,
  Anonymous392,
  Anonymous363,
  Anonymous121,
  Anonymous099,
  UrlClassifierStreamUpdater,
  HttpActivityDistributor,
  Anonymous305,
  Anonymous001,
  Anonymous425,
  Anonymous306,
  Anonymous280,
  Anonymous015,
  Anonymous105,
  Anonymous218,
  Anonymous185,
  Anonymous435,
  Anonymous094,
  Anonymous258,
  Anonymous050,
  Anonymous261,
  Anonymous074,
  Anonymous265,
  Anonymous214,
  Anonymous176,
  Anonymous022,
  Anonymous189,
  Anonymous278,
  AddonContentPolicy,
  Anonymous035,
  Anonymous047,
  Anonymous427,
  Anonymous400,
  Anonymous424,
  Anonymous114,
  ThirdPartyUtil,
  Anonymous089,
  Anonymous450,
  Locale,
  Anonymous381,
  Anonymous357,
  Anonymous153,
  Anonymous054,
  Anonymous157,
  Anonymous209,
  Anonymous257,
  Anonymous453,
  Anonymous006,

};

// May be added as a friend function to allow constructing services via
// private constructors and init methods.
nsresult CreateInstanceImpl(ModuleID aID, const nsIID& aIID, void** aResult);

class MOZ_STACK_CLASS StaticModuleHelper : public nsCOMPtr_helper {
 public:
  StaticModuleHelper(ModuleID aId, nsresult* aErrorPtr)
      : mId(aId), mErrorPtr(aErrorPtr) {}

 protected:
  nsresult SetResult(nsresult aRv) const {
    if (mErrorPtr) {
      *mErrorPtr = aRv;
    }
    return aRv;
  }

  ModuleID mId;
  nsresult* mErrorPtr;
};

class MOZ_STACK_CLASS GetServiceHelper final : public StaticModuleHelper {
 public:
  using StaticModuleHelper::StaticModuleHelper;

  nsresult NS_FASTCALL operator()(const nsIID& aIID,
                                  void** aResult) const override;
};

class MOZ_STACK_CLASS CreateInstanceHelper final : public StaticModuleHelper {
 public:
  using StaticModuleHelper::StaticModuleHelper;

  nsresult NS_FASTCALL operator()(const nsIID& aIID,
                                  void** aResult) const override;
};

class Components final {
 public:
  static const nsID& GetCID(ModuleID aID);
};

}  // namespace xpcom

namespace components {

namespace AddonContentPolicy {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AddonContentPolicy);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AddonContentPolicy, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AddonContentPolicy, aRv};
}
}  // namespace AddonContentPolicy

namespace AlertNotification {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AlertNotification);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AlertNotification, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AlertNotification, aRv};
}
}  // namespace AlertNotification

namespace Alerts {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Alerts);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Alerts, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Alerts, aRv};
}
}  // namespace Alerts

namespace AppStartup {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AppStartup);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AppStartup, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AppStartup, aRv};
}
}  // namespace AppStartup

namespace ApplicationReputation {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ApplicationReputation);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ApplicationReputation, aRv};
}
}  // namespace ApplicationReputation

namespace AsyncShutdown {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AsyncShutdown);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AsyncShutdown, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AsyncShutdown, aRv};
}
}  // namespace AsyncShutdown

namespace AuthPromptAdapter {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AuthPromptAdapter);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AuthPromptAdapter, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AuthPromptAdapter, aRv};
}
}  // namespace AuthPromptAdapter

namespace BounceTrackingProtection {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::BounceTrackingProtection);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::BounceTrackingProtection, aRv};
}
}  // namespace BounceTrackingProtection

namespace CORSPreflightCache {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::CORSPreflightCache);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CORSPreflightCache, aRv};
}
}  // namespace CORSPreflightCache

namespace CacheStorage {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::CacheStorage);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CacheStorage, aRv};
}
}  // namespace CacheStorage

namespace CaptivePortal {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::CaptivePortal);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CaptivePortal, aRv};
}
}  // namespace CaptivePortal

namespace CategoryManager {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::CategoryManager);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CategoryManager, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CategoryManager, aRv};
}
}  // namespace CategoryManager

namespace ChromeRegistry {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ChromeRegistry);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ChromeRegistry, aRv};
}
}  // namespace ChromeRegistry

namespace Console {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Console);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Console, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Console, aRv};
}
}  // namespace Console

namespace ContentSecurityManager {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ContentSecurityManager);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ContentSecurityManager, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ContentSecurityManager, aRv};
}
}  // namespace ContentSecurityManager

namespace CookieBannerService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::CookieBannerService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CookieBannerService, aRv};
}
}  // namespace CookieBannerService

namespace CredentialChooserService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::CredentialChooserService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CredentialChooserService, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CredentialChooserService, aRv};
}
}  // namespace CredentialChooserService

namespace DNS {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::DNS);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DNS, aRv};
}
}  // namespace DNS

namespace Dashboard {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Dashboard);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Dashboard, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Dashboard, aRv};
}
}  // namespace Dashboard

namespace Directory {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Directory);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Directory, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Directory, aRv};
}
}  // namespace Directory

namespace DocLoader {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::DocLoader);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DocLoader, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DocLoader, aRv};
}
}  // namespace DocLoader

namespace DownloadPlatform {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::DownloadPlatform);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DownloadPlatform, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DownloadPlatform, aRv};
}
}  // namespace DownloadPlatform

namespace EffectiveTLD {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::EffectiveTLD);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::EffectiveTLD, aRv};
}
}  // namespace EffectiveTLD

namespace ExtensionPolicy {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ExtensionPolicy);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ExtensionPolicy, aRv};
}
}  // namespace ExtensionPolicy

namespace ExternalProtocolHandler {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ExternalProtocolHandler);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ExternalProtocolHandler, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ExternalProtocolHandler, aRv};
}
}  // namespace ExternalProtocolHandler

namespace FileProtocolHandler {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::FileProtocolHandler);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::FileProtocolHandler, aRv};
}
}  // namespace FileProtocolHandler

namespace FindService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::FindService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::FindService, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::FindService, aRv};
}
}  // namespace FindService

namespace GfxInfo {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::GfxInfo);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::GfxInfo, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::GfxInfo, aRv};
}
}  // namespace GfxInfo

namespace History {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::History);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::History, aRv};
}
}  // namespace History

namespace HttpActivityDistributor {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::HttpActivityDistributor);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::HttpActivityDistributor, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::HttpActivityDistributor, aRv};
}
}  // namespace HttpActivityDistributor

namespace HttpHandler {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::HttpHandler);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::HttpHandler, aRv};
}
}  // namespace HttpHandler

namespace IDN {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::IDN);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IDN, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IDN, aRv};
}
}  // namespace IDN

namespace IO {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::IO);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IO, aRv};
}
}  // namespace IO

namespace IdentityCredentialPromptService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::IdentityCredentialPromptService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IdentityCredentialPromptService, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IdentityCredentialPromptService, aRv};
}
}  // namespace IdentityCredentialPromptService

namespace IdentityCredentialStorageService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::IdentityCredentialStorageService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IdentityCredentialStorageService, aRv};
}
}  // namespace IdentityCredentialStorageService

namespace Locale {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Locale);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Locale, aRv};
}
}  // namespace Locale

namespace MimeHeaderParam {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::MimeHeaderParam);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::MimeHeaderParam, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::MimeHeaderParam, aRv};
}
}  // namespace MimeHeaderParam

namespace NSSCertificateDB {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::NSSCertificateDB);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::NSSCertificateDB, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::NSSCertificateDB, aRv};
}
}  // namespace NSSCertificateDB

namespace NSSComponent {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::NSSComponent);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::NSSComponent, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::NSSComponent, aRv};
}
}  // namespace NSSComponent

namespace NSSErrors {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::NSSErrors);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::NSSErrors, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::NSSErrors, aRv};
}
}  // namespace NSSErrors

namespace NetworkErrorLogging {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::NetworkErrorLogging);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::NetworkErrorLogging, aRv};
}
}  // namespace NetworkErrorLogging

namespace Observer {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Observer);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Observer, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Observer, aRv};
}
}  // namespace Observer

namespace PageThumbsStorage {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::PageThumbsStorage);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::PageThumbsStorage, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::PageThumbsStorage, aRv};
}
}  // namespace PageThumbsStorage

namespace PermissionManager {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::PermissionManager);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::PermissionManager, aRv};
}
}  // namespace PermissionManager

namespace PlacesPreviewsHelper {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::PlacesPreviewsHelper);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::PlacesPreviewsHelper, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::PlacesPreviewsHelper, aRv};
}
}  // namespace PlacesPreviewsHelper

namespace Predictor {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Predictor);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Predictor, aRv};
}
}  // namespace Predictor

namespace Preferences {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Preferences);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Preferences, aRv};
}
}  // namespace Preferences

namespace Prefetch {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Prefetch);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Prefetch, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Prefetch, aRv};
}
}  // namespace Prefetch

namespace PrivateAttribution {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::PrivateAttribution);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::PrivateAttribution, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::PrivateAttribution, aRv};
}
}  // namespace PrivateAttribution

namespace ProtocolProxy {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ProtocolProxy);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ProtocolProxy, aRv};
}
}  // namespace ProtocolProxy

namespace RFPService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::RFPService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::RFPService, aRv};
}
}  // namespace RFPService

namespace RandomGenerator {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::RandomGenerator);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::RandomGenerator, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::RandomGenerator, aRv};
}
}  // namespace RandomGenerator

namespace ScriptSecurityManager {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ScriptSecurityManager);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ScriptSecurityManager, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ScriptSecurityManager, aRv};
}
}  // namespace ScriptSecurityManager

namespace ServiceWorkerManager {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ServiceWorkerManager);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ServiceWorkerManager, aRv};
}
}  // namespace ServiceWorkerManager

namespace SiteSecurity {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::SiteSecurity);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::SiteSecurity, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::SiteSecurity, aRv};
}
}  // namespace SiteSecurity

namespace SocketTransport {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::SocketTransport);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::SocketTransport, aRv};
}
}  // namespace SocketTransport

namespace StreamConverter {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::StreamConverter);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StreamConverter, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StreamConverter, aRv};
}
}  // namespace StreamConverter

namespace StreamTransport {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::StreamTransport);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StreamTransport, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StreamTransport, aRv};
}
}  // namespace StreamTransport

namespace StringBundle {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::StringBundle);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StringBundle, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StringBundle, aRv};
}
}  // namespace StringBundle

namespace SystemInfo {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::SystemInfo);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::SystemInfo, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::SystemInfo, aRv};
}
}  // namespace SystemInfo

namespace TextToSubURI {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::TextToSubURI);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::TextToSubURI, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::TextToSubURI, aRv};
}
}  // namespace TextToSubURI

namespace ThirdPartyUtil {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ThirdPartyUtil);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ThirdPartyUtil, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ThirdPartyUtil, aRv};
}
}  // namespace ThirdPartyUtil

namespace TypeAheadFind {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::TypeAheadFind);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::TypeAheadFind, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::TypeAheadFind, aRv};
}
}  // namespace TypeAheadFind

namespace URIFixup {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::URIFixup);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::URIFixup, aRv};
}
}  // namespace URIFixup

namespace URILoader {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::URILoader);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::URILoader, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::URILoader, aRv};
}
}  // namespace URILoader

namespace URLQueryStringStripper {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::URLQueryStringStripper);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::URLQueryStringStripper, aRv};
}
}  // namespace URLQueryStringStripper

namespace UUIDGenerator {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UUIDGenerator);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UUIDGenerator, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UUIDGenerator, aRv};
}
}  // namespace UUIDGenerator

namespace UrlClassifierDB {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UrlClassifierDB);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierDB, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierDB, aRv};
}
}  // namespace UrlClassifierDB

namespace UrlClassifierPrefixSet {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UrlClassifierPrefixSet);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierPrefixSet, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierPrefixSet, aRv};
}
}  // namespace UrlClassifierPrefixSet

namespace UrlClassifierStreamUpdater {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UrlClassifierStreamUpdater);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierStreamUpdater, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierStreamUpdater, aRv};
}
}  // namespace UrlClassifierStreamUpdater

namespace UrlClassifierTestUtils {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UrlClassifierTestUtils);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierTestUtils, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierTestUtils, aRv};
}
}  // namespace UrlClassifierTestUtils

namespace UrlClassifierUtils {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UrlClassifierUtils);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierUtils, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierUtils, aRv};
}
}  // namespace UrlClassifierUtils

namespace WifiMonitor {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::WifiMonitor);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::WifiMonitor, aRv};
}
}  // namespace WifiMonitor

namespace WindowWatcher {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::WindowWatcher);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::WindowWatcher, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::WindowWatcher, aRv};
}
}  // namespace WindowWatcher

namespace XULRuntime {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::XULRuntime);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::XULRuntime, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::XULRuntime, aRv};
}
}  // namespace XULRuntime

namespace nsIContentAnalysis {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::nsIContentAnalysis);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::nsIContentAnalysis, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::nsIContentAnalysis, aRv};
}
}  // namespace nsIContentAnalysis

namespace nsIWindowsTestDebug {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::nsIWindowsTestDebug);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::nsIWindowsTestDebug, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::nsIWindowsTestDebug, aRv};
}
}  // namespace nsIWindowsTestDebug

}  // namespace components

}  // namespace mozilla

#endif
