/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_dom_MlsGkFFI_h
#define mozilla_dom_MlsGkFFI_h

/* Generated with cbindgen:0.29.1 */

/* DO NOT MODIFY THIS MANUALLY! This file was generated using cbindgen. See RunCbindgen.py */


#include <cstdarg>
#include <cstdint>
#include <cstdlib>
#include <ostream>
#include <new>
#include "nsStringFwd.h"
#include "nsTArrayForwardDeclare.h"

namespace mozilla {
namespace security {
namespace mls {

struct GkGroupIdEpoch {
  nsTArray<uint8_t> group_id;
  nsTArray<uint8_t> group_epoch;
};

struct GkClientIdentifiers {
  nsTArray<uint8_t> identity;
  nsTArray<uint8_t> credential;
};

struct GkGroupDetails {
  nsTArray<uint8_t> group_id;
  nsTArray<uint8_t> group_epoch;
  nsTArray<GkClientIdentifiers> group_members;
};

struct GkMlsCommitOutput {
  nsTArray<uint8_t> commit;
  nsTArray<uint8_t> welcome;
  nsTArray<uint8_t> group_info;
  nsTArray<uint8_t> ratchet_tree;
  nsTArray<uint8_t> identity;
};

struct GkReceived {
  enum class Tag {
    None,
    ApplicationMessage,
    GroupIdEpoch,
    CommitOutput,
  };

  struct ApplicationMessage_Body {
    nsTArray<uint8_t> _0;
  };

  struct GroupIdEpoch_Body {
    GkGroupIdEpoch _0;
  };

  struct CommitOutput_Body {
    GkMlsCommitOutput _0;
  };

  Tag tag;
  union {
    ApplicationMessage_Body application_message;
    GroupIdEpoch_Body group_id_epoch;
    CommitOutput_Body commit_output;
  };

  ~GkReceived() {
    switch (tag) {
      case Tag::ApplicationMessage: application_message.~ApplicationMessage_Body(); break;
      case Tag::GroupIdEpoch: group_id_epoch.~GroupIdEpoch_Body(); break;
      case Tag::CommitOutput: commit_output.~CommitOutput_Body(); break;
      default: break;
    }
  }
  GkReceived() : tag(Tag::None) {}
  GkReceived(GkReceived&& other) : tag(other.tag) {
    switch (tag) {
      case Tag::ApplicationMessage:
        new (&application_message) ApplicationMessage_Body(std::move(other.application_message));
        break;
      case Tag::GroupIdEpoch:
        new (&group_id_epoch) GroupIdEpoch_Body(std::move(other.group_id_epoch));
        break;
      case Tag::CommitOutput:
        new (&commit_output) CommitOutput_Body(std::move(other.commit_output));
        break;
      case Tag::None:
        break;
    }
  }
};

struct GkExporterOutput {
  nsTArray<uint8_t> group_id;
  nsTArray<uint8_t> group_epoch;
  nsTArray<uint8_t> label;
  nsTArray<uint8_t> context;
  nsTArray<uint8_t> exporter;
};

extern "C" {

nsresult mls_state_delete(const nsACString *storage_prefix);

nsresult mls_state_delete_group(const nsACString *storage_prefix,
                                const uint8_t *group_id_bytes_ptr,
                                uintptr_t group_id_bytes_len,
                                const uint8_t *identifier_bytes_ptr,
                                uintptr_t identifier_bytes_len,
                                GkGroupIdEpoch *ret_group_id_epoch);

nsresult mls_generate_identity(const nsACString *storage_prefix, nsTArray<uint8_t> *ret_identifier);

nsresult mls_generate_credential_basic(const uint8_t *cred_content_bytes_ptr,
                                       uintptr_t cred_content_bytes_len,
                                       nsTArray<uint8_t> *ret_credential);

nsresult mls_generate_keypackage(const nsACString *storage_prefix,
                                 const uint8_t *identifier_bytes_ptr,
                                 uintptr_t identifier_bytes_len,
                                 const uint8_t *credential_bytes_ptr,
                                 uintptr_t credential_bytes_len,
                                 nsTArray<uint8_t> *ret_keypackage);

nsresult mls_group_details(const nsACString *storage_prefix,
                           const uint8_t *group_id_bytes_ptr,
                           uintptr_t group_id_bytes_len,
                           const uint8_t *identifier_bytes_ptr,
                           uintptr_t identifier_bytes_len,
                           GkGroupDetails *ret_group_details);

nsresult mls_group_create(const nsACString *storage_prefix,
                          const uint8_t *identifier_bytes_ptr,
                          uintptr_t identifier_bytes_len,
                          const uint8_t *credential_bytes_ptr,
                          uintptr_t credential_bytes_len,
                          const uint8_t *opt_group_id_bytes_ptr,
                          uintptr_t opt_group_id_bytes_len,
                          GkGroupIdEpoch *ret_group_id_epoch);

nsresult mls_group_add(const nsACString *storage_prefix,
                       const uint8_t *group_id_bytes_ptr,
                       uintptr_t group_id_bytes_len,
                       const uint8_t *identifier_bytes_ptr,
                       uintptr_t identifier_bytes_len,
                       const uint8_t *keypackage_bytes_ptr,
                       uintptr_t keypackage_bytes_len,
                       GkMlsCommitOutput *ret_commit_output);

nsresult mls_group_propose_add(const nsACString *storage_prefix,
                               const uint8_t *group_id_bytes_ptr,
                               uintptr_t group_id_bytes_len,
                               const uint8_t *identifier_bytes_ptr,
                               uintptr_t identifier_bytes_len,
                               const uint8_t *keypackage_bytes_ptr,
                               uintptr_t keypackage_bytes_len,
                               nsTArray<uint8_t> *ret_proposal);

nsresult mls_group_remove(const nsACString *storage_prefix,
                          const uint8_t *group_id_bytes_ptr,
                          uintptr_t group_id_bytes_len,
                          const uint8_t *identifier_bytes_ptr,
                          uintptr_t identifier_bytes_len,
                          const uint8_t *rem_identifier_bytes_ptr,
                          uintptr_t rem_identifier_bytes_len,
                          GkMlsCommitOutput *ret_commit_output);

nsresult mls_group_propose_remove(const nsACString *storage_prefix,
                                  const uint8_t *group_id_bytes_ptr,
                                  uintptr_t group_id_bytes_len,
                                  const uint8_t *identifier_bytes_ptr,
                                  uintptr_t identifier_bytes_len,
                                  const uint8_t *rem_identifier_bytes_ptr,
                                  uintptr_t rem_identifier_bytes_len,
                                  nsTArray<uint8_t> *ret_proposal);

nsresult mls_group_join(const nsACString *storage_prefix,
                        const uint8_t *identifier_bytes_ptr,
                        uintptr_t identifier_bytes_len,
                        const uint8_t *welcome_bytes_ptr,
                        uintptr_t welcome_bytes_len,
                        GkGroupIdEpoch *ret_group_id_epoch);

nsresult mls_group_close(const nsACString *storage_prefix,
                         const uint8_t *group_id_bytes_ptr,
                         uintptr_t group_id_bytes_len,
                         const uint8_t *identifier_bytes_ptr,
                         uintptr_t identifier_bytes_len,
                         GkMlsCommitOutput *ret_commit_output);

nsresult mls_receive(const nsACString *storage_prefix,
                     const uint8_t *identifier_bytes_ptr,
                     uintptr_t identifier_bytes_len,
                     const uint8_t *message_bytes_ptr,
                     uintptr_t message_bytes_len,
                     nsTArray<uint8_t> *ret_group_id,
                     GkReceived *ret_received);

nsresult mls_has_pending_proposals(const nsACString *storage_prefix,
                                   const uint8_t *group_id_bytes_ptr,
                                   uintptr_t group_id_bytes_len,
                                   const uint8_t *identifier_bytes_ptr,
                                   uintptr_t identifier_bytes_len,
                                   bool *ret_has_pending_proposals);

nsresult mls_clear_pending_proposals(const nsACString *storage_prefix,
                                     const uint8_t *group_id_bytes_ptr,
                                     uintptr_t group_id_bytes_len,
                                     const uint8_t *identifier_bytes_ptr,
                                     uintptr_t identifier_bytes_len,
                                     bool *ret_cleared_pending_proposals);

nsresult mls_has_pending_commit(const nsACString *storage_prefix,
                                const uint8_t *group_id_bytes_ptr,
                                uintptr_t group_id_bytes_len,
                                const uint8_t *identifier_bytes_ptr,
                                uintptr_t identifier_bytes_len,
                                bool *ret_has_pending_commit);

nsresult mls_clear_pending_commit(const nsACString *storage_prefix,
                                  const uint8_t *group_id_bytes_ptr,
                                  uintptr_t group_id_bytes_len,
                                  const uint8_t *identifier_bytes_ptr,
                                  uintptr_t identifier_bytes_len,
                                  bool *ret_cleared_pending_commit);

nsresult mls_apply_pending_commit(const nsACString *storage_prefix,
                                  const uint8_t *group_id_bytes_ptr,
                                  uintptr_t group_id_bytes_len,
                                  const uint8_t *identifier_bytes_ptr,
                                  uintptr_t identifier_bytes_len,
                                  GkReceived *ret_received);

nsresult mls_send(const nsACString *storage_prefix,
                  const uint8_t *group_id_bytes_ptr,
                  uintptr_t group_id_bytes_len,
                  const uint8_t *identifier_bytes_ptr,
                  uintptr_t identifier_bytes_len,
                  const uint8_t *message_bytes_ptr,
                  uintptr_t message_bytes_len,
                  nsTArray<uint8_t> *ret_encrypted);

nsresult mls_derive_exporter(const nsACString *storage_prefix,
                             const uint8_t *group_id_bytes_ptr,
                             uintptr_t group_id_bytes_len,
                             const uint8_t *identifier_bytes_ptr,
                             uintptr_t identifier_bytes_len,
                             const uint8_t *label_bytes_ptr,
                             uintptr_t label_bytes_len,
                             const uint8_t *context_bytes_ptr,
                             uintptr_t context_bytes_len,
                             uint64_t len,
                             GkExporterOutput *ret_exporter_output);

nsresult mls_get_group_id(const uint8_t *message_bytes_ptr,
                          uintptr_t message_bytes_len,
                          nsTArray<uint8_t> *ret_group_id);

nsresult mls_get_group_epoch(const uint8_t *message_bytes_ptr,
                             uintptr_t message_bytes_len,
                             nsTArray<uint8_t> *ret_group_epoch);

}  // extern "C"

}  // namespace mls
}  // namespace security
}  // namespace mozilla

#endif  // mozilla_dom_MlsGkFFI_h
