// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanBackupMetrics_h
#define mozilla_GleanBackupMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace browser_backup {
  /**
   * generated from browser.backup.archive_disabled_reason
   * Only set if `browser.backup.enabled` is `false`. Possible reasons are "nimbus", "pref" (non-Nimbus), "policy", "sanitizeOnShutdown", "selectable profiles".
   */
  constexpr impl::StringMetric archive_disabled_reason(248);

  /**
   * generated from browser.backup.archive_enabled
   * True if the user can create backups, i.e. it has not been disabled by a pref or otherwise deemed incompatible.
   */
  constexpr impl::BooleanMetric archive_enabled(249);

  /**
   * generated from browser.backup.backup_start
   */
  struct BackupStartExtra {
    mozilla::Maybe<nsCString> reason;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Dispatched when a backup is initiated.
   */
  constexpr impl::EventMetric<BackupStartExtra> backup_start(250);

  /**
   * generated from browser.backup.backup_throttled
   */
  /**
   * Dispatched when backups are throttled due to too many errors.
   */
  constexpr impl::EventMetric<NoExtraKeys> backup_throttled(251);

  /**
   * generated from browser.backup.browser_extension_data_size
   * The total size of the current profiles storage.local legacy JSON backend in the browser-extension-data directory, rounded to the nearest 10 kilobytes.
   */
  constexpr impl::QuantityMetric browser_extension_data_size(252);

  /**
   * generated from browser.backup.change_location
   */
  /**
   * Dispatched when the backup destination location is changed.
   */
  constexpr impl::EventMetric<NoExtraKeys> change_location(253);

  /**
   * generated from browser.backup.compressed_archive_size
   * The total compressed size of a single-file profile data backup archive. To reduce fingerprintability, we round to the nearest 1 mebibyte.
   */
  constexpr impl::MemoryDistributionMetric compressed_archive_size(254);

  /**
   * generated from browser.backup.cookies_size
   * The total file size of the cookies.sqlite db located in the current profile directory, in kilobytes.
   */
  constexpr impl::QuantityMetric cookies_size(255);

  /**
   * generated from browser.backup.created
   */
  struct CreatedExtra {
    mozilla::Maybe<bool> encrypted;
    mozilla::Maybe<nsCString> location;
    mozilla::Maybe<uint32_t> size;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (encrypted) {
        extraKeys.AppendElement()->AssignASCII("encrypted");
        extraValues.AppendElement()->AssignASCII(encrypted.value() ? "true" : "false");
      }
      if (location) {
        extraKeys.AppendElement()->AssignASCII("location");
        extraValues.EmplaceBack(location.value());
      }
      if (size) {
        extraKeys.AppendElement()->AssignASCII("size");
        extraValues.AppendElement()->AppendInt(size.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Dispatched when a backup is successfully created.
   */
  constexpr impl::EventMetric<CreatedExtra> created(256);

  /**
   * generated from browser.backup.credentials_data_size
   * The total size of logins, payment method, and form autofill related files in the current profile directory, in kilobytes.
   */
  constexpr impl::QuantityMetric credentials_data_size(257);

  /**
   * generated from browser.backup.enabled
   * True if the BackupService has initialized and reached idle. You may want to use archive_enabled/restore_enabled to determine whether those features are available, or use scheduler_enabled for whether automatic backups are enabled.
   */
  constexpr impl::BooleanMetric enabled(258);

  /**
   * generated from browser.backup.error
   */
  struct ErrorExtra {
    mozilla::Maybe<nsCString> backupStep;
    mozilla::Maybe<nsCString> errorCode;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (backupStep) {
        extraKeys.AppendElement()->AssignASCII("backup_step");
        extraValues.EmplaceBack(backupStep.value());
      }
      if (errorCode) {
        extraKeys.AppendElement()->AssignASCII("error_code");
        extraValues.EmplaceBack(errorCode.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Dispatched when a backup fails to be created. We encode the error code as well as the stage the backup failed in in the extra data.
   */
  constexpr impl::EventMetric<ErrorExtra> error(259);

  /**
   * generated from browser.backup.extension_store_permissions_data_size
   * The file size of the current profiles extension-store-permissions/data.safe.bin file, rounded to the nearest 10 kilobytes.
   */
  constexpr impl::QuantityMetric extension_store_permissions_data_size(260);

  /**
   * generated from browser.backup.extensions_json_size
   * The total file size of the current profiles extensions metadata files, rounded to the nearest 10 kilobytes. Files included are:
   *   - extensions.json
   *   - extension-settings.json
   *   - extension-preferences.json
   *   - addonStartup.json.lz4
   */
  constexpr impl::QuantityMetric extensions_json_size(261);

  /**
   * generated from browser.backup.extensions_storage_size
   * The total size of all extensions storage directories, rounded to the nearest 10 kilobytes.
   */
  constexpr impl::QuantityMetric extensions_storage_size(262);

  /**
   * generated from browser.backup.extensions_xpi_directory_size
   * The total size of the current profiles extensions directory, rounded to the nearest 10 kilobytes.
   */
  constexpr impl::QuantityMetric extensions_xpi_directory_size(263);

  /**
   * generated from browser.backup.favicons_size
   * The total file size of the favicons.sqlite db located in the current profile directory, in kilobytes.
   */
  constexpr impl::QuantityMetric favicons_size(264);

  /**
   * generated from browser.backup.favicons_time
   * Total time, in milliseconds, required to back up a profile's favicons database.
   */
  constexpr impl::TimingDistributionMetric favicons_time(265);

  /**
   * generated from browser.backup.form_history_size
   * The file size of the formhistory.sqlite db located in the current profile directory, in kilobytes.
   */
  constexpr impl::QuantityMetric form_history_size(266);

  /**
   * generated from browser.backup.location_on_device
   * 1 = the default location, 2 = a non-default location
   */
  constexpr impl::QuantityMetric location_on_device(267);

  /**
   * generated from browser.backup.misc_data_size
   * The total size of files for telemetry, site storage, media device origin mapping, chrome privileged IndexedDB databases, and Mozilla Accounts in the current profile directory, rounded to the nearest tenth kilobyte.
   */
  constexpr impl::QuantityMetric misc_data_size(268);

  /**
   * generated from browser.backup.password_added
   */
  /**
   * Dispatched when the backup encryption is enabled.
   */
  constexpr impl::EventMetric<NoExtraKeys> password_added(269);

  /**
   * generated from browser.backup.password_changed
   */
  /**
   * Dispatched when the backup encryption password is changed.
   */
  constexpr impl::EventMetric<NoExtraKeys> password_changed(270);

  /**
   * generated from browser.backup.password_removed
   */
  /**
   * Dispatched when the backup encryption is removed.
   */
  constexpr impl::EventMetric<NoExtraKeys> password_removed(271);

  /**
   * generated from browser.backup.places_size
   * The total file size of the places.sqlite db located in the current profile directory, in kilobytes.
   */
  constexpr impl::QuantityMetric places_size(272);

  /**
   * generated from browser.backup.places_time
   * Total time, in milliseconds, required to back up a profile's places database.
   */
  constexpr impl::TimingDistributionMetric places_time(273);

  /**
   * generated from browser.backup.preferences_size
   * The total size of files relating to user preferences and permissions in the current profile directory, in kilobytes.
   */
  constexpr impl::QuantityMetric preferences_size(274);

  /**
   * generated from browser.backup.prof_d_disk_space
   * The total disk space available on the storage device that the profile directory is stored on. To reduce fingerprintability, we round to the nearest 10 megabytes and return the result in kilobytes.
   */
  constexpr impl::QuantityMetric prof_d_disk_space(275);

  /**
   * generated from browser.backup.pswd_encrypted
   * True if the BackupService is configured to encrypt backups.
   */
  constexpr impl::BooleanMetric pswd_encrypted(276);

  /**
   * generated from browser.backup.restore_disabled_reason
   * Only set if `browser.backup.enabled` is `false`. Possible reasons are "nimbus", "pref" (non-Nimbus), "policy", "sanitizeOnShutdown", "selectable profiles".
   */
  constexpr impl::StringMetric restore_disabled_reason(277);

  /**
   * generated from browser.backup.restore_enabled
   * True if the user can restore backups, i.e. it has not been disabled by a pref or otherwise deemed incompatible.
   */
  constexpr impl::BooleanMetric restore_enabled(278);

  /**
   * generated from browser.backup.scheduler_enabled
   * True if the BackupService is configured to automatically create backups in the background.
   */
  constexpr impl::BooleanMetric scheduler_enabled(279);

  /**
   * generated from browser.backup.security_data_size
   * The total size of files needed for NSS initialization parameters and security certificate settings in the current profile directory, in kilobytes.
   */
  constexpr impl::QuantityMetric security_data_size(280);

  /**
   * generated from browser.backup.session_store_backups_directory_size
   * The total size of the session store backups directory, in kilobytes.
   */
  constexpr impl::QuantityMetric session_store_backups_directory_size(281);

  /**
   * generated from browser.backup.session_store_size
   * The size of uncompressed session store json, in kilobytes.
   */
  constexpr impl::QuantityMetric session_store_size(282);

  /**
   * generated from browser.backup.storage_sync_size
   * The file size of the current profiles storage-sync-v2.sqlite db, rounded to the nearest 10 kilobytes.
   */
  constexpr impl::QuantityMetric storage_sync_size(283);

  /**
   * generated from browser.backup.toggle_off
   */
  /**
   * Dispatched when scheduled backups are disabled.
   */
  constexpr impl::EventMetric<NoExtraKeys> toggle_off(284);

  /**
   * generated from browser.backup.toggle_on
   */
  struct ToggleOnExtra {
    mozilla::Maybe<bool> encrypted;
    mozilla::Maybe<nsCString> location;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (encrypted) {
        extraKeys.AppendElement()->AssignASCII("encrypted");
        extraValues.AppendElement()->AssignASCII(encrypted.value() ? "true" : "false");
      }
      if (location) {
        extraKeys.AppendElement()->AssignASCII("location");
        extraValues.EmplaceBack(location.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Dispatched when scheduled backups are enabled.
   */
  constexpr impl::EventMetric<ToggleOnExtra> toggle_on(285);

  /**
   * generated from browser.backup.total_backup_size
   * The total uncompressed size of all profile data included in a completed backup. To reduce fingerprintability, we round to the nearest 1 mebibyte.
   */
  constexpr impl::MemoryDistributionMetric total_backup_size(286);

  /**
   * generated from browser.backup.total_backup_time
   * Total time elapsed, in milliseconds, between the start and end of the profile backup creation process
   */
  constexpr impl::TimingDistributionMetric total_backup_time(287);
}

} // namespace mozilla::glean

#endif // mozilla_GleanBackupMetrics_h
